/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.actions;

import java.awt.event.ActionEvent;
import javax.swing.event.MenuEvent;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.internal.view.NetworkViewMediator;

public class DetachedViewToolBarAction
extends AbstractCyAction {
    private static String TITLE = "Detached View Tool Bars";
    private static String SHOW = "Show";
    private static String HIDE = "Hide";
    private final NetworkViewMediator netViewMediator;

    public DetachedViewToolBarAction(float menuGravity, NetworkViewMediator netViewMediator) {
        super(DetachedViewToolBarAction.getTitle(netViewMediator));
        this.netViewMediator = netViewMediator;
        this.setPreferredMenu("View");
        this.setMenuGravity(menuGravity);
        this.insertSeparatorBefore = true;
    }

    public void actionPerformed(ActionEvent e) {
        this.netViewMediator.setViewToolBarsVisible(!this.netViewMediator.isViewToolBarsVisible());
    }

    public void menuSelected(MenuEvent e) {
        this.putValue("Name", DetachedViewToolBarAction.getTitle(this.netViewMediator));
    }

    private static String getTitle(NetworkViewMediator netViewMediator) {
        return (netViewMediator.isViewToolBarsVisible() ? HIDE : SHOW) + " " + TITLE;
    }
}

