/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.events.CyShutdownRequestedEvent;
import org.cytoscape.application.events.CyShutdownRequestedListener;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.application.swing.CytoPanelState;
import org.cytoscape.internal.io.SessionIO;
import org.cytoscape.internal.io.networklist.Network;
import org.cytoscape.internal.io.networklist.NetworkList;
import org.cytoscape.internal.io.sessionstate.Cytopanel;
import org.cytoscape.internal.io.sessionstate.Cytopanels;
import org.cytoscape.internal.io.sessionstate.SessionState;
import org.cytoscape.internal.view.CytoPanelImpl;
import org.cytoscape.internal.view.CytoPanelStateInternal;
import org.cytoscape.internal.view.CytoscapeDesktop;
import org.cytoscape.internal.view.NetworkMainPanel;
import org.cytoscape.internal.view.NetworkViewMediator;
import org.cytoscape.internal.view.SubNetworkPanel;
import org.cytoscape.internal.view.util.ViewUtil;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.CySession;
import org.cytoscape.session.CySessionManager;
import org.cytoscape.session.events.SessionAboutToBeSavedEvent;
import org.cytoscape.session.events.SessionAboutToBeSavedListener;
import org.cytoscape.session.events.SessionLoadedEvent;
import org.cytoscape.session.events.SessionLoadedListener;
import org.cytoscape.task.write.SaveSessionAsTaskFactory;
import org.cytoscape.util.swing.FileChooserFilter;
import org.cytoscape.util.swing.FileUtil;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.work.SynchronousTaskManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionHandler
implements CyShutdownRequestedListener,
SessionLoadedListener,
SessionAboutToBeSavedListener {
    private static final String SESSION_STATE_DOC_VERSION = "1.1";
    private static final String APP_NAME = "org.cytoscape.swing-application";
    private static final String SESSION_STATE_FILENAME = "session_state.xml";
    private static final String NETWORK_LIST_FILENAME = "network_list.xml";
    private final Map<String, CytoPanelName> CYTOPANEL_NAMES = new LinkedHashMap<String, CytoPanelName>();
    private final CytoscapeDesktop desktop;
    private final NetworkViewMediator netViewMediator;
    private final SessionIO sessionIO;
    private final NetworkMainPanel netPanel;
    private final CyServiceRegistrar serviceRegistrar;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public SessionHandler(CytoscapeDesktop desktop, NetworkViewMediator netViewMediator, SessionIO sessionIO, NetworkMainPanel netPanel, CyServiceRegistrar serviceRegistrar) {
        this.desktop = desktop;
        this.netViewMediator = netViewMediator;
        this.sessionIO = sessionIO;
        this.netPanel = netPanel;
        this.serviceRegistrar = serviceRegistrar;
        this.CYTOPANEL_NAMES.put("CytoPanel1", CytoPanelName.WEST);
        this.CYTOPANEL_NAMES.put("CytoPanel2", CytoPanelName.SOUTH);
        this.CYTOPANEL_NAMES.put("CytoPanel3", CytoPanelName.EAST);
    }

    public void handleEvent(CyShutdownRequestedEvent e) {
        CyNetworkManager netMgr = (CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class);
        if (netMgr.getNetworkSet().isEmpty() || e.forceShutdown()) {
            return;
        }
        String msg = "Do you want to save your session?";
        String header = "Save Networks Before Quitting?";
        Object[] options = new Object[]{"Yes, save and quit", "No, just quit", "Cancel"};
        int n = JOptionPane.showOptionDialog(this.desktop.getJFrame(), "Do you want to save your session?", "Save Networks Before Quitting?", 0, 3, null, options, options[0]);
        if (n == 1) {
            return;
        }
        if (n == 0) {
            File file;
            CySessionManager sessionMgr = (CySessionManager)this.serviceRegistrar.getService(CySessionManager.class);
            String sessionFileName = sessionMgr.getCurrentSessionFileName();
            if (sessionFileName == null || sessionFileName.isEmpty()) {
                FileChooserFilter filter = new FileChooserFilter("Session File", "cys");
                ArrayList<FileChooserFilter> filterCollection = new ArrayList<FileChooserFilter>(1);
                filterCollection.add(filter);
                FileUtil fileUtil = (FileUtil)this.serviceRegistrar.getService(FileUtil.class);
                file = fileUtil.getFile((Component)this.desktop, "Save Session File", 1, filterCollection);
            } else {
                file = new File(sessionFileName);
            }
            if (file == null) {
                e.abortShutdown("User canceled the shutdown request.");
                return;
            }
            SynchronousTaskManager syncTaskMgr = (SynchronousTaskManager)this.serviceRegistrar.getService(SynchronousTaskManager.class);
            SaveSessionAsTaskFactory saveTaskFactory = (SaveSessionAsTaskFactory)this.serviceRegistrar.getService(SaveSessionAsTaskFactory.class);
            syncTaskMgr.execute(saveTaskFactory.createTaskIterator(file));
            return;
        }
        e.abortShutdown("User canceled the shutdown request.");
    }

    public void handleEvent(SessionAboutToBeSavedEvent e) {
        File f1 = this.saveSessionState(e);
        File f2 = this.saveNetworkList(e);
        ArrayList<File> files = new ArrayList<File>();
        if (f1 != null) {
            files.add(f1);
        }
        if (f2 != null) {
            files.add(f2);
        }
        try {
            if (!files.isEmpty()) {
                e.addAppFiles(APP_NAME, files);
            }
        }
        catch (Exception ex) {
            logger.error("Error adding app files to be saved in the session.", (Throwable)ex);
        }
    }

    public void handleEvent(SessionLoadedEvent e) {
        CySession sess = e.getLoadedSession();
        if (sess != null) {
            ViewUtil.invokeOnEDT(() -> this.postLoading(sess));
        }
    }

    private File saveSessionState(SessionAboutToBeSavedEvent e) {
        SessionState sessState = new SessionState();
        sessState.setDocumentVersion(SESSION_STATE_DOC_VERSION);
        Cytopanels cytopanels = new Cytopanels();
        sessState.setCytopanels(cytopanels);
        for (Map.Entry<String, CytoPanelName> entry : this.CYTOPANEL_NAMES.entrySet()) {
            CytoPanel p = this.desktop.getCytoPanel(entry.getValue());
            Cytopanel cytopanel = new Cytopanel();
            cytopanel.setId(entry.getKey());
            cytopanel.setPanelState(p.getState().toString());
            cytopanel.setSelectedPanel(Integer.toString(p.getSelectedIndex()));
            if (p instanceof CytoPanelImpl) {
                cytopanel.setPanelStateInternal(((CytoPanelImpl)p).getStateInternal().toString());
            }
            cytopanels.getCytopanel().add(cytopanel);
        }
        File tmpFile = new File(System.getProperty("java.io.tmpdir"), SESSION_STATE_FILENAME);
        tmpFile.deleteOnExit();
        this.sessionIO.write(sessState, tmpFile);
        return tmpFile;
    }

    private File saveNetworkList(SessionAboutToBeSavedEvent e) {
        Map<Long, Integer> netOrder = this.netPanel.getNetworkListOrder();
        NetworkList netList = new NetworkList();
        for (Map.Entry<Long, Integer> entry : netOrder.entrySet()) {
            Long suid = entry.getKey();
            Integer order = entry.getValue();
            if (order == null) continue;
            Network n = new Network();
            n.setId(suid);
            n.setOrder(order);
            netList.getNetwork().add(n);
        }
        File tmpFile = new File(System.getProperty("java.io.tmpdir"), NETWORK_LIST_FILENAME);
        tmpFile.deleteOnExit();
        this.sessionIO.write(netList, tmpFile);
        return tmpFile;
    }

    private final void postLoading(CySession sess) {
        List files;
        NetworkList netList = null;
        Map filesMap = sess.getAppFileListMap();
        if (filesMap != null && (files = (List)filesMap.get(APP_NAME)) != null) {
            SessionState sessState = null;
            for (File f : files) {
                if (f.getName().endsWith(SESSION_STATE_FILENAME)) {
                    sessState = this.sessionIO.read(f, SessionState.class);
                    continue;
                }
                if (!f.getName().endsWith(NETWORK_LIST_FILENAME)) continue;
                netList = this.sessionIO.read(f, NetworkList.class);
            }
            if (sessState != null) {
                this.setCytoPanelStates(sessState.getCytopanels());
            }
        }
        if (netList == null) {
            Set netSet = sess.getNetworks();
            HashMap<Long, Integer> netOrder = new HashMap<Long, Integer>();
            int count = 0;
            for (CyNetwork n : netSet) {
                netOrder.put(n.getSUID(), count++);
            }
            this.setSessionNetworks(netOrder);
        } else {
            this.setSessionNetworks(netList.getNetwork(), sess);
        }
    }

    private void setCytoPanelStates(Cytopanels cytopanels) {
        if (cytopanels != null) {
            List<Cytopanel> cytopanelsList = cytopanels.getCytopanel();
            for (Cytopanel cytopanel : cytopanelsList) {
                String id = cytopanel.getId();
                CytoPanelName panelName = this.CYTOPANEL_NAMES.get(id);
                if (panelName == null) continue;
                CytoPanel p = this.desktop.getCytoPanel(panelName);
                if (p instanceof CytoPanelImpl && cytopanel.getPanelStateInternal() != null) {
                    try {
                        CytoPanelImpl impl = (CytoPanelImpl)p;
                        impl.setStateInternal(CytoPanelStateInternal.valueOf(cytopanel.getPanelStateInternal().toUpperCase().trim()));
                    }
                    catch (Exception ex) {
                        logger.error("Cannot restore the internal state of panel \"" + panelName.getTitle() + "\"", (Throwable)ex);
                    }
                } else {
                    try {
                        p.setState(CytoPanelState.valueOf((String)cytopanel.getPanelState().toUpperCase().trim()));
                    }
                    catch (Exception ex) {
                        logger.error("Cannot restore the state of panel \"" + panelName.getTitle() + "\"", (Throwable)ex);
                    }
                }
                try {
                    int index = Integer.parseInt(cytopanel.getSelectedPanel());
                    if (index < 0 || index >= p.getCytoPanelComponentCount()) continue;
                    p.setSelectedIndex(index);
                }
                catch (Exception ex) {
                    logger.error("Cannot restore the selected index of panel \"" + panelName.getTitle() + "\"", (Throwable)ex);
                }
            }
        }
    }

    private void setSessionNetworks(List<Network> netInfoList, CySession sess) {
        HashMap<Long, Integer> netOrder = new HashMap<Long, Integer>();
        for (Network n : netInfoList) {
            CyNetwork net = (CyNetwork)sess.getObject(Long.valueOf(n.getId()), CyNetwork.class);
            if (net == null) continue;
            netOrder.put(net.getSUID(), n.getOrder());
        }
        this.setSessionNetworks(netOrder);
    }

    private void setSessionNetworks(final Map<Long, Integer> netOrder) {
        CyNetworkManager netMgr = (CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class);
        ArrayList<CySubNetwork> sortedNetworks = new ArrayList<CySubNetwork>();
        for (CyNetwork n : netMgr.getNetworkSet()) {
            if (!(n instanceof CySubNetwork) || !netMgr.networkExists(n.getSUID().longValue())) continue;
            sortedNetworks.add((CySubNetwork)n);
        }
        Collections.sort(sortedNetworks, new Comparator<CySubNetwork>(){

            @Override
            public int compare(CySubNetwork n1, CySubNetwork n2) {
                try {
                    Integer o1 = (Integer)netOrder.get(n1.getSUID());
                    Integer o2 = (Integer)netOrder.get(n2.getSUID());
                    if (o1 == null) {
                        o1 = -1;
                    }
                    if (o2 == null) {
                        o2 = -1;
                    }
                    return o1.compareTo(o2);
                }
                catch (Exception e) {
                    logger.error("Cannot sort networks", (Throwable)e);
                    return 0;
                }
            }
        });
        CyApplicationManager applicationMgr = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        CyNetworkViewManager netViewMgr = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
        List selectedNetworks = applicationMgr.getSelectedNetworks();
        List selectedViews = applicationMgr.getSelectedNetworkViews();
        ViewUtil.invokeOnEDT(() -> {
            this.netPanel.setNetworks(sortedNetworks);
            for (SubNetworkPanel snp : this.netPanel.getAllSubNetworkItems()) {
                int count = netViewMgr.getNetworkViews(snp.getModel().getNetwork()).size();
                snp.getModel().setViewCount(count);
            }
            this.netPanel.setSelectedNetworks(selectedNetworks);
            this.netViewMediator.getNetworkViewMainPanel().setSelectedNetworkViews(selectedViews);
        });
    }
}

