/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.cyBrowser.internal;

import edu.ucsf.rbvi.cyBrowser.internal.model.CyBrowserManager;
import edu.ucsf.rbvi.cyBrowser.internal.tasks.CloseBrowserTaskFactory;
import edu.ucsf.rbvi.cyBrowser.internal.tasks.DialogTaskFactory;
import edu.ucsf.rbvi.cyBrowser.internal.tasks.HideBrowserTaskFactory;
import edu.ucsf.rbvi.cyBrowser.internal.tasks.ListBrowsersTaskFactory;
import edu.ucsf.rbvi.cyBrowser.internal.tasks.SendTaskFactory;
import edu.ucsf.rbvi.cyBrowser.internal.tasks.ShowBrowserTaskFactory;
import edu.ucsf.rbvi.cyBrowser.internal.tasks.VersionTaskFactory;
import edu.ucsf.rbvi.cyBrowser.internal.util.IconUtil;
import java.awt.Font;
import java.util.Properties;
import javax.swing.Icon;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.service.util.AbstractCyActivator;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.TextIcon;
import org.cytoscape.work.AbstractTaskFactory;
import org.cytoscape.work.TaskFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class CyActivator
extends AbstractCyActivator {
    private static float LARGE_ICON_FONT_SIZE = 28.0f;
    private static int LARGE_ICON_SIZE = 32;

    public void start(BundleContext bc) {
        boolean haveGUI = true;
        ServiceReference ref = bc.getServiceReference(CySwingApplication.class.getName());
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        if (ref == null) {
            haveGUI = false;
        }
        CyServiceRegistrar registrar = (CyServiceRegistrar)this.getService(bc, CyServiceRegistrar.class);
        CyBrowserManager manager = new CyBrowserManager(registrar);
        String version = bc.getBundle().getVersion().toString();
        manager.setVersion(version);
        IconManager iconManager = (IconManager)this.getService(bc, IconManager.class);
        Font iconFont = IconUtil.getIconFont(LARGE_ICON_FONT_SIZE);
        AbstractTaskFactory startBrowser = new DialogTaskFactory(manager, "http://tutorials.cytoscape.org/");
        TextIcon icon = new TextIcon(IconUtil.BROWSER_ICON, iconFont, IconUtil.BROWSER_ICON_COLORS, LARGE_ICON_SIZE, LARGE_ICON_SIZE);
        String iconId = "rbvi::OPEN_CYBROWSER";
        iconManager.addIcon(iconId, (Icon)icon);
        Properties props = new Properties();
        props.setProperty("inMenuBar", "false");
        props.setProperty("inToolBar", "true");
        props.setProperty("toolBarGravity", "120000000000000.0");
        props.setProperty("largeIconID", iconId);
        props.setProperty("tooltip", "Cytoscape Web Browser");
        props.setProperty("tooltipLongDescription", "Open Cytoscape Web Browser.");
        this.registerService(bc, startBrowser, TaskFactory.class, props);
        startBrowser = new DialogTaskFactory(manager);
        Properties props2 = new Properties();
        props2.setProperty("preferredMenu", "Tools");
        props2.setProperty("title", "Open web page");
        props2.setProperty("menuGravity", "1.0");
        props2.setProperty("inMenuBar", "true");
        props2.setProperty("inToolBar", "false");
        props2.setProperty("tooltip", "Open Web Page");
        props2.setProperty("tooltipLongDescription", "Open Web Page in Cytoscape Web Browser.");
        props2.setProperty("commandNamespace", "cybrowser");
        props2.setProperty("command", "dialog");
        props2.setProperty("commandDescription", "Launch an HTML browser in a separate window");
        props2.setProperty("commandLongDescription", "Launch Cytoscape's internal web browser in a separate window.  Provide an ``id`` for the window if you want subsequent control of the window via ``cybrowser hide``");
        props2.setProperty("commandSupportsJSON", "true");
        props2.setProperty("commandExampleJSON", "{\"id\":\"my window\"}");
        this.registerService(bc, startBrowser, TaskFactory.class, props2);
        startBrowser = new ShowBrowserTaskFactory(manager);
        props2 = new Properties();
        props2.setProperty("commandNamespace", "cybrowser");
        props2.setProperty("command", "show");
        props2.setProperty("commandDescription", "Launch an HTML browser in the Results Panel");
        props2.setProperty("commandLongDescription", "Launch Cytoscape's internal web browser in a pane in the Result Panel.  Provide an ``id`` for the window if you want subsequent control of the window via ``cybrowser hide``");
        props2.setProperty("commandSupportsJSON", "true");
        props2.setProperty("commandExampleJSON", "{\"id\":\"my window\"}");
        this.registerService(bc, startBrowser, TaskFactory.class, props2);
        CloseBrowserTaskFactory closeBrowser = new CloseBrowserTaskFactory(manager);
        props2 = new Properties();
        props2.setProperty("commandNamespace", "cybrowser");
        props2.setProperty("command", "close");
        props2.setProperty("commandDescription", "Close an open browser, removing it's id");
        props2.setProperty("commandLongDescription", "Close an internal web browser and remove all content.  Provide an ``id`` for the browser you want to close.");
        props2.setProperty("commandSupportsJSON", "true");
        props2.setProperty("commandExampleJSON", "{\"id\":\"my window\"}");
        this.registerService(bc, (Object)closeBrowser, TaskFactory.class, props2);
        ListBrowsersTaskFactory listBrowsers = new ListBrowsersTaskFactory(manager);
        props2 = new Properties();
        props2.setProperty("commandNamespace", "cybrowser");
        props2.setProperty("command", "list");
        props2.setProperty("commandDescription", "List all open browsers");
        props2.setProperty("commandLongDescription", "List all browsers that are currently open, whether as a dialog or in the results panel.");
        props2.setProperty("commandSupportsJSON", "true");
        props2.setProperty("commandExampleJSON", "[{\"id\":\"my window\",\"title\":\"title\", \"url\":\"cytoscape.org\"}]");
        this.registerService(bc, (Object)listBrowsers, TaskFactory.class, props2);
        HideBrowserTaskFactory hideBrowser = new HideBrowserTaskFactory(manager);
        props2 = new Properties();
        props2.setProperty("commandNamespace", "cybrowser");
        props2.setProperty("command", "hide");
        props2.setProperty("commandDescription", "Hide an HTML browser in the Results Panel");
        props2.setProperty("commandLongDescription", "Hide an existing browser, whether it's in the Results panel or a separate window.");
        props2.setProperty("commandSupportsJSON", "true");
        props2.setProperty("commandExampleJSON", "{}");
        this.registerService(bc, (Object)hideBrowser, TaskFactory.class, props2);
        SendTaskFactory sendBrowser = new SendTaskFactory(manager);
        props2 = new Properties();
        props2.setProperty("commandNamespace", "cybrowser");
        props2.setProperty("command", "send");
        props2.setProperty("commandDescription", "Send (execute) javascript commands to a browser");
        props2.setProperty("commandLongDescription", "Send the text to the browser indicated by the ``id`` and return the response, if any.  Note that the JSON ``result`` field could either be a bare string or JSON formatted text.");
        props2.setProperty("commandSupportsJSON", "true");
        props2.setProperty("commandExampleJSON", "{\"browserId\":\"my window\", \"result\":[1,2,3,4]}");
        this.registerService(bc, (Object)sendBrowser, TaskFactory.class, props2);
        VersionTaskFactory versionTask = new VersionTaskFactory(version);
        props2 = new Properties();
        props2.setProperty("commandNamespace", "cybrowser");
        props2.setProperty("command", "version");
        props2.setProperty("commandDescription", "Display the CyBrowser version");
        props2.setProperty("commandLongDescription", "Display the version of the CyBrowser app.");
        props2.setProperty("commandSupportsJSON", "true");
        props2.setProperty("commandExampleJSON", "{\"version\":\"1.0\"}");
        this.registerService(bc, (Object)versionTask, TaskFactory.class, props2);
    }
}

