/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.diagnostics.internal.heuristics;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cytoscape.diagnostics.internal.heuristics.AbstractHeuristic;

public abstract class Vm_StatHeuristic<T>
extends AbstractHeuristic<T> {
    static final Pattern VMSTAT_PAGE_SIZE_PATTERN = Pattern.compile(".*\\(page size of (\\d+) bytes\\).*");
    static final Pattern VMSTAT_ENTRY_PATTERN = Pattern.compile("([^:]+):\\s+(\\d+)[.]");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Long> getValuesFromVmstat() throws IOException {
        if (!this.commandExists("vm_stat")) {
            return Collections.emptyMap();
        }
        HashMap<String, Long> values = new HashMap<String, Long>();
        Process process = new ProcessBuilder("vm_stat").start();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line = reader.readLine();
            while (line != null) {
                try {
                    Matcher matcher = VMSTAT_PAGE_SIZE_PATTERN.matcher(line);
                    if (matcher.matches()) {
                        Long pageSize = this.convert(matcher.group(1), Long.class);
                        values.put("page size", pageSize);
                        continue;
                    }
                    matcher = VMSTAT_ENTRY_PATTERN.matcher(line);
                    if (!matcher.matches()) continue;
                    String key = matcher.group(1);
                    Long value = this.convert(matcher.group(2), Long.class);
                    values.put(key, value);
                }
                finally {
                    line = reader.readLine();
                }
            }
            HashMap<String, Long> hashMap = values;
            return hashMap;
        }
    }

    public static class FreeMemory
    extends Vm_StatHeuristic<Long> {
        @Override
        public Long computeValue() throws IOException {
            Map<String, Long> values = this.getValuesFromVmstat();
            Long pageSize = values.get("page size");
            if (pageSize == null) {
                return null;
            }
            Long freeMemory1 = values.get("Pages free");
            Long freeMemory2 = values.get("Pages speculative");
            if (freeMemory1 == null || freeMemory2 == null) {
                return null;
            }
            return (freeMemory1 + freeMemory2) * pageSize;
        }
    }
}

