/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.diagnostics.internal.heuristics;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.cytoscape.diagnostics.internal.heuristics.Heuristic;

public abstract class AbstractHeuristic<T>
implements Heuristic<T> {
    static boolean isWindows = AbstractHeuristic.isWindows();

    private static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    protected boolean commandExists(String commandName) throws IOException {
        String command = isWindows ? "where" : "which";
        Process process = this.createProcess(command, commandName);
        if (isWindows) {
            process.getInputStream().close();
        }
        try {
            return process.waitFor() == 0;
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String runAndGetOutput(String ... arguments) throws IOException {
        Process process = this.createProcess(arguments);
        InputStream stream = process.getInputStream();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
            StringWriter writer = new StringWriter();
            String line = reader.readLine();
            boolean firstLine = true;
            while (line != null) {
                if (!firstLine) {
                    writer.write("\n");
                } else {
                    firstLine = false;
                }
                writer.write(line);
                line = reader.readLine();
            }
            String result = writer.toString();
            if (result != null && result.isEmpty()) {
                String string = null;
                return string;
            }
            if (process.waitFor() != 0) {
                String string = null;
                return string;
            }
            if (process.exitValue() != 0) {
                String string = null;
                return string;
            }
            String string = result;
            return string;
        }
    }

    private Process createProcess(String ... arguments) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(arguments);
        Process process = builder.start();
        if (isWindows) {
            process.getErrorStream().close();
            process.getOutputStream().close();
        }
        return process;
    }

    protected <S> S convert(String value, Class<S> type) {
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        if (type.equals(String.class)) {
            return (S)value;
        }
        try {
            Method method = type.getMethod("valueOf", String.class);
            return (S)method.invoke(null, value.trim());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return null;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected String join(String delimiter, String ... items) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String item : items) {
            if (!first) {
                builder.append(delimiter);
            } else {
                first = false;
            }
            builder.append(item);
        }
        return builder.toString();
    }
}

