/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.diagnostics.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cytoscape.diagnostics.PerformanceDetails;
import org.osgi.framework.Bundle;

public class PerformanceDetailsBuilder
implements PerformanceDetails {
    private long systemLaunchStartTime;
    private long systemLaunchEndTime;
    private long frameworkLaunchEndTime;
    private Map<Long, String> bundleNames = new HashMap<Long, String>();
    private Map<Long, Long> bundleActivationStartTimes = new HashMap<Long, Long>();
    private Map<Long, Long> bundleActivationEndTimes = new HashMap<Long, Long>();

    @Override
    public long getFrameworkLaunchDuration() {
        return this.frameworkLaunchEndTime - this.systemLaunchStartTime;
    }

    @Override
    public long getTotalLaunchDuration() {
        return this.systemLaunchEndTime - this.systemLaunchStartTime;
    }

    @Override
    public long getBundleLaunchDuration(long bundleId) {
        Long startTime = this.bundleActivationStartTimes.get(bundleId);
        Long endTime = this.bundleActivationEndTimes.get(bundleId);
        if (startTime == null || endTime == null) {
            return -1L;
        }
        return endTime - startTime;
    }

    @Override
    public Set<Long> getObservedBundleIds() {
        HashSet<Long> bundleIds = new HashSet<Long>(this.bundleActivationStartTimes.keySet());
        bundleIds.addAll(this.bundleActivationEndTimes.keySet());
        return bundleIds;
    }

    @Override
    public Map<String, Long> getAllBundleLaunchDurations() {
        HashMap<String, Long> durations = new HashMap<String, Long>();
        for (Map.Entry<Long, Long> entry : this.bundleActivationStartTimes.entrySet()) {
            Long bundleId = entry.getKey();
            Long endTime = this.bundleActivationEndTimes.get(bundleId);
            if (endTime == null) continue;
            durations.put(this.bundleNames.get(bundleId), endTime - entry.getValue());
        }
        return durations;
    }

    @Override
    public long getBundleLaunchLatency(long bundleId) {
        Long startTime = this.bundleActivationStartTimes.get(bundleId);
        if (startTime == null) {
            return -1L;
        }
        return startTime - this.systemLaunchStartTime;
    }

    @Override
    public String getBundleDescription(long bundleId) {
        return this.bundleNames.get(bundleId);
    }

    void setSystemLaunchStartTime(long time) {
        this.systemLaunchStartTime = time;
    }

    void setSystemLaunchEndTime(long time) {
        this.systemLaunchEndTime = time;
    }

    void setFrameworkLaunchEndTime(long time) {
        this.frameworkLaunchEndTime = time;
    }

    void logBundleStarting(Bundle bundle) {
        this.logBundleName(bundle);
        Long startTime = this.bundleActivationStartTimes.get(bundle.getBundleId());
        if (startTime != null) {
            return;
        }
        this.bundleActivationStartTimes.put(bundle.getBundleId(), System.currentTimeMillis());
    }

    private void logBundleName(Bundle bundle) {
        String name = this.bundleNames.get(bundle.getBundleId());
        if (name == null) {
            name = String.format("%s (%s)", bundle.getSymbolicName(), bundle.getVersion().toString());
            this.bundleNames.put(bundle.getBundleId(), name);
        }
    }

    void logBundleStarted(Bundle bundle) {
        this.logBundleName(bundle);
        Long endTime = this.bundleActivationEndTimes.get(bundle.getBundleId());
        if (endTime != null) {
            return;
        }
        this.bundleActivationEndTimes.put(bundle.getBundleId(), System.currentTimeMillis());
    }
}

