/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.manual.internal.scale;

import java.awt.event.ActionEvent;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.manual.internal.common.CheckBoxTracker;
import org.cytoscape.view.manual.internal.common.GraphConverter2;
import org.cytoscape.view.manual.internal.common.PolymorphicSlider;
import org.cytoscape.view.manual.internal.common.SliderStateTracker;
import org.cytoscape.view.manual.internal.layout.algorithm.MutablePolyEdgeGraphLayout;
import org.cytoscape.view.manual.internal.scale.ScaleLayouter;
import org.cytoscape.view.manual.internal.util.Util;
import org.cytoscape.view.model.CyNetworkView;

public class ScalePanel
extends JPanel
implements ChangeListener,
PolymorphicSlider {
    private JLabel label;
    private JCheckBox checkBox;
    private JSlider slider;
    private JCheckBox alongXAxis;
    private JCheckBox alongYAxis;
    private JButton resetButton;
    private int prevValue;
    private boolean startAdjusting = true;
    private final CyApplicationManager appMgr;

    public ScalePanel(CyApplicationManager appMgr, IconManager iconMgr) {
        this.appMgr = appMgr;
        this.prevValue = this.getSlider().getValue();
        this.label = new JLabel("Scale:");
        this.checkBox = new JCheckBox("Selected Only", true);
        new CheckBoxTracker(this.checkBox);
        this.alongXAxis = new JCheckBox("Width");
        this.alongYAxis = new JCheckBox("Height");
        this.alongXAxis.setSelected(true);
        this.alongYAxis.setSelected(true);
        this.resetButton = Util.createButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScalePanel.this.updateSlider(0);
            }
        }, "Reset Scale");
        this.resetButton.setText("\uf021");
        this.resetButton.setFont(iconMgr.getIconFont(16.0f));
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.label, this.checkBox, this.getSlider(), this.alongXAxis, this.alongYAxis});
        new SliderStateTracker(this);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(false);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addGroup(layout.createSequentialGroup().addComponent(this.label).addGap(10, 10, Short.MAX_VALUE).addComponent(this.alongXAxis).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.alongYAxis).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.checkBox)).addGroup(layout.createSequentialGroup().addComponent(this.getSlider(), -1, -1, Short.MAX_VALUE).addComponent(this.resetButton)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.label, -2, -1, -2).addComponent(this.alongXAxis, -2, -1, -2).addComponent(this.alongYAxis, -2, -1, -2).addComponent(this.checkBox, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(this.getSlider(), -2, -1, -2).addComponent(this.resetButton, -2, -1, -2)));
        if (LookAndFeelUtil.isAquaLAF()) {
            this.setOpaque(false);
        }
    }

    @Override
    public void updateSlider(int x) {
        this.prevValue = x;
        this.getSlider().setValue(x);
    }

    @Override
    public int getSliderValue() {
        return this.getSlider().getValue();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() != this.getSlider()) {
            return;
        }
        CyNetworkView currentView = this.appMgr.getCurrentNetworkView();
        if (currentView == null) {
            return;
        }
        if (this.startAdjusting) {
            this.startAdjusting = false;
        }
        MutablePolyEdgeGraphLayout nativeGraph = GraphConverter2.getGraphReference(128.0, true, this.checkBox.isSelected(), currentView);
        ScaleLayouter scale = new ScaleLayouter(nativeGraph);
        double prevAbsoluteScaleFactor = Math.pow(2.0, (double)this.prevValue / 100.0);
        double currentAbsoluteScaleFactor = Math.pow(2.0, (double)this.getSlider().getValue() / 100.0);
        double neededIncrementalScaleFactor = currentAbsoluteScaleFactor / prevAbsoluteScaleFactor;
        ScaleLayouter.Direction direction = ScaleLayouter.Direction.BOTH_AXES;
        if (this.alongXAxis.isSelected() && this.alongYAxis.isSelected()) {
            direction = ScaleLayouter.Direction.BOTH_AXES;
        } else if (this.alongXAxis.isSelected()) {
            direction = ScaleLayouter.Direction.X_AXIS_ONLY;
        } else if (this.alongYAxis.isSelected()) {
            direction = ScaleLayouter.Direction.Y_AXIS_ONLY;
        }
        scale.scaleGraph(neededIncrementalScaleFactor, direction);
        currentView.updateView();
        this.prevValue = this.getSlider().getValue();
        if (!this.getSlider().getValueIsAdjusting()) {
            this.startAdjusting = true;
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.label.setEnabled(enabled);
        this.checkBox.setEnabled(enabled);
        this.getSlider().setEnabled(enabled);
        this.alongXAxis.setEnabled(enabled);
        this.alongYAxis.setEnabled(enabled);
        this.resetButton.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public JSlider getSlider() {
        if (this.slider == null) {
            this.slider = new JSlider();
            this.slider.setMajorTickSpacing(100);
            this.slider.setPaintTicks(true);
            this.slider.setPaintLabels(true);
            this.slider.setMaximum(300);
            this.slider.setValue(0);
            this.slider.setMinimum(-300);
            this.slider.addChangeListener(this);
            Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
            labels.put(new Integer(-300), new JLabel("1/8"));
            labels.put(new Integer(-200), new JLabel("1/4"));
            labels.put(new Integer(-100), new JLabel("1/2"));
            labels.put(new Integer(0), new JLabel("1"));
            labels.put(new Integer(100), new JLabel("2"));
            labels.put(new Integer(200), new JLabel("4"));
            labels.put(new Integer(300), new JLabel("8"));
            this.slider.setLabelTable(labels);
        }
        return this.slider;
    }
}

