/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.manual.internal.rotate;

import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.manual.internal.common.CheckBoxTracker;
import org.cytoscape.view.manual.internal.common.GraphConverter2;
import org.cytoscape.view.manual.internal.common.PolymorphicSlider;
import org.cytoscape.view.manual.internal.common.SliderStateTracker;
import org.cytoscape.view.manual.internal.layout.algorithm.MutablePolyEdgeGraphLayout;
import org.cytoscape.view.manual.internal.rotate.RotationLayouter;
import org.cytoscape.view.model.CyNetworkView;

public class RotatePanel
extends JPanel
implements ChangeListener,
PolymorphicSlider {
    private JLabel label;
    private JCheckBox checkBox;
    private JSlider slider;
    private int prevValue;
    private boolean startAdjusting = true;
    private final CyApplicationManager appMgr;

    public RotatePanel(CyApplicationManager appMgr) {
        this.appMgr = appMgr;
        this.prevValue = this.getSlider().getValue();
        this.label = new JLabel("Rotate:");
        this.checkBox = new JCheckBox("Selected Only", true);
        new CheckBoxTracker(this.checkBox);
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.label, this.checkBox, this.getSlider()});
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(false);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addGroup(layout.createSequentialGroup().addComponent(this.label).addGap(20, 20, Short.MAX_VALUE).addComponent(this.checkBox)).addComponent(this.getSlider(), -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.label, -2, -1, -2).addComponent(this.checkBox, -2, -1, -2)).addComponent(this.getSlider(), -2, -1, -2));
        new SliderStateTracker(this);
        if (LookAndFeelUtil.isAquaLAF()) {
            this.setOpaque(false);
        }
    }

    @Override
    public void updateSlider(int x) {
        this.prevValue = x;
        this.getSlider().setValue(x);
    }

    @Override
    public int getSliderValue() {
        return this.getSlider().getValue();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() != this.getSlider()) {
            return;
        }
        CyNetworkView currentView = this.appMgr.getCurrentNetworkView();
        if (currentView == null) {
            return;
        }
        if (this.startAdjusting) {
            this.startAdjusting = false;
        }
        MutablePolyEdgeGraphLayout nativeGraph = GraphConverter2.getGraphReference(128.0, true, this.checkBox.isSelected(), currentView);
        RotationLayouter rotation = new RotationLayouter(nativeGraph);
        double radians = (double)(this.getSlider().getValue() - this.prevValue) * 2.0 * Math.PI / 360.0;
        rotation.rotateGraph(radians);
        currentView.updateView();
        this.prevValue = this.getSlider().getValue();
        if (!this.getSlider().getValueIsAdjusting()) {
            this.startAdjusting = true;
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.label.setEnabled(enabled);
        this.checkBox.setEnabled(enabled);
        this.getSlider().setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public JSlider getSlider() {
        if (this.slider == null) {
            this.slider = new JSlider();
            this.slider.setMinimum(-180);
            this.slider.setMaximum(180);
            this.slider.setValue(0);
            this.slider.setMajorTickSpacing(90);
            this.slider.setPaintLabels(true);
            this.slider.setPaintTicks(true);
            this.slider.setMinorTickSpacing(15);
            this.slider.addChangeListener(this);
        }
        return this.slider;
    }
}

