/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.manual.internal.control.actions.dist;

import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.manual.internal.control.actions.AbstractControlAction;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;

public class HDistRight
extends AbstractControlAction {
    public HDistRight(Icon i, CyApplicationManager appMgr) {
        super("", i, appMgr);
    }

    @Override
    protected void control(List<View<CyNode>> nodes) {
        if (nodes.size() <= 1) {
            return;
        }
        Collections.sort(nodes, new AbstractControlAction.XComparator());
        double d = this.X_max - this.X_min;
        d /= (double)(nodes.size() - 1);
        for (int i = 0; i < nodes.size(); ++i) {
            View<CyNode> n = nodes.get(i);
            double w = (Double)n.getVisualProperty(BasicVisualLexicon.NODE_WIDTH) / 2.0;
            n.setVisualProperty(BasicVisualLexicon.NODE_X_LOCATION, (Object)(this.X_min + (double)i * d - w));
        }
    }

    @Override
    protected double getX(View<CyNode> n) {
        double x = (Double)n.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION);
        double w = (Double)n.getVisualProperty(BasicVisualLexicon.NODE_WIDTH) / 2.0;
        return x + w;
    }
}

