/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.manual.internal.common;

import java.awt.event.ActionEvent;
import javax.swing.event.MenuEvent;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.application.swing.CytoPanelState;
import org.cytoscape.view.model.CyNetworkViewManager;

public abstract class AbstractManualLayoutAction
extends AbstractCyAction {
    protected static CytoPanel manualLayoutPanel;
    private final CySwingApplication swingApp;
    private static final String preferredMenu = "Layout";
    private final CytoPanelComponent comp;

    public AbstractManualLayoutAction(CytoPanelComponent comp, CySwingApplication swingApp, CyApplicationManager appMgr, CyNetworkViewManager networkViewManager, float menuGravity) {
        super(comp.getTitle(), appMgr, "networkAndView", networkViewManager);
        this.swingApp = swingApp;
        this.comp = comp;
        manualLayoutPanel = swingApp.getCytoPanel(CytoPanelName.SOUTH_WEST);
        this.setPreferredMenu(preferredMenu);
        this.setMenuGravity(menuGravity);
        this.useCheckBoxMenuItem = true;
    }

    public void actionPerformed(ActionEvent ev) {
        CytoPanelState curState = manualLayoutPanel.getState();
        int menuIndex = manualLayoutPanel.indexOfComponent(this.comp.getComponent());
        if (curState == CytoPanelState.HIDE) {
            manualLayoutPanel.setState(CytoPanelState.DOCK);
            manualLayoutPanel.setSelectedIndex(menuIndex);
        } else if (manualLayoutPanel.getSelectedIndex() != menuIndex) {
            manualLayoutPanel.setSelectedIndex(menuIndex);
        } else {
            manualLayoutPanel.setState(CytoPanelState.HIDE);
        }
    }

    public void menuSelected(MenuEvent e) {
        int menuIndex = manualLayoutPanel.indexOfComponent(this.comp.getComponent());
        if (manualLayoutPanel.getSelectedIndex() != menuIndex || manualLayoutPanel.getState() == CytoPanelState.HIDE) {
            this.putValue("SwingSelectedKey", false);
        } else {
            this.putValue("SwingSelectedKey", true);
        }
        CytoPanelState parentState = this.swingApp.getCytoPanel(CytoPanelName.WEST).getState();
        if (parentState == CytoPanelState.HIDE) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
        this.updateEnableState();
    }
}

