/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal.resource.apps.clustermaker2;

import com.google.inject.Inject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.cytoscape.ci.model.CIError;
import org.cytoscape.ci.model.CIResponse;
import org.cytoscape.command.AvailableCommands;
import org.cytoscape.command.CommandExecutorTaskFactory;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.rest.internal.CyRESTConstants;
import org.cytoscape.rest.internal.resource.apps.clustermaker2.MCODEParameters;
import org.cytoscape.rest.internal.task.LogLocation;
import org.cytoscape.work.FinishStatus;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.SynchronousTaskManager;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Apps: clusterMaker2"}, hidden=true)
@Path(value="/v1/apps/clustermaker2/")
public class ClusterMaker2Resource {
    private static final Logger logger = LoggerFactory.getLogger(ClusterMaker2Resource.class);
    @Inject
    protected CyNetworkManager networkManager;
    @Inject
    protected SynchronousTaskManager<Object> taskManager;
    @Inject
    @NotNull
    private AvailableCommands available;
    @Inject
    @NotNull
    private CommandExecutorTaskFactory ceTaskFactory;
    @Inject
    @LogLocation
    private URI logLocation;
    private static final String CLUSTER_ATTRIBUTE_KEY = "clusterAttribute";
    private static final String CLUSTER_ATTRIBUTE_DESCRIPTION = "Cluster attribute name";
    private static final String CREATE_GROUPS_KEY = "createGroups";
    private static final String CREATE_GROUPS_DESCRIPTION = "Create groups (metanodes) with results";
    private static final String SHOW_UI_KEY = "showUI";
    private static final String SHOW_UI_DESCRIPTION = "Create new clustered network";
    private static final String RESTORE_EDGES_KEY = "restoreEdges";
    private static final String RESTORE_EDGES_DESCRIPTION = "Restore inter-cluster edges after layout";
    private static final String CLUSTERMAKER2_ROOT = "clustermaker2";
    private static final String CLUSTERMAKER2_NAMESPACE = "cluster";
    private static final String MCODE_COMMAND = "mcode";
    private static final String MCODE_CLUSTER_ATTRIBUTE = "_mcodeCluster";
    private static final String MCODE_ERROR_NAME = "clustermaker2:mcode";

    private CIResponse<Object> buildCIErrorResponse(int status, String resourcePath, int code, String message, Exception e) {
        URI link;
        CIResponse ciResponse = new CIResponse();
        ciResponse.data = new Object();
        ArrayList<CIError> errors = new ArrayList<CIError>();
        CIError error = new CIError();
        error.type = CyRESTConstants.getErrorURI(resourcePath, code);
        if (e != null) {
            logger.error(message, (Throwable)e);
        } else {
            logger.error(message);
        }
        error.link = link = new File(this.logLocation).toURI();
        error.status = status;
        error.message = message;
        errors.add(error);
        ciResponse.errors = errors;
        return ciResponse;
    }

    private static final void applyAdvancedProperties(UriInfo info, String defaultClusterAttribute, Map<String, Object> map) {
        String clusterAttribute = (String)info.getQueryParameters().getFirst((Object)CLUSTER_ATTRIBUTE_KEY);
        if (clusterAttribute != null) {
            map.put(CLUSTER_ATTRIBUTE_KEY, clusterAttribute);
        } else {
            map.put(CLUSTER_ATTRIBUTE_KEY, defaultClusterAttribute);
        }
        if (info.getQueryParameters().containsKey((Object)CREATE_GROUPS_KEY)) {
            Boolean createGroups = new Boolean((String)info.getQueryParameters().getFirst((Object)CREATE_GROUPS_KEY));
            map.put(CREATE_GROUPS_KEY, createGroups);
        }
    }

    private static final void applyNetworkVizProperties(UriInfo info, Map<String, Object> map) {
        if (info.getQueryParameters().containsKey((Object)SHOW_UI_KEY)) {
            Boolean showUI = new Boolean((String)info.getQueryParameters().getFirst((Object)SHOW_UI_KEY));
            map.put(SHOW_UI_KEY, showUI);
        }
        if (info.getQueryParameters().containsKey((Object)RESTORE_EDGES_KEY)) {
            Boolean restoreEdges = new Boolean((String)info.getQueryParameters().getFirst((Object)RESTORE_EDGES_KEY));
            map.put(RESTORE_EDGES_KEY, restoreEdges);
        }
    }

    @Path(value="/mcode/{networkSUID}")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Execute MCODE Clustering", notes="", response=ClusterMakerCIResponse.class, hidden=true)
    @ApiResponses(value={@ApiResponse(code=404, message="Network does not exist", response=CIResponse.class), @ApiResponse(code=503, message="clusterMaker2 MCODE command is unavailable", response=CIResponse.class), @ApiResponse(code=400, message="Invalid or missing parameters", response=CIResponse.class)})
    @ApiImplicitParams(value={@ApiImplicitParam(name="clusterAttribute", value="Cluster attribute name", required=false, dataType="string", paramType="query", defaultValue="_mcodeCluster"), @ApiImplicitParam(name="createGroups", value="Create groups (metanodes) with results", required=false, dataType="boolean", paramType="query", defaultValue="false"), @ApiImplicitParam(name="showUI", value="Create new clustered network", required=false, dataType="boolean", paramType="query", defaultValue="false"), @ApiImplicitParam(name="restoreEdges", value="Restore inter-cluster edges after layout", required=false, dataType="boolean", paramType="query", defaultValue="false")})
    public Response cluster(@ApiParam(value="The SUID of the Network", required=true) @PathParam(value="networkSUID") long suid, MCODEParameters parameters, @Context UriInfo info) {
        if (!this.available.getNamespaces().contains(CLUSTERMAKER2_NAMESPACE) || !this.available.getCommands(CLUSTERMAKER2_NAMESPACE).contains(MCODE_COMMAND)) {
            String messageString = "clusterMaker2 MCODE command is unavailable";
            throw new ServiceUnavailableException(messageString, Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).type("application/json").entity(this.buildCIErrorResponse(503, MCODE_ERROR_NAME, 1, messageString, null)).build());
        }
        if (!this.networkManager.networkExists(suid)) {
            String messageString = "Network " + suid + " does not exist";
            throw new NotFoundException(messageString, Response.status((Response.Status)Response.Status.NOT_FOUND).type("application/json").entity(this.buildCIErrorResponse(404, MCODE_ERROR_NAME, 2, messageString, null)).build());
        }
        if (parameters == null) {
            String messageString = "Invalid or missing parameters";
            throw new BadRequestException(messageString, Response.status((Response.Status)Response.Status.BAD_REQUEST).type("application/json").entity(this.buildCIErrorResponse(400, MCODE_ERROR_NAME, 3, messageString, null)).build());
        }
        MCODETaskObserver taskObserver = new MCODETaskObserver(MCODE_ERROR_NAME, 4);
        HashMap<String, Object> tunableMap = new HashMap<String, Object>();
        tunableMap.putAll(parameters.getTunableMap());
        tunableMap.put("network", this.networkManager.getNetwork(suid));
        ClusterMaker2Resource.applyAdvancedProperties(info, MCODE_CLUSTER_ATTRIBUTE, tunableMap);
        ClusterMaker2Resource.applyNetworkVizProperties(info, tunableMap);
        TaskIterator taskIterator = this.ceTaskFactory.createTaskIterator(CLUSTERMAKER2_NAMESPACE, MCODE_COMMAND, tunableMap, (TaskObserver)taskObserver);
        this.taskManager.execute(taskIterator, (TaskObserver)taskObserver);
        return Response.status((Response.Status)(taskObserver.ciResponse.errors.size() == 0 ? Response.Status.OK : Response.Status.INTERNAL_SERVER_ERROR)).type("application/json").entity((Object)taskObserver.ciResponse).build();
    }

    @ApiModel(parent=CIResponse.class)
    private static class ClusterMakerCIResponse
    extends CIResponse<String> {
        private ClusterMakerCIResponse() {
        }
    }

    class MCODETaskObserver
    implements TaskObserver {
        private CIResponse ciResponse = null;
        private String resourceURI;
        private int errorCode;

        public MCODETaskObserver(String resourceName, int errorCode) {
            this.resourceURI = resourceName;
            this.errorCode = errorCode;
        }

        public void allFinished(FinishStatus arg0) {
            this.ciResponse = new CIResponse();
            if (arg0.getType() == FinishStatus.Type.SUCCEEDED || arg0.getType() == FinishStatus.Type.CANCELLED) {
                this.ciResponse.data = arg0.getType().toString();
                this.ciResponse.errors = new ArrayList();
            } else {
                this.ciResponse = ClusterMaker2Resource.this.buildCIErrorResponse(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.resourceURI, this.errorCode, arg0.getException().getMessage(), arg0.getException());
            }
        }

        public void taskFinished(ObservableTask arg0) {
        }
    }
}

