/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal.resource;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.cytoscape.ci.model.CIResponse;
import org.cytoscape.io.write.CyNetworkViewWriterFactory;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.io.write.PresentationWriterFactory;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.rest.internal.GraphicsWriterManager;
import org.cytoscape.rest.internal.datamapper.VisualStyleMapper;
import org.cytoscape.rest.internal.model.CountModel;
import org.cytoscape.rest.internal.model.NetworkViewSUIDModel;
import org.cytoscape.rest.internal.model.ObjectVisualPropertyValueModel;
import org.cytoscape.rest.internal.model.VisualPropertyValueModel;
import org.cytoscape.rest.internal.model.VisualStyleModel;
import org.cytoscape.rest.internal.resource.AbstractResource;
import org.cytoscape.rest.internal.serializer.VisualStyleSerializer;
import org.cytoscape.rest.internal.task.HeadlessTaskMonitor;
import org.cytoscape.task.write.ExportNetworkViewTaskFactory;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.RenderingEngineManager;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.util.BoundedDouble;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Network Views"})
@Singleton
@Path(value="/v1/networks/{networkId}/views")
public class NetworkViewResource
extends AbstractResource {
    private static final String DING_ID = "org.cytoscape.ding";
    private static final String DEF_HEIGHT = "600";
    static final String RESOURCE_URN = "networks:views";
    private static final Logger logger = LoggerFactory.getLogger(NetworkViewResource.class);
    static final int NETWORK_NOT_FOUND_ERROR = 1;
    static final int NETWORK_VIEW_NOT_FOUND_ERROR = 2;
    static final int OBJECT_TYPE_NOT_FOUND_ERROR = 3;
    static final int OBJECT_VIEW_NOT_FOUND_ERROR = 4;
    static final int INVALID_PARAMETER_ERROR = 5;
    static final int NO_VIEWS_FOR_NETWORK_ERROR = 6;
    static final int NO_VISUAL_LEXICON_ERROR = 7;
    static final int SERIALIZATION_ERROR = 8;
    public static final int INTERNAL_METHOD_ERROR = 9;
    public static final int CX_SERVICE_UNAVAILABLE_ERROR = 10;
    public static final int VISUAL_PROPERTY_DOES_NOT_EXIST_ERROR = 11;
    private static final String FIRST_VIEWS_NOTE = "Cytoscape can have multiple views per network model, but this feature is not exposed in the Cytoscape GUI. GUI access is limited to the first available view only.";
    private static final String VIEW_FILE_PARAMETER_NOTES = "The format of the file written is defined by the file extension.\n\n| Extension   | Details    |\n| ----------- | -----------|\n| .cys        | Cytoscape Style format |\n| .xml/.xgmml | [XGMML](http://manual.cytoscape.org/en/stable/Supported_Network_File_Formats.html?highlight=xgmml#xgmml-format) format |\n| .nnf        | [NNF](http://manual.cytoscape.org/en/stable/Supported_Network_File_Formats.html#nnf) format |\n| .sif        | [SIF](http://manual.cytoscape.org/en/stable/Supported_Network_File_Formats.html#sif-format) format |\n| .cyjs       | [Cytoscape.js](http://manual.cytoscape.org/en/stable/Supported_Network_File_Formats.html#cytoscape-js-json) format |\n";
    private static final String VIEW_FILE_OPERATION_NOTES = "If the `file` parameter is left unspecified, the response will contain data in [Cytoscape.js](http://manual.cytoscape.org/en/stable/Supported_Network_File_Formats.html#cytoscape-js-json) format.\n\nIf the `file` parameter is specified, the Network View will be written to a file, and the response will contain the location of the file in the following format:\n\n```\n\n{\n  \"file\": \"/media/HD1/myFiles/networkView.sif\"\n}\n```\n\nThe format of the output file is defined by the extension of the `file` parameter.";
    private static final String BYPASS_NOTES = "Note that this sets the Visual Properties temporarily unless the `bypass` parameter is set to `true`. If the `bypass` parameter is set to `true`, the Visual Style will be overridden by these Visual Property values. If the `bypass` parameter is not used or is set to `false`, any Visual Properties set will return to those defined in the Visual Style if the Network View is updated.\n";
    @Inject
    @NotNull
    private RenderingEngineManager renderingEngineManager;
    @Inject
    @NotNull
    private GraphicsWriterManager graphicsWriterManager;
    @Inject
    @NotNull
    private ExportNetworkViewTaskFactory exportNetworkViewTaskFactory;
    private final VisualStyleMapper styleMapper = new VisualStyleMapper();
    private final VisualStyleSerializer styleSerializer = new VisualStyleSerializer();
    private VisualLexicon lexicon;
    private Collection<VisualProperty<?>> nodeLexicon;
    private Collection<VisualProperty<?>> edgeLexicon;
    private Collection<VisualProperty<?>> networkLexicon;

    @Override
    public String getResourceURI() {
        return RESOURCE_URN;
    }

    @Override
    public Logger getResourceLogger() {
        return logger;
    }

    private final void initLexicon() {
        this.lexicon = this.getLexicon(7);
        this.nodeLexicon = this.lexicon.getAllDescendants(BasicVisualLexicon.NODE);
        this.edgeLexicon = this.lexicon.getAllDescendants(BasicVisualLexicon.EDGE);
        this.networkLexicon = this.lexicon.getAllDescendants(BasicVisualLexicon.NETWORK).stream().filter(vp -> vp.getIdString().startsWith("NETWORK")).collect(Collectors.toSet());
    }

    @POST
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a new Network View", notes="Creates a new Network View for the Network specified by the `networkId` parameter.")
    @ApiResponses(value={@ApiResponse(code=201, message="Network View SUID", response=NetworkViewSUIDModel.class)})
    public Response createNetworkView(@ApiParam(value="SUID of the Network", required=true) @PathParam(value="networkId") Long networkId) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        CyNetworkView view = this.networkViewFactory.createNetworkView(network);
        this.networkViewManager.addNetworkView(view);
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)new NetworkViewSUIDModel(view.getSUID())).build();
    }

    @GET
    @Path(value="/count")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get number of views for the given network model", notes="Returns a count of the Network Views available for the Network specified by the `networkId` parameter.\n\nCytoscape can have multiple views per network model, but this feature is not exposed in the Cytoscape GUI. GUI access is limited to the first available view only.", response=CountModel.class)
    public String getNetworkViewCount(@ApiParam(value="SUID of the Network") @PathParam(value="networkId") Long networkId) {
        return this.getNumberObjectString(8, "count", this.networkViewManager.getNetworkViews(this.getCyNetwork(1, networkId)).size());
    }

    @DELETE
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete all Network Views", notes="Deletes all Network Views available in the Network specified by the `networkId` parameter. Cytoscape can have multiple views per network model, but this feature is not exposed in the Cytoscape GUI. GUI access is limited to the first available view only.\n\n")
    public Response deleteAllNetworkViews(@ApiParam(value="SUID of the Network", required=true) @PathParam(value="networkId") Long networkId) {
        try {
            Collection views = this.networkViewManager.getNetworkViews(this.getCyNetwork(1, networkId));
            HashSet toBeDestroyed = new HashSet(views);
            for (CyNetworkView view : toBeDestroyed) {
                this.networkViewManager.destroyNetworkView(view);
            }
            return Response.ok().build();
        }
        catch (Exception e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 9, "Could not delete network views for network with SUID: " + networkId, this.getResourceLogger(), e);
        }
    }

    @GET
    @Path(value="/first")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the first Network View (as JSON or a file)", notes="This returns the first view of the network. Cytoscape can have multiple views per network model, but this feature is not exposed in the Cytoscape GUI. GUI access is limited to the first available view only.\n\nIf the `file` parameter is left unspecified, the response will contain data in [Cytoscape.js](http://manual.cytoscape.org/en/stable/Supported_Network_File_Formats.html#cytoscape-js-json) format.\n\nIf the `file` parameter is specified, the Network View will be written to a file, and the response will contain the location of the file in the following format:\n\n```\n\n{\n  \"file\": \"/media/HD1/myFiles/networkView.sif\"\n}\n```\n\nThe format of the output file is defined by the extension of the `file` parameter.")
    public Response getFirstNetworkView(@ApiParam(value="SUID of the Network") @PathParam(value="networkId") Long networkId, @ApiParam(value="A path to a file relative to the current directory. The format of the file written is defined by the file extension.\n\n| Extension   | Details    |\n| ----------- | -----------|\n| .cys        | Cytoscape Style format |\n| .xml/.xgmml | [XGMML](http://manual.cytoscape.org/en/stable/Supported_Network_File_Formats.html?highlight=xgmml#xgmml-format) format |\n| .nnf        | [NNF](http://manual.cytoscape.org/en/stable/Supported_Network_File_Formats.html#nnf) format |\n| .sif        | [SIF](http://manual.cytoscape.org/en/stable/Supported_Network_File_Formats.html#sif-format) format |\n| .cyjs       | [Cytoscape.js](http://manual.cytoscape.org/en/stable/Supported_Network_File_Formats.html#cytoscape-js-json) format |\n", required=false) @QueryParam(value="file") String file) {
        Collection<CyNetworkView> views = this.getCyNetworkViews(1, 6, networkId);
        CyNetworkView view = views.iterator().next();
        return this.getNetworkView(networkId, view.getSUID(), file);
    }

    @DELETE
    @Path(value="/first")
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete the first available view", notes="Deletes the first available Network View for the Network specified by the `networkId` parameter. Cytoscape can have multiple views per network model, but this feature is not exposed in the Cytoscape GUI. GUI access is limited to the first available view only.")
    public Response deleteFirstNetworkView(@ApiParam(value="SUID of the Network") @PathParam(value="networkId") Long networkId) {
        Collection<CyNetworkView> views = this.getCyNetworkViews(1, 6, networkId);
        if (!views.isEmpty()) {
            this.networkViewManager.destroyNetworkView(views.iterator().next());
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/{viewId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a Network View (as JSON or a file)", notes="Gets the Network View specified by the `viewId` and `networkId` parameters.\n\nIf the `file` parameter is left unspecified, the response will contain data in [Cytoscape.js](http://manual.cytoscape.org/en/stable/Supported_Network_File_Formats.html#cytoscape-js-json) format.\n\nIf the `file` parameter is specified, the Network View will be written to a file, and the response will contain the location of the file in the following format:\n\n```\n\n{\n  \"file\": \"/media/HD1/myFiles/networkView.sif\"\n}\n```\n\nThe format of the output file is defined by the extension of the `file` parameter.")
    public Response getNetworkView(@ApiParam(value="SUID of the Network", required=true) @PathParam(value="networkId") Long networkId, @ApiParam(value="SUID of the Network View", required=true) @PathParam(value="viewId") Long viewId, @ApiParam(value="A path to a file relative to the current directory. The format of the file written is defined by the file extension.\n\n| Extension   | Details    |\n| ----------- | -----------|\n| .cys        | Cytoscape Style format |\n| .xml/.xgmml | [XGMML](http://manual.cytoscape.org/en/stable/Supported_Network_File_Formats.html?highlight=xgmml#xgmml-format) format |\n| .nnf        | [NNF](http://manual.cytoscape.org/en/stable/Supported_Network_File_Formats.html#nnf) format |\n| .sif        | [SIF](http://manual.cytoscape.org/en/stable/Supported_Network_File_Formats.html#sif-format) format |\n| .cyjs       | [Cytoscape.js](http://manual.cytoscape.org/en/stable/Supported_Network_File_Formats.html#cytoscape-js-json) format |\n", required=false) @QueryParam(value="file") String file) {
        Collection<CyNetworkView> views = this.getCyNetworkViews(1, 6, networkId);
        CyNetworkView targetView = null;
        for (CyNetworkView view : views) {
            Long vid = view.getSUID();
            if (!vid.equals(viewId)) continue;
            targetView = view;
            break;
        }
        if (targetView == null) {
            return Response.ok((Object)"{}").build();
        }
        if (file != null) {
            return Response.ok(this.writeNetworkFile(file, targetView)).build();
        }
        return Response.ok((Object)this.getNetworkViewString(targetView)).build();
    }

    @GET
    @Path(value="/{viewId}.cx")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a Network View in CX format", notes="Returns the Network View specified by the `viewId` and `networkId` parameters in [CX format](http://manual.cytoscape.org/en/stable/Supported_Network_File_Formats.html#cytoscape-cx)")
    public Response getNetworkViewAsCx(@ApiParam(value="SUID of the Network") @PathParam(value="networkId") Long networkId, @ApiParam(value="SUID of the Network View") @PathParam(value="viewId") Long viewId, @ApiParam(hidden=true, value="File (unused)") @QueryParam(value="file") String file) {
        Collection<CyNetworkView> views = this.getCyNetworkViews(1, 6, networkId);
        CyNetworkView targetView = null;
        for (CyNetworkView view : views) {
            Long vid = view.getSUID();
            if (!vid.equals(viewId)) continue;
            targetView = view;
            break;
        }
        if (targetView == null) {
            return Response.ok((Object)"{}").build();
        }
        CyNetworkViewWriterFactory cxWriterFactory = this.viewWriterFactoryManager.getFactory("cxNetworkWriterFactory");
        if (cxWriterFactory == null) {
            throw this.getCIWebApplicationException(Response.Status.SERVICE_UNAVAILABLE.getStatusCode(), this.getResourceURI(), 10, "CX writer is not available.  Please install CX Support App to use this API.", this.getResourceLogger(), null);
        }
        return Response.ok((Object)this.getNetworkViewStringAsCX(targetView)).build();
    }

    private final Map<String, String> writeNetworkFile(String file, CyNetworkView view) {
        File networkFile = null;
        try {
            networkFile = new File(file);
            TaskIterator itr = this.exportNetworkViewTaskFactory.createTaskIterator(view, networkFile);
            while (itr.hasNext()) {
                Task task = itr.next();
                task.run((TaskMonitor)new HeadlessTaskMonitor());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 9, "Could not save network file.", logger, e);
        }
        HashMap<String, String> message = new HashMap<String, String>();
        message.put("file", networkFile.getAbsolutePath());
        return message;
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all Network Views", notes="Returns an array of all network views belonging to the network specified by the `networkId` paramter. The response is a list of Network SUIDs.")
    @ApiResponses(value={@ApiResponse(code=200, message="An array of Network View SUIDs", response=Long.class, responseContainer="List")})
    public Collection<Long> getAllNetworkViews(@ApiParam(value="SUID of the Network", required=true) @PathParam(value="networkId") Long networkId) {
        Collection<CyNetworkView> views = this.getCyNetworkViews(1, 6, networkId);
        HashSet<Long> suids = new HashSet<Long>();
        for (CyNetworkView view : views) {
            Long viewId = view.getSUID();
            suids.add(viewId);
        }
        return suids;
    }

    private final String getNetworkViewString(CyNetworkView networkView) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        CyNetworkViewWriterFactory cytoscapeJsWtrFactory = (CyNetworkViewWriterFactory)this.cytoscapeJsWriterFactory.getService();
        CyWriter writer = cytoscapeJsWtrFactory.createWriter((OutputStream)stream, networkView);
        String jsonString = null;
        try {
            writer.run(null);
            jsonString = stream.toString("UTF-8");
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonString;
    }

    private final String getNetworkViewStringAsCX(CyNetworkView networkView) {
        CyNetworkViewWriterFactory cxWriterFactory = this.viewWriterFactoryManager.getFactory("cxNetworkWriterFactory");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        CyWriter writer = cxWriterFactory.createWriter((OutputStream)stream, networkView);
        String jsonString = null;
        try {
            writer.run(null);
            jsonString = stream.toString("UTF-8");
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonString;
    }

    @GET
    @Path(value="/first.png")
    @Produces(value={"image/png", "application/json"})
    @ApiOperation(value="Get PNG image of the first available network view", notes="Returns a PNG image of the first available Network View for the Network specified by the `networkId` parameter.\n\nSetting the `h` or `w` parameter will resize the image. Only one of these parameters can be used at a time; the remaining dimension of the image will be calculated automatically. Using both will result in an error.\n\n Default size is 600 px.\n\n")
    @ApiResponses(value={@ApiResponse(code=200, message="PNG image stream.")})
    public Response getFirstImageAsPng(@ApiParam(required=true, value="SUID of the Network") @PathParam(value="networkId") Long networkId, @ApiParam(required=false, value="Width of the image.") @QueryParam(value="w") Integer width, @ApiParam(required=false, value="Height of the image.") @QueryParam(value="h") Integer height) {
        if (width != null && height != null) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 5, "Height and Width are both non-null. Use only one of these parameters.", logger, null);
        }
        if (width == null && height == null) {
            height = 600;
        }
        return this.getImage("png", networkId, height, width);
    }

    @GET
    @Path(value="/first.svg")
    @Produces(value={"image/svg+xml"})
    @ApiOperation(value="Get SVG image of the first available network view", notes="Returns an SVG image of the first available Network View for the Network specified by the `networkId` parameter.\n\nDefault size is 600 px")
    @ApiResponses(value={@ApiResponse(code=200, message="SVG image stream.")})
    public Response getFirstImageAsSvg(@ApiParam(required=true, value="SUID of the Network") @PathParam(value="networkId") Long networkId, @ApiParam(hidden=true, required=false, value="Height of the image. Width is set automatically") @DefaultValue(value="600") @QueryParam(value="h") int height) {
        return this.getImage("svg", networkId, height);
    }

    @GET
    @Path(value="/first.pdf")
    @Produces(value={"image/pdf"})
    @ApiOperation(value="Get PDF image of the first available network view", notes="Returns a PDF of the first available Network View for the Network specified by the `networkId` parameter.\n\nDefault size is 600 px")
    @ApiResponses(value={@ApiResponse(code=200, message="PDF image stream.")})
    public Response getFirstImageAsPdf(@ApiParam(required=true, value="SUID of the Network") @PathParam(value="networkId") Long networkId, @ApiParam(hidden=true, required=false, value="Height of the image. Width is set automatically") @DefaultValue(value="600") @QueryParam(value="h") int height) {
        return this.getImage("pdf", networkId, height);
    }

    private final Response getImage(String fileType, Long networkId, int height) {
        return this.getImage(fileType, networkId, height, height);
    }

    private final Response getImage(String fileType, Long networkId, Integer height, Integer width) {
        Collection<CyNetworkView> views = this.getCyNetworkViews(1, 6, networkId);
        if (views.isEmpty()) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), this.getResourceURI(), 6, "Could not create image. No views available for network with SUID: " + networkId, this.getResourceLogger(), null);
        }
        PresentationWriterFactory factory = this.graphicsWriterManager.getFactory(fileType);
        CyNetworkView view = views.iterator().next();
        return this.imageGenerator(fileType, factory, view, width, height);
    }

    @GET
    @Path(value="/{viewId}.png")
    @Produces(value={"image/png", "application/json"})
    @ApiOperation(value="Get PNG image of a network view", notes="Returns a PNG image of the Network View specified by the `viewId` and `networkId` parameters.\n\nSetting the `h` or `w` parameter will resize the image. Only one of these parameters can be used at a time; the remaining dimension of the image will be calculated automatically. Using both will result in an error.\n\n Default size is 600 px.\n\n ")
    @ApiResponses(value={@ApiResponse(code=200, message="PNG image stream.")})
    public Response getImageAsPng(@ApiParam(required=true, value="SUID of the Network") @PathParam(value="networkId") Long networkId, @ApiParam(required=true, value="SUID of the Network View") @PathParam(value="viewId") Long viewId, @ApiParam(required=false, value="Width of the image.") @QueryParam(value="w") Integer width, @ApiParam(required=false, value="Height of the image.") @QueryParam(value="h") Integer height) {
        if (width != null && height != null) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 5, "Height and Width are both non-null. Use only one of these parameters.", logger, null);
        }
        if (width == null && height == null) {
            height = 600;
        }
        return this.getImageForView("png", networkId, viewId, height, width);
    }

    @GET
    @Path(value="/{viewId}.svg")
    @Produces(value={"image/svg+xml"})
    @ApiOperation(value="Get SVG image of a network view", notes="Returns an SVG image of the Network View specified by the `viewId` and `networkId` parameters.\n\nDefault size is 600 px.")
    @ApiResponses(value={@ApiResponse(code=200, message="SVG image stream.")})
    public Response getImageAsSvg(@ApiParam(required=true, value="SUID of the Network") @PathParam(value="networkId") Long networkId, @ApiParam(required=true, value="SUID of the Network View") @PathParam(value="viewId") Long viewId, @ApiParam(hidden=true, required=false, value="Height of the image. Width is set automatically") @DefaultValue(value="600") @QueryParam(value="h") int height) {
        return this.getImageForView("svg", networkId, viewId, height);
    }

    @GET
    @Path(value="/{viewId}.pdf")
    @Produces(value={"image/pdf"})
    @ApiOperation(value="Get PDF image of a network view", notes="Returns a PDF of the Network View specified by the `viewId` and `networkId` parameters.\n\nDefault size is 500 px.")
    @ApiResponses(value={@ApiResponse(code=200, message="PDF image stream.")})
    public Response getImageAsPdf(@ApiParam(required=true, value="SUID of the Network") @PathParam(value="networkId") Long networkId, @ApiParam(required=true, value="SUID of the Network View") @PathParam(value="viewId") Long viewId) {
        return this.getImageForView("pdf", networkId, viewId, 500);
    }

    private Response getImageForView(String fileType, Long networkId, Long viewId, Integer height, Integer width) {
        Collection<CyNetworkView> views = this.getCyNetworkViews(1, 6, networkId);
        for (CyNetworkView view : views) {
            Long vid = view.getSUID();
            if (!vid.equals(viewId)) continue;
            return this.getImage(fileType, networkId, height, width);
        }
        throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), RESOURCE_URN, 2, "Could not find view for the network: " + networkId, logger, null);
    }

    private Response getImageForView(String fileType, Long networkId, Long viewId, Integer height) {
        Collection<CyNetworkView> views = this.getCyNetworkViews(1, 6, networkId);
        for (CyNetworkView view : views) {
            Long vid = view.getSUID();
            if (!vid.equals(viewId)) continue;
            return this.getImage(fileType, networkId, height);
        }
        throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), RESOURCE_URN, 2, "Could not find view for the network: " + networkId, logger, null);
    }

    private final Response imageGenerator(String fileType, PresentationWriterFactory factory, CyNetworkView view, Integer width, Integer height) {
        Collection re = this.renderingEngineManager.getRenderingEngines((View)view);
        int maxRetries = 20;
        int sleepTime = 100;
        try {
            for (int retry = 0; re.isEmpty() && retry < 20; ++retry) {
                Thread.sleep(100L);
                re = this.renderingEngineManager.getRenderingEngines((View)view);
            }
        }
        catch (InterruptedException e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 9, "Image generation interrupted", this.getResourceLogger(), e);
        }
        if (re.isEmpty()) {
            throw new IllegalArgumentException("No rendering engine for {\"network\":" + ((CyNetwork)view.getModel()).getSUID() + ", \"view\":" + view.getSUID() + "}");
        }
        try {
            RenderingEngine engine = null;
            for (RenderingEngine r : re) {
                if (!r.getRendererId().equals(DING_ID)) continue;
                engine = r;
                break;
            }
            if (engine == null) {
                throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 9, "No DING rendering engine available", this.getResourceLogger(), null);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CyWriter writer = factory.createWriter((OutputStream)baos, engine);
            if (fileType.equals("png")) {
                Object zl = writer.getClass().getMethod("getZoom", new Class[0]).invoke((Object)writer, new Object[0]);
                BoundedDouble bound = (BoundedDouble)zl;
                bound.setBounds((Comparable)((Double)bound.getLowerBound()), (Comparable)Double.valueOf(15000.0));
                try {
                    if (height != null) {
                        writer.getClass().getMethod("setHeightInPixels", Integer.TYPE).invoke((Object)writer, height);
                    } else if (width != null) {
                        writer.getClass().getMethod("setWidthInPixels", Integer.TYPE).invoke((Object)writer, width);
                    }
                }
                catch (Exception e) {
                    try {
                        Object units = writer.getClass().getMethod("getUnits", new Class[0]).invoke((Object)writer, new Object[0]);
                        Method method = units.getClass().getMethod("setSelectedValue", Object.class);
                        method.invoke(units, "pixels");
                        if (height != null) {
                            Double doubleHeight = height.doubleValue();
                            writer.getClass().getMethod("setHeight", Double.class).invoke((Object)writer, doubleHeight);
                        } else if (width != null) {
                            Double doubleWidth = width.doubleValue();
                            writer.getClass().getMethod("setWidth", Double.class).invoke((Object)writer, doubleWidth);
                        }
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            writer.run((TaskMonitor)new HeadlessTaskMonitor());
            byte[] imageData = baos.toByteArray();
            return Response.ok((Object)new ByteArrayInputStream(imageData)).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 9, "Could not create image.", this.getResourceLogger(), e);
        }
    }

    private void setVisualProperty(CyNetworkView networkView, String objectType, long objectId, JsonNode viewNode, boolean bypass) {
        if (viewNode == null) {
            return;
        }
        if (objectType == null || !objectType.equals("nodes") && !objectType.equals("edges")) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), RESOURCE_URN, 3, "Object type not recognized:" + objectType, logger, null);
        }
        View<? extends CyIdentifiable> view = this.getObjectView(networkView, objectType, objectId);
        if (view == null) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), RESOURCE_URN, 4, "Could not find view for object: " + objectId, logger, null);
        }
        this.styleMapper.updateView(view, viewNode, this.getLexicon(7), bypass);
    }

    @PUT
    @Path(value="/{viewId}/{objectType}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update multiple node/edge Visual Properties at once", notes="Updates multiple node or edge Visual Properties as defined by the `objectType` parameter, in the Network View specified by the `viewId` and `networkId` parameters.\n\nExamples of Visual Properties:\n\n```\n{\n  \"visualProperty\": \"NODE_BORDER_WIDTH\",\n  \"value\": 2\n}\n```\n```\n{\n  \"visualProperty\": \"NODE_BORDER_PAINT\",\n  \"value\": \"#CCCCCC\"\n}\n```\n\n```\n{\n  \"visualProperty\": \"EDGE_TRANSPARENCY\",\n  \"value\": 170\n}```\n```\n{\n  \"visualProperty\": \"EDGE_PAINT\",\n  \"value\": \"#808080\"\n }```\n\n\nAdditional details on common Visual Properties can be found in the [Basic Visual Lexicon JavaDoc API](http://chianti.ucsd.edu/cytoscape-3.8.0/API/org/cytoscape/view/presentation/property/BasicVisualLexicon.html)\n\nNote that this sets the Visual Properties temporarily unless the `bypass` parameter is set to `true`. If the `bypass` parameter is set to `true`, the Visual Style will be overridden by these Visual Property values. If the `bypass` parameter is not used or is set to `false`, any Visual Properties set will return to those defined in the Visual Style if the Network View is updated.\n")
    @ApiImplicitParams(value={@ApiImplicitParam(value="A list of Objects with Visual Properties.", dataType="[Lorg.cytoscape.rest.internal.model.ObjectVisualPropertyValueModel;", paramType="body", required=true)})
    public Response updateViews(@ApiParam(value="SUID of the Network", required=true) @PathParam(value="networkId") Long networkId, @ApiParam(value="SUID of the Network View", required=true) @PathParam(value="viewId") Long viewId, @ApiParam(value="Type of Object", required=true, allowableValues="nodes,edges") @PathParam(value="objectType") String objectType, @ApiParam(value="Bypass the Visual Style with these Visual Properties", defaultValue="false") @QueryParam(value="bypass") Boolean bypass, @ApiParam(hidden=true) InputStream is) {
        CyNetworkView networkView = this.getView(networkId, viewId);
        ObjectMapper objMapper = new ObjectMapper();
        if (bypass == null) {
            bypass = false;
        }
        try {
            JsonNode rootNode = (JsonNode)objMapper.readValue(is, JsonNode.class);
            for (JsonNode entry : rootNode) {
                Long objectId = entry.get("SUID").asLong();
                JsonNode viewNode = entry.get("view");
                if (objectId == null) continue;
                this.setVisualProperty(networkView, objectType, objectId, viewNode, bypass);
            }
            networkView.updateView();
        }
        catch (Exception e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 5, "Could not parse the input JSON for updating view because: " + e.getMessage(), logger, e);
        }
        return Response.ok().build();
    }

    @PUT
    @Path(value="/{viewId}/{objectType}/{objectId}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update the Visual Properties of an Object", notes="Updates the Visual Properties in the object specified by the `objectId` and `objectType` parameters in the Network View specified by the `viewId` and `networkId` parameters.\n\nExamples of Visual Properties:\n\n```\n{\n  \"visualProperty\": \"NODE_BORDER_WIDTH\",\n  \"value\": 2\n}\n```\n\n```\n{\n  \"visualProperty\": \"EDGE_TRANSPARENCY\",\n  \"value\": 170\n}```\n\n```\n{\n  \"visualProperty\": \"NETWORK_BACKGROUND_PAINT\",\n  \"value\": \"#000000\"\n}```\n\n\nAdditional details on common Visual Properties can be found in the [Basic Visual Lexicon JavaDoc API](http://chianti.ucsd.edu/cytoscape-3.8.0/API/org/cytoscape/view/presentation/property/BasicVisualLexicon.html)\n\nNote that this sets the Visual Properties temporarily unless the `bypass` parameter is set to `true`. If the `bypass` parameter is set to `true`, the Visual Style will be overridden by these Visual Property values. If the `bypass` parameter is not used or is set to `false`, any Visual Properties set will return to those defined in the Visual Style if the Network View is updated.\n")
    @ApiImplicitParams(value={@ApiImplicitParam(value="A list of Visual Properties and their values.", dataType="[Lorg.cytoscape.rest.internal.model.VisualPropertyValueModel;", paramType="body", required=true)})
    public Response updateView(@ApiParam(value="SUID of the Network") @PathParam(value="networkId") Long networkId, @ApiParam(value="SUID of the Network View") @PathParam(value="viewId") Long viewId, @ApiParam(value="Type of Object", allowableValues="nodes,edges,network") @PathParam(value="objectType") String objectType, @ApiParam(value="SUID of the Object") @PathParam(value="objectId") Long objectId, @ApiParam(value="Bypass the Visual Style with these Visual Properties", defaultValue="true") @QueryParam(value="bypass") Boolean bypass, @ApiParam(hidden=true) InputStream is) {
        CyNetworkView networkView = this.getView(networkId, viewId);
        View<? extends CyIdentifiable> view = this.getObjectView(networkView, objectType, objectId);
        if (view == null) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), RESOURCE_URN, 4, "Could not find view for object: " + objectId, logger, null);
        }
        ObjectMapper objMapper = new ObjectMapper();
        if (bypass == null) {
            bypass = false;
        }
        try {
            JsonNode rootNode = (JsonNode)objMapper.readValue(is, JsonNode.class);
            this.styleMapper.updateView(view, rootNode, this.getLexicon(7), bypass);
        }
        catch (Exception e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 5, "Could not parse the input JSON for updating view because: " + e.getMessage(), logger, e);
        }
        networkView.updateView();
        return Response.ok().build();
    }

    @PUT
    @Path(value="/{viewId}/network")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update the Visual Properties for a Network View", notes="Updates the Visual Properties in the Network View specified by the `viewId` and `networkId` parameters.\n\nExample Visual Properties:\n```\n{\n  \"visualProperty\": \"NETWORK_BACKGROUND_PAINT\",\n  \"value\": \"#000000\"\n}```\n```\n{\n  \"visualProperty\": \"NETWORK_CENTER_X_LOCATION\",\n  \"value\": 250\n}```\n\n\nAdditional details on common Visual Properties can be found in the [Basic Visual Lexicon JavaDoc API](http://chianti.ucsd.edu/cytoscape-3.8.0/API/org/cytoscape/view/presentation/property/BasicVisualLexicon.html)\n\nNote that this sets the Visual Properties temporarily unless the `bypass` parameter is set to `true`. If the `bypass` parameter is set to `true`, the Visual Style will be overridden by these Visual Property values. If the `bypass` parameter is not used or is set to `false`, any Visual Properties set will return to those defined in the Visual Style if the Network View is updated.\n")
    @ApiImplicitParams(value={@ApiImplicitParam(value="A list of Visual Properties and their values.", dataType="[Lorg.cytoscape.rest.internal.model.VisualPropertyValueModel;", paramType="body", required=true)})
    public Response updateNetworkView(@ApiParam(value="Network SUID") @PathParam(value="networkId") Long networkId, @ApiParam(value="Network View SUID") @PathParam(value="viewId") Long viewId, @ApiParam(value="Bypass the Visual Style with these properties", defaultValue="false") @QueryParam(value="bypass") Boolean bypass, @ApiParam(hidden=true) InputStream is) {
        CyNetworkView networkView = this.getView(networkId, viewId);
        ObjectMapper objMapper = new ObjectMapper();
        if (bypass == null) {
            bypass = false;
        }
        try {
            JsonNode rootNode = (JsonNode)objMapper.readValue(is, JsonNode.class);
            this.styleMapper.updateView((View<? extends CyIdentifiable>)networkView, rootNode, this.getLexicon(7), bypass);
        }
        catch (Exception e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 5, "Could not parse the input JSON for updating view because: " + e.getMessage(), logger, e);
        }
        networkView.updateView();
        return Response.ok().build();
    }

    @GET
    @Path(value="/{viewId}/network")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the Visual Properties for a Network View", notes="Returns a list of the Visual Properties for the Network View specified by the `viewId` and `networkId` parameters.\n\nAdditional details on common Visual Properties can be found in the [Basic Visual Lexicon JavaDoc API](http://chianti.ucsd.edu/cytoscape-3.8.0/API/org/cytoscape/view/presentation/property/BasicVisualLexicon.html)", response=VisualPropertyValueModel.class, responseContainer="List")
    public Response getNetworkVisualProps(@ApiParam(value="SUID of the Network") @PathParam(value="networkId") Long networkId, @ApiParam(value="SUID of the Network View") @PathParam(value="viewId") Long viewId) {
        return this.getViews(networkId, viewId, "network", null);
    }

    @GET
    @Path(value="/{viewId}/{objectType}/{objectId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the Visual Properties for a Node or Edge Object", notes="Gets a list of Visual Properties for the Object specified by the `objectId` and `objectType` parameters in the Network View specified by the `viewId` and `networkId` parameters.\n\nAdditional details on common Visual Properties can be found in the [Basic Visual Lexicon JavaDoc API](http://chianti.ucsd.edu/cytoscape-3.8.0/API/org/cytoscape/view/presentation/property/BasicVisualLexicon.html)\n\n", response=VisualPropertyValueModel.class, responseContainer="List")
    public String getView(@ApiParam(value="SUID of the Network") @PathParam(value="networkId") Long networkId, @ApiParam(value="SUID of the Network View") @PathParam(value="viewId") Long viewId, @ApiParam(value="Type of Object", allowableValues="nodes,edges") @PathParam(value="objectType") String objectType, @ApiParam(value="SUID of the Object") @PathParam(value="objectId") Long objectId) {
        CyNetworkView networkView = this.getView(networkId, viewId);
        View<? extends CyIdentifiable> view = this.getObjectView(networkView, objectType, objectId);
        Collection<VisualProperty<?>> lex = this.getVisualProperties(objectType);
        if (view == null) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), RESOURCE_URN, 4, "Could not find view for object: " + objectId, logger, null);
        }
        try {
            return this.styleSerializer.serializeView(view, lex);
        }
        catch (IOException e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 8, "Could not serialize the view object.", this.getResourceLogger(), e);
        }
    }

    private Collection<VisualProperty<?>> getVisualProperties(String objectType) {
        Collection<VisualProperty<?>> vps = null;
        if (this.nodeLexicon == null) {
            this.initLexicon();
        }
        if (objectType.equals("nodes")) {
            vps = this.nodeLexicon;
        } else if (objectType.equals("edges")) {
            vps = this.edgeLexicon;
        } else if (objectType.equals("network")) {
            vps = this.networkLexicon;
        }
        return vps;
    }

    private View<? extends CyIdentifiable> getObjectView(CyNetworkView networkView, String objectType, Long objectId) {
        CyNetworkView view = null;
        if (objectType.equals("nodes")) {
            CyNode cyNode = ((CyNetwork)networkView.getModel()).getNode(objectId.longValue());
            if (cyNode != null) {
                view = networkView.getNodeView(cyNode);
            }
        } else if (objectType.equals("edges")) {
            CyEdge cyEdge = ((CyNetwork)networkView.getModel()).getEdge(objectId.longValue());
            if (cyEdge != null) {
                view = networkView.getEdgeView(((CyNetwork)networkView.getModel()).getEdge(objectId.longValue()));
            }
        } else if (objectType.equals("network")) {
            view = networkView;
        } else {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), RESOURCE_URN, 3, "Object type not found: " + objectType, logger, null);
        }
        return view;
    }

    @GET
    @Path(value="/{viewId}/{objectType}/{objectId}/{visualProperty}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a Visual Property for an Object", notes="Gets the Visual Property specificed by the `visualProperty` parameter for the node or edge specified by the `objectId` parameter in the Network View specified by the `viewId` and `networkId` parameters.\n\nAdditional details on common Visual Properties can be found in the [Basic Visual Lexicon JavaDoc API](http://chianti.ucsd.edu/cytoscape-3.8.0/API/org/cytoscape/view/presentation/property/BasicVisualLexicon.html)\n\n", response=VisualPropertyValueModel.class)
    public String getSingleVisualPropertyValue(@ApiParam(value="SUID of the Network") @PathParam(value="networkId") Long networkId, @ApiParam(value="SUID of the Network View") @PathParam(value="viewId") Long viewId, @ApiParam(value="Type of Object", allowableValues="nodes,edges") @PathParam(value="objectType") String objectType, @ApiParam(value="SUID of the Object") @PathParam(value="objectId") Long objectId, @ApiParam(value="Name of the Visual Property", example="NODE_SHAPE") @PathParam(value="visualProperty") String visualProperty) {
        CyNetworkView networkView = this.getView(networkId, viewId);
        if (objectType == null || !objectType.equals("nodes") && !objectType.equals("edges")) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), RESOURCE_URN, 3, "Object type not found:" + objectType, logger, null);
        }
        Collection<VisualProperty<?>> vps = this.getVisualProperties(objectType);
        View<? extends CyIdentifiable> view = this.getObjectView(networkView, objectType, objectId);
        if (view == null) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), RESOURCE_URN, 4, "Could not find view.", logger, null);
        }
        return this.getSingleVp(visualProperty, view, vps);
    }

    @GET
    @Path(value="/{viewId}/{objectType}/{objectId}/{visualProperty}/bypass")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the Visual Properties a Visual Style is bypassed with", notes="Gets the bypass Visual Property specified by the `visualProperty` parameter from the object specified by the `objectId` and `objectType` parameters in the Network View Specified by the `viewId` and `networkId` parameters. The response is the Visual Property that is used in place of the definition provided by the Visual Style.\n\nAdditional details on common Visual Properties can be found in the [Basic Visual Lexicon JavaDoc API](http://chianti.ucsd.edu/cytoscape-3.8.0/API/org/cytoscape/view/presentation/property/BasicVisualLexicon.html)\n\n", response=SingleVisualPropertyResponse.class)
    public Response getSingleVisualPropertyValueBypass(@ApiParam(value="Network SUID") @PathParam(value="networkId") Long networkId, @ApiParam(value="Network View SUID") @PathParam(value="viewId") Long viewId, @ApiParam(value="Type of Object", allowableValues="nodes,edges") @PathParam(value="objectType") String objectType, @ApiParam(value="SUID of the Object") @PathParam(value="objectId") Long objectId, @ApiParam(value="Name of the Visual Property") @PathParam(value="visualProperty") String visualProperty) {
        CyNetworkView networkView = this.getNetworkViewCI(networkId, viewId);
        View<? extends CyIdentifiable> view = this.getObjectView(networkView, objectType, objectId);
        if (view == null) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), RESOURCE_URN, 4, "Could not find object view: " + objectId, logger, null);
        }
        VisualProperty<?> targetVp = this.getTargetVisualPropertyCI(view, objectType, visualProperty, true);
        VisualPropertyValueModel entity = new VisualPropertyValueModel();
        entity.visualProperty = targetVp.getIdString();
        Object value = view.getVisualProperty(targetVp);
        entity.value = targetVp.getRange().getType().equals(Boolean.class) || targetVp.getRange().getType().equals(String.class) || Number.class.isAssignableFrom(targetVp.getRange().getType()) ? value : targetVp.toSerializableString(value);
        return Response.ok((Object)this.ciResponseFactory.getCIResponse((Object)entity)).build();
    }

    private CyNetworkView getNetworkViewCI(Long networkId, Long viewId) throws WebApplicationException {
        CyNetworkView networkView = null;
        try {
            networkView = this.getView(networkId, viewId);
        }
        catch (NotFoundException e) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), RESOURCE_URN, 2, e.getMessage(), logger, (Exception)((Object)e));
        }
        return networkView;
    }

    private VisualProperty<?> getTargetVisualPropertyCI(View<? extends CyIdentifiable> view, String objectType, String visualProperty, boolean mustExist) throws WebApplicationException {
        Collection<VisualProperty<?>> vps = this.getVisualProperties(objectType);
        VisualProperty<?> targetVp = null;
        for (VisualProperty<?> vp : vps) {
            if (!vp.getIdString().equals(visualProperty)) continue;
            if (mustExist) {
                if (!view.isDirectlyLocked(vp)) break;
                targetVp = vp;
                break;
            }
            targetVp = vp;
            break;
        }
        if (targetVp == null) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), this.getResourceURI(), 11, "Bypass Visual Property does not exist: " + visualProperty, this.getResourceLogger(), null);
        }
        return targetVp;
    }

    @PUT
    @Path(value="/{viewId}/{objectType}/{objectId}/{visualProperty}/bypass")
    @Produces(value={"application/json"})
    @ApiOperation(value="Bypass a Visual Style with a set Visual Property", notes="Bypasses the Visual Style of the object specified by the `objectId` and `objectType` parameters, in the Network View specified by the `viewId` and `networkId` parameters. The Visual Property included in the message body will be used instead of the definition provided by the Visual Style.\n\nExamples of Visual Properties:\n\n```\n{\n  \"visualProperty\": \"NODE_BORDER_WIDTH\",\n  \"value\": 2\n}\n```\n\n```\n{\n  \"visualProperty\": \"EDGE_TRANSPARENCY\",\n  \"value\": 170\n}```\n\n```\n{\n  \"visualProperty\": \"NETWORK_BACKGROUND_PAINT\",\n  \"value\": \"#000000\"\n}```\n\n\nAdditional details on common Visual Properties can be found in the [Basic Visual Lexicon JavaDoc API](http://chianti.ucsd.edu/cytoscape-3.8.0/API/org/cytoscape/view/presentation/property/BasicVisualLexicon.html)")
    @ApiImplicitParams(value={@ApiImplicitParam(value="A Visual Property and its value.", dataType="org.cytoscape.rest.internal.model.VisualPropertyValueModel", paramType="body", required=true)})
    public Response putSingleVisualPropertyValueBypass(@ApiParam(value="Network SUID") @PathParam(value="networkId") Long networkId, @ApiParam(value="Network View SUID") @PathParam(value="viewId") Long viewId, @ApiParam(value="Type of Object", allowableValues="nodes,edges") @PathParam(value="objectType") String objectType, @ApiParam(value="SUID of the Object") @PathParam(value="objectId") Long objectId, @ApiParam(value="Name of the Visual Property") @PathParam(value="visualProperty") String visualProperty, @ApiParam(hidden=true) InputStream inputStream) {
        CyNetworkView networkView = this.getNetworkViewCI(networkId, viewId);
        View<? extends CyIdentifiable> view = this.getObjectView(networkView, objectType, objectId);
        if (view == null) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), RESOURCE_URN, 4, "Could not find object view: " + objectId, logger, null);
        }
        this.getTargetVisualPropertyCI(view, objectType, visualProperty, false);
        try {
            ObjectMapper objMapper = new ObjectMapper();
            JsonNode rootNode = (JsonNode)objMapper.readValue(inputStream, JsonNode.class);
            this.styleMapper.updateViewVisualProperty(view, rootNode, this.getLexicon(7), true);
        }
        catch (Exception e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 5, "Could not parse the input JSON for updating view. Reason: " + e.getMessage(), logger, e);
        }
        return Response.ok().entity((Object)this.ciResponseFactory.getCIResponse(new Object())).build();
    }

    @DELETE
    @Path(value="/{viewId}/{objectType}/{objectId}/{visualProperty}/bypass")
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete the Visual Property a Visual Style is bypassed with", notes="Deletes the bypass Visual Property specified by the `visualProperty` parameter from the object specified by the `objectId` and `objectType` parameters in the Network View Specified by the `viewId` and `networkId` parameters. When this is done, the Visual Property will be defined by the Visual Style\n\nAdditional details on common Visual Properties can be found in the [Basic Visual Lexicon JavaDoc API](http://chianti.ucsd.edu/cytoscape-3.8.0/API/org/cytoscape/view/presentation/property/BasicVisualLexicon.html)\n\n", response=CIResponse.class)
    public Response deleteSingleVisualPropertyValueBypass(@ApiParam(value="SUID of the Network") @PathParam(value="networkId") Long networkId, @ApiParam(value="SUID of the Network View") @PathParam(value="viewId") Long viewId, @ApiParam(value="Type of Object", allowableValues="nodes,edges") @PathParam(value="objectType") String objectType, @ApiParam(value="SUID of Object") @PathParam(value="objectId") Long objectId, @ApiParam(value="Name of the Visual Property") @PathParam(value="visualProperty") String visualProperty) {
        CyNetworkView networkView = this.getNetworkViewCI(networkId, viewId);
        View<? extends CyIdentifiable> view = this.getObjectView(networkView, objectType, objectId);
        if (view == null) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), RESOURCE_URN, 4, "Could not find object view: " + objectId, logger, null);
        }
        VisualProperty<?> targetVp = this.getTargetVisualPropertyCI(view, objectType, visualProperty, true);
        view.clearValueLock(targetVp);
        return Response.ok().entity((Object)this.ciResponseFactory.getCIResponse(new Object())).build();
    }

    @GET
    @Path(value="/{viewId}/network/{visualProperty}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a network Visual Property", notes="Gets the Network Visual Property specificed by the `visualProperty`, `viewId`, and `networkId` parameters.\n\nAdditional details on common Visual Properties can be found in the [Basic Visual Lexicon JavaDoc API](http://chianti.ucsd.edu/cytoscape-3.8.0/API/org/cytoscape/view/presentation/property/BasicVisualLexicon.html)")
    public String getNetworkVisualProp(@ApiParam(value="SUID of the Network") @PathParam(value="networkId") Long networkId, @ApiParam(value="SUID of the Network View") @PathParam(value="viewId") Long viewId, @ApiParam(value="Name of the Visual Property") @PathParam(value="visualProperty") String visualProperty) {
        CyNetworkView networkView = this.getView(networkId, viewId);
        if (this.nodeLexicon == null) {
            this.initLexicon();
        }
        return this.getSingleVp(visualProperty, (View<? extends CyIdentifiable>)networkView, this.networkLexicon);
    }

    @PUT
    @Path(value="/{viewId}/network/{visualProperty}/bypass")
    @Produces(value={"application/json"})
    @ApiOperation(value="Bypass the Network Visual Style with a set Visual Property", notes="Bypasses the Visual Style of the Network with the Visual Property specificed by the `visualProperty`, `viewId`, and `networkId` parameters.\n\nAdditional details on common Visual Properties can be found in the [Basic Visual Lexicon JavaDoc API](http://chianti.ucsd.edu/cytoscape-3.8.0/API/org/cytoscape/view/presentation/property/BasicVisualLexicon.html)", response=CIResponse.class)
    @ApiImplicitParams(value={@ApiImplicitParam(value="A Visual Property and its value.", dataType="org.cytoscape.rest.internal.model.VisualPropertyValueModel", paramType="body", required=true)})
    public Response putNetworkVisualPropBypass(@ApiParam(value="SUID of the Network") @PathParam(value="networkId") Long networkId, @ApiParam(value="SUID of the Network View") @PathParam(value="viewId") Long viewId, @ApiParam(value="Name of the Visual Property") @PathParam(value="visualProperty") String visualProperty, @ApiParam(hidden=true) InputStream is) {
        CyNetworkView networkView = this.getNetworkViewCI(networkId, viewId);
        if (this.nodeLexicon == null) {
            this.initLexicon();
        }
        this.getTargetVisualPropertyCI((View<? extends CyIdentifiable>)networkView, "network", visualProperty, false);
        try {
            ObjectMapper objMapper = new ObjectMapper();
            JsonNode rootNode = (JsonNode)objMapper.readValue(is, JsonNode.class);
            this.styleMapper.updateViewVisualProperty((View<? extends CyIdentifiable>)networkView, rootNode, this.getLexicon(7), true);
        }
        catch (Exception e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 5, "Could not parse the input JSON for updating view. Reason: " + e.getMessage(), logger, e);
        }
        return Response.ok().entity((Object)this.ciResponseFactory.getCIResponse(new Object())).build();
    }

    @DELETE
    @Path(value="/{viewId}/network/{visualProperty}/bypass")
    @Produces(value={"application/json"})
    @ApiOperation(value="Deletes the Visual Property the Network Visual Style is bypassed with", notes="Deletes the bypass Visual Property specificed by the `visualProperty`, `viewId`, and `networkId` parameters. When this is done, the Visual Property will be defined by the Visual Style\n\nAdditional details on common Visual Properties can be found in the [Basic Visual Lexicon JavaDoc API](http://chianti.ucsd.edu/cytoscape-3.8.0/API/org/cytoscape/view/presentation/property/BasicVisualLexicon.html)", response=CIResponse.class)
    public Response deleteNetworkVisualProp(@ApiParam(value="SUID of the Network") @PathParam(value="networkId") Long networkId, @ApiParam(value="SUID of the Network View") @PathParam(value="viewId") Long viewId, @ApiParam(value="Name of the Visual Property") @PathParam(value="visualProperty") String visualProperty) {
        CyNetworkView networkView = this.getNetworkViewCI(networkId, viewId);
        VisualProperty<?> targetVp = this.getTargetVisualPropertyCI((View<? extends CyIdentifiable>)networkView, "network", visualProperty, true);
        networkView.clearValueLock(targetVp);
        return Response.ok().entity((Object)this.ciResponseFactory.getCIResponse(new Object())).build();
    }

    @GET
    @Path(value="/{viewId}/network/{visualProperty}/bypass")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the Visual Property the Network Visual Style is bypassed with", notes="Gets the bypass Visual Property specified by the `visualProperty`, `viewId`, and `networkId` parameters.  The response is the Visual Property that is used in place of the definition provided by the Visual Style.\n\nAdditional details on common Visual Properties can be found in the [Basic Visual Lexicon JavaDoc API](http://chianti.ucsd.edu/cytoscape-3.8.0/API/org/cytoscape/view/presentation/property/BasicVisualLexicon.html)", response=SingleVisualPropertyResponse.class)
    public Response getNetworkVisualPropBypass(@ApiParam(value="SUID of the Network") @PathParam(value="networkId") Long networkId, @ApiParam(value="SUID of the Network View") @PathParam(value="viewId") Long viewId, @ApiParam(value="Name of the Visual Property") @PathParam(value="visualProperty") String visualProperty) {
        CyNetworkView networkView = this.getNetworkViewCI(networkId, viewId);
        VisualProperty<?> targetVp = this.getTargetVisualPropertyCI((View<? extends CyIdentifiable>)networkView, "network", visualProperty, true);
        VisualPropertyValueModel entity = new VisualPropertyValueModel();
        entity.visualProperty = targetVp.getIdString();
        Object value = networkView.getVisualProperty(targetVp);
        entity.value = targetVp.getRange().getType().equals(Boolean.class) || targetVp.getRange().getType().equals(String.class) || Number.class.isAssignableFrom(targetVp.getRange().getType()) ? value : targetVp.toSerializableString(value);
        return Response.ok((Object)this.ciResponseFactory.getCIResponse((Object)entity)).build();
    }

    private String getSingleVp(String visualProperty, View<? extends CyIdentifiable> view, Collection<VisualProperty<?>> vps) {
        VisualProperty<?> targetVp = null;
        for (VisualProperty<?> vp : vps) {
            if (!vp.getIdString().equals(visualProperty)) continue;
            targetVp = vp;
            break;
        }
        if (targetVp == null) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), this.getResourceURI(), 11, "Visual Property does not exist: " + visualProperty, this.getResourceLogger(), null);
        }
        try {
            return this.styleSerializer.serializeSingleVisualProp(view, targetVp);
        }
        catch (IOException e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 8, "Could not serialize the view object.", this.getResourceLogger(), e);
        }
    }

    @GET
    @Path(value="/{viewId}/currentStyle")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the current Visual Style for a Network View", notes="Returns the current Visual Style used by the Network View specified by the `networkId` and `viewId` parameters.", response=VisualStyleModel.class, tags={"Visual Styles"})
    public String getCurrentStyle(@ApiParam(value="SUID of the Network") @PathParam(value="networkId") Long networkId, @ApiParam(value="SUID of the Network View") @PathParam(value="viewId") Long viewId) {
        CyNetworkView networkView = this.getNetworkViewCI(networkId, viewId);
        VisualStyle style = this.vmm.getVisualStyle(networkView);
        try {
            return this.styleSerializer.serializeStyle(this.getLexicon(7).getAllVisualProperties(), style);
        }
        catch (IOException e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 9, "Could not get Visual Style JSON.", logger, e);
        }
    }

    @GET
    @Path(value="/{viewId}/{objectType}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all set values for a specific Visual Property", notes="Returns a list of all Visual Property values for the Visual Property specified by the `visualProperty` and `objectType` parameters, in the Network View specified by the `viewId` and `networkId` parameters.\n\nAdditional details on common Visual Properties can be found in the [Basic Visual Lexicon JavaDoc API](http://chianti.ucsd.edu/cytoscape-3.8.0/API/org/cytoscape/view/presentation/property/BasicVisualLexicon.html)", response=ObjectVisualPropertyValueModel.class, responseContainer="List")
    public Response getViews(@ApiParam(value="SUID of the Network") @PathParam(value="networkId") Long networkId, @ApiParam(value="SUID of the Network View") @PathParam(value="viewId") Long viewId, @ApiParam(value="Type of Object", allowableValues="nodes,edges,network") @PathParam(value="objectType") String objectType, @ApiParam(value="Name of the Visual Property", example="NODE_SHAPE") @QueryParam(value="visualProperty") String visualProperty) {
        if (visualProperty != null) {
            String result = this.getSingleVisualPropertyOfViews(networkId, viewId, objectType, visualProperty);
            return Response.ok((Object)result).build();
        }
        Collection<VisualProperty<?>> vps = this.getVisualProperties(objectType);
        return Response.ok((Object)this.getViewForVPList(networkId, viewId, objectType, vps)).build();
    }

    private final String getViewForVPList(Long networkId, Long viewId, String objectType, Collection<VisualProperty<?>> vps) {
        CyNetworkView networkView = this.getView(networkId, viewId);
        Collection graphObjects = null;
        if (objectType.equals("nodes")) {
            graphObjects = networkView.getNodeViews();
        } else if (objectType.equals("edges")) {
            graphObjects = networkView.getEdgeViews();
        } else if (objectType.equals("network")) {
            try {
                return this.styleSerializer.serializeView((View<? extends CyIdentifiable>)networkView, vps);
            }
            catch (IOException e) {
                throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 8, "Could not serialize the view object.", this.getResourceLogger(), e);
            }
        }
        if (graphObjects == null || graphObjects.isEmpty()) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), RESOURCE_URN, 4, "Could not find views.", logger, null);
        }
        try {
            return this.styleSerializer.serializeViews(graphObjects, vps);
        }
        catch (IOException e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 8, "Could not serialize the view object.", this.getResourceLogger(), e);
        }
    }

    private final String getSingleVisualPropertyOfViews(Long networkId, Long viewId, String objectType, String visualPropertyName) {
        if (this.nodeLexicon == null) {
            this.initLexicon();
        }
        HashSet vps = new HashSet();
        if (objectType.equals("nodes")) {
            vps.add(this.lexicon.lookup(CyNode.class, visualPropertyName));
        } else if (objectType.equals("edges")) {
            vps.add(this.lexicon.lookup(CyEdge.class, visualPropertyName));
        }
        if (vps.size() == 0) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), this.getResourceURI(), 11, "Visual Property does not exist: " + visualPropertyName, this.getResourceLogger(), null);
        }
        return this.getViewForVPList(networkId, viewId, objectType, vps);
    }

    private final CyNetworkView getView(Long networkId, Long viewId) {
        Collection<CyNetworkView> views = this.getCyNetworkViews(1, 6, networkId);
        for (CyNetworkView view : views) {
            Long vid = view.getSUID();
            if (!vid.equals(viewId)) continue;
            return view;
        }
        throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), RESOURCE_URN, 2, "Could not find network view: " + viewId, logger, null);
    }

    private static class SingleVisualPropertyResponse
    extends CIResponse<VisualPropertyValueModel> {
        private SingleVisualPropertyResponse() {
        }
    }
}

