/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal.resource;

import com.google.inject.Inject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Properties;
import javax.inject.Singleton;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.cytoscape.rest.internal.model.CytoscapeVersionModel;
import org.cytoscape.rest.internal.model.ServerStatusModel;
import org.cytoscape.rest.internal.resource.AbstractResource;
import org.cytoscape.rest.internal.task.AllAppsStartedListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"REST Service", "Cytoscape System"})
@Singleton
@Path(value="/v1")
public class MiscResource
extends AbstractResource {
    private static final String RESOURCE_URN = "";
    public static final int API_VERSION_NOT_FOUND_ERROR = 1;
    public static final int INTERNAL_METHOD_ERROR = 2;
    private static final Logger logger = LoggerFactory.getLogger(MiscResource.class);
    @Inject
    @NotNull
    private AllAppsStartedListener allAppsStartedListener;

    @Override
    public String getResourceURI() {
        return RESOURCE_URN;
    }

    @Override
    public Logger getResourceLogger() {
        return logger;
    }

    @GET
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Cytoscape RESTful API server status", notes="Returns the status of the server if operational, including version information and available memory and processor resources.")
    @ApiResponses(value={@ApiResponse(code=500, message="CyREST service is unavailable"), @ApiResponse(code=200, message="Server Status", response=ServerStatusModel.class)})
    public ServerStatusModel getStatus() {
        ServerStatusModel output = new ServerStatusModel();
        output.setAllAppsStarted(this.allAppsStartedListener.getAllAppsStarted());
        return output;
    }

    @GET
    @Path(value="/gc")
    @Produces(value={"application/json"})
    @ApiOperation(value="Run Java garbage collection", notes="Manually call Java's System.gc() to free up unused memory. This process happens automatically, but may be useful to call explicitly for testing or evaluation purposes.")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful Garbage Collection")})
    public Response runGarbageCollection() {
        Runtime.getRuntime().gc();
        return Response.noContent().build();
    }

    @GET
    @Path(value="/version")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get Cytoscape and REST API version", notes="Returns the version of the current Cytoscape REST API.")
    public CytoscapeVersionModel getCytoscapeVersion() {
        if (this.props == null) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 2, "Could not find CyProperty object.", logger, null);
        }
        Properties properties = (Properties)this.props.getProperties();
        Object versionNumber = properties.get("cytoscape.version.number");
        if (versionNumber != null) {
            return new CytoscapeVersionModel("v1", versionNumber.toString());
        }
        throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), this.getResourceURI(), 1, "Could not find Cytoscape version number property.", this.getResourceLogger(), null);
    }

    @PUT
    @Path(value="/ui/show-details")
    @Produces(value={"application/json"})
    @ApiOperation(value="Show Level of Graphics Details", hidden=true, notes="### Unimplemented\n\nDo not rely on this function.")
    public CytoscapeVersionModel updateShowGraphicsDetailsOption() {
        if (this.props == null) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 2, "Could not find CyProperty object.", logger, null);
        }
        Properties property = (Properties)this.props.getProperties();
        Object versionNumber = property.get("cytoscape.version.number");
        if (versionNumber != null) {
            return new CytoscapeVersionModel("v1", versionNumber.toString());
        }
        throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), this.getResourceURI(), 1, "Could not find Cytoscape version number property.", this.getResourceLogger(), null);
    }
}

