/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal.resource;

import com.google.inject.Inject;
import java.net.URI;
import java.util.ArrayList;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.cytoscape.ci.model.CIError;
import org.cytoscape.ci.model.CIResponse;
import org.cytoscape.rest.internal.CyRESTConstants;
import org.cytoscape.rest.internal.task.LogLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class CyExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final Logger logger = LoggerFactory.getLogger(CyExceptionMapper.class);
    @Inject
    @LogLocation
    private URI logLocation;

    public Response toResponse(Throwable ex) {
        if (ex instanceof WebApplicationException) {
            WebApplicationException webApplicationException = (WebApplicationException)ex;
            logger.error(ex.getMessage(), ex);
            return webApplicationException.getResponse();
        }
        CIResponse ciResponse = new CIResponse();
        ciResponse.data = new Object();
        ciResponse.errors = new ArrayList();
        CIError error = new CIError();
        error.link = this.logLocation;
        error.type = CyRESTConstants.getErrorURI("error-handling", 0);
        error.status = Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
        error.message = "Uncaught exception while processing resource [" + Thread.currentThread().getName() + "]: " + ex.getMessage();
        ciResponse.errors.add(error);
        logger.error(error.message, ex);
        return Response.serverError().entity((Object)ciResponse).build();
    }
}

