/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal.resource;

import com.google.inject.Inject;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.Provider;
import org.cytoscape.ci.CIErrorFactory;
import org.cytoscape.ci.CIExceptionFactory;
import org.cytoscape.ci.CIResponseFactory;
import org.cytoscape.ci.CIWrapping;
import org.cytoscape.ci.model.CIResponse;
import org.cytoscape.rest.internal.task.LogLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class CIResponseFilter
implements ContainerResponseFilter {
    private static final Logger logger = LoggerFactory.getLogger(CIResponseFilter.class);
    @Inject
    @LogLocation
    private URI logLocation;
    @Inject
    protected CIResponseFactory ciResponseFactory;
    @Inject
    protected CIErrorFactory ciErrorFactory;
    @Inject
    protected CIExceptionFactory ciExceptionFactory;
    public static final String INTERCEPTED_ERROR_URN = "urn:cytoscape:ci:cyrest-core:v1:ciresponsefilter:0";

    public void filter(ContainerRequestContext request, ContainerResponseContext response) throws IOException {
        Object object;
        Annotation[] annotations;
        boolean hasCIWrapperAnnotation = false;
        for (Annotation annotation : annotations = response.getEntityAnnotations()) {
            if (!annotation.annotationType().equals(CIWrapping.class)) continue;
            hasCIWrapperAnnotation = true;
        }
        if ((request.getHeaders().get((Object)"CIWrapping") != null && ((List)request.getHeaders().get((Object)"CIWrapping")).contains("true") || hasCIWrapperAnnotation) && !((object = response.getEntity()) instanceof CIResponse)) {
            if (response.getStatus() >= 200 && response.getStatus() <= 300) {
                if (object instanceof String) {
                    String wrappedObject = "{\n   \"data\":" + object + ",\n   \"errors\":[]\n}";
                    response.setEntity((Object)wrappedObject);
                } else {
                    try {
                        CIResponse ciResponse = (CIResponse)CIResponse.class.newInstance();
                        ciResponse.data = object;
                        ciResponse.errors = new ArrayList();
                        response.setEntity((Object)ciResponse);
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            } else if (response.getStatus() >= 400 && response.getStatus() <= 600) {
                logger.error(response.getEntity().toString());
                try {
                    CIResponse ciResponse = (CIResponse)CIResponse.class.newInstance();
                    ciResponse.data = new Object();
                    ciResponse.errors = Arrays.asList(this.ciErrorFactory.getCIError(Integer.valueOf(response.getStatus()), INTERCEPTED_ERROR_URN, response.getStatusInfo().getReasonPhrase()));
                    response.setEntity((Object)ciResponse);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

