/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal.resource;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.rest.internal.ClearAllEdgeBends;
import org.cytoscape.rest.internal.EdgeBundler;
import org.cytoscape.rest.internal.datamapper.MapperUtil;
import org.cytoscape.rest.internal.model.LayoutColumnTypesModel;
import org.cytoscape.rest.internal.model.LayoutModel;
import org.cytoscape.rest.internal.model.LayoutParameterModel;
import org.cytoscape.rest.internal.model.MessageModel;
import org.cytoscape.rest.internal.resource.AbstractResource;
import org.cytoscape.task.NetworkViewTaskFactory;
import org.cytoscape.view.layout.CyLayoutAlgorithm;
import org.cytoscape.view.layout.CyLayoutAlgorithmManager;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api
@Singleton
@Path(value="/v1/apply")
public class AlgorithmicResource
extends AbstractResource {
    @Inject
    @NotNull
    private TaskMonitor headlessTaskMonitor;
    @Inject
    @NotNull
    private CyLayoutAlgorithmManager layoutManager;
    @Inject
    @NotNull
    private NetworkViewTaskFactory fitContent;
    @Inject
    @NotNull
    private EdgeBundler edgeBundler;
    @Inject
    @NotNull
    private ClearAllEdgeBends clearAllEdgeBends;
    private static final String RESOURCE_URN = "apply";
    private static final Logger logger = LoggerFactory.getLogger(AlgorithmicResource.class);
    private static final int NETWORK_NOT_FOUND_ERROR = 1;
    private static final int NETWORK_VIEW_NOT_FOUND_ERROR = 2;
    private static final int LAYOUT_ALGORITHM_NOT_FOUND_ERROR = 3;
    private static final int STYLE_NOT_FOUND_ERROR = 4;
    private static final int ALGORITHM_EXECUTION_ERROR = 5;
    private static final int INVALID_PARAMETER_ERROR = 6;
    private static final int ILLEGAL_Y_FILES_ACCESS_ERROR = 7;

    @Override
    public String getResourceURI() {
        return RESOURCE_URN;
    }

    @Override
    public Logger getResourceLogger() {
        return logger;
    }

    @GET
    @Path(value="/layouts/{algorithmName}/{networkId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Apply a Layout to a Network", notes="Applies the Layout specified by the `algorithmName` parameter to the Network specified by the `networkId` parameter. If the Layout is has an option to use a Column, it can be specified by the `column` parameter.", tags={"Layouts"})
    public MessageModel applyLayout(@ApiParam(value="Name of layout algorithm", example="circular") @PathParam(value="algorithmName") String algorithmName, @ApiParam(value="SUID of the Network") @PathParam(value="networkId") Long networkId, @ApiParam(value="Name of the Column to be used by the Layout", required=false) @QueryParam(value="column") String column) {
        this.throw404ifYFiles(algorithmName);
        CyNetwork network = this.getCyNetwork(1, networkId);
        Collection views = this.networkViewManager.getNetworkViews(network);
        if (views.isEmpty()) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), this.getResourceURI(), 2, "Could not find view for the network with SUID: " + networkId, this.getResourceLogger(), null);
        }
        CyNetworkView view = (CyNetworkView)views.iterator().next();
        CyLayoutAlgorithm layout = this.layoutManager.getLayout(algorithmName);
        if (layout == null) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), this.getResourceURI(), 3, "No such layout algorithm: " + algorithmName, this.getResourceLogger(), null);
        }
        String columnForLayout = column;
        if (columnForLayout == null) {
            columnForLayout = "";
        }
        TaskIterator itr = layout.createTaskIterator(view, layout.getDefaultLayoutContext(), CyLayoutAlgorithm.ALL_NODE_VIEWS, columnForLayout);
        try {
            itr.next().run(this.headlessTaskMonitor);
        }
        catch (Exception e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 5, "Could not apply layout.", this.getResourceLogger(), e);
        }
        return new MessageModel("Layout finished.");
    }

    @GET
    @Path(value="/layouts/{algorithmName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all details of a Layout algorithm", tags={"Layouts"}, notes="Returns all the details, including names, parameters, and compatible column types for the Layout algorithm specified by the `algorithmName` parameter.", response=LayoutModel.class)
    public Response getLayout(@ApiParam(value="Name of the Layout algorithm") @PathParam(value="algorithmName") String algorithmName) {
        Map<String, Object> params;
        this.throw404ifYFiles(algorithmName);
        CyLayoutAlgorithm layout = this.layoutManager.getLayout(algorithmName);
        if (layout == null) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), this.getResourceURI(), 3, "No such layout algorithm: " + algorithmName, this.getResourceLogger(), null);
        }
        try {
            params = this.getLayoutDetails(layout);
        }
        catch (Exception e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 6, "Could not get layout parameters.", this.getResourceLogger(), e);
        }
        return Response.status((Response.Status)Response.Status.OK).entity(params).type("application/json").build();
    }

    @GET
    @Path(value="/layouts/{algorithmName}/parameters")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get Layout parameters", tags={"Layouts"}, notes="Returns all editable parameters for the Layout algorithm specified by the `algorithmName` parameter.", response=LayoutParameterModel.class, responseContainer="List")
    public Response getLayoutParameters(@ApiParam(value="Name of the Layout algorithm") @PathParam(value="algorithmName") String algorithmName) {
        List<Map<String, Object>> params;
        this.throw404ifYFiles(algorithmName);
        CyLayoutAlgorithm layout = this.layoutManager.getLayout(algorithmName);
        if (layout == null) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), this.getResourceURI(), 3, "No such layout algorithm: " + algorithmName, this.getResourceLogger(), null);
        }
        try {
            params = this.getLayoutParameterDetails(layout);
        }
        catch (Exception e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 6, "Could not get layout parameters.", this.getResourceLogger(), e);
        }
        return Response.status((Response.Status)Response.Status.OK).entity(params).type("application/json").build();
    }

    @GET
    @Path(value="/layouts/{algorithmName}/columntypes")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get column data types compatible a Layout algorithm", tags={"Layouts"}, notes="Returns a list of all compatible column data types for the Layout algorithm specified by the `algorithmName` parameter.", response=LayoutColumnTypesModel.class)
    public Response getCompatibleColumnDataTypes(@ApiParam(value="Name of layout algorithm") @PathParam(value="algorithmName") String algorithmName) {
        this.throw404ifYFiles(algorithmName);
        CyLayoutAlgorithm layout = this.layoutManager.getLayout(algorithmName);
        if (layout == null) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), this.getResourceURI(), 3, "No such layout algorithm: " + algorithmName, this.getResourceLogger(), null);
        }
        Map<String, Set<String>> result = this.getCompatibleTypes(layout);
        return Response.status((Response.Status)Response.Status.OK).entity(result).type("application/json").build();
    }

    private Map<String, Set<String>> getCompatibleTypes(CyLayoutAlgorithm layout) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        Set compatibleTypes = Collections.emptySet();
        if (!layout.getSupportedNodeAttributeTypes().isEmpty()) {
            compatibleTypes = layout.getSupportedNodeAttributeTypes();
            Set nodeSet = compatibleTypes.stream().map(type -> type.getSimpleName()).collect(Collectors.toSet());
            result.put("compatibleNodeColumnDataTypes", nodeSet);
        }
        if (!layout.getSupportedEdgeAttributeTypes().isEmpty()) {
            compatibleTypes = layout.getSupportedEdgeAttributeTypes();
            Set edgeSet = compatibleTypes.stream().map(type -> type.getSimpleName()).collect(Collectors.toSet());
            result.put("compatibleEdgeColumnDataTypes", edgeSet);
        }
        return result;
    }

    @PUT
    @Path(value="/layouts/{algorithmName}/parameters")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update Layout parameters for a Layout algorithm", tags={"Layouts"}, notes="Updates the Layout parameters for the Layout algorithm specified by the `algorithmName` parameter.")
    @ApiImplicitParams(value={@ApiImplicitParam(value="A list of Layout Parameters with Values.", dataType="[Lorg.cytoscape.rest.internal.model.LayoutParameterValueModel;", paramType="body", required=true)})
    public Response updateLayoutParameters(@ApiParam(value="Name of the layout algorithm") @PathParam(value="algorithmName") String algorithmName, @ApiParam(hidden=true) InputStream is) {
        this.throw404ifYFiles(algorithmName);
        ObjectMapper objMapper = new ObjectMapper();
        CyLayoutAlgorithm layout = this.layoutManager.getLayout(algorithmName);
        Object context = layout.getDefaultLayoutContext();
        try {
            Map<String, Class<?>> params = this.getParameterTypes(layout);
            JsonNode rootNode = (JsonNode)objMapper.readValue(is, JsonNode.class);
            for (JsonNode entry : rootNode) {
                String parameterName = entry.get("name").asText();
                Class<?> type = params.get(parameterName);
                if (type == null) {
                    throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 6, "No such parameter: " + parameterName, this.getResourceLogger(), null);
                }
                JsonNode val = entry.get("value");
                Object value = MapperUtil.getValue(val, params.get(parameterName));
                context.getClass().getField(parameterName).set(context, value);
            }
        }
        catch (Exception e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 6, "Could not parse input JSON.", this.getResourceLogger(), e);
        }
        return Response.status((Response.Status)Response.Status.OK).type("application/json").build();
    }

    private final Map<String, Class<?>> getParameterTypes(CyLayoutAlgorithm layout) {
        Object context = layout.getDefaultLayoutContext();
        List<Field> fields = Arrays.asList(context.getClass().getFields());
        return fields.stream().filter(field -> field.getAnnotation(Tunable.class) != null).collect(Collectors.toMap(Field::getName, Field::getType));
    }

    private final Map<String, Object> getLayoutDetails(CyLayoutAlgorithm layout) throws NoSuchFieldException, SecurityException {
        HashMap<String, Object> layoutInfo = new HashMap<String, Object>();
        layoutInfo.put("name", layout.getName());
        layoutInfo.put("longName", layout.toString());
        layoutInfo.put("parameters", this.getLayoutParameterDetails(layout));
        layoutInfo.put("compatibleColumnDataTypes", this.getCompatibleTypes(layout));
        return layoutInfo;
    }

    private final List<Map<String, Object>> getLayoutParameterDetails(CyLayoutAlgorithm layout) {
        return Arrays.asList(layout.getDefaultLayoutContext().getClass().getFields()).stream().filter(field -> field.getAnnotation(Tunable.class) != null).map(field -> this.buildLayoutParamEntry(layout, (Field)field)).collect(Collectors.toList());
    }

    private final Map<String, Object> buildLayoutParamEntry(CyLayoutAlgorithm layout, Field field) {
        HashMap<String, Object> entryMap = new HashMap<String, Object>();
        Tunable tunable = field.getAnnotation(Tunable.class);
        entryMap.put("name", field.getName());
        entryMap.put("description", tunable.description());
        entryMap.put("type", field.getType().getSimpleName());
        try {
            entryMap.put("value", field.get(layout.getDefaultLayoutContext()));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return entryMap;
    }

    @GET
    @Path(value="/styles/{styleName}/{networkId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Apply Visual Style to a network", notes="Applies the Visual Style specified by the `styleName` parameter to the network specified by the `networkId` parameter.", tags={"Visual Styles"})
    public MessageModel applyStyle(@ApiParam(value="Name of the Visual Style") @PathParam(value="styleName") String styleName, @ApiParam(value="SUID of the Network") @PathParam(value="networkId") Long networkId) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        Set styles = this.vmm.getAllVisualStyles();
        VisualStyle targetStyle = null;
        for (VisualStyle style : styles) {
            String name = style.getTitle();
            if (!name.equals(styleName)) continue;
            targetStyle = style;
            break;
        }
        if (targetStyle == null) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), this.getResourceURI(), 4, "Visual Style does not exist: " + styleName, this.getResourceLogger(), null);
        }
        Collection views = this.networkViewManager.getNetworkViews(network);
        if (views.isEmpty()) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), this.getResourceURI(), 2, "Network view does not exist for the network with SUID: " + networkId, this.getResourceLogger(), null);
        }
        CyNetworkView view = (CyNetworkView)views.iterator().next();
        this.vmm.setVisualStyle(targetStyle, view);
        this.vmm.setCurrentVisualStyle(targetStyle);
        targetStyle.apply(view);
        view.updateView();
        return new MessageModel("Visual Style applied.");
    }

    @GET
    @Path(value="/fit/{networkId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Fit network to the window", tags={"Network Views"}, notes="Fit the first available Network View for the Network specified by the `networkId` parameter to the current window.")
    public MessageModel fitContent(@ApiParam(value="SUID of the Network", required=true) @PathParam(value="networkId") Long networkId) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        Collection views = this.networkViewManager.getNetworkViews(network);
        if (views.isEmpty()) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), this.getResourceURI(), 2, "Network view does not exist for the network with SUID: " + networkId, this.getResourceLogger(), null);
        }
        CyNetworkView view = (CyNetworkView)views.iterator().next();
        TaskIterator fit = this.fitContent.createTaskIterator(view);
        try {
            fit.next().run(this.headlessTaskMonitor);
        }
        catch (Exception e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 5, "Could not fit content.", this.getResourceLogger(), e);
        }
        return new MessageModel("Fit content success.");
    }

    @GET
    @Path(value="/edgebundling/{networkId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Apply Edge Bundling to a network", tags={"Layouts"}, notes="Apply edge bundling to the Network specified by the `networkId` parameter. Edge bundling is executed with default parameters; at present, optional parameters are not supported.")
    public MessageModel bundleEdge(@ApiParam(value="SUID of the Network") @PathParam(value="networkId") Long networkId) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        Collection views = this.networkViewManager.getNetworkViews(network);
        if (views.isEmpty()) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), this.getResourceURI(), 2, "Network view does not exist for the network with SUID: " + networkId, this.getResourceLogger(), null);
        }
        TaskIterator bundler = this.edgeBundler.getBundlerTF().createTaskIterator(network);
        try {
            bundler.next().run(this.headlessTaskMonitor);
        }
        catch (Exception e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 5, "Could not finish edge bundling.", this.getResourceLogger(), e);
        }
        return new MessageModel("Edge bundling success.");
    }

    @GET
    @Path(value="/clearalledgebends/{networkId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Clear all edge bends in a network", tags={"Layouts"}, notes="Clear all edge bends in the Network specified by the `networkId` parameter.")
    public MessageModel clearAllEdgeBends(@ApiParam(value="SUID of the Network") @PathParam(value="networkId") Long networkId) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        Collection views = this.networkViewManager.getNetworkViews(network);
        if (views.isEmpty()) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), this.getResourceURI(), 2, "Network view does not exist for the network with SUID: " + networkId, this.getResourceLogger(), null);
        }
        TaskIterator clearAllEdgeBendsTaskIterator = this.clearAllEdgeBends.getClearAllEdgeBendsTF().createTaskIterator(views);
        try {
            clearAllEdgeBendsTaskIterator.next().run(this.headlessTaskMonitor);
        }
        catch (Exception e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 5, "Could not finish clearing all edge bends.", this.getResourceLogger(), e);
        }
        return new MessageModel("Clear all edge bends success.");
    }

    @GET
    @Path(value="/layouts")
    @Produces(value={"application/json"})
    @ApiOperation(nickname="layoutList", value="Get all available Layout names", tags={"Layouts"}, notes="Returns all available layouts as a list of layout names.\n\n<h3>Important Note</h3>\n\nThis <strong>does not include yFiles layout algorithms</strong>, due to license issues.")
    public Collection<String> getLayoutNames() {
        return this.layoutManager.getAllLayouts().stream().map(layout -> layout.getName()).filter(name -> !AlgorithmicResource.isYFiles(name)).collect(Collectors.toList());
    }

    @GET
    @Path(value="/styles")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get list of all Visual Style names", tags={"Visual Styles"}, notes="Returns a list of all Visual Style names. Style names may not be unique.")
    public Collection<String> getStyleNames() {
        return this.vmm.getAllVisualStyles().stream().map(style -> style.getTitle()).collect(Collectors.toList());
    }

    private static boolean isYFiles(String name) {
        return name.startsWith("com.yworks.yfiles.layout") || name.startsWith("yfiles.");
    }

    private void throw404ifYFiles(String algorithmName) {
        if (AlgorithmicResource.isYFiles(algorithmName)) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), this.getResourceURI(), 7, "No such layout: " + algorithmName, this.getResourceLogger(), null);
        }
    }
}

