/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal.resource;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.inject.Inject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.ci.CIErrorFactory;
import org.cytoscape.ci.CIExceptionFactory;
import org.cytoscape.ci.CIResponseFactory;
import org.cytoscape.ci.model.CIError;
import org.cytoscape.io.write.CyNetworkViewWriterFactory;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.property.CyProperty;
import org.cytoscape.rest.internal.CyActivator;
import org.cytoscape.rest.internal.CyNetworkViewWriterFactoryManager;
import org.cytoscape.rest.internal.TaskFactoryManager;
import org.cytoscape.rest.internal.datamapper.MapperUtil;
import org.cytoscape.rest.internal.reader.EdgeListReaderFactory;
import org.cytoscape.rest.internal.serializer.GraphObjectSerializer;
import org.cytoscape.rest.internal.task.CyRESTPort;
import org.cytoscape.rest.internal.task.CytoscapeJsReaderFactory;
import org.cytoscape.rest.internal.task.CytoscapeJsWriterFactory;
import org.cytoscape.rest.internal.task.HeadlessTaskMonitor;
import org.cytoscape.task.create.NewNetworkSelectedNodesAndEdgesTaskFactory;
import org.cytoscape.task.read.LoadNetworkURLTaskFactory;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.work.TaskMonitor;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;

public abstract class AbstractResource {
    protected static final String API_VERSION = "v1";
    protected static final String ERROR_TAG = "\"error\":";
    protected static final String NETWORK_QUERY_DESCRIPTION = "If the `column` and `query` parameters are specified, the results will be limited to rows in the network table where the value in the column specified by the `column` parameter matches the value specified by the `query` parameter.";
    protected static final String NODE_QUERY_DESCRIPTION = "If the `column` and `query` parameters are specified, the results will be limited to rows in the node table where the value in the column specified by the `column` parameter matches the value specified by the `query` parameter.";
    protected static final String EDGE_QUERY_DESCRIPTION = "If the `column` and `query` parameters are specified, the results will be limited to rows in the edge table where the value in the column specified by the `column` parameter matches the value specified by the `query` parameter.";
    protected static final String COLUMN_DESCRIPTION = "The name of the column that will be queried for matches.";
    protected static final String QUERY_STRING_DESCRIPTION = "The value to be matched.";
    @Inject
    @NotNull
    protected CyApplicationManager applicationManager;
    @Inject
    protected CyNetworkManager networkManager;
    @Inject
    protected CyRootNetworkManager cyRootNetworkManager;
    @Inject
    protected CyTableManager tableManager;
    @Inject
    protected CyNetworkViewManager networkViewManager;
    @Inject
    protected CyNetworkFactory networkFactory;
    @Inject
    protected CyNetworkViewFactory networkViewFactory;
    @Inject
    protected TaskFactoryManager tfManager;
    @Inject
    @CytoscapeJsReaderFactory
    protected ServiceTracker cytoscapeJsReaderFactory;
    @Inject
    @NotNull
    protected VisualMappingManager vmm;
    @Inject
    @CytoscapeJsWriterFactory
    protected ServiceTracker cytoscapeJsWriterFactory;
    @Inject
    protected CyNetworkViewWriterFactoryManager viewWriterFactoryManager;
    @Inject
    protected CyActivator.WriterListener vizmapWriterFactoryListener;
    @Inject
    protected LoadNetworkURLTaskFactory loadNetworkURLTaskFactory;
    @Inject
    protected CyProperty<Properties> props;
    @Inject
    protected NewNetworkSelectedNodesAndEdgesTaskFactory newNetworkSelectedNodesAndEdgesTaskFactory;
    @Inject
    protected EdgeListReaderFactory edgeListReaderFactory;
    @Inject
    @CyRESTPort
    protected String cyRESTPort;
    @Inject
    protected CIResponseFactory ciResponseFactory;
    @Inject
    protected CIErrorFactory ciErrorFactory;
    @Inject
    protected CIExceptionFactory ciExceptionFactory;
    protected final GraphObjectSerializer serializer = new GraphObjectSerializer();

    public abstract String getResourceURI();

    public abstract Logger getResourceLogger();

    protected final WebApplicationException getCIWebApplicationException(int status, String resourceURI, int code, String message, Logger logger, Exception e) {
        String errorURI = "urn:cytoscape:ci:cyrest-core:v1:" + resourceURI + ":errors:" + code;
        CIError ciError = this.ciErrorFactory.getCIError(Integer.valueOf(status), errorURI, message);
        if (logger != null) {
            if (e != null) {
                logger.error(message, (Throwable)e);
            } else {
                logger.error(message);
            }
        }
        return this.ciExceptionFactory.getCIException(status, new CIError[]{ciError});
    }

    protected final CyNetwork getCyNetwork(int networkNotFoundErrorCode, Long id) {
        if (id == null) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), this.getResourceURI(), networkNotFoundErrorCode, "Could not find Network: SUID is null.", this.getResourceLogger(), null);
        }
        CyNetwork network = this.networkManager.getNetwork(id.longValue());
        if (network == null) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), this.getResourceURI(), networkNotFoundErrorCode, "Could not find Network with SUID: " + id, this.getResourceLogger(), null);
        }
        return network;
    }

    protected final Collection<CyNetworkView> getCyNetworkViews(int networkNotFoundErrorCode, int noViewsForNetworkErrorCode, Long id) {
        Collection views = this.networkViewManager.getNetworkViews(this.getCyNetwork(networkNotFoundErrorCode, id));
        if (views.isEmpty()) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), this.getResourceURI(), noViewsForNetworkErrorCode, "No Views Available for Network with SUID: " + id, this.getResourceLogger(), null);
        }
        return views;
    }

    protected final CyNode getNode(int nodeNotFoundErrorCode, CyNetwork network, Long nodeId) {
        CyNode node = network.getNode(nodeId.longValue());
        if (node == null) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), this.getResourceURI(), nodeNotFoundErrorCode, "Could not find Node with SUID: " + nodeId, this.getResourceLogger(), null);
        }
        return node;
    }

    protected final String getGraphObject(int serializationErrorCode, CyNetwork network, CyIdentifiable obj) {
        CyRow row = network.getRow(obj);
        try {
            return this.serializer.serializeGraphObject(obj, row);
        }
        catch (IOException e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), serializationErrorCode, "Could not serialize Graph Object with SUID: " + obj.getSUID(), this.getResourceLogger(), e);
        }
    }

    protected final Collection<Long> getByQuery(int networkNotFoundErrorCode, int invalidObjectTypeErrorCode, int invalidParameterErrorCode, Long id, String objType, String column, String query) {
        List graphObjects;
        CyNetwork network = this.getCyNetwork(networkNotFoundErrorCode, id);
        CyTable table = null;
        if (objType.equals("nodes")) {
            table = network.getDefaultNodeTable();
            graphObjects = network.getNodeList();
        } else if (objType.equals("edges")) {
            table = network.getDefaultEdgeTable();
            graphObjects = network.getEdgeList();
        } else {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), invalidObjectTypeErrorCode, "Invalid Graph Object Type: " + objType, this.getResourceLogger(), null);
        }
        if (query == null && column == null) {
            return graphObjects.stream().map(obj -> obj.getSUID()).collect(Collectors.toList());
        }
        if (query == null || column == null) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), invalidParameterErrorCode, "Missing Query Parameter; query and column cannot be null", this.getResourceLogger(), null);
        }
        Object rawQuery = MapperUtil.getRawValue(query, table.getColumn(column).getType());
        Collection rows = table.getMatchingRows(column, rawQuery);
        Set selectedSuid = rows.stream().map(row -> (Long)row.get("SUID", Long.class)).collect(Collectors.toSet());
        Set<Long> allSuid = graphObjects.stream().map(obj -> obj.getSUID()).collect(Collectors.toSet());
        allSuid.retainAll(selectedSuid);
        return allSuid;
    }

    protected final String getNames(Collection<String> names) throws IOException {
        JsonFactory factory = new JsonFactory();
        String result = null;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        JsonGenerator generator = null;
        generator = factory.createGenerator((OutputStream)stream);
        generator.writeStartArray();
        for (String name : names) {
            generator.writeString(name);
        }
        generator.writeEndArray();
        generator.close();
        result = stream.toString("UTF-8");
        stream.close();
        return result;
    }

    protected final String getNumberObjectString(int serializationErrorCode, String fieldName, Number value) {
        JsonFactory factory = new JsonFactory();
        String result = null;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        JsonGenerator generator = null;
        try {
            generator = factory.createGenerator((OutputStream)stream);
            generator.writeStartObject();
            generator.writeFieldName(fieldName);
            generator.writeNumber(value.longValue());
            generator.writeEndObject();
            generator.close();
            result = stream.toString("UTF-8");
            stream.close();
        }
        catch (IOException e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), serializationErrorCode, "Could not serialize number: " + value, this.getResourceLogger(), e);
        }
        return result;
    }

    protected final Set<CyNetwork> getNetworksByQuery(int invalidParameterErrorCode, String query, String column) throws WebApplicationException {
        if (column != null || query != null) {
            if (column == null || column.length() == 0) {
                throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), invalidParameterErrorCode, "Column parameter is missing.", this.getResourceLogger(), null);
            }
            if (query == null || query.length() == 0) {
                throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), invalidParameterErrorCode, "Query parameter is missing.", this.getResourceLogger(), null);
            }
        }
        Set networks = this.networkManager.getNetworkSet();
        HashSet<CyNetwork> matchedNetworks = new HashSet<CyNetwork>();
        for (CyNetwork network : networks) {
            Object rawQuery;
            Collection rows;
            CyTable table = network.getDefaultNetworkTable();
            if (table.getColumn(column) == null) {
                table = network.getTable(CyNetwork.class, "LOCAL_ATTRS");
            }
            if (table.getColumn(column) == null || (rows = table.getMatchingRows(column, rawQuery = MapperUtil.getRawValue(query, table.getColumn(column).getType()))).isEmpty()) continue;
            matchedNetworks.add(network);
        }
        return matchedNetworks;
    }

    protected final String getNetworkString(int serviceUnavailableErrorCode, int serializationErrorCode, CyNetwork network) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        CyNetworkViewWriterFactory cytoscapeJsWriterFactory = (CyNetworkViewWriterFactory)this.cytoscapeJsWriterFactory.getService();
        if (cytoscapeJsWriterFactory == null) {
            throw this.getCIWebApplicationException(Response.Status.SERVICE_UNAVAILABLE.getStatusCode(), this.getResourceURI(), serviceUnavailableErrorCode, "No Cytoscape js writer available", this.getResourceLogger(), null);
        }
        CyWriter writer = cytoscapeJsWriterFactory.createWriter((OutputStream)stream, network);
        String jsonString = null;
        try {
            writer.run((TaskMonitor)new HeadlessTaskMonitor());
            jsonString = stream.toString("UTF-8");
            stream.close();
        }
        catch (Exception e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), serializationErrorCode, "Could not serialize network into JSON.", this.getResourceLogger(), e);
        }
        return jsonString;
    }

    protected final VisualLexicon getLexicon(int noVisualLexiconErrorCode) {
        Set lexicon = this.vmm.getAllVisualLexicon();
        if (lexicon.isEmpty()) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), noVisualLexiconErrorCode, "Could not find Visual Lexicon", this.getResourceLogger(), null);
        }
        return (VisualLexicon)lexicon.iterator().next();
    }
}

