/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal.datamapper;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.CyGroupFactory;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.subnetwork.CySubNetwork;

public class GroupMapper {
    public CyGroup createGroup(JsonNode rootNode, CyGroupFactory factory, CyNetwork network) {
        JsonNode groupNameNode = rootNode.get("name");
        String groupName = groupNameNode != null ? groupNameNode.textValue() : null;
        JsonNode memberNodes = rootNode.get("nodes");
        JsonNode memberEdges = rootNode.get("edges");
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException("Group name is missing.");
        }
        if (!memberNodes.isArray()) {
            throw new IllegalArgumentException("Invalid parameter.");
        }
        if (memberNodes.size() == 0) {
            throw new IllegalArgumentException("Group member list is empty.");
        }
        ArrayList<CyNode> nodes = new ArrayList<CyNode>();
        for (JsonNode node : memberNodes) {
            CyNode n = network.getNode(node.asLong());
            if (n == null) continue;
            nodes.add(n);
        }
        CyGroup group = factory.createGroup(network, nodes, null, true);
        CyRow groupRow = ((CySubNetwork)network).getRootNetwork().getRow((CyIdentifiable)group.getGroupNode(), "SHARED_ATTRS");
        groupRow.set("shared name", (Object)groupName);
        if (memberEdges != null && memberEdges.isArray()) {
            ArrayList<CyEdge> edges = new ArrayList<CyEdge>();
            for (JsonNode edge : memberEdges) {
                CyEdge e = network.getEdge(edge.asLong());
                if (e == null) continue;
                edges.add(e);
            }
            group.addEdges(edges);
        }
        return group;
    }
}

