/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal;

import java.util.HashMap;
import java.util.Map;
import org.cytoscape.io.read.InputStreamTaskFactory;
import org.cytoscape.rest.internal.TaskFactoryManager;
import org.cytoscape.task.NetworkCollectionTaskFactory;
import org.cytoscape.task.NetworkTaskFactory;
import org.cytoscape.work.TaskFactory;

public class TaskFactoryManagerImpl
implements TaskFactoryManager {
    private Map<String, Object> tfMap = new HashMap<String, Object>();

    public void addTaskFactory(TaskFactory tf, Map props) {
        if (tf == null) {
            return;
        }
        Object tfID = props.get("id");
        if (tfID != null) {
            this.tfMap.put(tfID.toString(), tf);
        } else {
            String tfName = tf.toString();
            this.tfMap.put(tfName, tf);
        }
    }

    public void addInputStreamTaskFactory(InputStreamTaskFactory tf, Map props) {
        if (tf == null) {
            return;
        }
        Object tfID = props.get("id");
        if (tfID != null) {
            this.tfMap.put(tfID.toString(), tf);
        } else {
            String tfName = tf.toString();
            this.tfMap.put(tfName, tf);
        }
    }

    public void addNetworkTaskFactory(NetworkTaskFactory tf, Map props) {
        if (tf == null) {
            return;
        }
        Object tfID = props.get("id");
        if (tfID != null) {
            this.tfMap.put(tfID.toString(), tf);
        } else {
            String tfName = tf.toString();
            this.tfMap.put(tfName, tf);
        }
    }

    public void addNetworkCollectionTaskFactory(NetworkCollectionTaskFactory tf, Map props) {
        if (tf == null) {
            return;
        }
        Object tfID = props.get("id");
        if (tfID != null) {
            this.tfMap.put(tfID.toString(), tf);
        } else {
            String tfName = tf.getClass().getSimpleName();
            this.tfMap.put(tfName, tf);
        }
    }

    public void removeTaskFactory(TaskFactory command, Map props) {
    }

    public void removeInputStreamTaskFactory(InputStreamTaskFactory tf, Map props) {
    }

    public void removeNetworkTaskFactory(NetworkTaskFactory command, Map props) {
    }

    public void removeNetworkCollectionTaskFactory(NetworkCollectionTaskFactory command, Map props) {
    }

    @Override
    public TaskFactory getTaskFactory(String id) {
        Object tf = this.tfMap.get(id);
        if (tf instanceof TaskFactory) {
            return (TaskFactory)tf;
        }
        return null;
    }

    @Override
    public NetworkTaskFactory getNetworkTaskFactory(String id) {
        Object tf = this.tfMap.get(id);
        if (tf instanceof NetworkTaskFactory) {
            return (NetworkTaskFactory)tf;
        }
        return null;
    }

    @Override
    public NetworkCollectionTaskFactory getNetworkCollectionTaskFactory(String id) {
        Object tf = this.tfMap.get(id);
        if (tf instanceof NetworkCollectionTaskFactory) {
            return (NetworkCollectionTaskFactory)tf;
        }
        return null;
    }

    @Override
    public InputStreamTaskFactory getInputStreamTaskFactory(String id) {
        Object tf = this.tfMap.get(id);
        if (tf instanceof InputStreamTaskFactory) {
            return (InputStreamTaskFactory)tf;
        }
        return null;
    }
}

