/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.util.json.CyJSONUtil;

public class CyJSONUtilImpl
implements CyJSONUtil {
    private final Gson gson;

    private JsonObject serialize(CyRow cyRow, CyColumn ... columns) {
        JsonObject object = new JsonObject();
        HashSet<CyColumn> columnSet = new HashSet<CyColumn>(Arrays.asList(columns));
        for (Map.Entry entry : cyRow.getAllValues().entrySet()) {
            if (columnSet.size() != 0 && !columnSet.contains(cyRow.getTable().getColumn((String)entry.getKey()))) continue;
            object.add((String)entry.getKey(), this.serializeCell(entry.getValue()));
        }
        return object;
    }

    private JsonElement serializeCell(Object object) {
        if (object instanceof List) {
            JsonArray listObject = new JsonArray();
            for (Object value : (List)object) {
                listObject.add(this.getPrimitive(value));
            }
            return listObject;
        }
        return this.getPrimitive(object);
    }

    private JsonElement getPrimitive(Object object) {
        if (object instanceof Number) {
            return new JsonPrimitive((Number)object);
        }
        if (object instanceof String) {
            return new JsonPrimitive((String)object);
        }
        if (object instanceof Boolean) {
            return new JsonPrimitive((Boolean)object);
        }
        if (object == null) {
            return JsonNull.INSTANCE;
        }
        throw new IllegalArgumentException();
    }

    public CyJSONUtilImpl() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.serializeNulls().setPrettyPrinting();
        this.gson = gsonBuilder.create();
    }

    public String toJson(CyIdentifiable cyIdentifiable) {
        return this.gson.toJson(cyIdentifiable.getSUID());
    }

    public String cyIdentifiablesToJson(Collection<? extends CyIdentifiable> collection) {
        List list = collection.stream().map(obj -> obj.getSUID()).collect(Collectors.toList());
        return this.gson.toJson(list);
    }

    public String toJson(CyNetwork cyNetwork, CyNode cyNode, CyColumn ... columns) {
        CyRow row = cyNetwork.getRow((CyIdentifiable)cyNode);
        return this.toJson(row, columns);
    }

    public String toJson(CyNetwork cyNetwork, CyEdge cyEdge, CyColumn ... columns) {
        CyRow row = cyNetwork.getRow((CyIdentifiable)cyEdge);
        JsonObject object = this.serialize(row, columns);
        object.addProperty("source", cyEdge.getSource().getSUID());
        object.addProperty("target", cyEdge.getTarget().getSUID());
        return this.gson.toJson(object);
    }

    public String toJson(CyNetwork cyNetwork) {
        CyRow row = cyNetwork.getRow((CyIdentifiable)cyNetwork);
        return this.toJson(row, new CyColumn[0]);
    }

    public String toJson(CyTable cyTable, boolean includeDefinition, boolean includeRows) {
        JsonObject object = new JsonObject();
        if (includeDefinition) {
            object.addProperty("SUID", cyTable.getSUID());
            object.addProperty("title", cyTable.getTitle());
            object.addProperty("public", cyTable.isPublic());
            object.addProperty("mutable", cyTable.getMutability().name());
            object.addProperty("primaryKey", cyTable.getPrimaryKey().getName());
        }
        if (includeRows) {
            JsonArray listObject = new JsonArray();
            for (CyRow row : cyTable.getAllRows()) {
                listObject.add(this.serialize(row, new CyColumn[0]));
            }
            object.add("rows", listObject);
        }
        return this.gson.toJson(object);
    }

    public String toJson(CyColumn cyColumn, boolean includeDefinition, boolean includeValues) {
        JsonObject object = new JsonObject();
        if (includeDefinition) {
            object.addProperty("name", cyColumn.getName());
            object.addProperty("type", cyColumn.getType().getSimpleName());
            if (List.class.isAssignableFrom(cyColumn.getType())) {
                object.addProperty("listType", cyColumn.getListElementType().getSimpleName());
            }
            object.addProperty("immutable", cyColumn.isImmutable());
            object.addProperty("primaryKey", cyColumn.isPrimaryKey());
        }
        if (includeValues) {
            JsonArray listObject = new JsonArray();
            for (CyRow row : cyColumn.getTable().getAllRows()) {
                listObject.add(this.serializeCell(row.get(cyColumn.getName(), cyColumn.getType())));
            }
            object.add("values", listObject);
        }
        return this.gson.toJson(object);
    }

    public String toJson(CyRow cyRow, CyColumn ... columns) {
        return this.gson.toJson(this.serialize(cyRow, columns));
    }

    public String cyColumnsToJson(Collection<CyColumn> collection) {
        JsonArray listObject = new JsonArray();
        for (CyColumn column : collection) {
            listObject.add(new JsonPrimitive(column.getName()));
        }
        return this.gson.toJson(listObject);
    }
}

