/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.FileChooserFilter;
import org.cytoscape.util.swing.FileUtil;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class DataSourceSelectDialog
extends JDialog {
    private static final long serialVersionUID = -2750086123978509461L;
    private JPanel mainPanel;
    private JPanel buttonPanel;
    private JButton addButton;
    private JButton browseButton;
    private JButton cancelButton;
    private JTextField dataSourceTextField;
    private JLabel nameLabel;
    private JTextField ontologyNameTextField;
    private JLabel sourceLabel;
    private int sourceType;
    private String sourceName;
    private String sourceFileName;
    private String sourceUrlString;
    private final CyServiceRegistrar serviceRegistrar;
    public static final int ANNOTATION_TYPE = 1;
    public static final int ONTOLOGY_TYPE = 2;

    public DataSourceSelectDialog(int sourceType, Window parent, Dialog.ModalityType modal, CyServiceRegistrar serviceRegistrar) {
        super(parent, modal);
        this.sourceType = sourceType;
        this.sourceName = null;
        this.sourceUrlString = null;
        this.sourceFileName = null;
        this.serviceRegistrar = serviceRegistrar;
        this.initComponents();
    }

    private void initComponents() {
        this.ontologyNameTextField = new JTextField();
        this.dataSourceTextField = new JTextField();
        this.browseButton = new JButton("Browse Local Files...");
        this.nameLabel = new JLabel("Data Source Name:");
        this.sourceLabel = new JLabel("Data Source URL:");
        this.setDefaultCloseOperation(2);
        this.setTitle("Add New Ontology Data Source");
        this.ontologyNameTextField.setToolTipText("Add data source from local file system...");
        this.dataSourceTextField.setText("http://");
        this.dataSourceTextField.setToolTipText("http, ftp, and file are supported.");
        this.cancelButton = new JButton(new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSourceSelectDialog.this.cancelButtonActionPerformed(e);
            }
        });
        this.addButton = new JButton(new AbstractAction("Add"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSourceSelectDialog.this.addButtonActionPerformed(e);
            }
        });
        this.browseButton.setToolTipText("Add data source from local file system...");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataSourceSelectDialog.this.browseButtonActionPerformed(evt);
            }
        });
        JPanel contentPane = new JPanel();
        GroupLayout layout = new GroupLayout(contentPane);
        contentPane.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(this.getMainPanel(), -1, -1, Short.MAX_VALUE).addComponent(this.getButtonPanel(), -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getMainPanel(), -2, -1, -2).addComponent(this.getButtonPanel(), -2, -1, -2));
        this.setContentPane(contentPane);
        this.pack();
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            GroupLayout layout = new GroupLayout(this.mainPanel);
            this.mainPanel.setLayout(layout);
            layout.setAutoCreateContainerGaps(true);
            layout.setAutoCreateGaps(true);
            layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.nameLabel).addComponent(this.sourceLabel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ontologyNameTextField, -1, 540, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.dataSourceTextField, -1, -1, Short.MAX_VALUE).addComponent(this.browseButton, -2, -1, -2))));
            layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.nameLabel).addComponent(this.ontologyNameTextField, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.sourceLabel).addComponent(this.dataSourceTextField, -2, -1, -2).addComponent(this.browseButton, -2, -1, -2)));
        }
        return this.mainPanel;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = LookAndFeelUtil.createOkCancelPanel((JButton)this.addButton, (JButton)this.cancelButton);
            LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)this.getRootPane(), (Action)this.addButton.getAction(), (Action)this.cancelButton.getAction());
            this.getRootPane().setDefaultButton(this.addButton);
        }
        return this.buttonPanel;
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        String name = this.ontologyNameTextField.getText();
        String source = this.dataSourceTextField.getText();
        if (name == null || source == null || name.length() == 0 || source.length() == 0) {
            return;
        }
        this.sourceName = name;
        this.sourceUrlString = source;
        this.setVisible(false);
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        File file = null;
        FileUtil fileUtil = (FileUtil)this.serviceRegistrar.getService(FileUtil.class);
        if (this.sourceType == 2) {
            FileChooserFilter filter = new FileChooserFilter("OBO File", "obo");
            ArrayList<FileChooserFilter> filterCollection = new ArrayList<FileChooserFilter>(1);
            filterCollection.add(filter);
            file = fileUtil.getFile((Component)this.getParent(), "Select OBO Source File", 0, filterCollection);
        } else {
            ArrayList filterCollection = new ArrayList();
            file = fileUtil.getFile((Component)this.getParent(), "Select Gene Annotation Source File", 0, filterCollection);
        }
        if (file == null) {
            return;
        }
        this.sourceFileName = file.getName();
        if (this.sourceType == 2) {
            this.ontologyNameTextField.setText("Local Ontology File: " + this.sourceFileName);
        } else {
            this.ontologyNameTextField.setText("Local Annotation File: " + this.sourceFileName);
        }
        try {
            this.dataSourceTextField.setText(file.toURI().toURL().toString());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        this.toFront();
    }

    public String getSourceUrlString() {
        return this.sourceUrlString;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }
}

