/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.ui;

import java.awt.Component;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.cytoscape.tableimport.internal.reader.TextDelimiter;
import org.cytoscape.tableimport.internal.util.AttributeDataType;
import org.cytoscape.tableimport.internal.util.SourceColumnSemantic;
import org.cytoscape.tableimport.internal.util.TypeUtil;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class AttributeEditorPanel
extends JPanel {
    private static final String OTHER = "Other:";
    private static final float ICON_FONT_SIZE = 14.0f;
    private JTextField attributeNameTextField;
    private final Map<SourceColumnSemantic, JToggleButton> typeButtons = new LinkedHashMap<SourceColumnSemantic, JToggleButton>();
    private final Map<AttributeDataType, JToggleButton> dataTypeButtons = new LinkedHashMap<AttributeDataType, JToggleButton>();
    private final Map<String, JToggleButton> namespaceButtons = new LinkedHashMap<String, JToggleButton>();
    private JToggleButton stringButton;
    private JToggleButton booleanButton;
    private JToggleButton floatingPointButton;
    private JToggleButton integerButton;
    private JToggleButton longButton;
    private JToggleButton stringListButton;
    private JToggleButton booleanListButton;
    private JToggleButton floatingPointListButton;
    private JToggleButton integerListButton;
    private JToggleButton longListButton;
    private JLabel listDelimiterLabel;
    private JComboBox<String> listDelimiterComboBox;
    private JTextField otherTextField;
    private ButtonGroup typeButtonGroup;
    private ButtonGroup namespaceButtonGroup;
    private ButtonGroup dataTypeButtonGroup;
    private String attrName;
    private SourceColumnSemantic attributeType;
    private String namespace = "USER";
    private final List<SourceColumnSemantic> availableTypes;
    private final List<String> availableNamespaces;
    private AttributeDataType attributeDataType;
    private String listDelimiter;
    private final IconManager iconManager;

    public AttributeEditorPanel(Window parent, String attrName, List<SourceColumnSemantic> availableTypes, List<String> availableNamespaces, SourceColumnSemantic attrType, String namespace, AttributeDataType attrDataType, String listDelimiter, IconManager iconManager) {
        this.attrName = attrName;
        this.availableTypes = availableTypes;
        this.attributeType = attrType;
        this.availableNamespaces = availableNamespaces;
        this.namespace = namespace;
        this.attributeDataType = attrDataType;
        this.listDelimiter = listDelimiter;
        this.iconManager = iconManager;
        if (!availableTypes.contains((Object)SourceColumnSemantic.NONE)) {
            availableTypes.add(0, SourceColumnSemantic.NONE);
        }
        this.initComponents();
        this.updateComponents();
    }

    public String getAttributeName() {
        return this.getAttributeNameTextField().getText().trim();
    }

    public SourceColumnSemantic getSelectedAttributeType() {
        ButtonModel model = this.typeButtonGroup.getSelection();
        for (Map.Entry<SourceColumnSemantic, JToggleButton> entry : this.typeButtons.entrySet()) {
            JToggleButton btn = entry.getValue();
            if (!btn.getModel().equals(model)) continue;
            return entry.getKey();
        }
        return SourceColumnSemantic.NONE;
    }

    public AttributeDataType getSelectedAttributeDataType() {
        ButtonModel model = this.dataTypeButtonGroup.getSelection();
        for (Map.Entry<AttributeDataType, JToggleButton> entry : this.dataTypeButtons.entrySet()) {
            JToggleButton btn = entry.getValue();
            if (!btn.getModel().equals(model)) continue;
            return entry.getKey();
        }
        return AttributeDataType.TYPE_STRING;
    }

    public String getListDelimiter() {
        if (this.isOtherDelimiterSelected()) {
            return this.getOtherTextField().getText();
        }
        String label = this.getListDelimiterComboBox().getSelectedItem().toString();
        TextDelimiter del = TextDelimiter.getByLabel(label);
        return del != null ? del.getDelimiter() : null;
    }

    protected SourceColumnSemantic getAttributeType() {
        return this.attributeType;
    }

    private void setAttributeType(SourceColumnSemantic attributeType) {
        if (this.attributeType != attributeType) {
            this.attributeType = attributeType;
            this.firePropertyChange("attributeType", (Object)this.attributeType, (Object)this.attributeType);
        }
    }

    protected String getNamespace() {
        return this.namespace;
    }

    private void setNamespace(String namespace) {
        if (this.namespace != namespace) {
            this.namespace = namespace;
            this.firePropertyChange("namespace", this.namespace, this.namespace);
        }
    }

    protected AttributeDataType getAttributeDataType() {
        return this.attributeDataType;
    }

    private void setAttributeDataType(AttributeDataType attributeDataType) {
        if (this.attributeDataType != attributeDataType) {
            this.attributeDataType = attributeDataType;
            this.firePropertyChange("attributeDataType", (Object)this.attributeDataType, (Object)this.attributeDataType);
        }
    }

    private void initComponents() {
        this.listDelimiterLabel = new JLabel("List Delimiter:");
        this.listDelimiterLabel.putClientProperty("JComponent.sizeVariant", "small");
        this.typeButtonGroup = new ButtonGroup();
        this.namespaceButtonGroup = new ButtonGroup();
        this.dataTypeButtonGroup = new ButtonGroup();
        ArrayList<JToggleButton> dataTypeBtnList = new ArrayList<JToggleButton>();
        this.stringButton = this.createDataTypeButton(AttributeDataType.TYPE_STRING);
        dataTypeBtnList.add(this.stringButton);
        this.integerButton = this.createDataTypeButton(AttributeDataType.TYPE_INTEGER);
        dataTypeBtnList.add(this.integerButton);
        this.longButton = this.createDataTypeButton(AttributeDataType.TYPE_LONG);
        dataTypeBtnList.add(this.longButton);
        this.floatingPointButton = this.createDataTypeButton(AttributeDataType.TYPE_FLOATING);
        dataTypeBtnList.add(this.floatingPointButton);
        this.booleanButton = this.createDataTypeButton(AttributeDataType.TYPE_BOOLEAN);
        dataTypeBtnList.add(this.booleanButton);
        this.stringListButton = this.createDataTypeButton(AttributeDataType.TYPE_STRING_LIST);
        dataTypeBtnList.add(this.stringListButton);
        this.integerListButton = this.createDataTypeButton(AttributeDataType.TYPE_INTEGER_LIST);
        dataTypeBtnList.add(this.integerListButton);
        this.longListButton = this.createDataTypeButton(AttributeDataType.TYPE_LONG_LIST);
        dataTypeBtnList.add(this.longListButton);
        this.floatingPointListButton = this.createDataTypeButton(AttributeDataType.TYPE_FLOATING_LIST);
        dataTypeBtnList.add(this.floatingPointListButton);
        this.booleanListButton = this.createDataTypeButton(AttributeDataType.TYPE_BOOLEAN_LIST);
        dataTypeBtnList.add(this.booleanListButton);
        this.setStyles(dataTypeBtnList.toArray(new JToggleButton[dataTypeBtnList.size()]));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(false);
        GroupLayout.SequentialGroup namespaceHGroup = layout.createSequentialGroup();
        GroupLayout.ParallelGroup namespaceVGroup = layout.createParallelGroup(GroupLayout.Alignment.CENTER, false);
        if (this.availableNamespaces.size() > 1) {
            for (String ns : this.availableNamespaces) {
                JToggleButton btn = this.createNamespaceButton(ns);
                namespaceHGroup.addComponent(btn, -1, -1, Short.MAX_VALUE);
                namespaceVGroup.addComponent(btn);
            }
        }
        GroupLayout.SequentialGroup typeHGroup = layout.createSequentialGroup();
        GroupLayout.ParallelGroup typeVGroup = layout.createParallelGroup(GroupLayout.Alignment.CENTER, false);
        for (SourceColumnSemantic type : this.availableTypes) {
            JToggleButton btn = this.createTypeButton(type);
            typeHGroup.addComponent(btn, -1, -1, Short.MAX_VALUE);
            typeVGroup.addComponent(btn);
        }
        this.setStyles(this.typeButtons.values().toArray(new JToggleButton[this.typeButtons.size()]));
        JLabel typeLabel = new JLabel("Meaning:");
        typeLabel.putClientProperty("JComponent.sizeVariant", "small");
        JLabel dataTypeLabel = new JLabel("Data Type:");
        dataTypeLabel.putClientProperty("JComponent.sizeVariant", "small");
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.getAttributeNameTextField(), -1, -1, Short.MAX_VALUE).addComponent(typeLabel, -1, -1, Short.MAX_VALUE).addGroup(typeHGroup).addGroup(namespaceHGroup).addComponent(dataTypeLabel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.stringButton, -1, -1, Short.MAX_VALUE).addComponent(this.integerButton, -1, -1, Short.MAX_VALUE).addComponent(this.longButton, -1, -1, Short.MAX_VALUE).addComponent(this.floatingPointButton, -1, -1, Short.MAX_VALUE).addComponent(this.booleanButton, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.stringListButton, -1, -1, Short.MAX_VALUE).addComponent(this.integerListButton, -1, -1, Short.MAX_VALUE).addComponent(this.longListButton, -1, -1, Short.MAX_VALUE).addComponent(this.floatingPointListButton, -1, -1, Short.MAX_VALUE).addComponent(this.booleanListButton, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.listDelimiterLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getListDelimiterComboBox(), -2, -1, -2).addComponent(this.getOtherTextField(), 12, 36, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getAttributeNameTextField(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(typeLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(typeVGroup).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(namespaceVGroup).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(dataTypeLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.stringButton).addComponent(this.integerButton).addComponent(this.longButton).addComponent(this.floatingPointButton).addComponent(this.booleanButton)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.stringListButton).addComponent(this.integerListButton).addComponent(this.longListButton).addComponent(this.floatingPointListButton).addComponent(this.booleanListButton)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.listDelimiterLabel).addComponent(this.getListDelimiterComboBox(), -2, -1, -2).addComponent(this.getOtherTextField(), -2, -1, -2))));
    }

    protected JTextField getAttributeNameTextField() {
        if (this.attributeNameTextField == null) {
            this.attributeNameTextField = new JTextField(this.attrName);
            this.attributeNameTextField.setToolTipText("Column Name");
            this.attributeNameTextField.putClientProperty("JComponent.sizeVariant", "small");
            this.attributeNameTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.onTextChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.onTextChanged();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.onTextChanged();
                }

                public void onTextChanged() {
                    AttributeEditorPanel.this.attrName = AttributeEditorPanel.this.getAttributeName();
                    AttributeEditorPanel.this.firePropertyChange("attributeName", AttributeEditorPanel.this.attrName, AttributeEditorPanel.this.attrName);
                }
            });
        }
        return this.attributeNameTextField;
    }

    private JComboBox<String> getListDelimiterComboBox() {
        if (this.listDelimiterComboBox == null) {
            this.listDelimiterComboBox = new JComboBox();
            this.listDelimiterComboBox.putClientProperty("JComponent.sizeVariant", "small");
            this.listDelimiterComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{TextDelimiter.PIPE.toString(), TextDelimiter.COLON.toString(), TextDelimiter.SLASH.toString(), TextDelimiter.BACKSLASH.toString(), TextDelimiter.COMMA.toString(), TextDelimiter.SPACE.toString(), TextDelimiter.TAB.toString(), OTHER}));
            final ListCellRenderer<String> renderer = this.listDelimiterComboBox.getRenderer();
            this.listDelimiterComboBox.setRenderer(new ListCellRenderer<String>(){

                @Override
                public Component getListCellRendererComponent(JList<? extends String> list, String value, int index, boolean isSelected, boolean cellHasFocus) {
                    Component c = renderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    if (AttributeEditorPanel.OTHER.equals(value) && c instanceof JComponent) {
                        ((JComponent)c).setFont(((JComponent)c).getFont().deriveFont(2));
                    }
                    return c;
                }
            });
            this.listDelimiterComboBox.addActionListener(evt -> {
                boolean isOther = this.isOtherDelimiterSelected();
                this.getOtherTextField().setEnabled(isOther);
                if (!isOther || !this.getOtherTextField().getText().isEmpty()) {
                    this.listDelimiter = this.getListDelimiter();
                    this.firePropertyChange("listDelimiter", this.listDelimiter, this.listDelimiter);
                }
            });
        }
        return this.listDelimiterComboBox;
    }

    private JTextField getOtherTextField() {
        if (this.otherTextField == null) {
            this.otherTextField = new JTextField();
            this.otherTextField.putClientProperty("JComponent.sizeVariant", "small");
            this.otherTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.onTextChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.onTextChanged();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.onTextChanged();
                }

                public void onTextChanged() {
                    AttributeEditorPanel.this.listDelimiter = AttributeEditorPanel.this.getListDelimiter();
                    AttributeEditorPanel.this.firePropertyChange("listDelimiter", AttributeEditorPanel.this.listDelimiter, AttributeEditorPanel.this.listDelimiter);
                }
            });
        }
        return this.otherTextField;
    }

    private void setStyles(JToggleButton ... btnList) {
        if (LookAndFeelUtil.isAquaLAF()) {
            for (int i = 0; i < btnList.length; ++i) {
                JToggleButton btn = btnList[i];
                btn.putClientProperty("JButton.buttonType", "segmentedGradient");
                btn.putClientProperty("JButton.segmentPosition", "only");
                btn.putClientProperty("JComponent.sizeVariant", "small");
            }
        }
        LookAndFeelUtil.equalizeSize((JComponent[])btnList);
    }

    private void updateComponents() {
        this.updateTypeButtonGroup();
        this.updateDataTypeButtonGroup();
        this.updateListDelimiterComboBox();
        this.updateOtherTextField();
        this.updateTypeButtons();
        this.updateDataTypeButtons();
        this.updateNamespaceButtons();
    }

    private void updateTypeButtons() {
        AttributeDataType dataType = this.getSelectedAttributeDataType();
        for (Map.Entry<SourceColumnSemantic, JToggleButton> entry : this.typeButtons.entrySet()) {
            SourceColumnSemantic type = entry.getKey();
            JToggleButton btn = entry.getValue();
            btn.setEnabled(TypeUtil.isValid(type, dataType));
            btn.setForeground(btn.isEnabled() ? type.getForeground() : UIManager.getColor("Button.disabledForeground"));
        }
    }

    private void updateDataTypeButtons() {
        SourceColumnSemantic type = this.getSelectedAttributeType();
        for (Map.Entry<AttributeDataType, JToggleButton> entry : this.dataTypeButtons.entrySet()) {
            AttributeDataType dataType = entry.getKey();
            JToggleButton btn = entry.getValue();
            btn.setEnabled(TypeUtil.isValid(type, dataType));
        }
    }

    private void updateNamespaceButtons() {
        SourceColumnSemantic type = this.getSelectedAttributeType();
        for (Map.Entry<String, JToggleButton> entry : this.namespaceButtons.entrySet()) {
            String namespace = entry.getKey();
            JToggleButton btn = entry.getValue();
            btn.setEnabled(TypeUtil.isValid(type, namespace));
            if (!namespace.equals(this.namespace) || btn.isEnabled()) continue;
            this.setNamespace(TypeUtil.getPreferredNamespace(type));
        }
        this.updateNamespaceButtonGroup();
    }

    private void updateTypeButtonGroup() {
        JToggleButton btn = this.typeButtons.get((Object)this.attributeType);
        if (btn == null) {
            btn = this.typeButtons.get((Object)SourceColumnSemantic.NONE);
        }
        if (btn != null) {
            this.typeButtonGroup.setSelected(btn.getModel(), true);
        }
    }

    private void updateDataTypeButtonGroup() {
        ButtonModel model;
        JToggleButton button = this.dataTypeButtons.get((Object)this.attributeDataType);
        ButtonModel buttonModel = model = button != null ? button.getModel() : null;
        if (model != null) {
            this.dataTypeButtonGroup.setSelected(model, true);
        }
    }

    private void updateNamespaceButtonGroup() {
        JToggleButton btn = this.namespaceButtons.get(this.namespace);
        if (btn != null) {
            this.namespaceButtonGroup.setSelected(btn.getModel(), true);
        } else {
            this.namespaceButtonGroup.clearSelection();
        }
    }

    private void updateListDelimiterComboBox() {
        this.listDelimiterLabel.setEnabled(this.attributeDataType.isList());
        this.getListDelimiterComboBox().setEnabled(this.attributeDataType.isList());
        if (this.listDelimiter == null || this.listDelimiter.isEmpty()) {
            this.getListDelimiterComboBox().setSelectedIndex(0);
        } else {
            for (int i = 0; i < this.getListDelimiterComboBox().getItemCount(); ++i) {
                String label = this.getListDelimiterComboBox().getItemAt(i);
                TextDelimiter del = TextDelimiter.getByLabel(label);
                if (del == null || !this.listDelimiter.equals(del.getDelimiter())) continue;
                this.getListDelimiterComboBox().setSelectedIndex(i);
                return;
            }
            this.getListDelimiterComboBox().setSelectedItem(OTHER);
        }
    }

    private void updateOtherTextField() {
        this.getOtherTextField().setEnabled(this.attributeDataType.isList() && this.isOtherDelimiterSelected());
        if (this.listDelimiter != null && !this.listDelimiter.isEmpty() && this.isOtherDelimiterSelected()) {
            this.getOtherTextField().setText(this.listDelimiter);
        }
    }

    private boolean isOtherDelimiterSelected() {
        return OTHER.equals(this.getListDelimiterComboBox().getSelectedItem().toString());
    }

    private JToggleButton createTypeButton(SourceColumnSemantic type) {
        JToggleButton btn = new JToggleButton(type.getText());
        btn.setToolTipText(type.getDescription());
        btn.setFont(this.iconManager.getIconFont(14.0f));
        btn.setForeground(type.getForeground());
        btn.setName(type.toString());
        btn.addActionListener(evt -> {
            this.setNamespace(TypeUtil.getPreferredNamespace(type));
            this.updateNamespaceButtons();
            this.updateDataTypeButtons();
            this.setAttributeType(this.getSelectedAttributeType());
        });
        this.typeButtonGroup.add(btn);
        this.typeButtons.put(type, btn);
        return btn;
    }

    private JToggleButton createNamespaceButton(String namespace) {
        String text = null;
        String toolTip = null;
        if (namespace.equals("LOCAL_ATTRS")) {
            text = "Local";
            toolTip = "<html>The column will be created in the network's table</html>";
        } else if (namespace.equals("USER")) {
            text = "Shared";
            toolTip = "<html>The column will be created in the network collection's table<br>and shared among all networks in the same collection</html>";
        } else if (namespace.equals("HIDDEN")) {
            text = "Hidden";
            toolTip = "<html>The column will be created in the network's private table<br>and hidden from the user</html>";
        } else {
            text = namespace;
        }
        JToggleButton btn = new JToggleButton(text);
        btn.setToolTipText(toolTip);
        btn.setName(namespace);
        btn.addActionListener(evt -> {
            TypeUtil.setPreferredNamespace(namespace);
            this.setNamespace(namespace);
        });
        this.setStyles(btn);
        if (!LookAndFeelUtil.isAquaLAF()) {
            btn.setFont(btn.getFont().deriveFont(LookAndFeelUtil.getSmallFontSize()));
        }
        this.namespaceButtonGroup.add(btn);
        this.namespaceButtons.put(namespace, btn);
        return btn;
    }

    private JToggleButton createDataTypeButton(AttributeDataType dataType) {
        JToggleButton btn = new JToggleButton(dataType.getText());
        btn.setToolTipText(dataType.getDescription());
        btn.setFont(new Font("Serif", 1, 11));
        btn.setName(dataType.toString());
        btn.addActionListener(new DataTypeButtonActionListener(dataType.isList()));
        this.dataTypeButtonGroup.add(btn);
        this.dataTypeButtons.put(dataType, btn);
        return btn;
    }

    private class DataTypeButtonActionListener
    implements ActionListener {
        final boolean isList;

        DataTypeButtonActionListener(boolean isList) {
            this.isList = isList;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AttributeEditorPanel.this.listDelimiterLabel.setEnabled(this.isList);
            AttributeEditorPanel.this.getListDelimiterComboBox().setEnabled(this.isList);
            AttributeEditorPanel.this.getOtherTextField().setEnabled(this.isList && AttributeEditorPanel.this.isOtherDelimiterSelected());
            AttributeEditorPanel.this.updateTypeButtons();
            AttributeEditorPanel.this.updateNamespaceButtonGroup();
            AttributeEditorPanel.this.setAttributeDataType(AttributeEditorPanel.this.getSelectedAttributeDataType());
        }
    }
}

