/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.task;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.tableimport.internal.task.LoadNetworkReaderTask;
import org.cytoscape.tableimport.internal.task.LoadTableReaderTask;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectFileTableTask
extends AbstractTask {
    @Tunable(description="Data table file", longDescription="The path to the file that contains the table or network to be imported.", exampleStringValue="myFile.csv", params="fileCategory=table;input=true", required=true, gravity=0.0)
    public File file;
    private LoadTableReaderTask tableReader;
    private LoadNetworkReaderTask networkReader;
    private InputStream stream;
    private final CyServiceRegistrar serviceRegistrar;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public SelectFileTableTask(Task readerTask, CyServiceRegistrar serviceRegistrar) {
        if (readerTask instanceof LoadTableReaderTask) {
            this.tableReader = (LoadTableReaderTask)readerTask;
            this.networkReader = null;
        }
        if (readerTask instanceof LoadNetworkReaderTask) {
            this.tableReader = null;
            this.networkReader = (LoadNetworkReaderTask)readerTask;
        }
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        try {
            this.stream = ((StreamUtil)this.serviceRegistrar.getService(StreamUtil.class)).getInputStream(this.file.toURI().toURL());
            if (!this.stream.markSupported()) {
                this.stream = new BufferedInputStream(this.stream);
            }
        }
        catch (IOException e) {
            logger.warn("Error opening stream to URI: " + this.file.toString(), (Throwable)e);
            throw new Exception("Error opening stream to URI: " + this.file.toString());
        }
        String fileFormat = this.file.toURI().toString().substring(this.file.toURI().toString().lastIndexOf(46));
        if (this.tableReader != null) {
            this.tableReader.setInputFile(this.stream, fileFormat, this.file.toURI().toString());
        }
        if (this.networkReader != null) {
            this.networkReader.setInputFile(this.stream, fileFormat, this.file.toURI().toString(), this.file.toURI(), (IconManager)this.serviceRegistrar.getService(IconManager.class));
        }
    }
}

