/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.task;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.cytoscape.io.read.CyNetworkReader;
import org.cytoscape.io.read.CyNetworkReaderManager;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.property.AbstractConfigDirPropsReader;
import org.cytoscape.property.CyProperty;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.tableimport.internal.reader.AbstractMappingParameters;
import org.cytoscape.tableimport.internal.reader.ExcelNetworkSheetReader;
import org.cytoscape.tableimport.internal.reader.GraphReader;
import org.cytoscape.tableimport.internal.reader.NetworkTableMappingParameters;
import org.cytoscape.tableimport.internal.reader.NetworkTableReader;
import org.cytoscape.tableimport.internal.reader.SupportedFileType;
import org.cytoscape.tableimport.internal.reader.TextDelimiter;
import org.cytoscape.tableimport.internal.task.CombineNetworkReaderAndMappingTask;
import org.cytoscape.tableimport.internal.task.DelimitersTunable;
import org.cytoscape.tableimport.internal.task.TableImportContext;
import org.cytoscape.tableimport.internal.ui.PreviewTablePanel;
import org.cytoscape.tableimport.internal.util.AttributeDataType;
import org.cytoscape.tableimport.internal.util.ImportType;
import org.cytoscape.tableimport.internal.util.SourceColumnSemantic;
import org.cytoscape.tableimport.internal.util.TypeUtil;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.view.layout.CyLayoutAlgorithm;
import org.cytoscape.view.layout.CyLayoutAlgorithmManager;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.TunableValidator;
import org.cytoscape.work.util.ListSelection;
import org.cytoscape.work.util.ListSingleSelection;

public class LoadNetworkReaderTask
extends AbstractTask
implements CyNetworkReader,
TunableValidator {
    private InputStream is;
    private String fileType;
    private CyNetwork[] networks;
    private String inputName;
    private GraphReader reader;
    private CyNetworkReader netReader;
    private PreviewTablePanel previewPanel;
    private String networkName;
    private URI uri;
    private File tempFile;
    private TaskMonitor taskMonitor;
    private final TableImportContext tableImportContext;
    private final CyServiceRegistrar serviceRegistrar;
    private boolean nogui;
    @ContainsTunables
    public DelimitersTunable delimiters = new DelimitersTunable();
    @Tunable(description="Text delimiters for lists", longDescription="Select the delimiters to use to separate list entries in a list, from the list '``|``','``\\``','``/``', or '``,``'.  ``|`` is used by default", exampleStringValue="|,\\", context="both")
    public ListSingleSelection<String> delimitersForDataList;
    @Tunable(description="Starting row", longDescription="The starting row of the import.  This is used to skip over comments and other non-data rows at the beginning of the file.", exampleStringValue="1", context="both")
    public int startLoadRow = -1;
    @Tunable(description="Column names in first row?", exampleStringValue="false", longDescription="If this is ``true`` then the first row should contain the names of the columns. Note that ``startLoadRow`` must be set for this to work properly", context="both")
    public boolean firstRowAsColumnNames;
    @Tunable(description="Source column number", exampleStringValue="1", longDescription="The column index that contains the source node identifiers.", required=false, context="both")
    public int indexColumnSourceInteraction = -1;
    @Tunable(description="Target column number", longDescription="The column index that contains the target node identifiers.  If this is not specified then the resulting network will have no edges", exampleStringValue="3", context="both")
    public int indexColumnTargetInteraction = -1;
    @Tunable(description="Interaction column number", longDescription="The column index that contains the interaction type.  This is not required.", exampleStringValue="2", context="both")
    public int indexColumnTypeInteraction = -1;
    @Tunable(description="Default interaction type", longDescription="Used to set the default interaction type to use when there is no interaction type column.", exampleStringValue="pp", context="both")
    public String defaultInteraction = "interacts with";
    @Tunable(description="Column data types", longDescription="List of column data types ordered by column index (e.g. \"string,int,long,double,boolean,intlist\" or just \"s,i,l,d,b,il\"):", exampleStringValue="string,int,string,double,double", context="nongui")
    public String dataTypeList;
    @Tunable(description="Column import types", longDescription="List of column types ordered by column index (e.g. \"source,target,interaction,source attribute,target attribute,edge attribute,skip\" or just \"s,t,i,sa,ta,ea,x\"):", exampleStringValue="source,target,source attribute,source attribute,target attribute,target attribute", context="nongui")
    public String columnTypeList;
    @Tunable(description="Decimal character used in the decimal format", longDescription="Character that separates the integer-part (characteristic) and the fractional-part (mantissa) of a decimal number. The default value is the dot \".\"", exampleStringValue=".", context="nogui")
    public String decimalSeparator;
    private Character decSeparator;
    private NetworkTableMappingParameters ntmp;
    private CyRootNetwork rootNetwork;
    private Map<Object, CyNode> nMap;
    private CyNetworkViewFactory networkViewFactory;
    static String DELIM = "\b";

    public LoadNetworkReaderTask(TableImportContext tableImportContext, CyServiceRegistrar serviceRegistrar) {
        this(tableImportContext, serviceRegistrar, false);
    }

    public LoadNetworkReaderTask(TableImportContext tableImportContext, CyServiceRegistrar serviceRegistrar, boolean nogui) {
        this.tableImportContext = tableImportContext;
        this.serviceRegistrar = serviceRegistrar;
        ArrayList<String> tempList = new ArrayList<String>();
        tempList.add(TextDelimiter.PIPE.getDelimiter());
        tempList.add(TextDelimiter.BACKSLASH.getDelimiter());
        tempList.add(TextDelimiter.SLASH.getDelimiter());
        tempList.add(TextDelimiter.COMMA.getDelimiter());
        this.delimitersForDataList = new ListSingleSelection(tempList);
        this.nogui = nogui;
    }

    public void setInputFile(InputStream is, String fileType, String inputName, URI uriName, IconManager iconManager) {
        this.is = is;
        this.fileType = fileType;
        this.inputName = inputName;
        this.uri = uriName;
        this.previewPanel = new PreviewTablePanel(ImportType.NETWORK_IMPORT, this.tableImportContext, iconManager);
        try {
            this.tempFile = File.createTempFile("temp", this.fileType);
            this.tempFile.deleteOnExit();
            FileOutputStream os = new FileOutputStream(this.tempFile);
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = is.read(bytes)) != -1) {
                os.write(bytes, 0, read);
            }
            os.flush();
            os.close();
            this.is = new FileInputStream(this.tempFile);
        }
        catch (Exception e) {
            this.is = null;
            e.printStackTrace();
        }
        this.delimiters.setSelectedValues(Arrays.asList(TextDelimiter.TAB, TextDelimiter.COMMA));
        this.delimitersForDataList.setSelectedValue((Object)TextDelimiter.PIPE.getDelimiter());
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("Loading network from table");
        tm.setProgress(0.0);
        tm.setStatusMessage("Loading network...");
        this.taskMonitor = tm;
        this.decSeparator = this.decimalSeparator == null || this.decimalSeparator.isEmpty() ? AbstractMappingParameters.DEF_DECIMAL_SEPARATOR : Character.valueOf(this.decimalSeparator.charAt(0));
        CyNetworkReaderManager networkReaderManager = (CyNetworkReaderManager)this.serviceRegistrar.getService(CyNetworkReaderManager.class);
        if (this.is != null) {
            this.netReader = networkReaderManager.getReader(this.is, this.inputName);
        }
        if (this.netReader == null) {
            this.netReader = networkReaderManager.getReader(this.uri, this.inputName);
        }
        if (this.netReader instanceof CombineNetworkReaderAndMappingTask) {
            Object[] listDelimiters;
            Workbook workbook = null;
            if (this.fileType != null && (this.fileType.equalsIgnoreCase(SupportedFileType.EXCEL.getExtension()) || this.fileType.equalsIgnoreCase(SupportedFileType.OOXML.getExtension())) && workbook == null) {
                try {
                    workbook = WorkbookFactory.create((InputStream)new FileInputStream(this.tempFile));
                }
                catch (InvalidFormatException e) {
                    throw new IllegalArgumentException("Could not read Excel file.  Maybe the file is broken?", e);
                }
            }
            this.netReader = null;
            if (this.startLoadRow > 0) {
                --this.startLoadRow;
            }
            int startLoadRowTemp = this.firstRowAsColumnNames ? 0 : this.startLoadRow;
            this.previewPanel.update(workbook, this.fileType, this.tempFile.getAbsolutePath(), new FileInputStream(this.tempFile), this.delimiters.getSelectedValues(), null, startLoadRowTemp, this.decSeparator);
            int colCount = this.previewPanel.getPreviewTable().getColumnModel().getColumnCount();
            Object curName = null;
            if (this.firstRowAsColumnNames) {
                this.previewPanel.setFirstRowAsColumnNames();
                ++this.startLoadRow;
            }
            SourceColumnSemantic[] types = this.previewPanel.getTypes();
            ArrayList<Object> attrNameList = new ArrayList<Object>();
            for (int i = 0; i < colCount; ++i) {
                curName = this.previewPanel.getPreviewTable().getColumnModel().getColumn(i).getHeaderValue();
                if (attrNameList.contains(curName)) {
                    int dupIndex = 0;
                    for (int idx = 0; idx < attrNameList.size(); ++idx) {
                        if (!curName.equals(attrNameList.get(idx))) continue;
                        dupIndex = idx;
                        break;
                    }
                    if (!TypeUtil.allowsDuplicateName(ImportType.NETWORK_IMPORT, types[i], types[dupIndex])) {
                        return;
                    }
                }
                if (curName == null) {
                    attrNameList.add("Column " + i);
                    continue;
                }
                attrNameList.add(curName.toString());
            }
            String[] attributeNames = attrNameList.toArray(new String[attrNameList.size()]);
            SourceColumnSemantic[] typesCopy = Arrays.copyOf(types, types.length);
            AttributeDataType[] dataTypes = this.previewPanel.getDataTypes();
            AttributeDataType[] dataTypesCopy = Arrays.copyOf(dataTypes, dataTypes.length);
            AttributeDataType[] tunableDataTypes = null;
            if (this.dataTypeList != null && !this.dataTypeList.trim().isEmpty()) {
                tunableDataTypes = TypeUtil.parseDataTypeList(this.dataTypeList);
            }
            if (tunableDataTypes != null && tunableDataTypes.length > 0) {
                System.arraycopy(tunableDataTypes, 0, dataTypesCopy, 0, Math.min(tunableDataTypes.length, dataTypesCopy.length));
            }
            SourceColumnSemantic[] tunableColumnTypes = null;
            if (this.columnTypeList != null && !this.columnTypeList.trim().isEmpty()) {
                tunableColumnTypes = TypeUtil.parseColumnTypeList(this.columnTypeList);
            }
            if (tunableColumnTypes != null && tunableColumnTypes.length > 0) {
                System.arraycopy(tunableColumnTypes, 0, typesCopy, 0, Math.min(tunableColumnTypes.length, typesCopy.length));
                int index = 1;
                for (SourceColumnSemantic scs : tunableColumnTypes) {
                    if (scs.equals((Object)SourceColumnSemantic.SOURCE)) {
                        this.indexColumnSourceInteraction = index;
                    } else if (scs.equals((Object)SourceColumnSemantic.TARGET)) {
                        this.indexColumnTargetInteraction = index;
                    } else if (scs.equals((Object)SourceColumnSemantic.INTERACTION)) {
                        this.indexColumnTypeInteraction = index;
                    }
                    ++index;
                }
            }
            String[] namespaces = this.previewPanel.getNamespaces();
            String[] namespacesCopy = Arrays.copyOf(namespaces, namespaces.length);
            if (this.nogui) {
                this.nogui = false;
                TunableValidator.ValidationState state = this.getValidationState(new StringBuffer(80));
                switch (state) {
                    case INVALID: {
                        tm.showMessage(TaskMonitor.Level.ERROR, "Source column must be specified");
                        return;
                    }
                    case REQUEST_CONFIRMATION: {
                        tm.showMessage(TaskMonitor.Level.WARN, "Target column is not specified.  No edges will be created");
                    }
                }
                this.nogui = true;
            }
            if ((listDelimiters = this.previewPanel.getListDelimiters()) == null || listDelimiters.length == 0) {
                listDelimiters = new String[dataTypes.length];
                if (this.delimitersForDataList.getSelectedValue() != null) {
                    Arrays.fill(listDelimiters, this.delimitersForDataList.getSelectedValue());
                }
            }
            if (this.indexColumnSourceInteraction > 0) {
                --this.indexColumnSourceInteraction;
            }
            if (this.indexColumnTargetInteraction > 0) {
                --this.indexColumnTargetInteraction;
            }
            if (this.indexColumnTypeInteraction > 0) {
                --this.indexColumnTypeInteraction;
            }
            this.networkName = this.previewPanel.getSourceName();
            this.ntmp = new NetworkTableMappingParameters(this.networkName, this.delimiters.getSelectedValues(), (String[])listDelimiters, attributeNames, dataTypesCopy, typesCopy, namespacesCopy, this.indexColumnSourceInteraction, this.indexColumnTargetInteraction, this.indexColumnTypeInteraction, this.defaultInteraction, this.startLoadRow, null, this.decSeparator);
            try {
                if (this.fileType.equalsIgnoreCase(SupportedFileType.EXCEL.getExtension()) || this.fileType.equalsIgnoreCase(SupportedFileType.OOXML.getExtension())) {
                    Sheet sheet = workbook.getSheet(this.networkName);
                    this.reader = new ExcelNetworkSheetReader(this.networkName, sheet, this.ntmp, this.nMap, this.rootNetwork, this.serviceRegistrar);
                } else {
                    this.networkName = this.inputName;
                    this.reader = new NetworkTableReader(this.networkName, new FileInputStream(this.tempFile), this.ntmp, this.nMap, this.rootNetwork, this.serviceRegistrar);
                }
            }
            catch (Exception ioe) {
                tm.showMessage(TaskMonitor.Level.ERROR, "Unable to read network: " + ioe.getMessage());
                return;
            }
            this.loadNetwork(tm);
            tm.setProgress(1.0);
        } else {
            this.networkName = this.inputName;
            this.insertTasksAfterCurrentTask(new Task[]{this.netReader});
        }
    }

    private void loadNetwork(TaskMonitor tm) throws IOException {
        CySubNetwork network;
        if (this.rootNetwork == null) {
            network = ((CyNetworkFactory)this.serviceRegistrar.getService(CyNetworkFactory.class)).createNetwork();
            this.rootNetwork = ((CyRootNetworkManager)this.serviceRegistrar.getService(CyRootNetworkManager.class)).getRootNetwork((CyNetwork)network);
        } else {
            network = this.rootNetwork.addSubNetwork();
        }
        tm.setProgress(0.1);
        this.reader.setNetwork((CyNetwork)network);
        if (this.cancelled) {
            return;
        }
        this.reader.read();
        tm.setProgress(0.8);
        if (this.cancelled) {
            return;
        }
        this.networks = new CyNetwork[]{network};
        tm.setProgress(1.0);
    }

    public CyNetworkView buildCyNetworkView(CyNetwork net) {
        if (this.netReader != null) {
            return this.netReader.buildCyNetworkView(net);
        }
        CyNetworkView view = this.networkViewFactory.createNetworkView(net);
        CyLayoutAlgorithmManager layoutMgr = (CyLayoutAlgorithmManager)this.serviceRegistrar.getService(CyLayoutAlgorithmManager.class);
        CyLayoutAlgorithm layout = layoutMgr.getDefaultLayout();
        String attribute = layoutMgr.getLayoutAttribute(layout, view);
        TaskIterator itr = layout.createTaskIterator(view, layout.getDefaultLayoutContext(), CyLayoutAlgorithm.ALL_NODE_VIEWS, attribute);
        Task nextTask = itr.next();
        try {
            nextTask.run(this.taskMonitor);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not finish layout", e);
        }
        this.taskMonitor.setProgress(1.0);
        return view;
    }

    public CyNetwork[] getNetworks() {
        if (this.netReader != null) {
            return this.netReader.getNetworks();
        }
        return this.networks;
    }

    public String getName() {
        return this.networkName;
    }

    public TunableValidator.ValidationState getValidationState(Appendable errMsg) {
        if (this.nogui) {
            return TunableValidator.ValidationState.OK;
        }
        try {
            if (this.indexColumnSourceInteraction <= 0) {
                if (this.indexColumnTargetInteraction <= 0) {
                    errMsg.append("The network cannot be created without selecting the source and target columns.");
                    return TunableValidator.ValidationState.INVALID;
                }
                errMsg.append("No edges will be created in the network; the source column is not selected.\nDo you want to continue?");
                return TunableValidator.ValidationState.REQUEST_CONFIRMATION;
            }
            if (this.indexColumnTargetInteraction <= 0) {
                errMsg.append("No edges will be created in the network; the target column is not selected.\nDo you want to continue?");
                return TunableValidator.ValidationState.REQUEST_CONFIRMATION;
            }
            return TunableValidator.ValidationState.OK;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return TunableValidator.ValidationState.INVALID;
        }
    }

    public void setRootNetwork(CyRootNetwork rootNetwork) {
        this.rootNetwork = rootNetwork;
    }

    public void setNodeMap(Map<Object, CyNode> nMap) {
        this.nMap = nMap;
    }

    public void setNetworkViewFactory(CyNetworkViewFactory networkViewFactory) {
        this.networkViewFactory = networkViewFactory;
    }

    private String getString() {
        StringBuilder str = new StringBuilder("LoadNetworkReaderTask\n");
        str.append("delimiters=").append(this.listToString(this.delimiters.getTunable())).append("\n");
        str.append("delimitersForDataList=").append(this.listToString((ListSelection<String>)this.delimitersForDataList)).append("\n");
        str.append("startLoadRow=" + this.startLoadRow + "\n");
        str.append("firstRowAsColumnNames=").append(this.firstRowAsColumnNames ? "TRUE" : "FALSE").append("\n");
        str.append("indexColumnSourceInteraction=" + this.indexColumnSourceInteraction + "\n");
        str.append("indexColumnTargetInteraction=" + this.indexColumnTargetInteraction + "\n");
        str.append("indexColumnTypeInteraction=" + this.indexColumnTypeInteraction + "\n");
        str.append("defaultInteraction=").append(this.defaultInteraction).append("\n");
        str.append("dataTypeList=").append(this.dataTypeList).append("\n");
        return str.toString();
    }

    private void setString(String state) {
        this.loadList(this.delimiters.getTunable(), this.fieldFromString(state, "delimiters"));
        this.loadList((ListSelection<String>)this.delimitersForDataList, this.fieldFromString(state, "delimitersForDataList"));
        this.startLoadRow = Integer.parseInt(this.fieldFromString(state, "startLoadRow"));
        this.firstRowAsColumnNames = "TRUE".equals(this.fieldFromString(state, "firstRowAsColumnNames"));
        this.indexColumnSourceInteraction = this.intFromString(state, "indexColumnSourceInteraction");
        this.indexColumnTypeInteraction = this.intFromString(state, "indexColumnTypeInteraction");
        this.defaultInteraction = this.fieldFromString(state, "defaultInteraction");
        this.dataTypeList = this.fieldFromString(state, "dataTypeList");
    }

    private int intFromString(String s, String fieldName) {
        String fld = this.fieldFromString(s, fieldName);
        try {
            return Integer.parseInt(fld);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private String listToString(ListSelection<String> set) {
        StringBuilder builder = new StringBuilder();
        for (String s : set.getPossibleValues()) {
            builder.append(s).append(DELIM);
        }
        return builder.toString();
    }

    private void loadList(ListSelection<String> set, String input) {
        ArrayList<String> delims = new ArrayList<String>();
        String[] parsed = input.split(DELIM);
        delims.addAll(Arrays.asList(parsed));
        set.setPossibleValues(delims);
    }

    private String fieldFromString(String s, String field) {
        int end;
        int start = s.indexOf(field + "=");
        if (start > 0 && (end = s.indexOf("\n", start += field.length() + 1)) > 0) {
            return s.substring(start, end);
        }
        return null;
    }

    private String getProperty() {
        CyProperty cyProperties = (CyProperty)this.serviceRegistrar.getService(CyProperty.class, "(cyPropertyName=myApp.props)");
        String propertyValue = "";
        if (propertyValue != null && !propertyValue.isEmpty()) {
            this.setString(propertyValue);
        }
        return null;
    }

    private void saveProperty() {
        Properties stateProps = new Properties();
        stateProps.setProperty("network.load.config", this.getString());
    }

    private static class PropsReader
    extends AbstractConfigDirPropsReader {
        public PropsReader(String name, String fileName) {
            super(name, fileName, CyProperty.SavePolicy.SESSION_FILE);
        }

        public static PropsReader makeReader(String props) {
            return new PropsReader("network.load.props", props);
        }
    }
}

