/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.task;

import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.io.read.CyTableReader;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNetworkTableManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.tableimport.internal.task.TableImportContext;
import org.cytoscape.tableimport.internal.util.DataUtils;
import org.cytoscape.util.json.CyJSONUtil;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.TunableValidator;
import org.cytoscape.work.json.JSONResult;
import org.cytoscape.work.util.ListChangeListener;
import org.cytoscape.work.util.ListMultipleSelection;
import org.cytoscape.work.util.ListSelection;
import org.cytoscape.work.util.ListSingleSelection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportTableDataTask
extends AbstractTask
implements TunableValidator,
ObservableTask {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private static final String NO_NETWORKS = "No Networks Found";
    public static final String NETWORK_COLLECTION = "To a Network Collection";
    public static final String NETWORK_SELECTION = "To selected networks only";
    public static final String UNASSIGNED_TABLE = "To an unassigned table";
    private CyTableReader reader;
    private final TableImportContext tableImportContext;
    private final CyServiceRegistrar serviceRegistrar;
    private CyTable globalTable;
    private boolean byReader;
    private Map<String, CyNetwork> name2NetworkMap;
    private Map<String, CyRootNetwork> name2RootMap;
    private Map<String, String> source2targetColumnMap;
    private boolean networksPresent;
    private List<CyTable> mappedTables;
    public ListSingleSelection<String> whereImportTable;
    public ListSingleSelection<String> targetNetworkCollection;
    public ListSingleSelection<TableType> dataTypeTargetForNetworkCollection;
    public ListSingleSelection<String> keyColumnForMapping;
    @Tunable(description="Case Sensitive Key Values:", groups={"Target Table Data", "Select a Network Collection"}, gravity=3.3, xorKey="To a Network Collection", longDescription="Determines whether capitalization is considered in matching and sorting", exampleStringValue="false")
    public boolean caseSensitiveNetworkCollectionKeys = true;
    public ListMultipleSelection<String> targetNetworkList;
    public ListSingleSelection<TableType> dataTypeTargetForNetworkList;
    public ListSingleSelection<String> keyColumnForMappingNetworkList;
    @Tunable(description="Case Sensitive Key Values:", groups={"Target Table Data", "Select Networks"}, gravity=3.4, xorKey="To selected networks only", longDescription="Determines whether capitalization is considered in matching and sorting", exampleStringValue="false")
    public boolean caseSensitiveNetworkKeys = true;
    @Tunable(description="New Table Name:", groups={"Target Table Data", "Set New Table Name"}, gravity=5.0, xorKey="To an unassigned table", longDescription="The title of the new table", exampleStringValue="Supplemental Info")
    public String newTableName;

    @Tunable(description="Where to Import Table Data:", gravity=1.0, groups={"Target Table Data"}, xorChildren=true, longDescription="Determines what network(s) the imported table will be associated with (if any).  A table can be imported into a ```Network Collection```, ```Selected networks``` or ```to an unassigned table```.", exampleStringValue="To a Network Collection")
    public ListSingleSelection<String> getWhereImportTable() {
        return this.whereImportTable;
    }

    public void setWhereImportTable(ListSingleSelection<String> chooser) {
        if (chooser != null && chooser != this.whereImportTable) {
            chooser.addListener((ListChangeListener)new ListChangeListener<String>(){

                public void selectionChanged(ListSelection<String> source) {
                    if (ImportTableDataTask.this.tableImportContext != null) {
                        ImportTableDataTask.this.tableImportContext.setKeyRequired(ImportTableDataTask.this.isKeyMandatory());
                    }
                }

                public void listChanged(ListSelection<String> source) {
                }
            });
        }
        this.whereImportTable = chooser;
    }

    @Tunable(description="Network Collection:", groups={"Target Table Data", "Select a Network Collection"}, gravity=2.0, xorKey="To a Network Collection", longDescription="The network collection to use for the table import", exampleStringValue="galFiltered.sif")
    public ListSingleSelection<String> getTargetNetworkCollection() {
        return this.targetNetworkCollection;
    }

    public void setTargetNetworkCollection(ListSingleSelection<String> roots) {
        this.targetNetworkCollection = roots;
        this.updateKeyColumnForMapping();
    }

    @Tunable(description="Import Data as:", groups={"Target Table Data", "Select a Network Collection"}, gravity=3.1, xorKey="To a Network Collection", longDescription="Select whether to import the data as ```Node Table Columns```, ```Edge Table Columns```, or ```Network Table Columns```", exampleStringValue="Node Table Columns")
    public ListSingleSelection<TableType> getDataTypeTargetForNetworkCollection() {
        return this.dataTypeTargetForNetworkCollection;
    }

    public void setDataTypeTargetForNetworkCollection(ListSingleSelection<TableType> options) {
        this.dataTypeTargetForNetworkCollection = options;
        this.updateKeyColumnForMapping();
    }

    @Tunable(description="Key Column for Network:", groups={"Target Table Data", "Select a Network Collection"}, gravity=3.2, xorKey="To a Network Collection", listenForChange={"DataTypeTargetForNetworkCollection", "TargetNetworkCollection"}, longDescription="The column in the network to use as the merge key", exampleStringValue="name")
    public ListSingleSelection<String> getKeyColumnForMapping() {
        return this.keyColumnForMapping;
    }

    public void setKeyColumnForMapping(ListSingleSelection<String> colList) {
        this.keyColumnForMapping = colList;
    }

    @Tunable(description="Network List:", groups={"Target Table Data", "Select Networks"}, gravity=3.1, xorKey="To selected networks only", longDescription="The list of networks into which the table is imported", exampleStringValue="all")
    public ListMultipleSelection<String> getTargetNetworkList() {
        return this.targetNetworkList;
    }

    public void setTargetNetworkList(ListMultipleSelection<String> list) {
        this.targetNetworkList = list;
        this.updateKeyColumnForMappingNetworkList();
    }

    @Tunable(description="Import Data as:", groups={"Target Table Data", "Select Networks"}, gravity=3.2, xorKey="To selected networks only", longDescription="The data type of the targets", exampleStringValue="int")
    public ListSingleSelection<TableType> getDataTypeTargetForNetworkList() {
        return this.dataTypeTargetForNetworkList;
    }

    public void setDataTypeTargetForNetworkList(ListSingleSelection<TableType> options) {
        this.dataTypeTargetForNetworkList = options;
        this.updateKeyColumnForMappingNetworkList();
    }

    @Tunable(description="Key Column for Networks:", groups={"Target Table Data", "Select Networks"}, gravity=3.3, xorKey="To selected networks only", listenForChange={"DataTypeTargetForNetworkList", "TargetNetworkList"}, longDescription="The column in the network to use as the merge key", exampleStringValue="name")
    public ListSingleSelection<String> getKeyColumnForMappingNetworkList() {
        return this.keyColumnForMappingNetworkList;
    }

    public void setKeyColumnForMappingNetworkList(ListSingleSelection<String> colList) {
        this.keyColumnForMappingNetworkList = colList;
    }

    @ProvidesTitle
    public String getTitle() {
        return "Import Data";
    }

    public ImportTableDataTask(CyTableReader reader, TableImportContext tableImportContext, CyServiceRegistrar serviceRegistrar) {
        this.reader = reader;
        this.tableImportContext = tableImportContext;
        this.serviceRegistrar = serviceRegistrar;
        this.byReader = true;
        this.init();
    }

    public ImportTableDataTask(CyTable globalTable, TableImportContext tableImportContext, CyServiceRegistrar serviceRegistrar) {
        this.byReader = false;
        this.tableImportContext = tableImportContext;
        this.serviceRegistrar = serviceRegistrar;
        this.globalTable = globalTable;
        this.init();
    }

    private final void init() {
        this.name2NetworkMap = new HashMap<String, CyNetwork>();
        this.name2RootMap = new HashMap<String, CyRootNetwork>();
        this.source2targetColumnMap = new HashMap<String, String>();
        this.mappedTables = new ArrayList<CyTable>();
        CyApplicationManager appMgr = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        CyNetworkManager netMgr = (CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class);
        if (!netMgr.getNetworkSet().isEmpty()) {
            this.setWhereImportTable((ListSingleSelection<String>)new ListSingleSelection((Object[])new String[]{NETWORK_COLLECTION, NETWORK_SELECTION, UNASSIGNED_TABLE}));
            this.getWhereImportTable().setSelectedValue((Object)NETWORK_COLLECTION);
            this.networksPresent = true;
        } else {
            this.setWhereImportTable((ListSingleSelection<String>)new ListSingleSelection((Object[])new String[]{UNASSIGNED_TABLE}));
            this.getWhereImportTable().setSelectedValue((Object)UNASSIGNED_TABLE);
        }
        if (this.tableImportContext != null) {
            this.tableImportContext.setKeyRequired(this.isKeyMandatory());
        }
        if (this.byReader) {
            if (this.reader != null && this.reader.getTables() != null) {
                this.newTableName = this.reader.getTables()[0].getTitle();
            }
        } else {
            this.newTableName = this.globalTable.getTitle();
        }
        if (this.networksPresent) {
            TableType tableType = this.tableImportContext.getTableType();
            ArrayList<TableType> options = new ArrayList<TableType>();
            if (tableType == null) {
                this.tableImportContext.setTableType(TableType.NODE_ATTR);
                tableType = this.tableImportContext.getTableType();
            }
            for (TableType type : TableType.values()) {
                options.add(type);
            }
            CyNetwork currNet = appMgr.getCurrentNetwork();
            this.dataTypeTargetForNetworkCollection = new ListSingleSelection(options);
            this.dataTypeTargetForNetworkList = new ListSingleSelection(options);
            if (tableType == null) {
                this.getWhereImportTable().setSelectedValue((Object)UNASSIGNED_TABLE);
            } else {
                this.dataTypeTargetForNetworkCollection.setSelectedValue((Object)tableType);
                this.dataTypeTargetForNetworkList.setSelectedValue((Object)tableType);
            }
            for (CyNetwork net : netMgr.getNetworkSet()) {
                Iterator netName = (String)net.getRow((CyIdentifiable)net).get("name", String.class);
                this.name2NetworkMap.put((String)((Object)netName), net);
            }
            ArrayList<String> names = new ArrayList<String>();
            names.addAll(this.name2NetworkMap.keySet());
            this.sort(names);
            if (names.isEmpty()) {
                this.targetNetworkList = new ListMultipleSelection((Object[])new String[]{NO_NETWORKS});
            } else {
                String currName;
                this.targetNetworkList = new ListMultipleSelection(names);
                if (currNet != null && (currName = (String)currNet.getRow((CyIdentifiable)currNet).get("name", String.class)) != null && this.targetNetworkList.getPossibleValues().contains(currName)) {
                    this.targetNetworkList.setSelectedValues(Collections.singletonList(currName));
                }
                ArrayList<CyNetwork> selectedNetworks = new ArrayList<CyNetwork>();
                for (String netName : this.targetNetworkList.getSelectedValues()) {
                    if (!this.name2NetworkMap.containsKey(netName)) continue;
                    selectedNetworks.add(this.name2NetworkMap.get(netName));
                }
                this.keyColumnForMappingNetworkList = this.getColumns(selectedNetworks, (TableType)((Object)this.dataTypeTargetForNetworkList.getSelectedValue()), "USER");
            }
            CyRootNetworkManager rootNetMgr = (CyRootNetworkManager)this.serviceRegistrar.getService(CyRootNetworkManager.class);
            for (CyNetwork net : netMgr.getNetworkSet()) {
                CyRootNetwork rootNet = rootNetMgr.getRootNetwork(net);
                if (this.name2RootMap.containsValue(rootNet)) continue;
                this.name2RootMap.put((String)rootNet.getRow((CyIdentifiable)rootNet).get("name", String.class), rootNet);
            }
            ArrayList<String> rootNames = new ArrayList<String>();
            rootNames.addAll(this.name2RootMap.keySet());
            this.sort(rootNames);
            this.targetNetworkCollection = new ListSingleSelection(rootNames);
            if (!rootNames.isEmpty()) {
                String currName;
                CyRootNetwork currRootNet;
                this.targetNetworkCollection.setSelectedValue((Object)((String)rootNames.get(0)));
                CyRootNetwork cyRootNetwork = currRootNet = currNet instanceof CySubNetwork ? rootNetMgr.getRootNetwork(currNet) : null;
                if (currRootNet != null && (currName = (String)currRootNet.getRow((CyIdentifiable)currRootNet).get("name", String.class)) != null && this.targetNetworkCollection.getPossibleValues().contains(currName)) {
                    this.targetNetworkCollection.setSelectedValue((Object)currName);
                }
                this.keyColumnForMapping = this.getColumns(Collections.singletonList(this.name2RootMap.get(this.targetNetworkCollection.getSelectedValue())), (TableType)((Object)this.dataTypeTargetForNetworkCollection.getSelectedValue()), "SHARED_ATTRS");
            }
        }
    }

    public void run(TaskMonitor tm) throws Exception {
        if (!this.checkKeys()) {
            if (this.byReader) {
                throw new IllegalArgumentException("Types of keys selected for tables are not valid.\nKeys must be of type Integer, Long, or String.");
            }
            throw new IllegalArgumentException("Types of keys selected for tables are not valid.\nKeys must be of type Integer, Long, or String, and must be the same type for a soft merge.");
        }
        if (this.networksPresent && this.name2RootMap.isEmpty()) {
            return;
        }
        String where = (String)this.getWhereImportTable().getSelectedValue();
        TableType tableType = this.getDataTypeOptions();
        if (where.matches(NETWORK_COLLECTION)) {
            this.mapTableToDefaultAttrs(tableType);
            CyRootNetwork rootNet = this.name2RootMap.get(this.targetNetworkCollection.getSelectedValue());
            if (rootNet != null) {
                List networks = rootNet.getSubNetworkList();
                this.mapTableToLocalAttrs(tableType, networks);
            }
        } else if (where.matches(NETWORK_SELECTION)) {
            if (!this.targetNetworkList.getSelectedValues().isEmpty()) {
                HashSet<CyNetwork> networks = new HashSet<CyNetwork>();
                if (!((String)this.targetNetworkList.getSelectedValues().get(0)).equals(NO_NETWORKS)) {
                    for (String netName : this.targetNetworkList.getSelectedValues()) {
                        CyNetwork net = this.name2NetworkMap.get(netName);
                        if (net == null) continue;
                        networks.add(net);
                    }
                    this.mapTableToLocalAttrs(tableType, networks);
                }
            }
        } else if (where.matches(UNASSIGNED_TABLE)) {
            this.addTable();
        }
    }

    private void updateKeyColumnForMapping() {
        ListSingleSelection<String> tempList = this.getColumns(Collections.singletonList(this.name2RootMap.get(this.targetNetworkCollection.getSelectedValue())), (TableType)((Object)this.dataTypeTargetForNetworkCollection.getSelectedValue()), "SHARED_ATTRS");
        if (!this.keyColumnForMapping.getPossibleValues().containsAll(tempList.getPossibleValues()) || this.keyColumnForMapping.getPossibleValues().size() != tempList.getPossibleValues().size()) {
            this.keyColumnForMapping = tempList;
        }
    }

    private void updateKeyColumnForMappingNetworkList() {
        ArrayList<CyNetwork> selectedNetworks = new ArrayList<CyNetwork>();
        for (String netName : this.targetNetworkList.getSelectedValues()) {
            if (!this.name2NetworkMap.containsKey(netName)) continue;
            selectedNetworks.add(this.name2NetworkMap.get(netName));
        }
        ListSingleSelection<String> tempList = this.getColumns(selectedNetworks, (TableType)((Object)this.dataTypeTargetForNetworkList.getSelectedValue()), "USER");
        if (!this.keyColumnForMappingNetworkList.getPossibleValues().containsAll(tempList.getPossibleValues()) || this.keyColumnForMappingNetworkList.getPossibleValues().size() != tempList.getPossibleValues().size()) {
            this.keyColumnForMappingNetworkList = tempList;
        }
    }

    private ListSingleSelection<String> getColumns(Collection<? extends CyNetwork> networkList, TableType tableType, String namespace) {
        ListSingleSelection listSingleSelection;
        HashSet<ColumnDescriptor> colDescSet = null;
        for (CyNetwork cyNetwork : networkList) {
            CyTable table = this.getTable(cyNetwork, tableType, namespace);
            HashSet<ColumnDescriptor> subSet = new HashSet<ColumnDescriptor>();
            for (CyColumn col : table.getColumns()) {
                if (!this.isMappableColumn(col)) continue;
                subSet.add(new ColumnDescriptor(col.getName(), col.getType()));
            }
            if (colDescSet == null) {
                colDescSet = subSet;
                continue;
            }
            colDescSet.retainAll(subSet);
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        if (colDescSet != null) {
            for (ColumnDescriptor cd : colDescSet) {
                columnNames.add(cd.name);
            }
            this.sort(columnNames);
        }
        if ((listSingleSelection = new ListSingleSelection(columnNames)).getPossibleValues().contains("shared name")) {
            listSingleSelection.setSelectedValue((Object)"shared name");
        }
        return listSingleSelection;
    }

    private boolean isMappableColumn(CyColumn col) {
        String name = col.getName();
        Class type = col.getType();
        return (type == Integer.class || type == Long.class || type == String.class) && !name.equals("SUID") && !name.endsWith(".SUID");
    }

    private void mapTableToLocalAttrs(TableType tableType, Collection<? extends CyNetwork> networks) {
        for (CyNetwork cyNetwork : networks) {
            CyTable targetTable = this.getTable(cyNetwork, tableType, "LOCAL_ATTRS");
            if (targetTable == null) continue;
            this.mappedTables.add(targetTable);
            this.applyMapping(targetTable, this.caseSensitiveNetworkKeys);
        }
    }

    private void mapTableToDefaultAttrs(TableType tableType) {
        CyTable targetTable = this.getTable((CyNetwork)this.name2RootMap.get(this.targetNetworkCollection.getSelectedValue()), tableType, "SHARED_DEFAULT_ATTRS");
        if (targetTable != null) {
            this.applyMapping(targetTable, this.caseSensitiveNetworkCollectionKeys);
            this.mappedTables.add(targetTable);
        }
    }

    private CyTable getTable(CyNetwork network, TableType tableType, String namespace) {
        if (tableType == TableType.NODE_ATTR) {
            return network.getTable(CyNode.class, namespace);
        }
        if (tableType == TableType.EDGE_ATTR) {
            return network.getTable(CyEdge.class, namespace);
        }
        if (tableType == TableType.NETWORK_ATTR) {
            return network.getTable(CyNetwork.class, namespace);
        }
        logger.warn("The selected table type is not valid. \nTable needs to be one of these types: " + TableType.NODE_ATTR + ", " + TableType.EDGE_ATTR + ", " + TableType.NETWORK_ATTR + ".");
        return null;
    }

    private void applyMapping(CyTable targetTable, boolean caseSensitive) {
        ArrayList<CyColumn> columns = new ArrayList<CyColumn>();
        if (this.byReader) {
            if (this.reader.getTables() != null && this.reader.getTables().length > 0) {
                for (CyTable sourceTable : this.reader.getTables()) {
                    columns.addAll(sourceTable.getColumns());
                    this.copyColumns(sourceTable, columns, targetTable, false);
                    this.copyRows(sourceTable, columns, targetTable, caseSensitive);
                }
            }
        } else if (this.globalTable != null) {
            columns.addAll(this.globalTable.getColumns());
            this.copyColumns(this.globalTable, columns, targetTable, true);
        }
    }

    private CyColumn getJoinTargetColumn(CyTable targetTable) {
        String joinKeyName = "name";
        if (((String)this.getWhereImportTable().getSelectedValue()).matches(NETWORK_COLLECTION)) {
            joinKeyName = (String)this.keyColumnForMapping.getSelectedValue();
        } else if (((String)this.getWhereImportTable().getSelectedValue()).matches(NETWORK_SELECTION)) {
            joinKeyName = (String)this.keyColumnForMappingNetworkList.getSelectedValue();
        }
        return targetTable.getColumn(joinKeyName);
    }

    private void copyRows(CyTable sourceTable, List<CyColumn> sourceColumns, CyTable targetTable, boolean caseSensitive) {
        CyColumn pk;
        CyColumn targetKeyColumn = this.getJoinTargetColumn(targetTable);
        HashMap<String, String> normalizedSourceKeys = new HashMap<String, String>();
        if (!caseSensitive && (pk = sourceTable.getPrimaryKey()).getType() == String.class) {
            for (CyRow row : sourceTable.getAllRows()) {
                String key = (String)row.get(pk.getName(), String.class);
                if (key == null) continue;
                normalizedSourceKeys.put(key.toLowerCase().trim(), key);
            }
        }
        for (CyRow targetRow : targetTable.getAllRows()) {
            Object key = targetRow.get(targetKeyColumn.getName(), targetKeyColumn.getType());
            if (key == null) continue;
            if (!caseSensitive) {
                key = normalizedSourceKeys.get(key.toString().toLowerCase().trim());
            }
            if (key == null) continue;
            if (key.getClass() != sourceTable.getPrimaryKey().getType()) {
                try {
                    key = DataUtils.convertString(key.toString(), sourceTable.getPrimaryKey().getType());
                }
                catch (Exception e) {
                    continue;
                }
            }
            if (key == null || !sourceTable.rowExists(key)) continue;
            CyRow sourceRow = sourceTable.getRow(key);
            for (CyColumn col : sourceColumns) {
                String targetColName;
                if (col == sourceTable.getPrimaryKey() || (targetColName = this.source2targetColumnMap.get(col.getName())) == null || targetTable.getColumn(targetColName) == null) continue;
                targetRow.set(targetColName, sourceRow.getRaw(col.getName()));
            }
        }
    }

    private void copyColumns(CyTable sourceTable, List<CyColumn> sourceColumns, CyTable targetTable, boolean addVirtual) {
        CyRootNetwork rootNet = this.name2RootMap.get(this.targetNetworkCollection.getSelectedValue());
        Set columnNames = rootNet != null ? this.getAllColumnNames(rootNet) : Collections.emptySet();
        for (CyColumn col : sourceColumns) {
            boolean exists;
            if (col == sourceTable.getPrimaryKey()) continue;
            String name = col.getName();
            boolean bl = exists = targetTable.getColumn(name) != null;
            if (!exists) {
                exists = columnNames.contains(name.toLowerCase());
            }
            if (!exists) {
                if (!addVirtual) {
                    if (col.getType() == List.class) {
                        targetTable.createListColumn(name, col.getListElementType(), col.isImmutable());
                    } else {
                        targetTable.createColumn(name, col.getType(), col.isImmutable(), col.getDefaultValue());
                    }
                } else {
                    targetTable.addVirtualColumn(name, col.getName(), sourceTable, this.getJoinTargetColumn(targetTable).getName(), false);
                }
            } else {
                CyColumn targetCol = targetTable.getColumn(name);
                if (targetCol != null && targetCol.getType() != col.getType() || col.getType() == List.class && targetCol.getListElementType() != col.getListElementType()) {
                    logger.error("Column '" + name + "' has a different type in the target table -- skipping column");
                    continue;
                }
            }
            this.source2targetColumnMap.put(col.getName(), name);
        }
    }

    private Set<String> getAllColumnNames(CyRootNetwork rootNet) {
        ArrayList<CyTable> tables = new ArrayList<CyTable>();
        Class<? extends CyIdentifiable> type = ((TableType)((Object)this.getDataTypeTargetForNetworkCollection().getSelectedValue())).type;
        CyNetworkTableManager netTableMgr = (CyNetworkTableManager)this.serviceRegistrar.getService(CyNetworkTableManager.class);
        CyTable rootTbl = netTableMgr.getTable((CyNetwork)rootNet, type, "LOCAL_ATTRS");
        if (rootTbl != null) {
            tables.add(rootTbl);
        }
        for (CyNetwork sub : rootNet.getSubNetworkList()) {
            CyTable netTbl = netTableMgr.getTable(sub, type, "LOCAL_ATTRS");
            if (netTbl == null) continue;
            tables.add(netTbl);
        }
        HashSet<String> set = new HashSet<String>();
        for (CyTable table : tables) {
            Collection columns = table.getColumns();
            for (CyColumn col : columns) {
                set.add(col.getName().toLowerCase());
            }
        }
        return set;
    }

    private void addTable() {
        CyTableManager tableMgr = (CyTableManager)this.serviceRegistrar.getService(CyTableManager.class);
        if (this.byReader) {
            if (this.reader != null && this.reader.getTables() != null) {
                for (CyTable table : this.reader.getTables()) {
                    if (this.newTableName != null && !this.newTableName.isEmpty()) {
                        table.setTitle(this.newTableName);
                    }
                    tableMgr.addTable(table);
                }
            } else if (this.reader == null) {
                logger.warn("reader is null.");
            } else {
                logger.warn("No tables in reader.");
            }
        } else {
            if (tableMgr.getTable(this.globalTable.getSUID().longValue()) != null) {
                tableMgr.deleteTable(this.globalTable.getSUID().longValue());
                this.globalTable.setPublic(true);
            }
            if (this.newTableName != null && !this.newTableName.isEmpty()) {
                this.globalTable.setTitle(this.newTableName);
            }
            tableMgr.addTable(this.globalTable);
            this.mappedTables.add(this.globalTable);
        }
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(List.class, String.class, JSONResult.class);
    }

    public Object getResults(Class requestedType) {
        if (requestedType.equals(List.class)) {
            return this.mappedTables;
        }
        if (requestedType.equals(String.class)) {
            Object str = "Mapped to tables:\n";
            for (CyTable table : this.mappedTables) {
                str = (String)str + "   " + table.toString() + "\n";
            }
            return str;
        }
        if (requestedType.equals(JSONResult.class)) {
            CyJSONUtil cyJSONUtil = (CyJSONUtil)this.serviceRegistrar.getService(CyJSONUtil.class);
            JSONResult res = () -> {
                if (this.mappedTables.isEmpty()) {
                    return "{}";
                }
                return "{\"mappedTables\":" + cyJSONUtil.cyIdentifiablesToJson(this.mappedTables) + "}";
            };
            return res;
        }
        return null;
    }

    private TableType getDataTypeOptions() {
        if (((String)this.getWhereImportTable().getSelectedValue()).matches(NETWORK_COLLECTION)) {
            if (this.dataTypeTargetForNetworkCollection != null) {
                return (TableType)((Object)this.dataTypeTargetForNetworkCollection.getSelectedValue());
            }
            return null;
        }
        if (this.dataTypeTargetForNetworkList != null) {
            return (TableType)((Object)this.dataTypeTargetForNetworkList.getSelectedValue());
        }
        return null;
    }

    private boolean isKeyMandatory() {
        return !((String)this.getWhereImportTable().getSelectedValue()).matches(UNASSIGNED_TABLE);
    }

    public boolean checkKeys() {
        ArrayList<CyColumn> joinTargetColumns = new ArrayList<CyColumn>();
        if (((String)this.getWhereImportTable().getSelectedValue()).matches(NETWORK_COLLECTION)) {
            joinTargetColumns.add(this.getJoinTargetColumn(this.getTable((CyNetwork)this.name2RootMap.get(this.targetNetworkCollection.getSelectedValue()), this.getDataTypeOptions(), "USER")));
        } else if (((String)this.getWhereImportTable().getSelectedValue()).matches(NETWORK_SELECTION)) {
            for (String targetNetwork : this.targetNetworkList.getSelectedValues()) {
                joinTargetColumns.add(this.getJoinTargetColumn(this.getTable(this.name2NetworkMap.get(targetNetwork), this.getDataTypeOptions(), "USER")));
            }
        }
        if (this.byReader) {
            if (this.tableImportContext.isKeyRequired()) {
                for (CyTable readerTable : this.reader.getTables()) {
                    if (this.isMappableColumn(readerTable.getPrimaryKey())) continue;
                    return false;
                }
            }
            for (CyColumn joinTargetColumn : joinTargetColumns) {
                if (this.isMappableColumn(joinTargetColumn)) continue;
                return false;
            }
        } else {
            if (this.tableImportContext.isKeyRequired() && !this.isMappableColumn(this.globalTable.getPrimaryKey())) {
                return false;
            }
            for (CyColumn joinTargetColumn : joinTargetColumns) {
                if (joinTargetColumn.getType() == this.globalTable.getPrimaryKey().getType()) continue;
                return false;
            }
        }
        return true;
    }

    public TunableValidator.ValidationState getValidationState(Appendable errMsg) {
        if (((String)this.getWhereImportTable().getSelectedValue()).matches(NETWORK_SELECTION) && this.targetNetworkList.getSelectedValues().isEmpty()) {
            try {
                errMsg.append("Please select at least one network.");
                return TunableValidator.ValidationState.INVALID;
            }
            catch (IOException e) {
                e.printStackTrace();
                return TunableValidator.ValidationState.INVALID;
            }
        }
        if (!((String)this.getWhereImportTable().getSelectedValue()).matches(UNASSIGNED_TABLE) || this.newTableName == null || this.newTableName.isEmpty()) {
            return TunableValidator.ValidationState.OK;
        }
        CyTableManager tableMgr = (CyTableManager)this.serviceRegistrar.getService(CyTableManager.class);
        for (CyTable table : tableMgr.getGlobalTables()) {
            try {
                if (!table.getTitle().matches(this.newTableName)) continue;
                errMsg.append("There already exists a table with name: " + this.newTableName + ". Please select another table name.\n");
                return TunableValidator.ValidationState.INVALID;
            }
            catch (IOException e) {
                e.printStackTrace();
                return TunableValidator.ValidationState.INVALID;
            }
        }
        return TunableValidator.ValidationState.OK;
    }

    private void sort(List<String> names) {
        final Collator collator = Collator.getInstance(Locale.getDefault());
        Collections.sort(names, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                if (s1 == null || s2 == null) {
                    if (s2 != null) {
                        return -1;
                    }
                    if (s1 != null) {
                        return 1;
                    }
                    return 0;
                }
                return collator.compare(s1, s2);
            }
        });
    }

    private static class ColumnDescriptor {
        private final String name;
        private final Class<?> type;

        ColumnDescriptor(String name, Class<?> type) {
            this.name = name;
            this.type = type;
        }

        public int hashCode() {
            int prime = 31;
            int result = 7;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.type == null || this.type.getCanonicalName() == null ? 0 : this.type.getCanonicalName().hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ColumnDescriptor)) {
                return false;
            }
            ColumnDescriptor other = (ColumnDescriptor)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.type == null ? other.type != null : this.type != other.type);
        }
    }

    static enum TableType {
        NODE_ATTR("Node Table Columns", CyNode.class),
        EDGE_ATTR("Edge Table Columns", CyEdge.class),
        NETWORK_ATTR("Network Table Columns", CyNetwork.class);

        private final String name;
        private final Class<? extends CyIdentifiable> type;

        private TableType(String name, Class<? extends CyIdentifiable> type) {
            this.name = name;
            this.type = type;
        }

        public Class<? extends CyIdentifiable> getType() {
            return this.type;
        }

        public String toString() {
            return this.name;
        }

        public static TableType fromType(Class<? extends CyIdentifiable> type) {
            if (type == CyNode.class) {
                return NODE_ATTR;
            }
            if (type == CyEdge.class) {
                return EDGE_ATTR;
            }
            if (type == CyNetwork.class) {
                return NETWORK_ATTR;
            }
            return null;
        }
    }
}

