/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.task;

import org.cytoscape.io.read.CyTableReader;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.tableimport.internal.task.ImportTableDataTask;
import org.cytoscape.tableimport.internal.task.TableImportContext;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.TunableValidator;

public class CombineTableReaderAndMappingTask
extends AbstractTask
implements TunableValidator {
    @ContainsTunables
    public ImportTableDataTask importTableDataTask;
    @ContainsTunables
    public CyTableReader tableReader;

    @ProvidesTitle
    public String getTitle() {
        return "Import Columns From Table";
    }

    public CombineTableReaderAndMappingTask(CyTableReader tableReader, TableImportContext tableImportContext, CyServiceRegistrar serviceRegistrar) {
        this.tableReader = tableReader;
        this.importTableDataTask = new ImportTableDataTask(tableReader, tableImportContext, serviceRegistrar);
    }

    public TunableValidator.ValidationState getValidationState(Appendable errMsg) {
        TunableValidator.ValidationState readVS;
        if (this.tableReader instanceof TunableValidator && (readVS = ((TunableValidator)this.tableReader).getValidationState(errMsg)) != TunableValidator.ValidationState.OK) {
            return readVS;
        }
        if (this.importTableDataTask instanceof TunableValidator && (readVS = this.importTableDataTask.getValidationState(errMsg)) != TunableValidator.ValidationState.OK) {
            return readVS;
        }
        return TunableValidator.ValidationState.OK;
    }

    public void run(TaskMonitor tm) throws Exception {
        this.tableReader.run(tm);
        this.importTableDataTask.run(tm);
    }
}

