/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.task;

import java.io.InputStream;
import java.util.Collections;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.NetworkViewRenderer;
import org.cytoscape.io.read.AbstractCyNetworkReader;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.tableimport.internal.task.ImportNetworkTableReaderTask;
import org.cytoscape.tableimport.internal.task.NetworkCollectionHelper;
import org.cytoscape.tableimport.internal.util.ImportType;
import org.cytoscape.view.layout.CyLayoutAlgorithm;
import org.cytoscape.view.layout.CyLayoutAlgorithmManager;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.TunableValidator;
import org.cytoscape.work.util.ListSingleSelection;

public class CombineNetworkReaderAndMappingTask
extends AbstractCyNetworkReader
implements TunableValidator {
    @ContainsTunables
    public ImportNetworkTableReaderTask importTask;
    private final NetworkCollectionHelper collectionHelper;
    private TaskMonitor taskMonitor;
    private final CyServiceRegistrar serviceRegistrar;

    @ProvidesTitle
    public String getTitle() {
        return ImportType.NETWORK_IMPORT.getTitle();
    }

    public CombineNetworkReaderAndMappingTask(InputStream is, String fileType, String inputName, CyServiceRegistrar serviceRegistrar) {
        super(is, (CyApplicationManager)serviceRegistrar.getService(CyApplicationManager.class), (CyNetworkFactory)serviceRegistrar.getService(CyNetworkFactory.class), (CyNetworkManager)serviceRegistrar.getService(CyNetworkManager.class), (CyRootNetworkManager)serviceRegistrar.getService(CyRootNetworkManager.class));
        this.serviceRegistrar = serviceRegistrar;
        this.importTask = new ImportNetworkTableReaderTask(is, fileType, inputName, serviceRegistrar);
        this.collectionHelper = new NetworkCollectionHelper(serviceRegistrar);
    }

    public TunableValidator.ValidationState getValidationState(Appendable errMsg) {
        TunableValidator.ValidationState readVS;
        if (this.importTask instanceof TunableValidator && (readVS = this.importTask.getValidationState(errMsg)) != TunableValidator.ValidationState.OK) {
            return readVS;
        }
        return TunableValidator.ValidationState.OK;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        ListSingleSelection ls;
        this.taskMonitor = taskMonitor;
        String rootNetName = (String)this.getRootNetworkList().getSelectedValue();
        String targetColumn = (String)this.getTargetColumnList().getSelectedValue();
        NetworkViewRenderer renderer = (NetworkViewRenderer)this.getNetworkViewRendererList().getSelectedValue();
        if (rootNetName != null) {
            ls = new ListSingleSelection(Collections.singletonList(rootNetName));
            ls.setSelectedValue((Object)rootNetName);
            this.collectionHelper.setRootNetworkList((ListSingleSelection<String>)ls);
        } else {
            this.collectionHelper.setRootNetworkList((ListSingleSelection<String>)new ListSingleSelection(Collections.emptyList()));
            this.collectionHelper.setTargetColumnList((ListSingleSelection<String>)new ListSingleSelection(Collections.emptyList()));
        }
        if (targetColumn != null) {
            ls = new ListSingleSelection(Collections.singletonList(targetColumn));
            ls.setSelectedValue((Object)targetColumn);
            this.collectionHelper.setTargetColumnList((ListSingleSelection<String>)ls);
        }
        if (renderer != null) {
            ls = new ListSingleSelection(Collections.singletonList(renderer));
            ls.setSelectedValue((Object)renderer);
            this.collectionHelper.setNetworkViewRendererList((ListSingleSelection<NetworkViewRenderer>)ls);
        }
        this.collectionHelper.run(taskMonitor);
        this.importTask.setNodeMap(this.collectionHelper.getNodeMap());
        this.importTask.setRootNetwork(this.collectionHelper.getRootNetwork());
        this.importTask.setNetworkViewFactory(this.collectionHelper.getNetworkViewFactory());
        this.importTask.run(taskMonitor);
    }

    public CyNetworkView buildCyNetworkView(CyNetwork network) {
        CyNetworkView view = this.collectionHelper.getNetworkViewFactory().createNetworkView(network);
        CyLayoutAlgorithmManager layoutMgr = (CyLayoutAlgorithmManager)this.serviceRegistrar.getService(CyLayoutAlgorithmManager.class);
        CyLayoutAlgorithm layout = layoutMgr.getDefaultLayout();
        String attribute = layoutMgr.getLayoutAttribute(layout, view);
        TaskIterator itr = layout.createTaskIterator(view, layout.getDefaultLayoutContext(), CyLayoutAlgorithm.ALL_NODE_VIEWS, attribute);
        Task nextTask = itr.next();
        try {
            nextTask.run(this.taskMonitor);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not finish layout", e);
        }
        this.taskMonitor.setProgress(1.0);
        return view;
    }

    public CyNetwork[] getNetworks() {
        return this.importTask.getNetworks();
    }
}

