/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.task;

import org.cytoscape.io.read.CyTableReader;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AddImportedTableTask
extends AbstractTask {
    private static Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private final CyTableReader reader;
    private final CyServiceRegistrar serviceRegistrar;

    AddImportedTableTask(CyTableReader reader, CyServiceRegistrar serviceRegistrar) {
        this.reader = reader;
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) throws Exception {
        if (this.reader != null && this.reader.getTables() != null) {
            CyTableManager tableMgr = (CyTableManager)this.serviceRegistrar.getService(CyTableManager.class);
            for (CyTable table : this.reader.getTables()) {
                tableMgr.addTable(table);
            }
        } else if (this.reader == null) {
            logger.warn("reader is null.");
        } else {
            logger.warn("No tables in reader.");
        }
    }
}

