/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.reader.ontology;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.io.read.CyNetworkReader;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.tableimport.internal.reader.ontology.OBOTags;
import org.cytoscape.tableimport.internal.util.OntologyDAGManager;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OBOReader
extends AbstractTask
implements CyNetworkReader {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    public static final String DAG_ATTR = "Ontology DAG";
    protected static final String TERM_NAME = "term name";
    public static final String OBO_PREFIX = "obo.";
    private static final String DEF_ORIGIN = "def_origin";
    protected static final String TERM_TAG = "[Term]";
    private List<String[]> interactionList;
    private CyNetwork ontologyDAG;
    private CyNetwork[] networks;
    private Map<String, String> header;
    private final InputStream inputStream;
    private final Map<String, CyNode> termID2nodeMap;
    private final String dagName;
    private final CyServiceRegistrar serviceRegistrar;

    public OBOReader(String dagName, InputStream oboStream, CyServiceRegistrar serviceRegistrar) {
        this.inputStream = oboStream;
        this.dagName = dagName;
        this.serviceRegistrar = serviceRegistrar;
        this.termID2nodeMap = new HashMap<String, CyNode>();
        this.networks = new CyNetwork[1];
        this.interactionList = new ArrayList<String[]>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor tm) throws Exception {
        BufferedReader bufRd = new BufferedReader(new InputStreamReader(this.inputStream, Charset.forName("UTF-8").newDecoder()));
        this.ontologyDAG = ((CyNetworkFactory)this.serviceRegistrar.getService(CyNetworkFactory.class)).createNetwork();
        try {
            String line;
            this.header = new HashMap<String, String>();
            while ((line = bufRd.readLine()) != null && !line.startsWith(TERM_TAG)) {
                if (line.startsWith("!") || line.trim().length() == 0) continue;
                this.parseHeader(line);
            }
            this.mapHeader();
            this.readEntry(bufRd);
        }
        finally {
            bufRd.close();
            this.inputStream.close();
        }
        this.buildEdge();
        this.networks[0] = this.ontologyDAG;
        OntologyDAGManager.addOntologyDAG(this.dagName, this.ontologyDAG);
        logger.debug("Number of terms loaded = " + this.termID2nodeMap.size());
        this.termID2nodeMap.clear();
    }

    private void parseHeader(String line) {
        int colonInx = line.indexOf(58);
        if (colonInx == -1) {
            return;
        }
        String key = line.substring(0, colonInx).trim();
        String val = line.substring(colonInx + 1).trim();
        this.header.put(key, val);
    }

    private void mapHeader() {
        CyTable networkTable = this.ontologyDAG.getDefaultNetworkTable();
        for (String tag : this.header.keySet()) {
            if (networkTable.getColumn(tag) == null) {
                networkTable.createColumn(tag, String.class, false);
            }
            networkTable.getRow((Object)this.ontologyDAG.getSUID()).set(tag, (Object)this.header.get(tag));
        }
        if (networkTable.getColumn(DAG_ATTR) == null) {
            networkTable.createColumn(DAG_ATTR, Boolean.class, true);
        }
        networkTable.getRow((Object)this.ontologyDAG.getSUID()).set(DAG_ATTR, (Object)true);
        this.ontologyDAG.getRow((CyIdentifiable)this.ontologyDAG).set("name", (Object)this.dagName);
    }

    private void readEntry(BufferedReader rd) throws IOException {
        String id = "";
        String line = null;
        CyNode termNode = null;
        boolean termSection = true;
        while ((line = rd.readLine()) != null) {
            int colonInx;
            if ((line = line.trim()).length() == 0 || line.startsWith("!")) continue;
            if (line.startsWith("[")) {
                if (!line.startsWith(TERM_TAG)) {
                    termSection = false;
                    continue;
                }
                termSection = true;
            }
            if (!termSection || (colonInx = line.indexOf(58)) == -1) continue;
            String key = line.substring(0, colonInx).trim();
            String val = line.substring(colonInx + 1).trim();
            if (key.equals(OBOTags.ID.toString())) {
                termNode = this.termID2nodeMap.get(val);
                if (termNode != null) continue;
                termNode = this.ontologyDAG.addNode();
                this.ontologyDAG.getRow((CyIdentifiable)termNode).set("name", (Object)val);
                this.termID2nodeMap.put(val, termNode);
                id = val;
                continue;
            }
            if (key.equals(OBOTags.NAME.toString())) {
                if (this.ontologyDAG.getRow((CyIdentifiable)termNode).getTable().getColumn(TERM_NAME) == null) {
                    this.ontologyDAG.getRow((CyIdentifiable)termNode).getTable().createColumn(TERM_NAME, String.class, true);
                }
                this.ontologyDAG.getRow((CyIdentifiable)termNode).set(TERM_NAME, (Object)val);
                continue;
            }
            if (key.equals(OBOTags.DEF.toString())) {
                String[] definitionParts = val.split("\"");
                if (this.ontologyDAG.getRow((CyIdentifiable)termNode).getTable().getColumn(key) == null) {
                    this.ontologyDAG.getRow((CyIdentifiable)termNode).getTable().createColumn(key, String.class, true);
                }
                this.ontologyDAG.getRow((CyIdentifiable)termNode).set(key, (Object)definitionParts[1]);
                List<String> originList = this.getReferences(val.substring(definitionParts[1].length() + 2));
                if (originList == null) continue;
                if (this.ontologyDAG.getRow((CyIdentifiable)termNode).getTable().getColumn(DEF_ORIGIN) == null) {
                    this.ontologyDAG.getRow((CyIdentifiable)termNode).getTable().createListColumn(DEF_ORIGIN, String.class, true);
                }
                this.ontologyDAG.getRow((CyIdentifiable)termNode).set(DEF_ORIGIN, originList);
                continue;
            }
            if (key.equals(OBOTags.EXACT_SYNONYM.toString()) || key.equals(OBOTags.RELATED_SYNONYM.toString()) || key.equals(OBOTags.BROAD_SYNONYM.toString()) || key.equals(OBOTags.NARROW_SYNONYM.toString()) || key.equals(OBOTags.SYNONYM.toString())) {
                ArrayList<String> listAttr;
                String[] synonymParts = val.split("\"");
                if (this.ontologyDAG.getRow((CyIdentifiable)termNode).getTable().getColumn(key) == null) {
                    this.ontologyDAG.getRow((CyIdentifiable)termNode).getTable().createListColumn(key, String.class, true);
                }
                if ((listAttr = this.ontologyDAG.getRow((CyIdentifiable)termNode).getList(key, String.class)) == null) {
                    listAttr = new ArrayList<String>();
                }
                listAttr.add(synonymParts[1]);
                this.ontologyDAG.getRow((CyIdentifiable)termNode).set(key, listAttr);
                continue;
            }
            if (key.equals(OBOTags.RELATIONSHIP.toString())) {
                String[] entry = val.split(" ");
                String[] itr = new String[]{id, entry[1], entry[0]};
                this.interactionList.add(itr);
                continue;
            }
            if (key.equals(OBOTags.IS_A.toString())) {
                int colonidx = val.indexOf(33);
                String targetId = colonidx == -1 ? val.trim() : val.substring(0, colonidx).trim();
                String[] itr = new String[]{id, targetId, "is_a"};
                this.interactionList.add(itr);
                continue;
            }
            if (key.equals(OBOTags.IS_OBSOLETE.toString())) {
                if (this.ontologyDAG.getRow((CyIdentifiable)termNode).getTable().getColumn(key) == null) {
                    this.ontologyDAG.getRow((CyIdentifiable)termNode).getTable().createColumn(key, Boolean.class, true);
                }
                try {
                    this.ontologyDAG.getRow((CyIdentifiable)termNode).set(key, (Object)Boolean.parseBoolean(val));
                }
                catch (Exception e) {}
                continue;
            }
            if (key.equals(OBOTags.XREF.toString()) || key.equals(OBOTags.XREF_ANALOG.toString()) || key.equals(OBOTags.ALT_ID.toString()) || key.equals(OBOTags.SUBSET.toString()) || key.equals(OBOTags.DISJOINT_FROM.toString())) {
                ArrayList<String> listAttr;
                if (this.ontologyDAG.getRow((CyIdentifiable)termNode).getTable().getColumn(key) == null) {
                    this.ontologyDAG.getRow((CyIdentifiable)termNode).getTable().createListColumn(key, String.class, true);
                }
                if ((listAttr = this.ontologyDAG.getRow((CyIdentifiable)termNode).getList(key, String.class)) == null) {
                    listAttr = new ArrayList<String>();
                }
                if (val != null) {
                    if (key.equals(OBOTags.DISJOINT_FROM.toString())) {
                        listAttr.add(val.split("!")[0].trim());
                    } else {
                        listAttr.add(val);
                    }
                }
                this.ontologyDAG.getRow((CyIdentifiable)termNode).set(key, listAttr);
                continue;
            }
            if (this.ontologyDAG.getRow((CyIdentifiable)termNode).getTable().getColumn(key) == null) {
                this.ontologyDAG.getRow((CyIdentifiable)termNode).getTable().createColumn(key, String.class, true);
            }
            this.ontologyDAG.getRow((CyIdentifiable)termNode).set(key, (Object)val);
        }
    }

    private void buildEdge() {
        for (String[] entry : this.interactionList) {
            CyEdge edge = this.ontologyDAG.addEdge(this.termID2nodeMap.get(entry[0]), this.termID2nodeMap.get(entry[1]), true);
            this.ontologyDAG.getRow((CyIdentifiable)edge).set("interaction", (Object)entry[2]);
        }
        this.interactionList.clear();
    }

    private List<String> getReferences(String list) {
        String trimed = list.trim();
        if ((trimed = trimed.substring(trimed.indexOf("[") + 1, trimed.indexOf("]"))).length() == 0) {
            return null;
        }
        ArrayList<String> entries = new ArrayList<String>();
        for (String entry : trimed.split(",")) {
            entries.add(entry.trim());
        }
        return entries;
    }

    public CyNetworkView buildCyNetworkView(CyNetwork net) {
        CyNetworkViewFactory netViewFactory = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getDefaultNetworkViewRenderer().getNetworkViewFactory();
        CyNetworkView view = netViewFactory.createNetworkView(this.ontologyDAG);
        return view;
    }

    public CyNetwork[] getNetworks() {
        return this.networks;
    }
}

