/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.reader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.SUIDFactory;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.tableimport.internal.reader.AbstractLineParser;
import org.cytoscape.tableimport.internal.reader.AbstractMappingParameters;
import org.cytoscape.tableimport.internal.reader.AttributeMappingParameters;
import org.cytoscape.tableimport.internal.util.AttributeDataType;
import org.cytoscape.tableimport.internal.util.SourceColumnSemantic;

public class AttributeLineParser
extends AbstractLineParser {
    private final AttributeMappingParameters mapping;
    private final Map<String, Object> invalid = new HashMap<String, Object>();

    public AttributeLineParser(AttributeMappingParameters mapping, CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
        this.mapping = mapping;
    }

    public void parseAll(CyTable table, String[] parts) {
        Object primaryKey;
        int partsLen = parts.length;
        int keyIndex = this.mapping.getKeyIndex();
        if (keyIndex >= 0) {
            if (keyIndex < partsLen) {
                AttributeDataType typeKey = this.mapping.getDataTypes()[keyIndex];
                String part = "";
                if (parts[keyIndex] != null) {
                    part = parts[keyIndex].trim();
                }
                switch (typeKey) {
                    case TYPE_BOOLEAN: {
                        primaryKey = Boolean.valueOf(part);
                        break;
                    }
                    case TYPE_INTEGER: {
                        primaryKey = Integer.valueOf(part);
                        break;
                    }
                    case TYPE_LONG: {
                        primaryKey = Long.valueOf(part);
                        break;
                    }
                    case TYPE_FLOATING: {
                        primaryKey = Double.valueOf(part);
                        break;
                    }
                    default: {
                        primaryKey = part;
                        break;
                    }
                }
            } else {
                primaryKey = null;
            }
        } else {
            if (!table.getPrimaryKey().getName().equals("SUID")) {
                throw new RuntimeException("When not importing a primary key columnm, the primary key must be the default 'SUID'");
            }
            if (table.getPrimaryKey().getType() != Long.class) {
                throw new RuntimeException("The type of the primary key column 'SUID' must be Long");
            }
            primaryKey = SUIDFactory.getNextSUID();
        }
        if (primaryKey != null) {
            if (keyIndex >= 0 && partsLen == 1) {
                table.getRow((Object)parts[0]);
            } else {
                SourceColumnSemantic[] types = this.mapping.getTypes();
                for (int i = 0; i < partsLen; ++i) {
                    if (i == keyIndex || types[i] == SourceColumnSemantic.NONE || parts[i] == null) continue;
                    this.mapAttribute(table, primaryKey, parts[i].trim(), i);
                }
            }
        }
    }

    private void mapAttribute(CyTable table, Object key, String entry, int index) {
        AttributeDataType type = this.mapping.getDataTypes()[index];
        try {
            if (type.isList()) {
                String delimiter;
                String[] delimiters = this.mapping.getListDelimiters();
                String string = delimiter = delimiters != null && delimiters.length > index ? delimiters[index] : AbstractMappingParameters.DEF_LIST_DELIMITER;
                if (delimiter == null || delimiter.isEmpty()) {
                    delimiter = AbstractMappingParameters.DEF_LIST_DELIMITER;
                }
                Object value = this.parse(entry, type, delimiter, this.mapping.getDecimalSeparator());
                this.setListAttribute(table, type, key, this.mapping.getAttributeNames()[index], value);
            } else {
                this.setAttribute(table, type, key, this.mapping.getAttributeNames()[index], entry);
            }
        }
        catch (Exception e) {
            this.invalid.put(key.toString(), entry);
        }
    }

    private void setAttribute(CyTable tbl, AttributeDataType type, Object key, String attrName, String attrValue) {
        if (tbl.getColumn(attrName) == null) {
            tbl.createColumn(attrName, type.getType(), false);
        }
        Object value = this.parse(attrValue, type, null, this.mapping.getDecimalSeparator());
        CyRow row = tbl.getRow(key);
        row.set(attrName, value);
    }

    private void setListAttribute(CyTable tbl, AttributeDataType type, Object key, String attributeName, Object value) {
        if (tbl.getColumn(attributeName) == null) {
            tbl.createListColumn(attributeName, type.getListType(), false);
        }
        CyRow row = tbl.getRow(key);
        if (value instanceof List) {
            ArrayList curList = row.getList(attributeName, type.getListType());
            if (curList == null) {
                curList = new ArrayList();
            }
            curList.addAll(value);
            value = curList;
        }
        row.set(attributeName, (Object)value);
    }

    protected Map<String, Object> getInvalidMap() {
        return this.invalid;
    }
}

