/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.reader;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.cytoscape.tableimport.internal.reader.MappingParameter;
import org.cytoscape.tableimport.internal.reader.TextDelimiter;
import org.cytoscape.tableimport.internal.util.AttributeDataType;
import org.cytoscape.tableimport.internal.util.SourceColumnSemantic;
import org.cytoscape.tableimport.internal.util.TypeUtil;

public abstract class AbstractMappingParameters
implements MappingParameter {
    public static final String ID = "name";
    public static final String DEF_LIST_DELIMITER = TextDelimiter.PIPE.getDelimiter();
    private static final String DEF_DELIMITER = TextDelimiter.TAB.getDelimiter();
    public static final Character DEF_DECIMAL_SEPARATOR = Character.valueOf('.');
    private String name;
    protected String[] attributeNames;
    protected AttributeDataType[] dataTypes;
    protected SourceColumnSemantic[] types;
    protected String[] namespaces;
    protected List<String> delimiters;
    protected String[] listDelimiters;
    protected Character decimalSeparator;
    private Map<String, List<String>> attr2id;
    private Map<String, String> networkTitle2ID;
    private int startLineNumber;
    private String commentChar;
    public InputStream is;
    public String fileType;

    public AbstractMappingParameters(InputStream is, String fileType) {
        this.delimiters = new ArrayList<String>();
        this.delimiters.add(DEF_DELIMITER);
        this.is = is;
        this.fileType = fileType;
        this.decimalSeparator = DEF_DECIMAL_SEPARATOR;
    }

    public AbstractMappingParameters(String name, List<String> delimiters, String[] listDelimiters, String[] attrNames, AttributeDataType[] dataTypes, SourceColumnSemantic[] types, String[] namespaces, boolean caseSensitive) throws Exception {
        this(name, delimiters, listDelimiters, attrNames, dataTypes, types, namespaces, 0, null, DEF_DECIMAL_SEPARATOR);
    }

    public AbstractMappingParameters(String name, List<String> delimiters, String[] listDelimiters, String[] attrNames, AttributeDataType[] dataTypes, SourceColumnSemantic[] types, String[] namespaces, int startNumber, String commentChar, Character decimalSeparator) throws Exception {
        this.name = name;
        this.startLineNumber = startNumber;
        this.commentChar = commentChar;
        if (attrNames == null) {
            throw new Exception("attributeNames should not be null.");
        }
        this.decimalSeparator = decimalSeparator;
        if (this.decimalSeparator == null) {
            this.decimalSeparator = DEF_DECIMAL_SEPARATOR;
        }
        this.attributeNames = attrNames;
        if (delimiters == null) {
            this.delimiters = new ArrayList<String>();
            this.delimiters.add(DEF_DELIMITER);
        } else {
            this.delimiters = delimiters;
        }
        this.listDelimiters = listDelimiters;
        if (dataTypes == null) {
            this.dataTypes = new AttributeDataType[attrNames.length];
            Arrays.fill((Object[])this.dataTypes, (Object)AttributeDataType.TYPE_STRING);
        } else {
            this.dataTypes = dataTypes;
        }
        if (types == null) {
            this.types = new SourceColumnSemantic[attrNames.length];
            Arrays.fill((Object[])types, (Object)SourceColumnSemantic.NONE);
        } else {
            this.types = types;
        }
        this.namespaces = namespaces == null ? TypeUtil.getPreferredNamespaces(this.types) : namespaces;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String[] getAttributeNames() {
        return this.attributeNames;
    }

    @Override
    public AttributeDataType[] getDataTypes() {
        return this.dataTypes;
    }

    @Override
    public SourceColumnSemantic[] getTypes() {
        return this.types;
    }

    @Override
    public String[] getListDelimiters() {
        return this.listDelimiters;
    }

    public List<String> getDelimiters() {
        return this.delimiters;
    }

    @Override
    public String[] getNamespaces() {
        return this.namespaces;
    }

    public String getDelimiterRegEx() {
        StringBuffer delimiterBuffer = new StringBuffer();
        delimiterBuffer.append("[");
        for (String delimiter : this.delimiters) {
            if (delimiter.equals(" += +")) {
                return " += +";
            }
            delimiterBuffer.append(delimiter);
        }
        delimiterBuffer.append("]");
        return delimiterBuffer.toString();
    }

    public List<String> toID(String attributeValue) {
        return this.attr2id.get(attributeValue);
    }

    public Map<String, List<String>> getAttributeToIDMap() {
        return this.attr2id;
    }

    public Character getDecimalSeparator() {
        return this.decimalSeparator;
    }

    @Override
    public int getColumnCount() {
        if (this.attributeNames == null) {
            return -1;
        }
        return this.attributeNames.length;
    }

    public int getSelectedColumnCount() {
        if (this.attributeNames == null) {
            return -1;
        }
        int count = 0;
        for (SourceColumnSemantic t : this.types) {
            if (t == SourceColumnSemantic.NONE) continue;
            ++count;
        }
        return count;
    }

    protected Map<String, String> getnetworkTitleMap() {
        return this.networkTitle2ID;
    }

    public int getStartLineNumber() {
        return this.startLineNumber;
    }

    public String getCommentChar() {
        return this.commentChar;
    }
}

