/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.idmapper.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.idmapper.IdMapping;
import org.cytoscape.idmapper.MappingSource;
import org.cytoscape.idmapper.Species;
import org.cytoscape.idmapper.internal.BridgeDbIdMapper;
import org.cytoscape.idmapper.internal.MappingUtil;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractTableColumnTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;
import org.cytoscape.work.swing.RequestsUIHelper;
import org.cytoscape.work.swing.TunableUIHelper;
import org.cytoscape.work.undo.UndoSupport;
import org.cytoscape.work.util.ListChangeListener;
import org.cytoscape.work.util.ListSelection;
import org.cytoscape.work.util.ListSingleSelection;

public class ColumnMappingTask
extends AbstractTableColumnTask
implements RequestsUIHelper,
ListChangeListener<String>,
ObservableTask {
    public static final boolean VERBOSE = false;
    private static Species saveSpecies = Species.Human;
    private static MappingSource saveSource = MappingSource.Entrez;
    private static MappingSource saveTarget = MappingSource.Entrez;
    private final CyServiceRegistrar registrar;
    private TunableUIHelper helper;
    String windowTitle = "ID Mapping";
    @Tunable(description="Species", gravity=0.0, longDescription="The common or latin name of the species to which the identifiers apply", exampleStringValue="Homo Sapiens")
    public ListSingleSelection<String> speciesList = new ListSingleSelection(Species.fullNames());
    @Tunable(description="Map from", gravity=1.0, longDescription="Specifies the data source describing the existing identifiers", exampleStringValue="ENSEMBL")
    public ListSingleSelection<MappingSource> mapFrom = new ListSingleSelection((Object[])new MappingSource[0]);
    @Tunable(description="To", gravity=2.0, longDescription="Specifies the data source identifiers to be returned as a result in a new column", exampleStringValue="Entrez")
    public ListSingleSelection<MappingSource> mapTo = new ListSingleSelection((Object[])new MappingSource[0]);
    @Tunable(description="Force single ", gravity=3.0, longDescription="When multiple identifiers can be mapped from a single term, this forces a singular result", exampleStringValue="false")
    public boolean forceSingle = true;
    public String new_column_name = "";
    public String ERROR = "Can't map this column type as identifiers";

    public ColumnMappingTask(UndoSupport undoSupport, CyColumn column, CyServiceRegistrar reg) {
        super(column);
        this.registrar = reg;
        if (column.getType() == String.class) {
            Species.buildMaps();
            this.speciesList.setPossibleValues(Species.fullNames());
            this.speciesList.addListener((ListChangeListener)this);
            this.mapFrom.addListener((ListChangeListener)new MappingSourceListener(this));
            this.mapTo.addListener((ListChangeListener)new MappingSourceListener(this));
            this.resetSpecies();
            String species = this.readSpeciesFromNetworkTable();
            if (species != null) {
                this.speciesList.setSelectedValue((Object)species);
            }
        }
    }

    public void speciesSelectionChanged(ListSelection<String> source) {
        ListSingleSelection src;
        if (source instanceof ListSingleSelection && (src = (ListSingleSelection)source) == this.speciesList) {
            String selected = (String)this.speciesList.getSelectedValue();
            saveSpecies = Species.lookup(selected);
            this.resetSpecies();
        }
    }

    public void mappingSourceChanged(ListSelection<MappingSource> source) {
        if (source instanceof ListSingleSelection) {
            ListSingleSelection src = (ListSingleSelection)source;
            if (src == this.mapFrom) {
                this.resetSource();
            } else if (src != this.mapTo) {
                System.err.println("selectionChanged error: " + source.toString());
            }
        }
    }

    private void resetSpecies() {
        this.speciesList.setSelectedValue((Object)saveSpecies.fullname());
        this.guessSource();
    }

    private void guessSource() {
        List<MappingSource> sources = MappingSource.filteredStrings(saveSpecies, null);
        this.mapFrom.setPossibleValues(sources);
        if (this.helper != null) {
            this.helper.refresh((Object)this);
        }
        if (this.column != null) {
            List ids = this.column.getValues(String.class);
            saveSource = MappingSource.guessSource(saveSpecies, ids);
            if (sources.contains((Object)saveSource)) {
                this.mapFrom.setSelectedValue((Object)saveSource);
            }
            this.resetSource(sources);
        }
    }

    private void resetSource() {
        this.resetSource(this.mapFrom.getPossibleValues());
    }

    private void resetSource(List<MappingSource> sources) {
        saveSource = (MappingSource)((Object)this.mapFrom.getSelectedValue());
        this.resetTarget(saveSource);
    }

    private void resetTarget(MappingSource src) {
        List<MappingSource> targetList = MappingSource.filteredStrings(saveSpecies, src);
        saveTarget = (MappingSource)((Object)this.mapTo.getSelectedValue());
        this.mapTo.setPossibleValues(targetList);
        if (this.helper != null) {
            this.helper.refresh((Object)this);
        }
        if (saveTarget == null) {
            saveTarget = MappingSource.Ensembl;
        }
        if (!targetList.contains((Object)saveTarget) && !targetList.isEmpty()) {
            saveTarget = targetList.get(0);
        }
        if (targetList.contains((Object)saveTarget)) {
            this.mapTo.setSelectedValue((Object)saveTarget);
        }
    }

    @ProvidesTitle
    public String getTitle() {
        return this.windowTitle;
    }

    public void run(TaskMonitor taskMonitor) {
        Set<String> matched_ids;
        Map<String, IdMapping> res;
        String species = (String)this.speciesList.getSelectedValue();
        MappingSource rawTarget = (MappingSource)((Object)this.mapTo.getSelectedValue());
        MappingSource source = (MappingSource)((Object)this.mapFrom.getSelectedValue());
        if (this.column.getType() == Double.class || this.column.getType() == Integer.class || this.column.getType() == Boolean.class) {
            this.windowTitle = this.ERROR;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(null, ColumnMappingTask.this.ERROR, "ID Mapping Result", 2);
                }
            });
            return;
        }
        saveTarget = rawTarget;
        saveSpecies = Species.lookup(species);
        boolean source_is_list = false;
        if (this.column.getType() == List.class) {
            source_is_list = true;
        }
        this.storeSpeciesIntoNetworkTable();
        List values = this.column.getValues(this.column.getType());
        ArrayList<String> ids = new ArrayList<String>();
        for (Object v : values) {
            if (v == null) continue;
            if (source_is_list) {
                for (Object lv : (List)v) {
                    MappingUtil.addCleanedStrValueToList(ids, lv);
                }
                continue;
            }
            MappingUtil.addCleanedStrValueToList(ids, v);
        }
        try {
            BridgeDbIdMapper map = new BridgeDbIdMapper();
            res = map.map(ids, source.system(), saveTarget.system(), saveSpecies.name(), saveSpecies.name());
            matched_ids = map.getMatchedIds();
            Set<String> unmatched_ids = map.getUnmatchedIds();
        }
        catch (Exception e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(null, e.getMessage(), "ID Mapping Error", 0);
                }
            });
            return;
        }
        this.new_column_name = saveTarget.descriptor();
        this.new_column_name = MappingUtil.makeNewColumnName(this.new_column_name, source.descriptor(), this.new_column_name, this.column);
        boolean all_unique = true;
        int non_unique = 0;
        int unique = 0;
        int min = Integer.MAX_VALUE;
        int max = 0;
        if (res != null) {
            for (Map.Entry<String, IdMapping> entry : res.entrySet()) {
                Set<String> v = entry.getValue().getTargetIds();
                if (v == null) continue;
                if (v.size() > 1) {
                    all_unique = false;
                    ++non_unique;
                    if (v.size() > max) {
                        max = v.size();
                    }
                    if (v.size() >= min) continue;
                    min = v.size();
                    continue;
                }
                ++unique;
            }
        }
        CyTable table = this.column.getTable();
        boolean many_to_one = false;
        if (matched_ids.size() > 0) {
            boolean all_single = false;
            if (this.forceSingle) {
                table.createColumn(this.new_column_name, String.class, false);
            } else {
                all_single = MappingUtil.isAllSingle(source_is_list, res, this.column, table);
                if (all_single) {
                    table.createColumn(this.new_column_name, String.class, false);
                } else {
                    table.createListColumn(this.new_column_name, String.class, false);
                }
            }
            many_to_one = MappingUtil.fillNewColumn(source_is_list, res, table, this.column, this.new_column_name, this.forceSingle || all_single);
        }
        String targ = saveTarget.descriptor();
        String src = source.descriptor();
        final String msg = MappingUtil.createMsg(this.new_column_name, targ, src, ids, matched_ids, all_unique, non_unique, unique, min, max, many_to_one, this.forceSingle);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, msg, "ID Mapping Result", matched_ids.size() < 1 ? 2 : 1);
            }
        });
    }

    public void listChanged(ListSelection<String> source) {
        this.speciesSelectionChanged(source);
    }

    public void selectionChanged(ListSelection<String> source) {
        this.speciesSelectionChanged(source);
    }

    private String readSpeciesFromNetworkTable() {
        Species sp;
        String speciesStr = this.getValueFromNetworkTable("idmapper.species");
        if (speciesStr != null && (sp = Species.lookup(speciesStr)) != null) {
            saveSpecies = sp;
        }
        return saveSpecies.fullname();
    }

    public void storeSpeciesIntoNetworkTable() {
        this.putValueIntoNetworkTable("idmapper.species", saveSpecies.toString());
    }

    private String getValueFromNetworkTable(String key) {
        CyNetwork network = ((CyApplicationManager)this.registrar.getService(CyApplicationManager.class)).getCurrentNetwork();
        CyTable networkTable = network.getDefaultNetworkTable();
        List rows = networkTable.getAllRows();
        if (rows.isEmpty()) {
            return null;
        }
        CyRow row = (CyRow)rows.get(0);
        return (String)row.get(key, String.class);
    }

    private void putValueIntoNetworkTable(String key, String value) {
        List rows;
        CyColumn col;
        CyNetwork network = ((CyApplicationManager)this.registrar.getService(CyApplicationManager.class)).getCurrentNetwork();
        CyTable networkTable = network.getDefaultNetworkTable();
        if (networkTable != null && (col = networkTable.getColumn(key)) == null) {
            networkTable.createColumn(key, String.class, false);
        }
        if ((rows = networkTable.getAllRows()).isEmpty()) {
            return;
        }
        CyRow row = (CyRow)rows.get(0);
        row.set(key, (Object)value);
    }

    public void setUIHelper(TunableUIHelper helper) {
        this.helper = helper;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, JSONResult.class);
    }

    public Object getResults(Class requestedType) {
        if (requestedType.equals(String.class)) {
            return this.new_column_name;
        }
        if (requestedType.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.new_column_name == null) {
                    return "{ }";
                }
                return this.new_column_name;
            };
            return res;
        }
        return null;
    }

    class MappingSourceListener
    implements ListChangeListener<MappingSource> {
        MappingSourceListener(ColumnMappingTask task) {
        }

        public void listChanged(ListSelection<MappingSource> source) {
            ColumnMappingTask.this.mappingSourceChanged(source);
        }

        public void selectionChanged(ListSelection<MappingSource> source) {
            ColumnMappingTask.this.mappingSourceChanged(source);
        }
    }
}

