/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.idmapper.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.cytoscape.idmapper.IdMapping;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;

public final class MappingUtil {
    public static final void addCleanedStrValueToList(List<String> ids, Object v) {
        String v_str;
        if (v instanceof String && ids != null && v != null && (v_str = (String)v) != null && (v_str = v_str.trim()).length() > 0) {
            ids.add(v_str);
        }
    }

    public static final boolean fillNewColumn(boolean source_is_list, Map<String, IdMapping> res, CyTable table, CyColumn column, String new_column_name, boolean force_single) {
        List rows = table.getAllRows();
        boolean many_to_one = false;
        if (source_is_list) {
            for (CyRow row : rows) {
                List in_vals = (List)row.get(column.getName(), column.getType());
                if (in_vals == null) continue;
                TreeSet<String> ts = new TreeSet<String>();
                for (Object iv : in_vals) {
                    Set<String> matched;
                    String in_val = (String)iv;
                    if (in_val == null || in_val.length() <= 0 || !res.containsKey(in_val) || (matched = res.get(in_val).getTargetIds()).isEmpty()) continue;
                    for (String m : matched) {
                        if (m == null || m.length() <= 0) continue;
                        if (ts.contains(m)) {
                            many_to_one = true;
                            continue;
                        }
                        ts.add(m);
                    }
                }
                ArrayList l = new ArrayList(ts);
                if (l.isEmpty()) continue;
                row.set(new_column_name, force_single ? l.get(0) : l);
            }
        } else {
            for (CyRow row : rows) {
                Set<String> matched;
                String in_val = (String)row.get(column.getName(), column.getType());
                if (in_val == null || in_val.length() <= 0 || !res.containsKey(in_val) || (matched = res.get(in_val).getTargetIds()).isEmpty()) continue;
                if (force_single) {
                    row.set(new_column_name, (Object)matched.iterator().next());
                    continue;
                }
                TreeSet<String> ts = new TreeSet<String>();
                for (String m : matched) {
                    if (m == null || m.length() <= 0) continue;
                    if (ts.contains(m)) {
                        many_to_one = true;
                        continue;
                    }
                    ts.add(m);
                }
                ArrayList l = new ArrayList(ts);
                row.set(new_column_name, l);
            }
        }
        return many_to_one;
    }

    public static final boolean isAllSingle(boolean source_is_list, Map<String, IdMapping> res, CyColumn column, CyTable table) {
        List rows = table.getAllRows();
        ArrayList list = new ArrayList();
        if (source_is_list) {
            for (CyRow row : rows) {
                List list2 = (List)row.get(column.getName(), column.getType());
                if (list2 == null) continue;
                TreeSet<String> ts = new TreeSet<String>();
                for (Object iv : list2) {
                    IdMapping matched;
                    String in_val = (String)iv;
                    if (in_val == null || in_val.length() <= 0 || !res.containsKey(in_val) || (matched = res.get(in_val)).getTargetIds().isEmpty()) continue;
                    for (String m : matched.getTargetIds()) {
                        if (m == null || m.length() <= 0) continue;
                        ts.add(m);
                    }
                }
                list.add(ts);
            }
        } else {
            for (CyRow row : rows) {
                Set<String> matched;
                String string = (String)row.get(column.getName(), column.getType());
                if (string == null || string.length() <= 0 || !res.containsKey(string) || (matched = res.get(string).getTargetIds()).isEmpty()) continue;
                TreeSet<String> ts = new TreeSet<String>();
                for (String m : matched) {
                    if (m == null || m.length() <= 0) continue;
                    ts.add(m);
                }
                list.add(ts);
            }
        }
        boolean all_single = true;
        for (Set set : list) {
            if (set.size() <= 1) continue;
            all_single = false;
            break;
        }
        return all_single;
    }

    public static final String makeNewColumnName(String target, String source, String new_column_name, CyColumn column) {
        String my_target = target;
        String my_source = source;
        Object my_col_name = new_column_name == null || new_column_name.trim().length() < 1 ? column.getName() + ": " + my_source + "->" + my_target : new_column_name.trim();
        CyTable table = column.getTable();
        if (table.getColumn((String)my_col_name) != null) {
            int counter = 1;
            String new_new_column_name = (String)my_col_name + " (" + counter + ")";
            while (table.getColumn(new_new_column_name) != null) {
                new_new_column_name = (String)my_col_name + " (" + ++counter + ")";
            }
            my_col_name = new_new_column_name;
        }
        return my_col_name;
    }

    public static final String createMsg(String new_column_name, String target, String source, List<String> ids, Set<String> matched_ids, boolean all_unique, int non_unique, int unique, int min, int max, boolean many_to_one, boolean force_single) {
        Object o2o;
        String srcTarget = "Mapped: " + source + " -> " + target + "\n";
        if (matched_ids.size() < 1) {
            return "Failed to map any of " + ids.size() + " identifiers.\n" + srcTarget;
        }
        if (all_unique) {
            o2o = "All mappings one-to-one.\n";
        } else {
            String intro = force_single ? "Some mappings reduced to first value:" : "Not all mappings one-to-one:";
            o2o = intro + "\n  one-to-one: " + unique + "\n  one-to-many: " + non_unique;
            o2o = (String)o2o + (min != max ? " (range: 1-to-" + min + " ~ 1-to-" + max + ")\n" : " (1-to-" + min + ")\n");
        }
        String m2o = many_to_one ? "Same/all mappings many-to-one\n" : "";
        String msg = srcTarget + "Successfully mapped " + matched_ids.size() + " of " + ids.size() + " identifiers.\n" + (String)o2o + m2o + "New column: " + new_column_name;
        return msg;
    }
}

