/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.idmapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.cytoscape.idmapper.Species;

public final class MappingSource
extends Enum<MappingSource> {
    public static final /* enum */ MappingSource HGNC = new MappingSource("HGNC", "H", "Homo sapiens", "^[A-Za-z0-9]+", "DAPK1");
    public static final /* enum */ MappingSource HMDB = new MappingSource("HMDB", "Ch", "", "^[A-Za-z0-9]+", "Trytophan");
    public static final /* enum */ MappingSource Ensembl = new MappingSource("Ensembl", "En", "", "^ENS[A-Z]*[FPTG]\\d{11}$", "ENSG00000139618");
    public static final /* enum */ MappingSource Entrez = new MappingSource("Entrez Gene", "L", "", "^\\d+$", "11234");
    public static final /* enum */ MappingSource FlyBase = new MappingSource("FlyBase", "F", "Drosophila melanogaster", "^FB\\w{2}\\d{7}$", "FBgn0011293");
    public static final /* enum */ MappingSource MGI = new MappingSource("MGI", "M", "Mus musculus", "^MGI:\\d+$", "MGI:2442292");
    public static final /* enum */ MappingSource miRBase = new MappingSource("miRBase", "Mbm", "", "MIMAT\\d{7}", "MIMAT0000001");
    public static final /* enum */ MappingSource RGD = new MappingSource("RGD", "R", "Rattus norvegicus", "^\\d{4,7}$", "2018");
    public static final /* enum */ MappingSource SGD = new MappingSource("SGD", "D", "Saccharomyces cerevisiae", "^S\\d+$", "S000028457");
    public static final /* enum */ MappingSource TAIR = new MappingSource("TAIR", "A", "Arabidopsis thaliana", "^AT[1-5]G\\d{5}$", "AT1G01030");
    public static final /* enum */ MappingSource UniGene = new MappingSource("UniGene", "U", "", "[A-Z][a-z][a-z]?\\.\\d+", "Hs.553708");
    public static final /* enum */ MappingSource Uniprot = new MappingSource("Uniprot-TrEMBL", "S", "", "^([A-N,R-Z][0-9][A-Z][A-Z, 0-9][A-Z, 0-9][0-9])|([O,P,Q][0-9][A-Z, 0-9][A-Z, 0-9][A-Z, 0-9][0-9])(\\.\\d+)?|([A-N,R-Z][0-9][A-Z][A-Z, 0-9][A-Z, 0-9][0-9][A-Z][A-Z, 0-9][A-Z, 0-9][0-9])$", "P62158");
    public static final /* enum */ MappingSource WormBase = new MappingSource("WormBase", "W", "Caenorhabditis elegans", "^WBGene\\d{8}$", "WBGene00000001");
    public static final /* enum */ MappingSource ZFIN = new MappingSource("ZFIN", "Z", "Danio rerio", "ZDB\\-GENE\\-\\d+\\-\\d+", "ZDB-GENE-041118-11");
    private final String descriptor;
    private final String system;
    private final Species species;
    private final Pattern pattern;
    private final String example;
    private static boolean VERBOSE;
    private static int N_ITERATIONS;
    private static final /* synthetic */ MappingSource[] $VALUES;

    public static MappingSource[] values() {
        return (MappingSource[])$VALUES.clone();
    }

    public static MappingSource valueOf(String name) {
        return Enum.valueOf(MappingSource.class, name);
    }

    private MappingSource(String s, String sy, String spec, String pat, String sample) {
        this.descriptor = s;
        this.system = sy;
        this.species = Species.lookup(spec);
        this.pattern = Pattern.compile(pat);
        this.example = sample;
    }

    public String descriptor() {
        return this.descriptor;
    }

    public String system() {
        return this.system;
    }

    public String species() {
        return this.species == null ? "" : this.species.common();
    }

    public Pattern pattern() {
        return this.pattern;
    }

    public static MappingSource systemLookup(String sys) {
        for (MappingSource src : MappingSource.values()) {
            if (!src.system.equals(sys)) continue;
            return src;
        }
        return null;
    }

    public List<String> systems(String sys) {
        ArrayList<String> results = new ArrayList<String>();
        for (MappingSource src : MappingSource.values()) {
            if (!src.system.equals(sys)) continue;
            results.add(src.system);
        }
        return results;
    }

    public static MappingSource nameLookup(String str) {
        if (str != null) {
            for (MappingSource src : MappingSource.values()) {
                if (!str.contains(src.descriptor) && !str.contains(src.getMenuString())) continue;
                return src;
            }
        }
        return null;
    }

    public static List<MappingSource> nameLookup(List<MappingSource> srcs) {
        ArrayList<MappingSource> results = new ArrayList<MappingSource>();
        for (MappingSource src : srcs) {
            results.add(src);
        }
        return results;
    }

    public boolean matchSpecies(Species inSpecies) {
        boolean isMatch = this.species == null || inSpecies == null || inSpecies.match(this.species);
        return isMatch;
    }

    public static List<MappingSource> filteredStrings(Species inSpecies, MappingSource inSource) {
        assert (inSpecies != null);
        ArrayList<MappingSource> matchingSources = new ArrayList<MappingSource>();
        String srcName = inSource == null ? "" : inSource.name();
        for (MappingSource src : MappingSource.values()) {
            if (inSource == src || !src.matchSpecies(inSpecies) || src.name().equals(srcName)) continue;
            matchingSources.add(src);
        }
        return matchingSources;
    }

    public String getMenuString() {
        String ex = this.example.trim().length() > 0 ? " (e.g., " + this.example + ")" : "";
        return this.descriptor + ex;
    }

    private boolean patternMatch(String id) {
        if (this.pattern == null) {
            return false;
        }
        if (id == null) {
            return true;
        }
        if (this.pattern.matcher(id) == null) {
            return false;
        }
        return this.pattern.matcher(id).matches();
    }

    public static MappingSource guessSource(Species inSpecies, List<String> names) {
        HashMap<MappingSource, Integer> counter = new HashMap<MappingSource, Integer>();
        for (MappingSource src : MappingSource.values()) {
            counter.put(src, 0);
        }
        int sampleSize = Math.min(names.size(), N_ITERATIONS);
        for (int i = 0; i < sampleSize; ++i) {
            String id = names.get(i);
            for (MappingSource src : MappingSource.values()) {
                if (!src.matchSpecies(inSpecies) || !src.patternMatch(id)) continue;
                counter.put(src, (Integer)counter.get((Object)src) + 1);
            }
            int ensemblCt = (Integer)counter.get((Object)Ensembl);
            if (!(inSpecies.isYeast() && id.startsWith("Y") || inSpecies.isFly() && id.startsWith("F")) && (!inSpecies.isWorm() || !id.startsWith("W"))) continue;
            counter.put(Ensembl, ensemblCt + 1);
        }
        MappingSource maxSrc = Ensembl;
        int maxCount = 0;
        for (MappingSource src : MappingSource.values()) {
            int count = (Integer)counter.get((Object)src);
            if (count <= maxCount) continue;
            maxCount = count;
            maxSrc = src;
        }
        if (VERBOSE) {
            String msg = maxSrc.descriptor + " is maximum with  " + counter.get((Object)maxSrc) + " matches";
            System.out.println(msg);
        }
        return maxSrc;
    }

    static {
        $VALUES = new MappingSource[]{HGNC, HMDB, Ensembl, Entrez, FlyBase, MGI, miRBase, RGD, SGD, TAIR, UniGene, Uniprot, WormBase, ZFIN};
        VERBOSE = false;
        N_ITERATIONS = 10;
    }
}

