/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.psi_mi.internal.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.cytoscape.psi_mi.internal.util.DataServiceException;

public class ContentReader {
    private static final String HTTP = "http";
    private static final String FTP = "ftp";

    public String retrieveContent(String urlStr) throws DataServiceException {
        String content = null;
        URL url = null;
        try {
            if (urlStr.startsWith(HTTP) || urlStr.startsWith(FTP)) {
                url = new URL(urlStr);
                if (url.getProtocol().equalsIgnoreCase(HTTP)) {
                    content = this.retrieveContentFromWeb(url);
                }
                if (url.getProtocol().equalsIgnoreCase(FTP)) {
                    content = this.retrieveContentFromFtp(url);
                }
            } else {
                File file = new File(urlStr);
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("UTF-8").newDecoder());
                content = this.retrieveContentFromFile(reader);
            }
        }
        catch (MalformedURLException e) {
            throw new DataServiceException(e, "URL is malformed:  " + url + ".  Please try again.");
        }
        catch (UnknownHostException e) {
            String msg = "Network error occurred while trying to make network connection.  Could not find server:  " + e.getMessage() + ". Please check your server and network settings, and try again.";
            throw new DataServiceException(e, msg);
        }
        catch (IOException e) {
            throw new DataServiceException(e, "Error occurred  while trying to retrieve data from:  " + urlStr);
        }
        return content;
    }

    private String retrieveContentFromWeb(URL url) throws IOException {
        InputStreamReader isr = new InputStreamReader(url.openStream(), Charset.forName("UTF-8").newDecoder());
        int bufSize = 65536;
        char[] buf = new char[65536];
        Object content = "";
        int charsread = 0;
        while ((charsread = isr.read(buf, 0, 65536)) != -1) {
            String bufstring = new String(buf, 0, charsread);
            content = (String)content + bufstring;
        }
        return content;
    }

    private String retrieveContentFromFtp(URL url) throws IOException {
        InputStreamReader isr = new InputStreamReader(url.openStream(), Charset.forName("UTF-8").newDecoder());
        int bufSize = 65536;
        char[] buf = new char[65536];
        Object content = "";
        int charsread = 0;
        while ((charsread = isr.read(buf, 0, 65536)) != -1) {
            String bufstring = new String(buf, 0, charsread);
            content = (String)content + bufstring;
        }
        return content;
    }

    private String retrieveContentFromFile(InputStreamReader reader) throws IOException {
        int bufSize = 65536;
        char[] buf = new char[65536];
        StringBuffer content = new StringBuffer("");
        int charsread = 0;
        int totalcharsread = 0;
        while (true) {
            charsread = reader.read(buf, 0, 65536);
            totalcharsread += charsread;
            if (charsread == -1) break;
            String bufstring = new String(buf, 0, charsread);
            content.append(bufstring);
        }
        return content.toString();
    }

    public static InputStreamReader determineFileType(InputStream aStream) {
        InputStreamReader result = null;
        try {
            byte[] firstFour = new byte[4];
            PushbackInputStream pbi = new PushbackInputStream(aStream, 4);
            int count = pbi.read(firstFour, 0, 4);
            if (count == 4) {
                ZipInputStream zis;
                ZipEntry ze;
                pbi.unread(firstFour);
                if (firstFour[0] == 31 && firstFour[1] == -117) {
                    result = new InputStreamReader((InputStream)new GZIPInputStream(pbi), Charset.forName("UTF-8").newDecoder());
                } else if (firstFour[0] == 80 && firstFour[1] == 75 && firstFour[2] == 3 && firstFour[3] == 4 && (ze = (zis = new ZipInputStream(pbi)).getNextEntry()) != null) {
                    result = new InputStreamReader(zis);
                }
                if (result == null) {
                    System.out.println("Defaulted to standard Reader.");
                    result = new InputStreamReader(pbi);
                }
            }
        }
        catch (Exception ioe) {
            System.out.println("IOException while attempting to determine filetype." + ioe);
        }
        return result;
    }
}

