/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.psi_mi.internal.plugin;

import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.psi_mi.internal.cyto_mapper.MapFromCytoscape;
import org.cytoscape.psi_mi.internal.data_mapper.MapInteractionsToPsiOne;
import org.cytoscape.psi_mi.internal.data_mapper.MapInteractionsToPsiTwoFive;
import org.cytoscape.psi_mi.internal.data_mapper.SchemaMapper;
import org.cytoscape.psi_mi.internal.model.Interaction;
import org.cytoscape.psi_mi.internal.plugin.SchemaVersion;
import org.cytoscape.psi_mi.internal.schema.mi1.EntrySet;
import org.cytoscape.work.TaskMonitor;

public class PsiMiWriter
implements CyWriter {
    private final OutputStream outputStream;
    private final CyNetwork network;
    private final SchemaVersion version;

    public PsiMiWriter(OutputStream outputStream, CyNetwork network, SchemaVersion version) {
        this.outputStream = outputStream;
        this.network = network;
        this.version = version;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        SchemaMapper<EntrySet> schemaMapper;
        MapFromCytoscape modelMapper = new MapFromCytoscape(this.network);
        modelMapper.doMapping();
        ArrayList<Interaction> interactions = modelMapper.getInteractions();
        switch (this.version) {
            case LEVEL_1: {
                schemaMapper = new MapInteractionsToPsiOne(interactions);
                break;
            }
            case LEVEL_2_5: {
                schemaMapper = new MapInteractionsToPsiTwoFive(interactions);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        schemaMapper.doMapping();
        EntrySet model = schemaMapper.getModel();
        Marshaller marshaller = this.createMarshaller(schemaMapper.getSchemaNamespace());
        marshaller.marshal((Object)model, this.outputStream);
    }

    public void cancel() {
    }

    private Marshaller createMarshaller(String schema) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((String)schema, (ClassLoader)this.getClass().getClassLoader());
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        return marshaller;
    }
}

