/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.psi_mi.internal.data_mapper;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.cytoscape.psi_mi.internal.data_mapper.Mapper;
import org.cytoscape.psi_mi.internal.data_mapper.MapperException;
import org.cytoscape.psi_mi.internal.data_mapper.MapperUtil;
import org.cytoscape.psi_mi.internal.model.ExternalReference;
import org.cytoscape.psi_mi.internal.model.Interaction;
import org.cytoscape.psi_mi.internal.model.Interactor;
import org.cytoscape.psi_mi.internal.schema.mi25.BibrefType;
import org.cytoscape.psi_mi.internal.schema.mi25.CvType;
import org.cytoscape.psi_mi.internal.schema.mi25.DbReferenceType;
import org.cytoscape.psi_mi.internal.schema.mi25.EntrySet;
import org.cytoscape.psi_mi.internal.schema.mi25.ExperimentType;
import org.cytoscape.psi_mi.internal.schema.mi25.InteractionElementType;
import org.cytoscape.psi_mi.internal.schema.mi25.InteractorElementType;
import org.cytoscape.psi_mi.internal.schema.mi25.NamesType;
import org.cytoscape.psi_mi.internal.schema.mi25.ParticipantType;
import org.cytoscape.psi_mi.internal.schema.mi25.XrefType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapPsiTwoFiveToInteractions
implements Mapper {
    private static final Logger logger = LoggerFactory.getLogger(MapPsiTwoFiveToInteractions.class);
    private final Map<String, InteractorElementType> interactorMap;
    private final Map<String, ExperimentType> experimentMap;
    private final List<Interaction> interactions;
    private final String xml;

    public MapPsiTwoFiveToInteractions(String xml, List<Interaction> interactions) {
        this.xml = xml;
        this.interactions = interactions;
        this.interactorMap = new HashMap<String, InteractorElementType>();
        this.experimentMap = new HashMap<String, ExperimentType>();
    }

    @Override
    public void doMapping() throws MapperException {
        this.parseXml(this.xml);
    }

    private void parseXml(String xml) throws MapperException {
        StringReader reader = new StringReader(xml);
        JAXBContext jc = null;
        try {
            jc = JAXBContext.newInstance((String)"org.cytoscape.psi_mi.internal.schema.mi25", (ClassLoader)this.getClass().getClassLoader());
        }
        catch (JAXBException e) {
            logger.error("Could not create JAXBContext", (Throwable)e);
        }
        Unmarshaller u = null;
        try {
            u = jc.createUnmarshaller();
        }
        catch (JAXBException e) {
            logger.error("Could not create Unmarshaller", (Throwable)e);
        }
        EntrySet entrySet = null;
        try {
            entrySet = (EntrySet)u.unmarshal((Reader)reader);
        }
        catch (JAXBException e) {
            logger.error("unmarshal operation failed", (Throwable)e);
        }
        int entryCount = entrySet.getEntry().size();
        for (int i = 0; i < entryCount; ++i) {
            this.extractEntry(entrySet.getEntry().get(i));
        }
    }

    private void extractEntry(EntrySet.Entry entry) throws MapperException {
        EntrySet.Entry.ExperimentList expList = entry.getExperimentList();
        this.extractExperimentList(expList);
        EntrySet.Entry.InteractorList interactorList = entry.getInteractorList();
        this.extractInteractorList(interactorList);
        EntrySet.Entry.InteractionList interactionList = entry.getInteractionList();
        this.extractInteractionList(interactionList);
    }

    private void extractExperimentList(EntrySet.Entry.ExperimentList expList) {
        if (expList != null) {
            int count = expList.getExperimentDescription().size();
            for (int i = 0; i < count; ++i) {
                ExperimentType expType = expList.getExperimentDescription().get(i);
                this.experimentMap.put(Integer.toString(expType.getId()), expType);
            }
        }
    }

    private void extractInteractorList(EntrySet.Entry.InteractorList interactorList) {
        logger.debug("Extracting Interactor List: Start");
        if (interactorList != null) {
            for (InteractorElementType cProtein : interactorList.getInteractor()) {
                this.interactorMap.put(Integer.toString(cProtein.getId()), cProtein);
            }
        }
        logger.debug("Extracting Interactor List: End");
    }

    private void extractInteractionList(EntrySet.Entry.InteractionList interactionList) throws MapperException {
        logger.debug("Extracting Interaction List: Start");
        for (EntrySet.Entry.InteractionList.Interaction cInteraction : interactionList.getInteraction()) {
            Interaction interaction = new Interaction();
            List<CvType> interactionTypes = cInteraction.getInteractionType();
            InteractionElementType.ParticipantList pList = cInteraction.getParticipantList();
            int pCount = pList.getParticipant().size();
            ArrayList<Interactor> interactorList = new ArrayList<Interactor>();
            HashMap<String, String> interactorRoles = new HashMap<String, String>();
            for (int j = 0; j < pCount; ++j) {
                Interactor interactor = this.extractInteractorRefOrElement(pList, j);
                logger.debug("Getting interactor:  " + interactor);
                interactorList.add(interactor);
                ParticipantType participant = pList.getParticipant().get(j);
                ParticipantType.ExperimentalRoleList role = participant.getExperimentalRoleList();
                if (role == null) continue;
                for (ParticipantType.ExperimentalRoleList.ExperimentalRole expRole : role.getExperimentalRole()) {
                    NamesType namesType = expRole.getNames();
                    String roleName = namesType.getShortLabel();
                    logger.debug("Storing role for:  " + interactor.getName() + " --> " + roleName);
                    interactorRoles.put(interactor.getName(), roleName);
                }
            }
            interaction.setInteractors(interactorList);
            interaction.setInteractionId(cInteraction.getId());
            List<Interaction> expDatalist = this.extractExperimentalData(cInteraction, interaction);
            for (int j = 0; j < expDatalist.size(); ++j) {
                interaction = expDatalist.get(j);
                interaction.addAttribute("BAIT_MAP", interactorRoles);
                this.extractInteractionNamesXrefs(cInteraction, interaction);
                this.addInteractorType(interactionTypes, interaction);
            }
            logger.debug("Adding num interactions:  " + expDatalist.size());
            this.interactions.addAll(expDatalist);
        }
        logger.debug("Extracting Interaction List: End");
    }

    private void addInteractorType(List<CvType> interactionTypes, Interaction interaction) {
        String shortName;
        CvType interactionType;
        NamesType namesType;
        if (interactionTypes != null && interactionTypes.size() == 1 && (namesType = (interactionType = interactionTypes.get(0)).getNames()) != null && (shortName = namesType.getShortLabel()) != null) {
            interaction.addAttribute("INTERACTION_TYPE_NAME", shortName);
        }
    }

    private void extractInteractionNamesXrefs(InteractionElementType cInteraction, Interaction interaction) {
        XrefType xref;
        ExternalReference[] refs;
        NamesType names = cInteraction.getNames();
        if (names != null) {
            String shortLabel = names.getShortLabel();
            String fullName = names.getFullName();
            if (shortLabel != null) {
                interaction.addAttribute("INTERACTION_SHORT_NAME", shortLabel);
            }
            if (fullName != null) {
                interaction.addAttribute("INTERACTION_FULL_NAME", fullName);
            }
        }
        if ((refs = this.extractExternalRefs(xref = cInteraction.getXref())) != null && refs.length > 0) {
            logger.debug("Got refs:  " + refs.length);
            interaction.setExternalRefs(refs);
        }
    }

    private Interactor extractInteractorRefOrElement(InteractionElementType.ParticipantList pList, int j) throws MapperException {
        InteractorElementType cInteractor = null;
        ParticipantType participant = pList.getParticipant().get(j);
        Integer ref = participant.getInteractorRef();
        cInteractor = ref != null ? this.interactorMap.get(ref.toString()) : participant.getInteractor();
        Interactor interactor = this.createInteractor(cInteractor);
        return interactor;
    }

    private void extractInteractorName(InteractorElementType cProtein, Interactor interactor) throws MapperException {
        NamesType names = cProtein.getNames();
        if (names != null) {
            String name = MapperUtil.normalizeText(MapperUtil.extractName(cProtein, interactor.getExternalRefs()));
            interactor.setName(name);
            String fullName = names.getFullName();
            interactor.addAttribute("FULL_NAME", fullName);
        }
    }

    private ExternalReference[] extractExternalRefs(XrefType xref) {
        ArrayList<ExternalReference> refList = new ArrayList<ExternalReference>();
        if (xref != null) {
            DbReferenceType primaryRef = xref.getPrimaryRef();
            this.createExternalReference(primaryRef.getDb(), primaryRef.getId(), refList);
            for (DbReferenceType secondaryRef : xref.getSecondaryRef()) {
                this.createExternalReference(secondaryRef.getDb(), secondaryRef.getId(), refList);
            }
            ExternalReference[] refs = new ExternalReference[refList.size()];
            refs = refList.toArray(refs);
            return refs;
        }
        return null;
    }

    private void createExternalReference(String db, String id, List<ExternalReference> refList) {
        ExternalReference ref = new ExternalReference(db, id);
        refList.add(ref);
    }

    private List<Interaction> extractExperimentalData(InteractionElementType cInteraction, Interaction interactionTemplate) throws MapperException {
        InteractionElementType.ExperimentList expList = cInteraction.getExperimentList();
        ArrayList<Interaction> list = new ArrayList<Interaction>();
        if (expList != null) {
            int expCount = expList.getExperimentRefOrExperimentDescription().size();
            for (int i = 0; i < expCount; ++i) {
                Interaction interaction = this.cloneInteractionTemplate(interactionTemplate);
                Object expItem = expList.getExperimentRefOrExperimentDescription().get(i);
                ExperimentType expType = this.extractExperimentReferenceOrElement(expItem);
                String id = this.getPubMedId(expType);
                if (id != null) {
                    interaction.addAttribute("PUB_MED_ID", id);
                }
                this.extractInteractionDetection(expType, interaction);
                list.add(interaction);
            }
        } else {
            throw new MapperException("Could not determine experimental data for one of the PSI-MI interactions");
        }
        return list;
    }

    private Interaction cloneInteractionTemplate(Interaction interactionTemplate) {
        Interaction interaction = new Interaction();
        List<Interactor> interactors = interactionTemplate.getInteractors();
        interaction.setInteractors(interactors);
        return interaction;
    }

    private ExperimentType extractExperimentReferenceOrElement(Object expItem) {
        if (expItem instanceof Integer) {
            String ref = "" + expItem;
            return this.experimentMap.get(ref);
        }
        return (ExperimentType)expItem;
    }

    private void extractInteractionDetection(ExperimentType expDesc, Interaction interaction) {
        if (expDesc != null) {
            DbReferenceType primaryRef;
            XrefType xref;
            CvType detection = expDesc.getInteractionDetectionMethod();
            if (detection == null) {
                return;
            }
            NamesType names = detection.getNames();
            String expSystem = names.getShortLabel();
            if (expSystem != null) {
                interaction.addAttribute("EXPERIMENTAL_SYSTEM_NAME", expSystem);
            }
            if ((xref = detection.getXref()) != null && (primaryRef = xref.getPrimaryRef()) != null) {
                interaction.addAttribute("EXPERIMENTAL_SYSTEM_XREF_DB", primaryRef.getDb());
                interaction.addAttribute("EXPERIMENTAL_SYSTEM_XREF_ID", primaryRef.getId());
            }
        }
    }

    private String getPubMedId(ExperimentType expDesc) {
        DbReferenceType primaryRef;
        XrefType xRef;
        BibrefType bibRef;
        String id = null;
        if (expDesc != null && (bibRef = expDesc.getBibref()) != null && (xRef = bibRef.getXref()) != null && (primaryRef = xRef.getPrimaryRef()) != null) {
            id = primaryRef.getId();
        }
        return id;
    }

    private Interactor createInteractor(InteractorElementType cProtein) throws MapperException {
        Interactor interactor = new Interactor();
        this.extractOrganismInfo(cProtein, interactor);
        this.extractSequenceData(cProtein, interactor);
        ExternalReference[] refs = this.extractExternalRefs(cProtein.getXref());
        if (refs != null && refs.length > 0) {
            interactor.setExternalRefs(refs);
        }
        String localId = "" + cProtein.getId();
        interactor.addAttribute("LOCAL_ID", localId);
        this.extractInteractorName(cProtein, interactor);
        this.extractCvType(cProtein, interactor);
        return interactor;
    }

    private void extractCvType(InteractorElementType cProtein, Interactor interactor) {
        CvType cvType = cProtein.getInteractorType();
        if (cvType != null) {
            interactor.setCvType(cvType);
        }
    }

    private void extractSequenceData(InteractorElementType cProtein, Interactor interactor) {
        String sequence = cProtein.getSequence();
        if (sequence != null) {
            interactor.addAttribute("SEQUENCE_DATA", sequence);
        }
    }

    private void extractOrganismInfo(InteractorElementType cProtein, Interactor interactor) {
        InteractorElementType.Organism organism = cProtein.getOrganism();
        if (organism != null) {
            NamesType names = organism.getNames();
            String commonName = names.getShortLabel();
            String fullName = names.getFullName();
            int ncbiTaxID = organism.getNcbiTaxId();
            if (commonName != null && commonName.length() > 0) {
                interactor.addAttribute("ORGANISM_COMMON_NAME", commonName);
            }
            if (fullName != null && fullName.length() > 0) {
                interactor.addAttribute("ORGANISM_SPECIES", fullName);
            }
            if (ncbiTaxID > 0) {
                interactor.addAttribute("ORGANISM_NCBI_TAXON_ID", Integer.toString(ncbiTaxID));
            }
        }
    }
}

