/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.psi_mi.internal.data_mapper;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.cytoscape.psi_mi.internal.data_mapper.SchemaMapper;
import org.cytoscape.psi_mi.internal.model.AttributeBag;
import org.cytoscape.psi_mi.internal.model.ExternalReference;
import org.cytoscape.psi_mi.internal.model.Interaction;
import org.cytoscape.psi_mi.internal.model.Interactor;
import org.cytoscape.psi_mi.internal.schema.mi1.BibrefType;
import org.cytoscape.psi_mi.internal.schema.mi1.CvType;
import org.cytoscape.psi_mi.internal.schema.mi1.DbReferenceType;
import org.cytoscape.psi_mi.internal.schema.mi1.EntrySet;
import org.cytoscape.psi_mi.internal.schema.mi1.ExperimentType;
import org.cytoscape.psi_mi.internal.schema.mi1.InteractionElementType;
import org.cytoscape.psi_mi.internal.schema.mi1.NamesType;
import org.cytoscape.psi_mi.internal.schema.mi1.ProteinInteractorType;
import org.cytoscape.psi_mi.internal.schema.mi1.ProteinParticipantType;
import org.cytoscape.psi_mi.internal.schema.mi1.RefType;
import org.cytoscape.psi_mi.internal.schema.mi1.XrefType;

public class MapInteractionsToPsiOne
implements SchemaMapper<EntrySet> {
    public static final String SCHEMA_NAMESPACE = "org.cytoscape.psi_mi.internal.schema.mi1";
    private static final String EXP_AFFINITY_PRECIPITATION = "Affinity Precipitation";
    private static final String EXP_AFFINITY_CHROMOTOGRAPHY = "Affinity Chromatography";
    private static final String EXP_TWO_HYBRID = "Two Hybrid";
    private static final String EXP_PURIFIED_COMPLEX = "Purified Complex";
    private static final String PUB_MED_DB = "pubmed";
    private EntrySet entrySet;
    private List<Interaction> interactions;

    @Override
    public String getSchemaNamespace() {
        return SCHEMA_NAMESPACE;
    }

    public MapInteractionsToPsiOne(List<Interaction> interactions) {
        this.interactions = interactions;
    }

    @Override
    public void doMapping() {
        this.entrySet = new EntrySet();
        this.entrySet.setLevel(new BigInteger("1"));
        this.entrySet.setVersion(new BigInteger("1"));
        EntrySet.Entry entry = new EntrySet.Entry();
        EntrySet.Entry.InteractorList interactorList = this.getInteractorList();
        EntrySet.Entry.InteractionList interactionList = this.getInteractionList();
        entry.setInteractorList(interactorList);
        entry.setInteractionList(interactionList);
        this.entrySet.getEntry().add(entry);
    }

    @Override
    public EntrySet getModel() {
        return this.entrySet;
    }

    private EntrySet.Entry.InteractorList getInteractorList() {
        Map<String, Interactor> proteinSet = this.getNonRedundantInteractors();
        EntrySet.Entry.InteractorList interactorList = new EntrySet.Entry.InteractorList();
        for (Interactor interactor : proteinSet.values()) {
            ProteinInteractorType jaxbInteractor = new ProteinInteractorType();
            this.setNameId(interactor, jaxbInteractor);
            this.setOrganism(interactor, jaxbInteractor);
            this.setSequence(interactor, jaxbInteractor);
            XrefType xref = this.createExternalRefs(interactor);
            if (xref != null) {
                jaxbInteractor.setXref(xref);
            }
            interactorList.getProteinInteractor().add(jaxbInteractor);
        }
        return interactorList;
    }

    private void setSequence(Interactor interactor, ProteinInteractorType jaxbInteractor) {
        String seqData = (String)interactor.getAttribute("SEQUENCE_DATA");
        if (seqData != null) {
            jaxbInteractor.setSequence(seqData);
        }
    }

    private void setNameId(Interactor interactor, ProteinInteractorType jaxbInteractor) {
        NamesType names = new NamesType();
        names.setShortLabel(interactor.getName());
        String fullName = (String)interactor.getAttribute("FULL_NAME");
        if (fullName != null) {
            names.setFullName(fullName);
        }
        jaxbInteractor.setNames(names);
        jaxbInteractor.setId(interactor.getName());
    }

    private void setOrganism(Interactor interactor, ProteinInteractorType jaxbInteractor) {
        String speciesName;
        ProteinInteractorType.Organism organism = new ProteinInteractorType.Organism();
        String taxonomyID = (String)interactor.getAttribute("ORGANISM_NCBI_TAXON_ID");
        if (taxonomyID != null) {
            organism.setNcbiTaxId(new BigInteger(taxonomyID));
        }
        NamesType orgNames = new NamesType();
        String commonName = (String)interactor.getAttribute("ORGANISM_COMMON_NAME");
        if (commonName != null) {
            orgNames.setShortLabel(commonName);
        }
        if ((speciesName = (String)interactor.getAttribute("ORGANISM_SPECIES")) != null) {
            orgNames.setFullName(speciesName);
        }
        organism.setNames(orgNames);
        jaxbInteractor.setOrganism(organism);
    }

    private XrefType createExternalRefs(AttributeBag bag) {
        HashSet<String> set = new HashSet<String>();
        ExternalReference[] refs = bag.getExternalRefs();
        XrefType xref = new XrefType();
        if (refs != null && refs.length > 0) {
            this.createPrimaryKey(refs[0], xref);
            if (refs.length > 1) {
                for (int i = 1; i < refs.length; ++i) {
                    String key = this.generateXRefKey(refs[i]);
                    if (set.contains(key)) continue;
                    this.createSecondaryKey(refs[i], xref);
                    set.add(key);
                }
            }
        }
        if (xref.getPrimaryRef() != null) {
            return xref;
        }
        return null;
    }

    private String generateXRefKey(ExternalReference ref) {
        return ref.getDatabase() + "." + ref.getId();
    }

    private void createPrimaryKey(ExternalReference ref, XrefType xref) {
        DbReferenceType primaryRef = new DbReferenceType();
        primaryRef.setDb(ref.getDatabase());
        primaryRef.setId(ref.getId());
        xref.setPrimaryRef(primaryRef);
    }

    private void createSecondaryKey(ExternalReference ref, XrefType xref) {
        DbReferenceType secondaryRef = new DbReferenceType();
        secondaryRef.setDb(ref.getDatabase());
        secondaryRef.setId(ref.getId());
        xref.getSecondaryRef().add(secondaryRef);
    }

    private Map<String, Interactor> getNonRedundantInteractors() {
        HashMap<String, Interactor> interactorMap = new HashMap<String, Interactor>();
        for (Interaction interaction : this.interactions) {
            List<Interactor> interactors = interaction.getInteractors();
            for (Interactor interactor : interactors) {
                this.addToHashMap(interactor, interactorMap);
            }
        }
        return interactorMap;
    }

    private void addToHashMap(Interactor interactor, Map<String, Interactor> interactorMap) {
        String orfName = interactor.getName();
        if (!interactorMap.containsKey(orfName)) {
            interactorMap.put(orfName, interactor);
        }
    }

    private EntrySet.Entry.InteractionList getInteractionList() {
        EntrySet.Entry.InteractionList interactionList = new EntrySet.Entry.InteractionList();
        for (int i = 0; i < this.interactions.size(); ++i) {
            InteractionElementType jaxbInteraction = new InteractionElementType();
            Interaction interaction = this.interactions.get(i);
            InteractionElementType.ExperimentList expList = this.getExperimentDescription(interaction, i);
            jaxbInteraction.setExperimentList(expList);
            InteractionElementType.ParticipantList participantList = this.getParticipantList(interaction);
            jaxbInteraction.setParticipantList(participantList);
            interactionList.getInteraction().add(jaxbInteraction);
            XrefType xref = this.createExternalRefs(interaction);
            if (xref == null) continue;
            jaxbInteraction.setXref(xref);
        }
        return interactionList;
    }

    private InteractionElementType.ExperimentList getExperimentDescription(Interaction interaction, int index) {
        InteractionElementType.ExperimentList expList = new InteractionElementType.ExperimentList();
        ExperimentType expType = new ExperimentType();
        expType.setId("exp" + index);
        BibrefType bibRef = null;
        Object pmid = interaction.getAttribute("PUB_MED_ID");
        if (pmid != null && pmid instanceof String) {
            bibRef = this.createBibRef(PUB_MED_DB, (String)pmid);
            expType.setBibref(bibRef);
        }
        CvType interactionDetection = this.getInteractionDetection(interaction);
        expType.setInteractionDetection(interactionDetection);
        expList.getExperimentRefOrExperimentDescription().add(expType);
        return expList;
    }

    private BibrefType createBibRef(String database, String id) {
        XrefType xref = this.createXRef(database, id);
        BibrefType bibRef = new BibrefType();
        bibRef.setXref(xref);
        return bibRef;
    }

    private XrefType createXRef(String database, String id) {
        XrefType xref = new XrefType();
        DbReferenceType primaryRef = new DbReferenceType();
        primaryRef.setDb(database);
        primaryRef.setId(id);
        xref.setPrimaryRef(primaryRef);
        return xref;
    }

    private CvType getInteractionDetection(Interaction interaction) {
        CvType interactionDetection = new CvType();
        String idStr = null;
        try {
            idStr = (String)interaction.getAttribute("EXPERIMENTAL_SYSTEM_NAME");
        }
        catch (ClassCastException e) {
            idStr = null;
        }
        if (idStr == null) {
            idStr = "Not Specified";
        }
        String idRef = null;
        try {
            idRef = (String)interaction.getAttribute("EXPERIMENTAL_SYSTEM_XREF_ID");
        }
        catch (ClassCastException e) {
            idRef = null;
        }
        if (idRef == null) {
            if (idStr.equals(EXP_AFFINITY_PRECIPITATION) || idStr.equals(EXP_AFFINITY_CHROMOTOGRAPHY)) {
                idStr = "affinity chromatography technologies";
                idRef = "MI:0004";
            } else if (idStr.equals(EXP_TWO_HYBRID)) {
                idStr = "classical two hybrid";
                idRef = "MI:0018";
            } else if (idStr.equals(EXP_PURIFIED_COMPLEX)) {
                idStr = "copurification";
                idRef = "MI:0025";
            } else {
                idRef = "Not Specified";
            }
        }
        NamesType names = this.createName(idStr, null);
        interactionDetection.setNames(names);
        String dbRef = null;
        try {
            dbRef = (String)interaction.getAttribute("EXPERIMENTAL_SYSTEM_XREF_DB");
        }
        catch (ClassCastException e) {
            dbRef = null;
        }
        if (dbRef == null) {
            dbRef = "PSI-MI";
        }
        XrefType xref = this.createXRef(dbRef, idRef);
        interactionDetection.setXref(xref);
        return interactionDetection;
    }

    private NamesType createName(String shortLabel, String fullName) {
        NamesType names = new NamesType();
        names.setShortLabel(shortLabel);
        if (fullName != null) {
            names.setFullName(fullName);
        }
        return names;
    }

    private InteractionElementType.ParticipantList getParticipantList(Interaction interaction) {
        InteractionElementType.ParticipantList participantList = new InteractionElementType.ParticipantList();
        List<Interactor> interactors = interaction.getInteractors();
        for (Interactor interactor : interactors) {
            String name = interactor.getName();
            ProteinParticipantType participant1 = this.createParticipant(name);
            participantList.getProteinParticipant().add(participant1);
        }
        return participantList;
    }

    private ProteinParticipantType createParticipant(String id) {
        ProteinParticipantType participant = new ProteinParticipantType();
        RefType ref = new RefType();
        ref.setRef(id);
        participant.setProteinInteractorRef(ref);
        return participant;
    }
}

