/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.psi_mi.internal.cyto_mapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.psi_mi.internal.data_mapper.Mapper;
import org.cytoscape.psi_mi.internal.data_mapper.MapperException;
import org.cytoscape.psi_mi.internal.model.ExternalReference;
import org.cytoscape.psi_mi.internal.model.Interaction;
import org.cytoscape.psi_mi.internal.model.Interactor;
import org.cytoscape.psi_mi.internal.util.AttributeUtil;

public class MapToCytoscape
implements Mapper {
    public static final int SPOKE_VIEW = 1;
    public static final int MATRIX_VIEW = 2;
    public static final String ROOT_GRAPH_INDEXES = "ROOT_GRAPH_INDEXES";
    public static final String DS_INTERACTOR = "DS_INTERACTOR";
    public static final String DS_INTERACTION = "DS_INTERACTION";
    private List<CyNode> nodeList = new ArrayList<CyNode>();
    private List<CyEdge> edgeList = new ArrayList<CyEdge>();
    private List<Interaction> interactions;
    private int graphType;
    private List<String> warnings = new ArrayList<String>();
    private static final int MATRIX_CUT_OFF = 5;
    protected static final String OPEN_PAREN = " (";
    protected static final String CLOSE_PAREN = ") ";
    private Map<Integer, Interaction> intMap;
    private CyNetwork network;

    public MapToCytoscape(CyNetwork network, List<Interaction> interactionList, int graphType) {
        if (graphType < 1 || graphType > 2) {
            throw new IllegalArgumentException("Illegal GraphType Parameter.");
        }
        this.interactions = interactionList;
        this.graphType = graphType;
        this.network = network;
    }

    public void setInteractions(List<Interaction> interactions) {
        this.interactions = interactions;
    }

    public void setGraphType(int graphType) {
        this.graphType = graphType;
    }

    @Override
    public final void doMapping() throws MapperException {
        HashMap<String, CyNode> nodeMap = new HashMap<String, CyNode>();
        this.intMap = new HashMap<Integer, Interaction>();
        this.validateInteractions();
        this.addNewNodes(nodeMap);
        this.addNewEdges(nodeMap);
    }

    public long[] getNodeIndices() {
        long[] nodeIndices = new long[this.nodeList.size()];
        for (int i = 0; i < this.nodeList.size(); ++i) {
            CyNode node = this.nodeList.get(i);
            nodeIndices[i] = node.getSUID();
        }
        return nodeIndices;
    }

    public long[] getEdgeIndices() {
        long[] edgeIndices = new long[this.edgeList.size()];
        for (int i = 0; i < this.edgeList.size(); ++i) {
            CyEdge edge = this.edgeList.get(i);
            edgeIndices[i] = edge.getSUID();
        }
        return edgeIndices;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    private void validateInteractions() throws MapperException {
        String errorMsg = "In order to correctly graph your interactions, each interaction must specify exactly one bait value.";
        if (this.graphType == 1) {
            for (Interaction interaction : this.interactions) {
                List<Interactor> interactors = interaction.getInteractors();
                if (interactors.size() <= 2) continue;
                Map baitMap = (Map)interaction.getAttribute("BAIT_MAP");
                if (baitMap == null) {
                    throw new MapperException(errorMsg);
                }
                Interactor bait = this.determineBait(interactors, baitMap);
                if (bait != null) continue;
                throw new MapperException(errorMsg);
            }
        }
    }

    private void addNewNodes(Map<String, CyNode> nodeMap) {
        for (Interaction interaction : this.interactions) {
            for (Interactor interactor : interaction.getInteractors()) {
                this.addNode(interactor, nodeMap);
            }
        }
    }

    private void addNewEdges(Map<String, CyNode> nodeMap) {
        HashSet<String> edgeIds = new HashSet<String>();
        for (int i = 0; i < this.interactions.size(); ++i) {
            Interaction interaction = this.interactions.get(i);
            List<Interactor> interactors = interaction.getInteractors();
            if (this.graphType == 2) {
                this.doMatrixView(interactors, nodeMap, edgeIds, interaction);
                continue;
            }
            this.doSpokeView(interactors, nodeMap, edgeIds, interaction);
        }
    }

    private void doMatrixView(List<Interactor> interactors, Map<String, CyNode> nodeMap, Set<String> edgeIds, Interaction interaction) {
        if (interactors.size() <= 5) {
            for (int j = 0; j < interactors.size(); ++j) {
                for (int k = j + 1; k < interactors.size(); ++k) {
                    Interactor interactor1 = interactors.get(j);
                    Interactor interactor2 = interactors.get(k);
                    this.createEdge(interactor1, interactor2, interaction, nodeMap, edgeIds);
                }
            }
        } else {
            ExternalReference[] refs = interaction.getExternalRefs();
            StringBuffer refList = new StringBuffer();
            if (refs != null && refs.length > 0) {
                for (int i = 0; i < refs.length; ++i) {
                    String db = refs[i].getDatabase();
                    String id = refs[i].getId();
                    refList.append("[" + db + ":" + id + "] ");
                }
            } else {
                refList.append("[No Ids available]");
            }
            String warningMsg = new String("Interaction contains more than 5 interactors.  The interaction will not be mapped to  any Cytoscape edges.  The offending interaction is identified with the following identifiers:  " + refList);
            this.warnings.add(warningMsg);
        }
    }

    private void doSpokeView(List<Interactor> interactors, Map<String, CyNode> nodeMap, Set<String> edgeIds, Interaction interaction) {
        Map baitMap = (Map)interaction.getAttribute("BAIT_MAP");
        if (interactors.size() > 2) {
            Interactor bait = this.determineBait(interactors, baitMap);
            for (Interactor interactor : interactors) {
                String role = (String)baitMap.get(interactor.getName());
                boolean eliminateInteractorflag = false;
                if (role != null && role.equalsIgnoreCase("bait")) continue;
                if (role != null && !role.equalsIgnoreCase("prey")) {
                    if (!bait.getName().equalsIgnoreCase(interactor.getName())) {
                        this.createEdge(bait, interactor, interaction, nodeMap, edgeIds);
                        continue;
                    }
                    if (eliminateInteractorflag) {
                        this.createEdge(bait, interactor, interaction, nodeMap, edgeIds);
                        continue;
                    }
                    if (eliminateInteractorflag) continue;
                    eliminateInteractorflag = true;
                    continue;
                }
                this.createEdge(bait, interactor, interaction, nodeMap, edgeIds);
            }
        } else if (interactors.size() == 2) {
            Interactor interactor0 = interactors.get(0);
            Interactor interactor1 = interactors.get(1);
            if (interactor0 != null && interactor1 != null) {
                this.createEdge(interactor0, interactor1, interaction, nodeMap, edgeIds);
            }
        }
    }

    private Interactor determineBait(List<Interactor> interactors, Map<String, String> baitMap) {
        Interactor bait = null;
        for (int i = 0; i < interactors.size(); ++i) {
            Interactor interactor = interactors.get(i);
            String name = interactor.getName();
            String role = baitMap.get(name);
            if (role == null || !role.equalsIgnoreCase("bait")) continue;
            bait = interactor;
            AttributeUtil.setbaitStatus(0);
            break;
        }
        if (bait == null) {
            bait = this.determineBaitByName(interactors);
            AttributeUtil.setbaitStatus(1);
        }
        return bait;
    }

    private Interactor determineBaitByName(List<Interactor> interactors) {
        for (int i = 0; i < interactors.size(); ++i) {
            for (int j = 0; j < interactors.size() - 1; ++j) {
                Interactor interactor1 = interactors.get(j);
                Interactor interactor2 = interactors.get(j + 1);
                if (interactor1.getName().compareTo(interactor2.getName()) <= 0) continue;
                Interactor temp = interactor1;
                interactor1 = interactor2;
                interactor2 = temp;
            }
        }
        return interactors.get(0);
    }

    private void createEdge(Interactor interactor1, Interactor interactor2, Interaction interaction, Map<String, CyNode> nodeMap, Set<String> edgeIds) {
        String name1 = interactor1.getName();
        String name2 = interactor2.getName();
        CyNode node1 = nodeMap.get(name1);
        CyNode node2 = nodeMap.get(name2);
        String key = String.format("%s %s %s", name1, this.getInteractionTypeId(interaction), name2);
        if (!edgeIds.contains(key)) {
            CyEdge edge = this.network.addEdge(node1, node2, true);
            this.mapEdgeAttributes(interaction, edge, this.network);
            Long edgeRootGraphIndex = edge.getSUID();
            ArrayList<Long> indexes = (ArrayList<Long>)interaction.getAttribute(ROOT_GRAPH_INDEXES);
            if (indexes == null) {
                indexes = new ArrayList<Long>();
                interaction.addAttribute(ROOT_GRAPH_INDEXES, indexes);
            }
            indexes.add(edgeRootGraphIndex);
            this.intMap.put(interaction.getInteractionId(), interaction);
            edgeIds.add(key);
        }
    }

    private void addNode(Interactor interactor, Map<String, CyNode> map) {
        String name = interactor.getName();
        boolean inGraph = map.containsKey(name);
        if (!inGraph) {
            CyNode node = this.network.addNode();
            this.network.getRow((CyIdentifiable)node).set("name", (Object)name);
            this.nodeList.add(node);
            this.mapNodeAttributes(interactor, node, this.network);
            map.put(name, node);
        }
    }

    protected void mapNodeAttributes(Interactor interactor, CyNode cyNode, CyNetwork network) {
        Map<String, Object> attributeMap = interactor.getAllAttributes();
        CyRow attributes = network.getRow((CyIdentifiable)cyNode);
        for (Map.Entry<String, Object> entry : attributeMap.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof String)) continue;
            this.addAttribute(attributes, entry.getKey(), value);
        }
        ExternalReference[] refs = interactor.getExternalRefs();
        if (refs != null) {
            ArrayList<String> dbsList = new ArrayList<String>(refs.length);
            ArrayList<String> idsList = new ArrayList<String>(refs.length);
            for (int i = 0; i < refs.length; ++i) {
                ExternalReference ref = refs[i];
                dbsList.add(ref.getDatabase());
                idsList.add(ref.getId());
            }
            if (dbsList != null && dbsList.size() != 0) {
                this.addListAttribute(attributes, "XREF_DB_NAME", dbsList, String.class);
            }
            if (idsList != null && idsList.size() != 0) {
                this.addListAttribute(attributes, "XREF_DB_ID", idsList, String.class);
            }
        }
    }

    protected void mapEdgeAttributes(Interaction interaction, CyEdge cyEdge, CyNetwork network) {
        Map<String, Object> attributeMap = interaction.getAllAttributes();
        CyRow attributes = network.getRow((CyIdentifiable)cyEdge);
        for (Map.Entry<String, Object> entry : attributeMap.entrySet()) {
            String object;
            String key = entry.getKey();
            Object attrObject = entry.getValue();
            if (!(attrObject instanceof String)) continue;
            if (!this.attribExists(attributes, key)) {
                attributes.getTable().createColumn(key, String.class, false);
                object = null;
            } else {
                object = (String)attributes.get(key, String.class);
            }
            String str = (String)attrObject;
            if (object != null) {
                String[] values = AttributeUtil.appendString(object, str);
                if (values == null || values.toString().length() == 0) continue;
                attributes.set(key, (Object)values.toString());
                continue;
            }
            if (str == null || str.length() == 0) continue;
            attributes.set(key, (Object)str);
        }
        ExternalReference[] refs = interaction.getExternalRefs();
        if (refs != null) {
            ArrayList<String> dbsList = new ArrayList<String>(refs.length);
            ArrayList<String> idsList = new ArrayList<String>(refs.length);
            for (int i = 0; i < refs.length; ++i) {
                ExternalReference ref = refs[i];
                dbsList.add(ref.getDatabase());
                idsList.add(ref.getId());
            }
            if (dbsList != null && dbsList.size() != 0) {
                this.addListAttribute(attributes, "XREF_DB_NAME", dbsList, String.class);
            }
            if (idsList != null && idsList.size() != 0) {
                this.addListAttribute(attributes, "XREF_DB_ID", idsList, String.class);
            }
        }
    }

    private <T> void addAttribute(CyRow attributes, String name, T value) {
        if (!this.attribExists(attributes, name)) {
            attributes.getTable().createColumn(name, value.getClass(), false);
        }
        attributes.set(name, value);
    }

    private <T> void addListAttribute(CyRow attributes, String name, List<T> value, Class<T> listElementType) {
        if (!this.attribExists(attributes, name)) {
            attributes.getTable().createListColumn(name, listElementType, false);
        }
        attributes.set(name, value);
    }

    private boolean attribExists(CyRow attributes, String attrName) {
        return attributes.getTable().getColumn(attrName) != null;
    }

    protected String getInteractionTypeId(Interaction interaction) {
        StringBuffer key = new StringBuffer(OPEN_PAREN);
        String expType = (String)interaction.getAttribute("EXPERIMENTAL_SYSTEM_NAME");
        String shortName = (String)interaction.getAttribute("INTERACTION_SHORT_NAME");
        String pmid = (String)interaction.getAttribute("PUB_MED_ID");
        if (expType == null) {
            key.append(" <--> ");
        } else {
            key.append(expType);
        }
        if (shortName != null) {
            key.append(":" + shortName);
        }
        if (pmid != null) {
            key.append(":" + pmid);
        }
        key.append(CLOSE_PAREN);
        return key.toString();
    }
}

