/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.session.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.TableViewRenderer;
import org.cytoscape.event.CyEvent;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.group.CyGroupManager;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNetworkTableManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.model.CyTableMetadata;
import org.cytoscape.model.SavePolicy;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.property.CyProperty;
import org.cytoscape.property.SimpleCyProperty;
import org.cytoscape.property.bookmark.Bookmarks;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.CySession;
import org.cytoscape.session.CySessionManager;
import org.cytoscape.session.events.SessionAboutToBeSavedEvent;
import org.cytoscape.session.events.SessionLoadedEvent;
import org.cytoscape.session.events.SessionSavedEvent;
import org.cytoscape.session.events.SessionSavedListener;
import org.cytoscape.session.internal.CyTableMetadataImpl;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.model.table.CyColumnViewMetadata;
import org.cytoscape.view.model.table.CyRowViewMetadata;
import org.cytoscape.view.model.table.CyTableView;
import org.cytoscape.view.model.table.CyTableViewFactory;
import org.cytoscape.view.model.table.CyTableViewManager;
import org.cytoscape.view.model.table.CyTableViewMetadata;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.RenderingEngineManager;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.presentation.property.table.BasicTableVisualLexicon;
import org.cytoscape.view.vizmap.TableVisualMappingManager;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualPropertyDependency;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.undo.UndoSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CySessionManagerImpl
implements CySessionManager,
SessionSavedListener {
    private static Class<? extends CyIdentifiable>[] TYPES = new Class[]{CyNetwork.class, CyNode.class, CyEdge.class};
    private String currentFileName;
    private final Map<String, CyProperty<?>> sessionProperties;
    private CyProperty<Bookmarks> bookmarks;
    private boolean disposed;
    private final CyServiceRegistrar serviceRegistrar;
    private final Object lock = new Object();
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public CySessionManagerImpl(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.sessionProperties = new HashMap();
    }

    public CySession getCurrentSession() {
        SessionAboutToBeSavedEvent savingEvent = new SessionAboutToBeSavedEvent((CySessionManager)this);
        CyEventHelper eventHelper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
        eventHelper.fireEvent((CyEvent)savingEvent);
        Set<CyNetwork> networks = this.getSerializableNetworks();
        CyNetworkViewManager nvMgr = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
        Set netViews = nvMgr.getNetworkViewSet();
        HashMap<CyNetworkView, String> stylesMap = new HashMap<CyNetworkView, String>();
        VisualMappingManager vmMgr = (VisualMappingManager)this.serviceRegistrar.getService(VisualMappingManager.class);
        if (netViews != null) {
            for (CyNetworkView nv : netViews) {
                VisualStyle style = vmMgr.getVisualStyle(nv);
                if (style == null) continue;
                stylesMap.put(nv, style.getTitle());
            }
        }
        TableVisualMappingManager tblVmMgr = (TableVisualMappingManager)this.serviceRegistrar.getService(TableVisualMappingManager.class);
        CyTableViewManager tvMgr = (CyTableViewManager)this.serviceRegistrar.getService(CyTableViewManager.class);
        Set tableViews = tvMgr.getTableViewSet();
        HashSet<CyTableViewMetadata> tableViewMetadatas = new HashSet<CyTableViewMetadata>();
        for (CyTableView tableView : tableViews) {
            tableViewMetadatas.add(this.getTableViewMetadata(tableView));
        }
        Map appMap = savingEvent.getAppFileListMap();
        Set<CyTableMetadata> metadata = this.createTablesMetadata(networks);
        Set styles = vmMgr.getAllVisualStyles();
        Set<CyProperty<?>> props = this.getAllProperties();
        Set tableStyles = tblVmMgr.getAllVisualStyles();
        CySession sess = new CySession.Builder().properties(props).appFileListMap(appMap).tables(metadata).networks(networks).networkViews(netViews).tableViews(tableViewMetadatas).visualStyles(styles).tableStyles(tableStyles).viewVisualStyleMap(stylesMap).build();
        return sess;
    }

    private CyTableViewMetadata getTableViewMetadata(CyTableView tableView) {
        CyNetworkTableManager networkTableManager = (CyNetworkTableManager)this.serviceRegistrar.getService(CyNetworkTableManager.class);
        TableVisualMappingManager tableMappingManager = (TableVisualMappingManager)this.serviceRegistrar.getService(TableVisualMappingManager.class);
        VisualLexicon lexicon = this.getVisualLexicon(tableView);
        CyTable table = (CyTable)tableView.getModel();
        Long actualSuid = table.getPrimaryKey().getTable().getSUID();
        String namespace = networkTableManager.getTableNamespace(table);
        String rendererID = tableView.getRendererId();
        HashMap<String, String> tableBypasses = new HashMap<String, String>();
        for (Object vp : lexicon.getAllDescendants(BasicTableVisualLexicon.TABLE)) {
            if (!tableView.isDirectlyLocked((VisualProperty)vp)) continue;
            CySessionManagerImpl.addBypassValue(tableBypasses, (VisualProperty)vp, tableView.getVisualProperty((VisualProperty)vp));
        }
        ArrayList<CyColumnViewMetadata> columnMetadataList = new ArrayList<CyColumnViewMetadata>();
        for (View colView : tableView.getColumnViews()) {
            HashMap<String, String> colBypasses = new HashMap<String, String>();
            for (VisualProperty vp : lexicon.getAllDescendants(BasicTableVisualLexicon.COLUMN)) {
                if (!colView.isDirectlyLocked(vp)) continue;
                CySessionManagerImpl.addBypassValue(colBypasses, vp, colView.getVisualProperty(vp));
            }
            VisualStyle style = tableMappingManager.getVisualStyle(colView);
            String styleName = null;
            if (style != null) {
                styleName = style.getTitle();
            }
            String colName = ((CyColumn)colView.getModel()).getName();
            CyColumnViewMetadata colMetadata = new CyColumnViewMetadata(colName, styleName, colBypasses);
            columnMetadataList.add(colMetadata);
        }
        CyColumn keyCol = table.getPrimaryKey();
        ArrayList<CyRowViewMetadata> rowMetadataList = new ArrayList<CyRowViewMetadata>();
        for (View rowView : tableView.getRowViews()) {
            HashMap<String, String> rowBypasses = new HashMap<String, String>();
            for (VisualProperty vp : lexicon.getAllDescendants(BasicTableVisualLexicon.ROW)) {
                if (!rowView.isDirectlyLocked(vp)) continue;
                CySessionManagerImpl.addBypassValue(rowBypasses, vp, rowView.getVisualProperty(vp));
            }
            Object keyValue = ((CyRow)rowView.getModel()).get(keyCol.getName(), keyCol.getType());
            CyRowViewMetadata rowMetadata = new CyRowViewMetadata(keyValue, rowBypasses);
            rowMetadataList.add(rowMetadata);
        }
        return new CyTableViewMetadata(actualSuid.longValue(), namespace, rendererID, tableBypasses, columnMetadataList, rowMetadataList, keyCol.getType(), keyCol.getListElementType());
    }

    private static void addBypassValue(Map<String, String> bypassValues, VisualProperty vp, Object value) {
        String valueString = null;
        try {
            valueString = vp.toSerializableString(value);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (value != null) {
            bypassValues.put(vp.getIdString(), valueString);
        }
    }

    private VisualLexicon getVisualLexicon(CyTableView tableView) {
        RenderingEngineManager renderingEngineManager = (RenderingEngineManager)this.serviceRegistrar.getService(RenderingEngineManager.class);
        Collection renderingEngines = renderingEngineManager.getRenderingEngines((View)tableView);
        for (RenderingEngine re : renderingEngines) {
            if (!Objects.equals(tableView.getRendererId(), re.getRendererId())) continue;
            return re.getVisualLexicon();
        }
        logger.error("VisualLexicon not found for tableView while saving session: " + ((CyTable)tableView.getModel()).getTitle());
        return renderingEngineManager.getDefaultTableVisualLexicon();
    }

    private Set<CyNetwork> getSerializableNetworks() {
        HashSet<CyNetwork> serializableNetworks = new HashSet<CyNetwork>();
        CyNetworkTableManager netTblMgr = (CyNetworkTableManager)this.serviceRegistrar.getService(CyNetworkTableManager.class);
        Set allNetworks = netTblMgr.getNetworkSet();
        for (CyNetwork net : allNetworks) {
            if (net.getSavePolicy() != SavePolicy.SESSION_FILE) continue;
            serializableNetworks.add(net);
        }
        return serializableNetworks;
    }

    private Set<CyTableMetadata> createTablesMetadata(Set<CyNetwork> networks) {
        HashSet<CyTableMetadata> result = new HashSet<CyTableMetadata>();
        result.addAll(this.createNetworkTablesMetadata(networks));
        result.addAll(this.createGlobalTablesMetadata(((CyTableManager)this.serviceRegistrar.getService(CyTableManager.class)).getGlobalTables()));
        return result;
    }

    private Set<CyTableMetadata> createNetworkTablesMetadata(Set<CyNetwork> networks) {
        HashSet<CyTableMetadata> result = new HashSet<CyTableMetadata>();
        CyNetworkTableManager netTblMgr = (CyNetworkTableManager)this.serviceRegistrar.getService(CyNetworkTableManager.class);
        for (CyNetwork network : networks) {
            for (Class<? extends CyIdentifiable> type : TYPES) {
                Map tableMap = netTblMgr.getTables(network, type);
                for (Map.Entry entry : tableMap.entrySet()) {
                    CyTable tbl = (CyTable)entry.getValue();
                    if (tbl.getSavePolicy() != SavePolicy.SESSION_FILE) continue;
                    String namespace = (String)entry.getKey();
                    CyTableMetadata metadata = new CyTableMetadataImpl.CyTableMetadataBuilder().setCyTable(tbl).setNamespace(namespace).setType(type).setNetwork(network).build();
                    result.add(metadata);
                }
            }
        }
        return result;
    }

    private Collection<? extends CyTableMetadata> createGlobalTablesMetadata(Set<CyTable> tables) {
        HashSet<CyTableMetadataImpl.CyTableMetadataBuilder> result = new HashSet<CyTableMetadataImpl.CyTableMetadataBuilder>();
        for (CyTable tbl : tables) {
            if (tbl.getSavePolicy() != SavePolicy.SESSION_FILE) continue;
            result.add(new CyTableMetadataImpl.CyTableMetadataBuilder().setCyTable(tbl));
        }
        return result;
    }

    public void setCurrentSession(CySession sess, String fileName) {
        if (!this.disposed) {
            this.disposeCurrentSession();
        }
        if (sess == null) {
            logger.debug("Creating empty session...");
            VisualMappingManager vmMgr = (VisualMappingManager)this.serviceRegistrar.getService(VisualMappingManager.class);
            Set styles = vmMgr.getAllVisualStyles();
            Set<CyProperty<?>> props = this.getAllProperties();
            sess = new CySession.Builder().properties(props).visualStyles(styles).build();
        } else {
            logger.debug("Restoring the session...");
            ArrayList<CyNetwork> selectedNetworks = new ArrayList<CyNetwork>();
            Set networks = sess.getNetworks();
            for (CyNetwork n : networks) {
                Boolean selected = (Boolean)n.getDefaultNetworkTable().getRow((Object)n.getSUID()).get("selected", Boolean.class);
                if (!Boolean.TRUE.equals(selected)) continue;
                selectedNetworks.add(n);
            }
            this.restoreProperties(sess);
            this.restoreNetworks(sess);
            this.restoreTables(sess);
            this.restoreNetworkViews(sess, selectedNetworks);
            this.restoreNetworkSelection(sess, selectedNetworks);
            this.restoreVisualStyles(sess);
            this.restoreTableViews(sess);
            this.restoreCurrentVisualStyle();
        }
        this.currentFileName = fileName;
        this.disposed = false;
        CyEventHelper eventHelper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
        eventHelper.fireEvent((CyEvent)new SessionLoadedEvent((CySessionManager)this, sess, this.getCurrentSessionFileName()));
    }

    public void handleEvent(SessionSavedEvent e) {
        if (this.currentFileName != e.getSavedFileName()) {
            this.currentFileName = e.getSavedFileName();
        }
    }

    public String getCurrentSessionFileName() {
        return this.currentFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCyProperty(CyProperty<?> newCyProperty, Map<String, String> properties) {
        CyProperty.SavePolicy sp = newCyProperty.getSavePolicy();
        Object object = this.lock;
        synchronized (object) {
            if (sp == CyProperty.SavePolicy.SESSION_FILE || sp == CyProperty.SavePolicy.SESSION_FILE_AND_CONFIG_DIR) {
                if (Bookmarks.class.isAssignableFrom(newCyProperty.getPropertyType())) {
                    this.bookmarks = newCyProperty;
                } else {
                    this.sessionProperties.put(newCyProperty.getName(), newCyProperty);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCyProperty(CyProperty<?> oldCyProperty, Map<String, String> properties) {
        CyProperty.SavePolicy sp = oldCyProperty.getSavePolicy();
        Object object = this.lock;
        synchronized (object) {
            if (sp == CyProperty.SavePolicy.SESSION_FILE || sp == CyProperty.SavePolicy.SESSION_FILE_AND_CONFIG_DIR) {
                if (Bookmarks.class.isAssignableFrom(oldCyProperty.getPropertyType())) {
                    this.bookmarks = null;
                } else {
                    this.sessionProperties.remove(oldCyProperty.getName());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<CyProperty<?>> getAllProperties() {
        HashSet set;
        Object object = this.lock;
        synchronized (object) {
            set = new HashSet(this.sessionProperties.values());
        }
        if (this.bookmarks != null) {
            set.add(this.bookmarks);
        }
        return set;
    }

    private void restoreProperties(CySession sess) {
        for (CyProperty cyProps : sess.getProperties()) {
            CyProperty<?> oldCyProps = this.sessionProperties.get(cyProps.getName());
            if (oldCyProps != null && oldCyProps.getSavePolicy() == CyProperty.SavePolicy.SESSION_FILE_AND_CONFIG_DIR) {
                if (oldCyProps.getPropertyType() == Properties.class && cyProps.getPropertyType() == Properties.class) {
                    Properties oldProps = (Properties)oldCyProps.getProperties();
                    Properties newProps = (Properties)cyProps.getProperties();
                    for (String key : newProps.stringPropertyNames()) {
                        String newValue = newProps.getProperty(key);
                        oldProps.setProperty(key, newValue);
                    }
                    continue;
                }
                cyProps = new SimpleCyProperty(cyProps.getName(), cyProps.getProperties(), cyProps.getPropertyType(), CyProperty.SavePolicy.SESSION_FILE_AND_CONFIG_DIR);
                this.serviceRegistrar.unregisterAllServices(oldCyProps);
            }
            Properties serviceProps = new Properties();
            serviceProps.setProperty("cyPropertyName", cyProps.getName());
            this.serviceRegistrar.registerAllServices((Object)cyProps, serviceProps);
        }
    }

    private void restoreNetworks(CySession sess) {
        logger.debug("Restoring networks...");
        Set networks = sess.getNetworks();
        CyNetworkManager netMgr = (CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class);
        for (CyNetwork n : networks) {
            netMgr.addNetwork(n, false);
        }
    }

    private void restoreNetworkViews(CySession sess, List<CyNetwork> selectedNetworks) {
        logger.debug("Restoring network views...");
        Set netViews = sess.getNetworkViews();
        ArrayList<CyNetworkView> selectedViews = new ArrayList<CyNetworkView>();
        for (CyNetworkView nv : netViews) {
            CyNetwork network = (CyNetwork)nv.getModel();
            if (!selectedNetworks.contains(network)) continue;
            selectedViews.add(nv);
        }
        HashMap viewVPMap = new HashMap();
        if (netViews != null) {
            CyNetworkViewManager nvMgr = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
            for (CyNetworkView cyNetworkView : netViews) {
                if (cyNetworkView == null) continue;
                HashMap<VisualProperty, Object> vpMap = new HashMap<VisualProperty, Object>();
                viewVPMap.put(cyNetworkView, vpMap);
                vpMap.put(BasicVisualLexicon.NETWORK_HEIGHT, cyNetworkView.getVisualProperty(BasicVisualLexicon.NETWORK_HEIGHT));
                vpMap.put(BasicVisualLexicon.NETWORK_WIDTH, cyNetworkView.getVisualProperty(BasicVisualLexicon.NETWORK_WIDTH));
                nvMgr.addNetworkView(cyNetworkView, false);
            }
        }
        CyEventHelper eventHelper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
        eventHelper.flushPayloadEvents();
        for (Map.Entry entry : viewVPMap.entrySet()) {
            CyNetworkView nv = (CyNetworkView)entry.getKey();
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                nv.setVisualProperty((VisualProperty)entry2.getKey(), entry2.getValue());
            }
        }
        CyApplicationManager appMgr = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        if (!selectedViews.isEmpty()) {
            appMgr.setCurrentNetworkView((CyNetworkView)selectedViews.get(0));
        }
        appMgr.setSelectedNetworkViews(selectedViews);
    }

    private void restoreTableViews(CySession sess) {
        CyApplicationManager appManager = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        CyTableViewManager tableViewManager = (CyTableViewManager)this.serviceRegistrar.getService(CyTableViewManager.class);
        CyNetworkTableManager networkTableManager = (CyNetworkTableManager)this.serviceRegistrar.getService(CyNetworkTableManager.class);
        TableVisualMappingManager tableMappingManager = (TableVisualMappingManager)this.serviceRegistrar.getService(TableVisualMappingManager.class);
        Set styles = sess.getTableStyles();
        HashMap<String, VisualStyle> stylesMap = new HashMap<String, VisualStyle>();
        if (styles != null) {
            for (VisualStyle vs : styles) {
                stylesMap.put(vs.getTitle(), vs);
            }
        }
        Set tableViews = sess.getTableViews();
        for (CyTableViewMetadata tableViewMetadata : tableViews) {
            CyTableMetadata tableMetadata;
            TableViewRenderer renderer = appManager.getTableViewRenderer(tableViewMetadata.getRendererID());
            if (renderer == null || (tableMetadata = tableViewMetadata.getUnderlyingTable()) == null) continue;
            CyTable table = tableMetadata.getTable();
            if ("LOCAL_ATTRS".equals(tableMetadata.getNamespace()) && "USER".equals(tableViewMetadata.getNamespace())) {
                table = networkTableManager.getTable(tableMetadata.getNetwork(), tableMetadata.getType(), "USER");
            }
            CyTableViewFactory tableViewFactory = renderer.getTableViewFactory();
            CyTableView tableView = tableViewFactory.createTableView(table);
            VisualLexicon lexicon = renderer.getRenderingEngineFactory("").getVisualLexicon();
            this.restoreTableViewBypasses(sess, tableView, tableViewMetadata, lexicon);
            tableViewManager.setTableView(tableView);
            for (CyColumnViewMetadata colViewMeta : tableViewMetadata.getColumnViews()) {
                View colView;
                VisualStyle vs;
                String styleName = colViewMeta.getStyleName();
                if (styleName == null || (vs = (VisualStyle)stylesMap.get(styleName)) == null || (colView = tableView.getColumnView(colViewMeta.getName())) == null) continue;
                tableMappingManager.setVisualStyle(colView, vs);
                vs.apply(colView);
            }
        }
    }

    private void restoreTableViewBypasses(CySession sess, CyTableView tableView, CyTableViewMetadata tableViewMetadata, VisualLexicon lexicon) {
        for (Map.Entry entry : tableViewMetadata.getBypassValues().entrySet()) {
            Object parsedValue;
            String vpId = (String)entry.getKey();
            String vpStr = (String)entry.getValue();
            VisualProperty visualProperty = lexicon.lookup(CyTable.class, vpId);
            if (visualProperty == null || (parsedValue = visualProperty.parseSerializableString(vpStr)) == null) continue;
            tableView.setLockedValue(visualProperty, parsedValue);
        }
        for (CyColumnViewMetadata colViewMeta : tableViewMetadata.getColumnViews()) {
            View colView = tableView.getColumnView(colViewMeta.getName());
            if (colView == null) continue;
            for (Map.Entry entry : colViewMeta.getBypassValues().entrySet()) {
                Object parsedValue;
                String vpId = (String)entry.getKey();
                String vpStr = (String)entry.getValue();
                VisualProperty vp = lexicon.lookup(CyColumn.class, vpId);
                if (vp == null || (parsedValue = vp.parseSerializableString(vpStr)) == null) continue;
                colView.setLockedValue(vp, parsedValue);
            }
        }
        for (CyRowViewMetadata rowViewMeta : tableViewMetadata.getRowViews()) {
            CyRow row = ((CyTable)tableView.getModel()).getRow(rowViewMeta.getKeyValue());
            View rowView = tableView.getRowView(row);
            if (rowView == null) continue;
            for (Map.Entry entry : rowViewMeta.getBypassValues().entrySet()) {
                Object parsedValue;
                String vpId = (String)entry.getKey();
                String vpStr = (String)entry.getValue();
                VisualProperty vp = lexicon.lookup(CyRow.class, vpId);
                if (vp == null || (parsedValue = vp.parseSerializableString(vpStr)) == null) continue;
                rowView.setLockedValue(vp, parsedValue);
            }
        }
    }

    private void restoreTables(CySession sess) {
        HashSet<Object> allTables = new HashSet<Object>();
        for (CyTableMetadata metadata : sess.getTables()) {
            allTables.add(metadata.getTable());
        }
        CyNetworkTableManager netTblMgr = (CyNetworkTableManager)this.serviceRegistrar.getService(CyNetworkTableManager.class);
        CyRootNetworkManager rootNetMgr = (CyRootNetworkManager)this.serviceRegistrar.getService(CyRootNetworkManager.class);
        for (CyNetwork net : sess.getNetworks()) {
            allTables.addAll(netTblMgr.getTables(net, CyNetwork.class).values());
            allTables.addAll(netTblMgr.getTables(net, CyNode.class).values());
            allTables.addAll(netTblMgr.getTables(net, CyEdge.class).values());
            if (net instanceof CyRootNetwork) continue;
            CyRootNetwork cyRootNetwork = rootNetMgr.getRootNetwork(net);
            allTables.addAll(netTblMgr.getTables((CyNetwork)cyRootNetwork, CyNetwork.class).values());
            allTables.addAll(netTblMgr.getTables((CyNetwork)cyRootNetwork, CyNode.class).values());
            allTables.addAll(netTblMgr.getTables((CyNetwork)cyRootNetwork, CyEdge.class).values());
        }
        CyTableManager tblMgr = (CyTableManager)this.serviceRegistrar.getService(CyTableManager.class);
        for (CyTable cyTable : allTables) {
            if (tblMgr.getTable(cyTable.getSUID().longValue()) != null) continue;
            tblMgr.addTable(cyTable);
        }
    }

    private void restoreVisualStyles(CySession sess) {
        Map viewStyleMap;
        logger.debug("Restoring visual styles...");
        VisualMappingManager vmMgr = (VisualMappingManager)this.serviceRegistrar.getService(VisualMappingManager.class);
        VisualStyle defStyle = vmMgr.getDefaultVisualStyle();
        String DEFAULT_STYLE_NAME = defStyle.getTitle();
        Set styles = sess.getVisualStyles();
        HashMap<String, VisualStyle> stylesMap = new HashMap<String, VisualStyle>();
        RenderingEngineManager engineManager = (RenderingEngineManager)this.serviceRegistrar.getService(RenderingEngineManager.class);
        VisualLexicon lexicon = engineManager.getDefaultVisualLexicon();
        if (styles != null) {
            for (VisualStyle vs : styles) {
                if (vs.getTitle().equals(DEFAULT_STYLE_NAME)) {
                    CySessionManagerImpl.updateVisualStyle(vs, defStyle, lexicon);
                    vs = defStyle;
                }
                stylesMap.put(vs.getTitle(), vs);
                if (vs.equals(defStyle)) continue;
                vmMgr.addVisualStyle(vs);
            }
        }
        if ((viewStyleMap = sess.getViewVisualStyleMap()) != null) {
            for (Map.Entry entry : viewStyleMap.entrySet()) {
                CyNetworkView netView = (CyNetworkView)entry.getKey();
                String stName = (String)entry.getValue();
                VisualStyle vs = (VisualStyle)stylesMap.get(stName);
                if (vs == null) {
                    vs = defStyle;
                }
                if (vs == null) continue;
                vmMgr.setVisualStyle(vs, netView);
                vs.apply(netView);
            }
        }
    }

    private static void updateVisualStyle(VisualStyle source, VisualStyle target, VisualLexicon lexicon) {
        HashSet mapingSet = new HashSet(target.getAllVisualMappingFunctions());
        for (Object mapping : mapingSet) {
            target.removeVisualMappingFunction(mapping.getVisualProperty());
        }
        HashSet depList = new HashSet(target.getAllVisualPropertyDependencies());
        for (VisualPropertyDependency dep : depList) {
            target.removeVisualPropertyDependency(dep);
        }
        Set properties = lexicon.getAllVisualProperties();
        for (VisualProperty vp : properties) {
            if (vp.equals(BasicVisualLexicon.NETWORK) || vp.equals(BasicVisualLexicon.NODE) || vp.equals(BasicVisualLexicon.EDGE) || vp.equals(BasicTableVisualLexicon.TABLE) || vp.equals(BasicTableVisualLexicon.COLUMN) || vp.equals(BasicTableVisualLexicon.TABLE)) continue;
            target.setDefaultValue(vp, source.getDefaultValue(vp));
        }
        for (VisualPropertyDependency dep : source.getAllVisualPropertyDependencies()) {
            target.addVisualPropertyDependency(dep);
        }
        for (VisualMappingFunction mapping : source.getAllVisualMappingFunctions()) {
            target.addVisualMappingFunction(mapping);
        }
    }

    private void restoreNetworkSelection(CySession sess, List<CyNetwork> selectedNets) {
        if (!selectedNets.isEmpty()) {
            CyNetwork cn = selectedNets.get(0);
            CyApplicationManager appMgr = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
            appMgr.setCurrentNetwork(cn);
            CyNetworkViewManager nvMgr = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
            Collection cnViews = nvMgr.getNetworkViews(cn);
            CyNetworkView cv = cnViews.isEmpty() ? null : (CyNetworkView)cnViews.iterator().next();
            appMgr.setCurrentNetworkView(cv);
            appMgr.setSelectedNetworks(selectedNets);
        }
    }

    private void restoreCurrentVisualStyle() {
        VisualMappingManager vmMgr;
        VisualStyle style;
        CyEventHelper eventHelper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
        eventHelper.flushPayloadEvents();
        CyApplicationManager appMgr = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        CyNetworkView cv = appMgr.getCurrentNetworkView();
        if (cv != null && (style = (vmMgr = (VisualMappingManager)this.serviceRegistrar.getService(VisualMappingManager.class)).getVisualStyle(cv)) != null && !style.equals(vmMgr.getCurrentVisualStyle())) {
            vmMgr.setCurrentVisualStyle(style);
        }
    }

    public void disposeCurrentSession() {
        logger.debug("Disposing current session...");
        CyNetworkViewManager nvMgr = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
        for (Object nv : nvMgr.getNetworkViewSet()) {
            nvMgr.destroyNetworkView((CyNetworkView)nv);
        }
        nvMgr.reset();
        CyTableViewManager tvMgr = (CyTableViewManager)this.serviceRegistrar.getService(CyTableViewManager.class);
        for (CyTableView tv : tvMgr.getTableViewSet()) {
            tvMgr.destroyTableView(tv);
        }
        tvMgr.reset();
        CyNetworkManager netMgr = (CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class);
        Set networks = netMgr.getNetworkSet();
        for (CyNetwork n : networks) {
            netMgr.destroyNetwork(n);
        }
        netMgr.reset();
        logger.debug("Removing current visual styles...");
        VisualMappingManager vmMgr = (VisualMappingManager)this.serviceRegistrar.getService(VisualMappingManager.class);
        VisualStyle defaultStyle = vmMgr.getDefaultVisualStyle();
        ArrayList allStyles = new ArrayList(vmMgr.getAllVisualStyles());
        for (VisualStyle vs : allStyles) {
            if (vs.equals(defaultStyle)) continue;
            vmMgr.removeVisualStyle(vs);
        }
        CyTableManager tblMgr = (CyTableManager)this.serviceRegistrar.getService(CyTableManager.class);
        tblMgr.reset();
        ((CyGroupManager)this.serviceRegistrar.getService(CyGroupManager.class)).reset();
        Set<CyProperty<?>> cyPropsClone = this.getAllProperties();
        for (CyProperty<?> cyProps : cyPropsClone) {
            if (!cyProps.getSavePolicy().equals((Object)CyProperty.SavePolicy.SESSION_FILE)) continue;
            this.serviceRegistrar.unregisterAllServices(cyProps);
            this.sessionProperties.remove(cyProps.getName());
        }
        ((UndoSupport)this.serviceRegistrar.getService(UndoSupport.class)).reset();
        CyApplicationManager appMgr = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        appMgr.reset();
        this.currentFileName = null;
        this.disposed = true;
    }
}

