/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.browser.internal.view;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JPopupMenu;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.browser.internal.util.TableBrowserUtil;
import org.cytoscape.browser.internal.view.AbstractTableBrowser;
import org.cytoscape.browser.internal.view.TableChooserCellRenderer;
import org.cytoscape.browser.internal.view.TableRenderer;
import org.cytoscape.browser.internal.view.tools.AbstractToolBarControl;
import org.cytoscape.browser.internal.view.tools.GeneralOptionsControl;
import org.cytoscape.browser.internal.view.tools.RowHeightControl;
import org.cytoscape.browser.internal.view.tools.ViewModeControl;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkTableManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.TextIcon;
import org.cytoscape.view.presentation.property.table.TableMode;
import org.cytoscape.view.presentation.property.table.TableModeVisualProperty;

public class DefaultTableBrowser
extends AbstractTableBrowser {
    private JPopupMenu displayMode;
    private JComboBox<CyTable> tableChooser;
    private ViewModeControl viewModeControl;
    private boolean ignoreSetCurrentTable = true;

    public DefaultTableBrowser(String tabTitle, Class<? extends CyIdentifiable> objType, CyServiceRegistrar serviceRegistrar) {
        super(tabTitle, objType, serviceRegistrar);
        ArrayList<AbstractToolBarControl> controls = new ArrayList<AbstractToolBarControl>();
        if (objType != CyNetwork.class) {
            this.viewModeControl = new ViewModeControl(serviceRegistrar);
            controls.add(this.viewModeControl);
        }
        controls.add(new RowHeightControl(serviceRegistrar));
        controls.add(new GeneralOptionsControl(objType, serviceRegistrar));
        this.getOptionsBar().setFormatControls(controls);
        this.createPopupMenu();
    }

    public String getIdentifier() {
        return "org.cytoscape." + this.objType.getSimpleName().replace("Cy", "") + "Tables";
    }

    private TableMode getTableMode() {
        TableRenderer renderer = this.getCurrentRenderer();
        return renderer == null ? TableRenderer.getDefaultTableMode() : renderer.getTableMode();
    }

    private void setTableMode(TableMode mode) {
        TableRenderer renderer = this.getCurrentRenderer();
        renderer.setTableMode(mode);
    }

    @Override
    public Icon getIcon() {
        if (this.icon == null) {
            String text = null;
            if (this.objType == CyNode.class) {
                text = "#";
            } else if (this.objType == CyEdge.class) {
                text = "!";
            } else if (this.objType == CyNetwork.class) {
                text = "\"";
            }
            if (text != null) {
                this.icon = new TextIcon(text, ((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont("cytoscape-3", 14.0f), 16, 16);
            } else {
                return super.getIcon();
            }
        }
        return this.icon;
    }

    private void createPopupMenu() {
        this.displayMode = new JPopupMenu();
        TableMode tableMode = this.getTableMode();
        JCheckBoxMenuItem displayAuto = new JCheckBoxMenuItem("Auto");
        displayAuto.setSelected(tableMode == TableModeVisualProperty.AUTO);
        JCheckBoxMenuItem displayAll = new JCheckBoxMenuItem("Show all");
        displayAll.setSelected(tableMode == TableModeVisualProperty.ALL);
        JCheckBoxMenuItem displaySelect = new JCheckBoxMenuItem("Show selected");
        displaySelect.setSelected(tableMode == TableModeVisualProperty.SELECTED);
        displayAuto.addActionListener(e -> {
            this.setTableMode(TableModeVisualProperty.AUTO);
            displayAuto.setSelected(true);
            displayAll.setSelected(false);
            displaySelect.setSelected(false);
        });
        displayAll.addActionListener(e -> {
            this.setTableMode(TableModeVisualProperty.ALL);
            displayAuto.setSelected(false);
            displayAll.setSelected(true);
            displaySelect.setSelected(false);
        });
        displaySelect.addActionListener(e -> {
            this.setTableMode(TableModeVisualProperty.SELECTED);
            displayAuto.setSelected(false);
            displayAll.setSelected(false);
            displaySelect.setSelected(true);
        });
        this.displayMode.add(displayAuto);
        this.displayMode.add(displayAll);
        this.displayMode.add(displaySelect);
    }

    public void setCurrentTable() {
        if (!this.ignoreSetCurrentTable) {
            CyTableManager tableManager;
            CyTable table = (CyTable)this.getTableChooser().getSelectedItem();
            this.setCurrentTable(table);
            this.showSelectedTable();
            if (this.viewModeControl != null && table != null) {
                this.viewModeControl.setVisible(table.getPrimaryKey().getType() == Long.class);
            }
            CyApplicationManager applicationManager = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
            if (table != null && !table.equals(applicationManager.getCurrentTable()) && (tableManager = (CyTableManager)this.serviceRegistrar.getService(CyTableManager.class)).getTable(table.getSUID().longValue()) != null) {
                applicationManager.setCurrentTable(table);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(CyNetwork network) {
        if (network != null) {
            if (this.objType == CyNode.class) {
                this.setCurrentTable(network.getDefaultNodeTable());
            } else if (this.objType == CyEdge.class) {
                this.setCurrentTable(network.getDefaultEdgeTable());
            } else {
                this.setCurrentTable(network.getDefaultNetworkTable());
            }
            this.currentTableType = this.objType;
        } else {
            this.setCurrentTable(null);
            this.currentTableType = null;
        }
        Set<CyTable> tables = this.getPublicTables(network);
        this.ignoreSetCurrentTable = true;
        try {
            this.getTableChooser().removeAllItems();
            if (this.currentTable != null) {
                for (CyTable tbl : tables) {
                    this.getTableChooser().addItem(tbl);
                }
                this.getTableChooser().setSelectedItem(this.currentTable);
            }
        }
        finally {
            this.ignoreSetCurrentTable = false;
        }
        this.showSelectedTable();
    }

    @Override
    protected JComboBox<CyTable> getTableChooser() {
        if (this.tableChooser == null) {
            this.tableChooser = new JComboBox(new DefaultComboBoxModel());
            this.tableChooser.setRenderer(new TableChooserCellRenderer(this.serviceRegistrar));
            this.tableChooser.setMaximumSize(new Dimension(600, this.tableChooser.getPreferredSize().height));
            this.tableChooser.setVisible(false);
            this.tableChooser.addActionListener(e -> this.setCurrentTable());
            this.tableChooser.getModel().addListDataListener(new ListDataListener(){

                @Override
                public void intervalRemoved(ListDataEvent e) {
                    this.setVisible();
                }

                @Override
                public void intervalAdded(ListDataEvent e) {
                    this.setVisible();
                }

                @Override
                public void contentsChanged(ListDataEvent e) {
                }

                private void setVisible() {
                    DefaultTableBrowser.this.tableChooser.setVisible(DefaultTableBrowser.this.tableChooser.getItemCount() > 1);
                }
            });
        }
        this.tableChooser.getEditor().setItem("");
        return this.tableChooser;
    }

    private Set<CyTable> getPublicTables(CyNetwork network) {
        LinkedHashSet<CyTable> tables = new LinkedHashSet<CyTable>();
        if (network == null) {
            return tables;
        }
        CyNetworkTableManager netTableManager = (CyNetworkTableManager)this.serviceRegistrar.getService(CyNetworkTableManager.class);
        Map map = netTableManager.getTables(network, this.objType);
        if (TableBrowserUtil.isShowPrivateTables(this.serviceRegistrar)) {
            tables.addAll(map.values());
        } else {
            for (CyTable tbl : map.values()) {
                if (!tbl.isPublic()) continue;
                tables.add(tbl);
            }
        }
        return tables;
    }
}

