/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.browser.internal.util;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.slf4j.Logger;

public class ViewUtil {
    public static void invokeOnEDT(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void invokeOnEDTAndWait(Runnable runnable) {
        ViewUtil.invokeOnEDTAndWait(runnable, null);
    }

    public static void invokeOnEDTAndWait(Runnable runnable, Logger logger) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception e) {
                if (logger != null) {
                    logger.error("Unexpected error", (Throwable)e);
                }
                e.printStackTrace();
            }
        }
    }

    public static void styleToolBarButton(AbstractButton btn) {
        ViewUtil.styleToolBarButton(btn, null, true);
    }

    public static void styleToolBarButton(AbstractButton btn, boolean addPadding) {
        ViewUtil.styleToolBarButton(btn, null, addPadding);
    }

    public static void styleToolBarButton(AbstractButton btn, Font font) {
        ViewUtil.styleToolBarButton(btn, font, true);
    }

    public static void styleToolBarButton(AbstractButton btn, Font font, boolean addPadding) {
        int hPad = addPadding ? 5 : 0;
        int vPad = addPadding ? 4 : 0;
        ViewUtil.styleToolBarButton(btn, font, hPad, vPad);
    }

    public static void styleToolBarButton(AbstractButton btn, int width, int height, Font font) {
        ViewUtil.styleToolBarButton(btn, font, 0, 0);
        Dimension d = new Dimension(width, height);
        btn.setPreferredSize(d);
        btn.setMinimumSize(d);
        btn.setMaximumSize(d);
        btn.setSize(d);
    }

    public static void styleToolBarButton(AbstractButton btn, Font font, int hPad, int vPad) {
        if (font != null) {
            btn.setFont(font);
        }
        btn.setFocusPainted(false);
        btn.setFocusable(false);
        btn.setBorder(BorderFactory.createEmptyBorder());
        btn.setContentAreaFilled(false);
        btn.setOpaque(true);
        btn.setHorizontalTextPosition(0);
        btn.setVerticalTextPosition(1);
        if (hPad > 0 || vPad > 0) {
            Dimension d = btn.getPreferredSize();
            d = new Dimension(d.width + 2 * hPad, d.height + 2 * vPad);
            btn.setPreferredSize(d);
            btn.setMinimumSize(d);
            btn.setMaximumSize(d);
            btn.setSize(d);
        }
        if (btn instanceof JToggleButton) {
            btn.addItemListener(evt -> ViewUtil.updateToolBarStyle((JToggleButton)btn));
            ViewUtil.updateToolBarStyle((JToggleButton)btn);
        }
    }

    public static void updateToolBarStyle(JToggleButton btn) {
        ViewUtil.updateToolBarStyle(btn, true);
    }

    public static void updateToolBarStyle(JToggleButton btn, boolean showSelectionBorder) {
        Border defBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        if (btn.isEnabled()) {
            Border selBorder = showSelectionBorder ? BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, UIManager.getColor("CyToggleButton[Selected].borderColor")), BorderFactory.createEmptyBorder(1, 1, 1, 1)) : defBorder;
            btn.setBorder(btn.isSelected() ? selBorder : defBorder);
            btn.setBackground(btn.isSelected() ? UIManager.getColor("CyToggleButton[Selected].background") : UIManager.getColor("CyToggleButton.background"));
            btn.setForeground(btn.isSelected() ? UIManager.getColor("CyToggleButton[Selected].foreground") : UIManager.getColor("CyToggleButton.foreground"));
        } else {
            btn.setBorder(defBorder);
            btn.setForeground(UIManager.getColor("ToggleButton.disabledForeground"));
            btn.setBackground(UIManager.getColor("CyToggleButton.unselectedBackground"));
        }
    }

    public static JSeparator createToolBarSeparator() {
        ToolBarSeparator sep = new ToolBarSeparator(1);
        sep.setForeground(UIManager.getColor("Separator.foreground"));
        return sep;
    }

    private ViewUtil() {
    }

    private static class ToolBarSeparator
    extends JSeparator {
        ToolBarSeparator(int orientation) {
            super(orientation);
        }

        @Override
        public void paint(Graphics g) {
            Dimension s = this.getSize();
            if (this.getOrientation() == 1) {
                g.setColor(this.getForeground());
                g.drawLine(0, 0, 0, s.height);
            } else {
                g.setColor(this.getForeground());
                g.drawLine(0, 0, s.width, 0);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.getOrientation() == 1) {
                return new Dimension(1, 0);
            }
            return new Dimension(0, 1);
        }
    }
}

