/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.browser.internal.task;

import org.cytoscape.browser.internal.task.ClearAllErrorsTask;
import org.cytoscape.browser.internal.util.TableBrowserUtil;
import org.cytoscape.equations.Equation;
import org.cytoscape.equations.EquationCompiler;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractTableColumnTaskFactory;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

public final class ClearAllErrorsTaskFactory
extends AbstractTableColumnTaskFactory {
    private final CyServiceRegistrar serviceRegistrar;

    public ClearAllErrorsTaskFactory(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public TaskIterator createTaskIterator(CyColumn column) {
        if (column == null) {
            throw new IllegalStateException("you forgot to set the CyColumn on this task factory.");
        }
        return new TaskIterator(new Task[]{new ClearAllErrorsTask(column, this.serviceRegistrar)});
    }

    public boolean isReady(CyColumn column) {
        CyTable table = column.getTable();
        EquationCompiler compiler = (EquationCompiler)this.serviceRegistrar.getService(EquationCompiler.class);
        for (CyRow row : table.getAllRows()) {
            Equation eq;
            boolean success;
            Object raw = row.getRaw(column.getName());
            if (!(raw instanceof Equation) || (success = compiler.compile((eq = (Equation)raw).toString(), TableBrowserUtil.getAttNameToTypeMap(table, null))) && row.get(column.getName(), column.getType()) != null) continue;
            return true;
        }
        return false;
    }
}

