/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.enfin.mi.cluster;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.log4j.Logger;
import org.hupo.psi.mi.psicquic.registry.ServiceType;
import org.hupo.psi.mi.psicquic.registry.client.PsicquicRegistryClientException;
import org.hupo.psi.mi.psicquic.registry.client.registry.DefaultPsicquicRegistryClient;
import org.hupo.psi.mi.psicquic.wsclient.PsicquicSimpleClient;
import psidev.psi.mi.tab.PsimiTabReader;
import psidev.psi.mi.tab.model.BinaryInteraction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PsicquicService {
    private static Logger logger = Logger.getLogger(PsicquicService.class);
    private ServiceType service;
    private String serviceName;

    public PsicquicService(String serviceName) {
        this.serviceName = serviceName;
        DefaultPsicquicRegistryClient registryClient = new DefaultPsicquicRegistryClient();
        try {
            this.service = registryClient.getService(serviceName);
            if (this.service == null) {
                logger.warn((Object)("Could not find service for " + this.serviceName));
            }
        }
        catch (PsicquicRegistryClientException e) {
            e.printStackTrace();
            logger.error((Object)("Could not get " + serviceName + " psicquic service"));
            logger.error((Object)e);
        }
    }

    public ServiceType getService() {
        return this.service;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Integer countInteractions(String query) throws IOException {
        Integer psicquicCount = null;
        if (this.service.isActive()) {
            String encoded = URLEncoder.encode(query, "UTF-8");
            encoded = encoded.replaceAll("\\+", "%20");
            String url = this.service.getRestUrl();
            PsicquicSimpleClient client = new PsicquicSimpleClient(url);
            logger.info((Object)("Querying ..." + url));
            psicquicCount = Long.valueOf(client.countByQuery(query)).intValue();
        } else {
            logger.warn((Object)(this.serviceName + " psicquic service not active"));
        }
        return psicquicCount;
    }

    public List<BinaryInteraction> getInteractions(String query, int firstResult, int maxNumberOfResults) throws IOException {
        String str;
        ArrayList<BinaryInteraction> results = new ArrayList<BinaryInteraction>(Math.min(2048, maxNumberOfResults));
        String url = this.service.getRestUrl();
        PsicquicSimpleClient client = new PsicquicSimpleClient(url);
        InputStream is = client.getByQuery(query, "tab25-bin", firstResult, maxNumberOfResults);
        GZIPInputStream gzipIs = new GZIPInputStream(is);
        PsimiTabReader tabReader = new PsimiTabReader(false);
        BufferedReader in = new BufferedReader(new InputStreamReader(gzipIs));
        while ((str = in.readLine()) != null) {
            BinaryInteraction interaction = tabReader.readLine(str);
            results.add(interaction);
        }
        in.close();
        return results;
    }
}

