/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.enfin.mi.cluster;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hupo.psi.mi.psicquic.registry.ServiceType;
import org.hupo.psi.mi.psicquic.registry.client.PsicquicRegistryClientException;
import org.hupo.psi.mi.psicquic.registry.client.registry.DefaultPsicquicRegistryClient;
import psidev.psi.mi.tab.PsimiTabWriter;
import psidev.psi.mi.tab.model.BinaryInteraction;
import uk.ac.ebi.enfin.mi.cluster.AbstractInteractionCluster;
import uk.ac.ebi.enfin.mi.cluster.ClusterServiceException;
import uk.ac.ebi.enfin.mi.cluster.Encore2Binary;
import uk.ac.ebi.enfin.mi.cluster.EncoreInteraction;
import uk.ac.ebi.enfin.mi.cluster.MethodTypePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractionCluster
extends AbstractInteractionCluster<EncoreInteraction> {
    private static final Logger logger = Logger.getLogger(InteractionCluster.class);
    protected List<String> querySources = new ArrayList<String>();
    protected List<String> queryAccs = new ArrayList<String>();

    public InteractionCluster() {
        super(0, 200);
        this.interactionMapping = new HashMap();
        this.interactorMapping = new HashMap();
        this.synonymMapping = new HashMap();
    }

    public InteractionCluster(List<BinaryInteraction> binaryInteractionList, String mappingIdDbNames) {
        super(binaryInteractionList, mappingIdDbNames);
        this.interactionMapping = new HashMap();
        this.interactorMapping = new HashMap();
        this.synonymMapping = new HashMap();
    }

    public InteractionCluster(List<BinaryInteraction> binaryInteractionList) {
        super(binaryInteractionList);
        this.interactionMapping = new HashMap();
        this.interactorMapping = new HashMap();
        this.synonymMapping = new HashMap();
    }

    public InteractionCluster(InputStream is, boolean hasHeader) throws ClusterServiceException {
        super(is, hasHeader);
        this.interactionMapping = new HashMap();
        this.interactorMapping = new HashMap();
        this.synonymMapping = new HashMap();
    }

    public InteractionCluster(Reader r, boolean hasHeader) throws ClusterServiceException {
        super(r, hasHeader);
        this.interactionMapping = new HashMap();
        this.interactorMapping = new HashMap();
        this.synonymMapping = new HashMap();
    }

    public InteractionCluster(Iterator<BinaryInteraction> iterator) throws ClusterServiceException {
        super(iterator);
        this.interactionMapping = new HashMap();
        this.interactorMapping = new HashMap();
        this.synonymMapping = new HashMap();
    }

    public InteractionCluster(int queryStart, int queryRange) {
        super(queryStart, queryRange);
        this.interactionMapping = new HashMap();
        this.interactorMapping = new HashMap();
        this.synonymMapping = new HashMap();
    }

    public InteractionCluster(int queryStart, int queryRange, String mappingIdDbNames) {
        super(queryStart, queryRange, mappingIdDbNames);
        this.interactionMapping = new HashMap();
        this.interactorMapping = new HashMap();
        this.synonymMapping = new HashMap();
    }

    public InteractionCluster(String mappingIdDbNames) {
        super(mappingIdDbNames);
        this.interactionMapping = new HashMap();
        this.interactorMapping = new HashMap();
        this.synonymMapping = new HashMap();
    }

    public InteractionCluster(List<String> miqlQueries, List<String> querySource, int queryStart, int queryRange) {
        super(queryStart, queryRange);
        if (miqlQueries != null) {
            this.queryAccs = miqlQueries;
        }
        if (querySource != null) {
            this.querySources = querySource;
        }
        this.interactionMapping = new HashMap();
        this.interactorMapping = new HashMap();
        this.synonymMapping = new HashMap();
    }

    public InteractionCluster(List<String> miqlQueries, List<String> querySource, int queryStart, int queryRange, String mappingIdDbNames) {
        super(queryStart, queryRange, mappingIdDbNames);
        if (miqlQueries != null) {
            this.queryAccs = miqlQueries;
        }
        if (querySource != null) {
            this.querySources = querySource;
        }
        this.interactionMapping = new HashMap();
        this.interactorMapping = new HashMap();
        this.synonymMapping = new HashMap();
    }

    public InteractionCluster(String miqlQuery, String querySource, int queryStart, int queryRange) {
        super(queryStart, queryRange);
        this.addMIQLQuery(miqlQuery);
        this.addQuerySource(querySource);
    }

    public InteractionCluster(String miqlQuery, String querySource, int queryStart, int queryRange, String mappingIdDbNames) {
        super(queryStart, queryRange, mappingIdDbNames);
        this.addMIQLQuery(miqlQuery);
        this.addQuerySource(querySource);
    }

    public InteractionCluster(String miqlQuery, String querySource, String mappingIdDbNames) {
        super(mappingIdDbNames);
        this.addMIQLQuery(miqlQuery);
        this.addQuerySource(querySource);
    }

    public InteractionCluster(String miqlQuery, String querySource) {
        super(0, 200);
        this.addMIQLQuery(miqlQuery);
        this.addQuerySource(querySource);
    }

    @Override
    protected void setMappingForPsicquic() {
        if (this.queryAccs.size() > 0 && this.querySources.size() > 0) {
            for (String queryAcc : this.queryAccs) {
                for (String querySource : this.querySources) {
                    try {
                        super.setMappingForPsicquic(queryAcc, querySource);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    protected EncoreInteraction convertEncoreInteractionFrom(BinaryInteraction binaryInteraction, String[] strings) {
        this.binary2Encore.setIdDbNameList(strings);
        return this.binary2Encore.getEncoreInteractionForScoring(binaryInteraction);
    }

    @Override
    protected void processMethodAndType(EncoreInteraction encoreInteraction, EncoreInteraction mappingEncoreInteraction) {
        Map<MethodTypePair, List<String>> existingMethodTypeToPubmed = mappingEncoreInteraction.getMethodTypePairListMap();
        for (Map.Entry<MethodTypePair, List<String>> entry : encoreInteraction.getMethodTypePairListMap().entrySet()) {
            if (existingMethodTypeToPubmed.containsKey(entry.getKey())) {
                List<String> existingPubmeds = existingMethodTypeToPubmed.get(entry.getKey());
                List<String> newPubmeds = encoreInteraction.getMethodTypePairListMap().get(entry.getKey());
                for (String pub : newPubmeds) {
                    if (existingPubmeds.contains(pub)) continue;
                    existingPubmeds.add(pub);
                }
                continue;
            }
            existingMethodTypeToPubmed.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void saveResultsInMitab(String fileName) throws IOException {
        PsimiTabWriter writer = new PsimiTabWriter();
        File file = new File(fileName);
        Map interactionMapping = this.getInteractionMapping();
        Encore2Binary iConverter = new Encore2Binary(this.getMappingIdDbNames());
        for (Integer mappingId : interactionMapping.keySet()) {
            EncoreInteraction eI = (EncoreInteraction)interactionMapping.get(mappingId);
            BinaryInteraction bI = iConverter.getBinaryInteractionForScoring(eI);
            writer.writeOrAppend(bI, file, false);
        }
    }

    @Override
    protected EncoreInteraction mergeWithExistingEncoreInteraction(EncoreInteraction encoreInteraction, int interactionIdFound) {
        EncoreInteraction mappingEcoreInteraction = (EncoreInteraction)this.interactionMapping.get(interactionIdFound);
        if (mappingEcoreInteraction == null) {
            throw new IllegalStateException("Could not find an EncoreInteraction with id: " + interactionIdFound);
        }
        boolean swapInteractors = true;
        for (String acc : mappingEcoreInteraction.getInteractorAccsA().values()) {
            if (!encoreInteraction.getInteractorAccsA().containsValue(acc)) continue;
            swapInteractors = false;
            break;
        }
        if (swapInteractors) {
            mappingEcoreInteraction.addInteractorAccsA(encoreInteraction.getInteractorAccsB());
            mappingEcoreInteraction.addInteractorAccsB(encoreInteraction.getInteractorAccsA());
            mappingEcoreInteraction.addOtherInteractorAccsA(encoreInteraction.getOtherInteractorAccsB());
            mappingEcoreInteraction.addOtherInteractorAccsB(encoreInteraction.getOtherInteractorAccsA());
            mappingEcoreInteraction.addOrganismsA(encoreInteraction.getOrganismsB());
            mappingEcoreInteraction.addOrganismsB(encoreInteraction.getOrganismsA());
        } else {
            mappingEcoreInteraction.addInteractorAccsA(encoreInteraction.getInteractorAccsA());
            mappingEcoreInteraction.addInteractorAccsB(encoreInteraction.getInteractorAccsB());
            mappingEcoreInteraction.addOtherInteractorAccsA(encoreInteraction.getOtherInteractorAccsA());
            mappingEcoreInteraction.addOtherInteractorAccsB(encoreInteraction.getOtherInteractorAccsB());
            mappingEcoreInteraction.addOrganismsA(encoreInteraction.getOrganismsA());
            mappingEcoreInteraction.addOrganismsB(encoreInteraction.getOrganismsB());
        }
        mappingEcoreInteraction.addPublicationId(encoreInteraction.getPublicationIds());
        mappingEcoreInteraction.addExperimentToPubmed(encoreInteraction.getExperimentToPubmed());
        mappingEcoreInteraction.addExperimentToDatabase(encoreInteraction.getExperimentToDatabase());
        this.processMethodAndType(encoreInteraction, mappingEcoreInteraction);
        mappingEcoreInteraction.addAuthors(encoreInteraction.getAuthors());
        mappingEcoreInteraction.addConfidenceValues(encoreInteraction.getConfidenceValues());
        mappingEcoreInteraction.addSourceDatabases(encoreInteraction.getSourceDatabases());
        mappingEcoreInteraction.getDistinctPublications().addAll(encoreInteraction.getDistinctPublications());
        return mappingEcoreInteraction;
    }

    public void setQueryAccs(List<String> queryAccs) {
        this.queryAccs = queryAccs;
    }

    public void setMIQLQueries(List<String> miqlQueries) {
        this.setQueryAccs(miqlQueries);
    }

    public void addQueryAcc(String queryAcc) {
        this.queryAccs.add(queryAcc);
    }

    public void addMIQLQuery(String miqlQuery) {
        this.addQueryAcc(miqlQuery);
    }

    public List<String> getQueryAccs() {
        return this.queryAccs;
    }

    public List<String> getMIQLQueries() {
        return this.getQueryAccs();
    }

    public void setQuerySources(List<String> querySources) {
        this.querySources = querySources;
    }

    public void addQuerySource(String querySource) {
        this.querySources.add(querySource);
    }

    public void setQuerySourcesFromPsicquicRegistry() {
        DefaultPsicquicRegistryClient registryClient = new DefaultPsicquicRegistryClient();
        try {
            List allServices = registryClient.listServices();
            for (ServiceType service : allServices) {
                if (!service.isActive()) continue;
                this.addQuerySource(service.getName());
            }
        }
        catch (PsicquicRegistryClientException e) {
            logger.error((Object)e);
            e.printStackTrace();
        }
    }

    public void setImexSources() {
        DefaultPsicquicRegistryClient registryClient = new DefaultPsicquicRegistryClient();
        try {
            List allServices = registryClient.listServices();
            for (ServiceType service : allServices) {
                List tags = service.getTags();
                if (!service.isActive() || tags == null || !tags.contains("MI:0959")) continue;
                this.addQuerySource(service.getName());
            }
        }
        catch (PsicquicRegistryClientException e) {
            logger.error((Object)e);
            e.printStackTrace();
        }
    }

    public List<String> getQuerySources() {
        return this.querySources;
    }
}

