/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.enfin.mi.cluster;

import uk.ac.ebi.enfin.mi.cluster.EncoreInteraction;
import uk.ac.ebi.enfin.mi.cluster.cache.CacheManager;
import uk.ac.ebi.enfin.mi.cluster.cache.CacheStrategy;
import uk.ac.ebi.enfin.mi.cluster.cache.EHCacheManager;
import uk.ac.ebi.enfin.mi.cluster.cache.InMemoryCacheManager;

public class ClusterContext {
    private CacheManager<EncoreInteraction> cacheManager;
    private CacheStrategy cacheStrategy = CacheStrategy.IN_MEMORY;
    private static ThreadLocal<ClusterContext> instance = new ThreadLocal<ClusterContext>(){

        @Override
        protected ClusterContext initialValue() {
            return new ClusterContext();
        }
    };

    public static ClusterContext getInstance() {
        return instance.get();
    }

    private ClusterContext() {
    }

    public synchronized CacheStrategy getCacheStrategy() {
        return this.cacheStrategy;
    }

    public synchronized boolean isCacheStrategyAlreadySet() {
        return this.cacheStrategy != null;
    }

    public synchronized void setCacheStrategy(CacheStrategy cacheStrategy) {
        if (this.cacheManager != null && !this.cacheStrategy.equals((Object)cacheStrategy)) {
            throw new IllegalArgumentException("A cache manager is already instanciated with strategy '" + (Object)((Object)this.cacheStrategy) + "', you cannot request '" + (Object)((Object)cacheStrategy) + "' ");
        }
        this.cacheStrategy = cacheStrategy;
    }

    public synchronized CacheManager getCacheManager() {
        if (this.cacheManager == null) {
            if (this.cacheStrategy.equals((Object)CacheStrategy.ON_DISK)) {
                this.cacheManager = new EHCacheManager();
            } else if (this.cacheStrategy.equals((Object)CacheStrategy.IN_MEMORY)) {
                this.cacheManager = new InMemoryCacheManager();
            } else {
                throw new IllegalArgumentException("Strategy '" + (Object)((Object)this.cacheStrategy) + "' is not supported.");
            }
        }
        return this.cacheManager;
    }
}

