/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.enfin.mi.cluster;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import psidev.psi.mi.tab.model.Alias;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.model.CrossReference;
import psidev.psi.mi.tab.model.InteractionDetectionMethod;
import psidev.psi.mi.tab.model.InteractionType;
import psidev.psi.mi.tab.model.Interactor;
import uk.ac.ebi.enfin.mi.cluster.EncoreBinaryInteraction;
import uk.ac.ebi.enfin.mi.cluster.EncoreIdentifiers;
import uk.ac.ebi.enfin.mi.cluster.EncoreInteraction;
import uk.ac.ebi.enfin.mi.cluster.MethodTypePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Binary2Encore {
    static Logger logger = Logger.getLogger(EncoreInteraction.class);
    public static final Pattern UNIPROT_ACC = Pattern.compile("[A-Z][0-9][A-Z0-9]{3}[0-9]|[A-Z][0-9][A-Z0-9]{3}[0-9]-[0-9]+", 2);
    public static final Pattern UNIPROT_ID = Pattern.compile("[A-Z0-9]{1,6}_[A-Z0-9]{3,5}", 2);
    String[] idDbNameList = null;

    public Binary2Encore() {
    }

    public Binary2Encore(String[] idDbNameList) {
        this.idDbNameList = idDbNameList;
    }

    private String convertEncoreInteraction(EncoreBinaryInteraction encoreInteraction, BinaryInteraction binaryInteraction) {
        encoreInteraction.setId(0);
        List<CrossReference> iPublications = binaryInteraction.getPublications();
        String pubmed = "";
        String doi = "";
        String imex = "";
        String other = "";
        for (CrossReference iPublication : iPublications) {
            if (iPublication.getDatabase().equalsIgnoreCase("pubmed")) {
                pubmed = iPublication.getIdentifier();
                continue;
            }
            if (iPublication.getDatabase().equalsIgnoreCase("doi")) {
                doi = iPublication.getIdentifier();
                continue;
            }
            if (iPublication.getDatabase().equalsIgnoreCase("imex")) {
                imex = iPublication.getIdentifier();
                continue;
            }
            other = iPublication.getIdentifier();
        }
        String validPublication = pubmed.length() == 0 ? (doi.length() == 0 ? (imex.length() == 0 ? other : imex) : doi) : pubmed;
        encoreInteraction.addPublicationId(iPublications);
        String sourceDatabase = "";
        List<CrossReference> iSourceDatabases = binaryInteraction.getSourceDatabases();
        if (iSourceDatabases.size() > 0) {
            sourceDatabase = iSourceDatabases.get(0).getText();
        }
        List<CrossReference> iExps = binaryInteraction.getInteractionAcs();
        String experiment = "";
        String database = "";
        Iterator<CrossReference> i$ = iExps.iterator();
        if (i$.hasNext()) {
            CrossReference iExp = i$.next();
            experiment = iExp.getIdentifier();
            database = iExp.getDatabase();
        }
        encoreInteraction.addExperimentToPubmed(experiment, validPublication);
        if (database.length() > 0) {
            encoreInteraction.addExperimentToDatabase(experiment, database);
        } else {
            encoreInteraction.addExperimentToDatabase(experiment, sourceDatabase);
        }
        try {
            Object iA = binaryInteraction.getInteractorA();
            EncoreIdentifiers interactorAccsA = this.getInteractorAccs((Interactor)iA);
            encoreInteraction.setInteractorAccsA(interactorAccsA.getAccessions());
            encoreInteraction.setOtherInteractorAccsA(interactorAccsA.getOtherAccessions());
            if (((Interactor)iA).getOrganism() != null) {
                encoreInteraction.addOrganismsA(((Interactor)iA).getOrganism().getIdentifiers());
            } else {
                logger.warn((Object)"Organism is null");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Object iB = binaryInteraction.getInteractorB();
            EncoreIdentifiers interactorAccsB = this.getInteractorAccs((Interactor)iB);
            encoreInteraction.setInteractorAccsB(interactorAccsB.getAccessions());
            encoreInteraction.setOtherInteractorAccsB(interactorAccsB.getOtherAccessions());
            if (((Interactor)iB).getOrganism() != null) {
                encoreInteraction.addOrganismsB(((Interactor)iB).getOrganism().getIdentifiers());
            } else {
                logger.warn((Object)"Organism is null");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (binaryInteraction.getConfidenceValues() != null) {
            encoreInteraction.addConfidenceValues(binaryInteraction.getConfidenceValues());
        } else {
            logger.warn((Object)"Confidence Values is null");
        }
        if (binaryInteraction.getAuthors() != null) {
            encoreInteraction.addAuthors(binaryInteraction.getAuthors());
        } else {
            logger.warn((Object)"Authors is null");
        }
        if (binaryInteraction.getSourceDatabases() != null) {
            encoreInteraction.addSourceDatabases(binaryInteraction.getSourceDatabases());
        } else {
            logger.warn((Object)"SourceDatabases is null");
        }
        if (validPublication.length() == 0) {
            logger.warn((Object)("Pubmed missing for \"" + experiment + "\" in \"" + database + "\""));
        }
        return validPublication;
    }

    public EncoreInteraction getEncoreInteraction(BinaryInteraction binaryInteraction) {
        EncoreInteraction encoreInteraction = new EncoreInteraction();
        String pubmed = this.convertEncoreInteraction(encoreInteraction, binaryInteraction);
        List<InteractionType> iTypes = binaryInteraction.getInteractionTypes();
        for (InteractionType iType : iTypes) {
            encoreInteraction.addTypeToPubmed(iType.getIdentifier(), pubmed);
        }
        List<InteractionDetectionMethod> iMethods = binaryInteraction.getDetectionMethods();
        for (InteractionDetectionMethod iMethod : iMethods) {
            encoreInteraction.addMethodToPubmed(iMethod.getIdentifier(), pubmed);
        }
        return encoreInteraction;
    }

    public EncoreInteraction getEncoreInteractionForScoring(BinaryInteraction binaryInteraction) {
        EncoreInteraction encoreInteraction = new EncoreInteraction();
        String pubmed = this.convertEncoreInteraction(encoreInteraction, binaryInteraction);
        if (pubmed.length() > 0) {
            encoreInteraction.getDistinctPublications().add(pubmed);
        }
        List<InteractionType> iTypes = binaryInteraction.getInteractionTypes();
        List<InteractionDetectionMethod> iMethods = binaryInteraction.getDetectionMethods();
        if (iTypes.size() == 1 && iMethods.size() > 1) {
            String type = iTypes.get(0).getIdentifier();
            for (InteractionDetectionMethod meth : iMethods) {
                MethodTypePair pair = new MethodTypePair(meth.getIdentifier(), type);
                if (encoreInteraction.getMethodTypePairListMap().containsKey(pair)) {
                    encoreInteraction.getMethodTypePairListMap().get(pair).add(pubmed);
                    continue;
                }
                ArrayList<String> pubmeds = new ArrayList<String>();
                pubmeds.add(pubmed);
                encoreInteraction.getMethodTypePairListMap().put(pair, pubmeds);
            }
        } else if (iTypes.size() > 1 && iMethods.size() == 1) {
            String method = iMethods.get(0).getIdentifier();
            for (InteractionType type : iTypes) {
                MethodTypePair pair = new MethodTypePair(method, type.getIdentifier());
                if (encoreInteraction.getMethodTypePairListMap().containsKey(pair)) {
                    encoreInteraction.getMethodTypePairListMap().get(pair).add(pubmed);
                    continue;
                }
                ArrayList<String> pubmeds = new ArrayList<String>();
                pubmeds.add(pubmed);
                encoreInteraction.getMethodTypePairListMap().put(pair, pubmeds);
            }
        } else if (iMethods.size() == iTypes.size()) {
            for (int i = 0; i < iMethods.size(); ++i) {
                String method = iMethods.get(i).getIdentifier();
                String type = iTypes.get(i).getIdentifier();
                MethodTypePair pair = new MethodTypePair(method, type);
                if (encoreInteraction.getMethodTypePairListMap().containsKey(pair)) {
                    encoreInteraction.getMethodTypePairListMap().get(pair).add(pubmed);
                    continue;
                }
                ArrayList<String> pubmeds = new ArrayList<String>();
                pubmeds.add(pubmed);
                encoreInteraction.getMethodTypePairListMap().put(pair, pubmeds);
            }
        } else if (iMethods.isEmpty() && iTypes.size() > 0) {
            for (InteractionType type : iTypes) {
                MethodTypePair pair = new MethodTypePair(null, type.getIdentifier());
                if (encoreInteraction.getMethodTypePairListMap().containsKey(pair)) {
                    encoreInteraction.getMethodTypePairListMap().get(pair).add(pubmed);
                    continue;
                }
                ArrayList<String> pubmeds = new ArrayList<String>();
                pubmeds.add(pubmed);
                encoreInteraction.getMethodTypePairListMap().put(pair, pubmeds);
            }
        } else if (iTypes.isEmpty() && iMethods.size() > 0) {
            for (InteractionDetectionMethod meth : iMethods) {
                MethodTypePair pair = new MethodTypePair(meth.getIdentifier(), null);
                if (encoreInteraction.getMethodTypePairListMap().containsKey(pair)) {
                    encoreInteraction.getMethodTypePairListMap().get(pair).add(pubmed);
                    continue;
                }
                ArrayList<String> pubmeds = new ArrayList<String>();
                pubmeds.add(pubmed);
                encoreInteraction.getMethodTypePairListMap().put(pair, pubmeds);
            }
        } else {
            ArrayList<String> pubmeds;
            MethodTypePair pair;
            for (InteractionType type : iTypes) {
                pair = new MethodTypePair(null, type.getIdentifier());
                if (encoreInteraction.getMethodTypePairListMap().containsKey(pair)) {
                    encoreInteraction.getMethodTypePairListMap().get(pair).add(pubmed);
                    continue;
                }
                pubmeds = new ArrayList<String>();
                pubmeds.add(pubmed);
                encoreInteraction.getMethodTypePairListMap().put(pair, pubmeds);
            }
            for (InteractionDetectionMethod meth : iMethods) {
                pair = new MethodTypePair(meth.getIdentifier(), null);
                if (encoreInteraction.getMethodTypePairListMap().containsKey(pair)) {
                    encoreInteraction.getMethodTypePairListMap().get(pair).add(pubmed);
                    continue;
                }
                pubmeds = new ArrayList();
                pubmeds.add(pubmed);
                encoreInteraction.getMethodTypePairListMap().put(pair, pubmeds);
            }
        }
        return encoreInteraction;
    }

    private void updateAccMap(Map<String, String> accs, String acc, String[] idDbNameList, String sourceIdDbName) {
        if (idDbNameList != null && idDbNameList.length > 0) {
            for (int i = 0; i < idDbNameList.length; ++i) {
                String idDbName = idDbNameList[i];
                if (!sourceIdDbName.equalsIgnoreCase(idDbName)) continue;
                if (idDbName.equalsIgnoreCase("uniprotkb")) {
                    if (!accs.containsKey(sourceIdDbName)) {
                        accs.put(sourceIdDbName, acc);
                        continue;
                    }
                    if (!UNIPROT_ACC.matcher(acc).matches()) continue;
                    String upac = acc;
                    int idx = acc.indexOf(".");
                    if (idx != -1) {
                        upac = acc.substring(0, idx);
                    }
                    accs.put(sourceIdDbName, upac);
                    continue;
                }
                if (accs.containsKey(sourceIdDbName)) continue;
                accs.put(sourceIdDbName, acc);
            }
        }
    }

    private void updateOtherAccMap(Map<String, List<String>> otherAccs, String sourceIdDbName, String acc) {
        List<Object> otherAccsList = new ArrayList<String>();
        if (!otherAccs.containsKey(sourceIdDbName)) {
            otherAccsList.add(acc);
            otherAccs.put(sourceIdDbName, otherAccsList);
        } else {
            otherAccsList = otherAccs.get(sourceIdDbName);
            if (!otherAccsList.contains(acc)) {
                otherAccsList.add(acc);
                otherAccs.put(sourceIdDbName, otherAccsList);
            }
        }
    }

    private EncoreIdentifiers getInteractorAccs(Interactor interactor) {
        int newSize;
        int firtSize;
        String sourceIdDbName;
        String acc;
        EncoreIdentifiers eIds = new EncoreIdentifiers();
        HashMap<String, String> accs = new HashMap<String, String>();
        HashMap<String, List<String>> otherAccs = new HashMap<String, List<String>>();
        for (CrossReference xref : interactor.getIdentifiers()) {
            acc = xref.getIdentifier();
            sourceIdDbName = xref.getDatabase();
            firtSize = accs.size();
            this.updateAccMap(accs, acc, this.idDbNameList, sourceIdDbName);
            newSize = accs.size();
            if (firtSize != newSize) continue;
            this.updateOtherAccMap(otherAccs, sourceIdDbName, acc);
        }
        for (CrossReference aXref : interactor.getAlternativeIdentifiers()) {
            acc = aXref.getIdentifier();
            sourceIdDbName = aXref.getDatabase();
            firtSize = accs.size();
            this.updateAccMap(accs, acc, this.idDbNameList, sourceIdDbName);
            newSize = accs.size();
            if (firtSize != newSize) continue;
            this.updateOtherAccMap(otherAccs, sourceIdDbName, acc);
        }
        Iterator<Serializable> i$ = interactor.getAliases().iterator();
        while (i$.hasNext()) {
            Alias alias = (Alias)i$.next();
            acc = alias.getName();
            sourceIdDbName = alias.getDbSource();
            firtSize = accs.size();
            this.updateAccMap(accs, acc, this.idDbNameList, sourceIdDbName);
            newSize = accs.size();
            if (firtSize != newSize) continue;
            this.updateOtherAccMap(otherAccs, sourceIdDbName, acc);
        }
        if (accs.size() == 0 && (i$ = otherAccs.keySet().iterator()).hasNext()) {
            String otherAccDb = (String)((Object)i$.next());
            accs.put(otherAccDb, (String)((List)otherAccs.get(otherAccDb)).get(0));
            otherAccs.remove(otherAccDb);
        }
        eIds.setAccessions(accs);
        eIds.setOtherAccessions(otherAccs);
        return eIds;
    }

    public String[] getIdDbNameList() {
        return this.idDbNameList;
    }

    public void setIdDbNameList(String[] idDbNameList) {
        this.idDbNameList = idDbNameList;
    }
}

