/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.model.builder;

import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.model.builder.Column;
import psidev.psi.mi.tab.model.builder.ColumnDefinition;
import psidev.psi.mi.tab.model.builder.DocumentDefinition;
import psidev.psi.mi.tab.model.builder.Field;
import psidev.psi.mi.tab.model.builder.FieldBuilder;
import psidev.psi.mi.tab.model.builder.ParseUtils;
import psidev.psi.mi.tab.model.builder.Row;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowBuilder<T extends BinaryInteraction> {
    private static final Log log = LogFactory.getLog(RowBuilder.class);
    private DocumentDefinition documentDefinition;

    public RowBuilder(DocumentDefinition documentDefinition) {
        this.documentDefinition = documentDefinition;
    }

    public Row createRow(String strRow) {
        LinkedList<Column> columns = new LinkedList<Column>();
        String[] colStrs = ParseUtils.quoteAwareSplit(strRow, new char[]{'\t'}, false);
        int columnDefinitionCount = this.documentDefinition.getColumnDefinitionCount();
        if (columnDefinitionCount > colStrs.length && log.isDebugEnabled()) {
            log.debug((Object)("Parsing row with less columns than those expected by the document definition. Found " + colStrs.length + " and expected: " + columnDefinitionCount));
        }
        for (int i = 0; i < colStrs.length; ++i) {
            String strCol = colStrs[i];
            String[] strFields = ParseUtils.quoteAwareSplit(strCol, new char[]{'|'}, false);
            if (i >= this.documentDefinition.getColumnsCount()) break;
            ColumnDefinition columnDefinition = this.documentDefinition.getColumnDefinition(i);
            FieldBuilder builder = columnDefinition.getBuilder();
            ArrayList<Field> fields = new ArrayList<Field>(strFields.length);
            for (String strField : strFields) {
                Field field = builder.createField(strField);
                if (field == null) continue;
                fields.add(field);
            }
            Column col = new Column(fields);
            columns.add(col);
        }
        return new Row(columns);
    }
}

