/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.model.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.model.Alias;
import psidev.psi.mi.tab.model.AliasImpl;
import psidev.psi.mi.tab.model.Author;
import psidev.psi.mi.tab.model.AuthorImpl;
import psidev.psi.mi.tab.model.Confidence;
import psidev.psi.mi.tab.model.ConfidenceImpl;
import psidev.psi.mi.tab.model.CrossReference;
import psidev.psi.mi.tab.model.CrossReferenceImpl;
import psidev.psi.mi.tab.model.InteractionDetectionMethod;
import psidev.psi.mi.tab.model.InteractionDetectionMethodImpl;
import psidev.psi.mi.tab.model.InteractionType;
import psidev.psi.mi.tab.model.InteractionTypeImpl;
import psidev.psi.mi.tab.model.Organism;
import psidev.psi.mi.tab.model.OrganismImpl;
import psidev.psi.mi.tab.model.builder.Column;
import psidev.psi.mi.tab.model.builder.Field;
import psidev.psi.mi.tab.model.builder.FieldBuilder;
import psidev.psi.mi.tab.model.builder.IllegalFormatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParseUtils {
    private static final Log log = LogFactory.getLog(ParseUtils.class);

    private ParseUtils() {
    }

    public static String[] quoteAwareSplit(String str, char[] delimiters, boolean removeUnescapedQuotes) {
        if (str == null) {
            throw new NullPointerException("Null String to create Field");
        }
        if (StringUtils.isEmpty((String)str)) {
            throw new IllegalArgumentException("Empty String passed to create Field");
        }
        if (delimiters == null) {
            throw new NullPointerException("Null delimiters to create Field");
        }
        if (delimiters.length == 0) {
            throw new IllegalArgumentException("At least one delimiter char is needed");
        }
        LinkedList<String> groups = new LinkedList<String>();
        StringBuilder currGroup = new StringBuilder(str.length());
        char[] chars = str.toCharArray();
        boolean withinQuotes = false;
        boolean previousCharIsEscape = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            boolean markedAsEscape = false;
            if (c == '\"') {
                if (withinQuotes) {
                    if (previousCharIsEscape) {
                        if (!removeUnescapedQuotes) {
                            currGroup.append("\\");
                        }
                        currGroup.append(c);
                    } else if (currGroup.length() > 0) {
                        withinQuotes = !withinQuotes;
                    }
                } else {
                    withinQuotes = true;
                }
                if (!removeUnescapedQuotes && !previousCharIsEscape) {
                    currGroup.append(c);
                }
            } else if (ParseUtils.arrayContains(delimiters, c)) {
                if (currGroup.length() > 0) {
                    if (!withinQuotes) {
                        groups.add(currGroup.toString());
                        currGroup.setLength(0);
                    } else {
                        currGroup.append(c);
                    }
                } else if (withinQuotes) {
                    currGroup.append(c);
                }
            } else if (c == '\\') {
                if (withinQuotes) {
                    previousCharIsEscape = true;
                    markedAsEscape = true;
                } else {
                    currGroup.append(c);
                }
            } else {
                currGroup.append(c);
            }
            if (markedAsEscape) continue;
            previousCharIsEscape = false;
        }
        if (currGroup.length() > 0) {
            groups.add(currGroup.toString());
        }
        return groups.toArray(new String[groups.size()]);
    }

    private static boolean arrayContains(char[] chars, char cToFind) {
        for (char c : chars) {
            if (c != cToFind) continue;
            return true;
        }
        return false;
    }

    public static String[] columnSplit(String columnString) {
        return ParseUtils.quoteAwareSplit(columnString, new char[]{'|'}, false);
    }

    public static Column createColumnFromString(String xrefColumn, FieldBuilder fieldBuilder) {
        String[] fieldStrs = ParseUtils.columnSplit(xrefColumn);
        LinkedList<Field> fields = new LinkedList<Field>();
        for (String fieldStr : fieldStrs) {
            ParseUtils.addFieldToList(fields, fieldBuilder.createField(fieldStr));
        }
        return new Column(fields);
    }

    public static List<CrossReference> createCrossReferences(Column column) {
        LinkedList<CrossReference> xrefs = new LinkedList<CrossReference>();
        for (Field field : column.getFields()) {
            try {
                xrefs.add(ParseUtils.createCrossReference(field));
            }
            catch (Throwable e) {
                throw new IllegalFormatException("Problem creating cross reference from field: " + field, e);
            }
        }
        return xrefs;
    }

    public static List<InteractionDetectionMethod> createInteractionDetectionMethods(Column column) {
        LinkedList<InteractionDetectionMethod> xrefs = new LinkedList<InteractionDetectionMethod>();
        for (Field field : column.getFields()) {
            try {
                xrefs.add(ParseUtils.createInteractionDetectionMethod(field));
            }
            catch (Throwable e) {
                throw new IllegalFormatException("Problem creating interaction detection method from field: " + field, e);
            }
        }
        return xrefs;
    }

    public static List<InteractionType> createInteractionTypes(Column column) {
        ArrayList<InteractionType> xrefs = new ArrayList<InteractionType>();
        for (Field field : column.getFields()) {
            try {
                xrefs.add(ParseUtils.createInteractionType(field));
            }
            catch (Throwable e) {
                throw new IllegalFormatException("Problem creating interaction type from field: " + field, e);
            }
        }
        return xrefs;
    }

    private static CrossReference createCrossReference(Field field) {
        CrossReferenceImpl xref = new CrossReferenceImpl();
        ParseUtils.populateCrossReference(field, xref);
        return xref;
    }

    public static InteractionDetectionMethod createInteractionDetectionMethod(Field field) {
        InteractionDetectionMethodImpl xref = new InteractionDetectionMethodImpl();
        ParseUtils.populateCrossReference(field, xref);
        return xref;
    }

    public static InteractionType createInteractionType(Field field) {
        InteractionTypeImpl xref = new InteractionTypeImpl();
        ParseUtils.populateCrossReference(field, xref);
        return xref;
    }

    private static void populateCrossReference(Field field, CrossReference xref) {
        xref.setDatabase(field.getType());
        xref.setIdentifier(field.getValue());
        xref.setText(field.getDescription());
    }

    public static List<Alias> createAliases(Column column) {
        ArrayList<Alias> aliases = new ArrayList<Alias>();
        for (Field field : column.getFields()) {
            aliases.add(ParseUtils.createAlias(field));
        }
        return aliases;
    }

    public static Alias createAlias(Field field) {
        AliasImpl alias = new AliasImpl();
        alias.setDbSource(field.getType());
        alias.setName(field.getValue());
        alias.setAliasType(field.getDescription());
        return alias;
    }

    public static List<Author> createAuthors(Column column) {
        ArrayList<Author> authors = new ArrayList<Author>();
        for (Field field : column.getFields()) {
            if (field == null) continue;
            authors.add(ParseUtils.createAuthor(field));
        }
        return authors;
    }

    public static Author createAuthor(Field field) {
        return new AuthorImpl(field.getValue());
    }

    public static Organism createOrganism(Column column) {
        return new OrganismImpl(ParseUtils.createCrossReferences(column));
    }

    public static List<Confidence> createConfidenceValues(Column column) {
        ArrayList<Confidence> confidences = new ArrayList<Confidence>();
        for (Field field : column.getFields()) {
            try {
                confidences.add(ParseUtils.createConfidence(field));
            }
            catch (Throwable e) {
                throw new IllegalFormatException("Problem creating confidence from field: " + field, e);
            }
        }
        return confidences;
    }

    public static Confidence createConfidence(Field field) {
        String type = field.getType();
        String value = field.getValue();
        String description = field.getDescription();
        if (type == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Expecting cross-reference format but found free text instead. Using db 'not-defined': " + value));
            }
            type = "not-defined";
            if (description == null) {
                description = "free-text";
            }
        }
        if (description == null) {
            description = "free-text";
        }
        return new ConfidenceImpl(type, value, description);
    }

    public static Column createColumnFromOrganism(Organism organism) {
        Column column = organism != null ? ParseUtils.createColumnFromCrossReferences(organism.getIdentifiers()) : new Column();
        return column;
    }

    public static Column createColumnFromConfidences(Collection<Confidence> confidences) {
        LinkedList<Field> fields = new LinkedList<Field>();
        for (Confidence confidence : confidences) {
            ParseUtils.addFieldToList(fields, ParseUtils.createFieldFromConfidence(confidence));
        }
        return new Column(fields);
    }

    public static Field createFieldFromConfidence(Confidence confidence) {
        return new Field(confidence.getType(), confidence.getValue(), confidence.getText());
    }

    public static Column createColumnFromInteractionTypes(Collection<InteractionType> types) {
        LinkedList<Field> fields = new LinkedList<Field>();
        for (InteractionType type : types) {
            ParseUtils.addFieldToList(fields, ParseUtils.createFieldFromCrossReference(type));
        }
        return new Column(fields);
    }

    public static Column createColumnFromDetectionMethods(Collection<InteractionDetectionMethod> methods) {
        LinkedList<Field> fields = new LinkedList<Field>();
        for (InteractionDetectionMethod method : methods) {
            ParseUtils.addFieldToList(fields, ParseUtils.createFieldFromCrossReference(method));
        }
        return new Column(fields);
    }

    public static Column createColumnFromAuthors(Collection<Author> authors) {
        LinkedList<Field> fields = new LinkedList<Field>();
        for (Author author : authors) {
            Field field = ParseUtils.createFieldFromAuthor(author);
            ParseUtils.addFieldToList(fields, field);
        }
        return new Column(fields);
    }

    public static Field createFieldFromAuthor(Author author) {
        return new Field(author.getName());
    }

    public static Column createColumnFromCrossReferences(Collection<CrossReference> xrefs) {
        if (xrefs == null) {
            return new Column();
        }
        return ParseUtils.createColumnFromCrossReferences(xrefs.toArray(new CrossReference[xrefs.size()]));
    }

    public static Column createColumnFromCrossReferences(CrossReference ... xrefs) {
        LinkedList<Field> fields = new LinkedList<Field>();
        for (CrossReference xref : xrefs) {
            ParseUtils.addFieldToList(fields, ParseUtils.createFieldFromCrossReference(xref));
        }
        return new Column(fields);
    }

    public static Field createFieldFromCrossReference(CrossReference xref) {
        if (xref == null) {
            return null;
        }
        return new Field(xref.getDatabase(), xref.getIdentifier(), xref.getText());
    }

    public static Column createColumnFromAliases(Collection<Alias> aliases) {
        LinkedList<Field> fields = new LinkedList<Field>();
        for (Alias alias : aliases) {
            ParseUtils.addFieldToList(fields, ParseUtils.createFieldFromAlias(alias));
        }
        return new Column(fields);
    }

    public static Field createFieldFromAlias(Alias alias) {
        return new Field(alias.getDbSource(), alias.getName(), alias.getAliasType());
    }

    public static void addFieldToList(List<Field> fields, Field field) {
        if (field != null) {
            fields.add(field);
        }
    }
}

