/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.model.builder;

import java.util.ArrayList;
import java.util.List;
import psidev.psi.mi.tab.model.Alias;
import psidev.psi.mi.tab.model.Author;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.model.BinaryInteractionImpl;
import psidev.psi.mi.tab.model.Confidence;
import psidev.psi.mi.tab.model.CrossReference;
import psidev.psi.mi.tab.model.CrossReferenceImpl;
import psidev.psi.mi.tab.model.InteractionDetectionMethod;
import psidev.psi.mi.tab.model.InteractionDetectionMethodImpl;
import psidev.psi.mi.tab.model.InteractionType;
import psidev.psi.mi.tab.model.InteractionTypeImpl;
import psidev.psi.mi.tab.model.Interactor;
import psidev.psi.mi.tab.model.Organism;
import psidev.psi.mi.tab.model.builder.AbstractInteractionRowConverter;
import psidev.psi.mi.tab.model.builder.Column;
import psidev.psi.mi.tab.model.builder.Field;
import psidev.psi.mi.tab.model.builder.IllegalFormatException;
import psidev.psi.mi.tab.model.builder.ParseUtils;
import psidev.psi.mi.tab.model.builder.Row;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MitabInteractionRowConverter
extends AbstractInteractionRowConverter<BinaryInteraction> {
    @Override
    protected Interactor newInteractor() {
        return new Interactor();
    }

    @Override
    protected BinaryInteraction newBinaryInteraction(Interactor interactorA, Interactor interactorB) {
        return new BinaryInteractionImpl(interactorA, interactorB);
    }

    @Override
    protected Interactor createInteractorA(Row row) {
        Column idACol = row.getColumnByIndex(0);
        Column altidACol = row.getColumnByIndex(2);
        Column aliasACol = row.getColumnByIndex(4);
        Column taxidACol = row.getColumnByIndex(9);
        Interactor interactorA = new Interactor();
        interactorA.setIdentifiers(this.createCrossReferences(idACol));
        interactorA.setAlternativeIdentifiers(this.createCrossReferences(altidACol));
        interactorA.setAliases(this.createAliases(aliasACol));
        interactorA.setOrganism(this.createOrganism(taxidACol));
        return interactorA;
    }

    @Override
    protected Interactor createInteractorB(Row row) {
        Column idBCol = row.getColumnByIndex(1);
        Column altidBCol = row.getColumnByIndex(3);
        Column aliasBCol = row.getColumnByIndex(5);
        Column taxidBCol = row.getColumnByIndex(10);
        Interactor interactorB = new Interactor();
        if (idBCol != null) {
            interactorB.setIdentifiers(this.createCrossReferences(idBCol));
        }
        if (altidBCol != null) {
            interactorB.setAlternativeIdentifiers(this.createCrossReferences(altidBCol));
        }
        if (aliasBCol != null) {
            interactorB.setAliases(this.createAliases(aliasBCol));
        }
        if (taxidBCol != null) {
            interactorB.setOrganism(this.createOrganism(taxidBCol));
        }
        return interactorB;
    }

    @Override
    protected void populateBinaryInteraction(BinaryInteraction binaryInteraction, Row row) {
        Column intDetMethodCol = row.getColumnByIndex(6);
        Column pubAuthCol = row.getColumnByIndex(7);
        Column pubIdCol = row.getColumnByIndex(8);
        Column intTypeCol = row.getColumnByIndex(11);
        Column sourceDbCol = row.getColumnByIndex(12);
        Column intIdCol = row.getColumnByIndex(13);
        Column confCol = row.getColumnByIndex(14);
        binaryInteraction.setDetectionMethods(this.createInteractionDetectionMethods(intDetMethodCol));
        binaryInteraction.setAuthors(this.createAuthors(pubAuthCol));
        binaryInteraction.setPublications(this.createCrossReferences(pubIdCol));
        binaryInteraction.setInteractionTypes(this.createInteractionTypes(intTypeCol));
        binaryInteraction.setSourceDatabases(this.createCrossReferences(sourceDbCol));
        binaryInteraction.setInteractionAcs(this.createCrossReferences(intIdCol));
        binaryInteraction.setConfidenceValues(this.createConfidenceValues(confCol));
    }

    protected List<CrossReference> createCrossReferences(Column column) {
        ArrayList<CrossReference> xrefs = new ArrayList<CrossReference>();
        for (Field field : column.getFields()) {
            if (field == null) {
                throw new IllegalArgumentException("Column contains null fields: " + column);
            }
            try {
                xrefs.add(this.createCrossReference(field));
            }
            catch (Throwable e) {
                throw new IllegalFormatException("Problem creating cross reference from field: " + field, e);
            }
        }
        return xrefs;
    }

    protected List<InteractionDetectionMethod> createInteractionDetectionMethods(Column column) {
        ArrayList<InteractionDetectionMethod> xrefs = new ArrayList<InteractionDetectionMethod>();
        for (Field field : column.getFields()) {
            try {
                xrefs.add(this.createInteractionDetectionMethod(field));
            }
            catch (Throwable e) {
                throw new IllegalFormatException("Problem creating interaction detection method from field: " + field);
            }
        }
        return xrefs;
    }

    protected List<InteractionType> createInteractionTypes(Column column) {
        ArrayList<InteractionType> xrefs = new ArrayList<InteractionType>();
        for (Field field : column.getFields()) {
            try {
                xrefs.add(this.createInteractionType(field));
            }
            catch (Throwable e) {
                throw new IllegalFormatException("Problem creating interaction type from field: " + field);
            }
        }
        return xrefs;
    }

    protected CrossReference createCrossReference(Field field) {
        CrossReferenceImpl xref = new CrossReferenceImpl();
        this.populateCrossReference(field, xref);
        return xref;
    }

    protected InteractionDetectionMethod createInteractionDetectionMethod(Field field) {
        InteractionDetectionMethodImpl xref = new InteractionDetectionMethodImpl();
        this.populateCrossReference(field, xref);
        return xref;
    }

    protected InteractionType createInteractionType(Field field) {
        InteractionTypeImpl xref = new InteractionTypeImpl();
        this.populateCrossReference(field, xref);
        return xref;
    }

    private void populateCrossReference(Field field, CrossReference xref) {
        xref.setDatabase(field.getType());
        xref.setIdentifier(field.getValue());
        xref.setText(field.getDescription());
    }

    protected List<Alias> createAliases(Column column) {
        return ParseUtils.createAliases(column);
    }

    protected List<Author> createAuthors(Column column) {
        ArrayList<Author> authors = new ArrayList<Author>();
        for (Field field : column.getFields()) {
            authors.add(this.createAuthor(field));
        }
        return authors;
    }

    protected Author createAuthor(Field field) {
        return ParseUtils.createAuthor(field);
    }

    protected Organism createOrganism(Column column) {
        return ParseUtils.createOrganism(column);
    }

    protected List<Confidence> createConfidenceValues(Column column) {
        ArrayList<Confidence> confidences = new ArrayList<Confidence>();
        for (Field field : column.getFields()) {
            try {
                confidences.add(this.createConfidence(field));
            }
            catch (Throwable e) {
                throw new IllegalFormatException("Problem creating confidence from field: " + field);
            }
        }
        return confidences;
    }

    protected Confidence createConfidence(Field field) {
        return ParseUtils.createConfidence(field);
    }
}

